/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.model;

import feign.Response;
import io.instacount.client.model.headers.Quota;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public abstract class InstacountResponse {
    @NonNull
    private final Response response;
    @NonNull
    private final Quota quota;

    public int getHttpResponseCode() {
        return this.response.status();
    }

    @NonNull
    public Response getResponse() {
        return this.response;
    }

    @NonNull
    public Quota getQuota() {
        return this.quota;
    }

    @ConstructorProperties(value={"response", "quota"})
    public InstacountResponse(@NonNull Response response, @NonNull Quota quota) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        if (quota == null) {
            throw new NullPointerException("quota");
        }
        this.response = response;
        this.quota = quota;
    }

    public String toString() {
        return "InstacountResponse(response=" + this.getResponse() + ", quota=" + this.getQuota() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstacountResponse)) {
            return false;
        }
        InstacountResponse other = (InstacountResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        Quota this$quota = this.getQuota();
        Quota other$quota = other.getQuota();
        return !(this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstacountResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        Quota $quota = this.getQuota();
        result = result * 59 + ($quota == null ? 43 : ((Object)$quota).hashCode());
        return result;
    }
}

