/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.model;

import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;

public class Errors {
    @NonNull
    private final Integer httpResponseCode;
    @NonNull
    private final List<Error> errors;

    private Errors() {
        this.httpResponseCode = null;
        this.errors = null;
    }

    public static Errors empty(int httpResponseCode) {
        return new Errors(httpResponseCode, (List<Error>)ImmutableList.of());
    }

    @NonNull
    public Integer getHttpResponseCode() {
        return this.httpResponseCode;
    }

    @NonNull
    public List<Error> getErrors() {
        return this.errors;
    }

    @ConstructorProperties(value={"httpResponseCode", "errors"})
    public Errors(@NonNull Integer httpResponseCode, @NonNull List<Error> errors) {
        if (httpResponseCode == null) {
            throw new NullPointerException("httpResponseCode");
        }
        if (errors == null) {
            throw new NullPointerException("errors");
        }
        this.httpResponseCode = httpResponseCode;
        this.errors = errors;
    }

    public String toString() {
        return "Errors(httpResponseCode=" + this.getHttpResponseCode() + ", errors=" + this.getErrors() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Errors)) {
            return false;
        }
        Errors other = (Errors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$httpResponseCode = this.getHttpResponseCode();
        Integer other$httpResponseCode = other.getHttpResponseCode();
        if (this$httpResponseCode == null ? other$httpResponseCode != null : !((Object)this$httpResponseCode).equals(other$httpResponseCode)) {
            return false;
        }
        List<Error> this$errors = this.getErrors();
        List<Error> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Errors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $httpResponseCode = this.getHttpResponseCode();
        result = result * 59 + ($httpResponseCode == null ? 43 : ((Object)$httpResponseCode).hashCode());
        List<Error> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public static class Error {
        @NonNull
        private final String message;
        @NonNull
        private final String developerMessage;
        @NonNull
        private final String moreInfo;

        private Error() {
            this.message = null;
            this.developerMessage = null;
            this.moreInfo = null;
        }

        @NonNull
        public String getMessage() {
            return this.message;
        }

        @NonNull
        public String getDeveloperMessage() {
            return this.developerMessage;
        }

        @NonNull
        public String getMoreInfo() {
            return this.moreInfo;
        }

        @ConstructorProperties(value={"message", "developerMessage", "moreInfo"})
        public Error(@NonNull String message, @NonNull String developerMessage, @NonNull String moreInfo) {
            if (message == null) {
                throw new NullPointerException("message");
            }
            if (developerMessage == null) {
                throw new NullPointerException("developerMessage");
            }
            if (moreInfo == null) {
                throw new NullPointerException("moreInfo");
            }
            this.message = message;
            this.developerMessage = developerMessage;
            this.moreInfo = moreInfo;
        }

        public String toString() {
            return "Errors.Error(message=" + this.getMessage() + ", developerMessage=" + this.getDeveloperMessage() + ", moreInfo=" + this.getMoreInfo() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$developerMessage = this.getDeveloperMessage();
            String other$developerMessage = other.getDeveloperMessage();
            if (this$developerMessage == null ? other$developerMessage != null : !this$developerMessage.equals(other$developerMessage)) {
                return false;
            }
            String this$moreInfo = this.getMoreInfo();
            String other$moreInfo = other.getMoreInfo();
            return !(this$moreInfo == null ? other$moreInfo != null : !this$moreInfo.equals(other$moreInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Error;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $developerMessage = this.getDeveloperMessage();
            result = result * 59 + ($developerMessage == null ? 43 : $developerMessage.hashCode());
            String $moreInfo = this.getMoreInfo();
            result = result * 59 + ($moreInfo == null ? 43 : $moreInfo.hashCode());
            return result;
        }
    }
}

