/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.decoders;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.squareup.okhttp.HttpUrl;
import feign.Response;
import feign.codec.Decoder;
import io.instacount.client.decoders.AbstractInstacountDecoder;
import io.instacount.client.model.headers.Quota;
import io.instacount.client.model.shardedcounters.ShardedCounter;
import io.instacount.client.model.shardedcounters.ShardedCounterOperation;
import io.instacount.client.model.shardedcounters.responses.CounterLocationInfo;
import io.instacount.client.model.shardedcounters.responses.CreateShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.DecrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.GetShardedCounterOperationResponse;
import io.instacount.client.model.shardedcounters.responses.GetShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.IncrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.UpdateShardedCounterResponse;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class InstacountJacksonDecoder
extends AbstractInstacountDecoder
implements Decoder {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public InstacountJacksonDecoder() {
        this(Collections.emptyList());
    }

    public InstacountJacksonDecoder(Iterable<Module> modules) {
        this(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(modules));
    }

    public InstacountJacksonDecoder(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public Object decode(Response response, Type type) throws IOException {
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull((Object)type);
        if (CreateShardedCounterResponse.class.equals((Object)type)) {
            return this.constructCreateShardedCounterResponse(response);
        }
        if (GetShardedCounterResponse.class.equals((Object)type)) {
            return this.constructGetShardedCounterResponse(response);
        }
        if (UpdateShardedCounterResponse.class.equals((Object)type)) {
            return this.constructUpdateShardedCounterResponse(response);
        }
        if (IncrementShardedCounterResponse.class.equals((Object)type)) {
            return this.constructIncrementCounterResponse(response);
        }
        if (DecrementShardedCounterResponse.class.equals((Object)type)) {
            return this.constructDecrementCounterResponse(response);
        }
        if (GetShardedCounterOperationResponse.class.equals((Object)type)) {
            return this.constructGetCounterOperationResponse(response);
        }
        throw new RuntimeException(String.format("Unable to decode response with type '%s'", type));
    }

    private Quota constructQuota(Response response) {
        Map headers = response.headers();
        Long numAccessRequestsLimit = this.toLong((Optional<Collection<String>>)Optional.fromNullable(headers.get("X-Ratelimit-Access-Counters-Limit")));
        Long numAccessRequestsRemaining = this.toLong((Optional<Collection<String>>)Optional.fromNullable(headers.get("X-Ratelimit-Access-Counters-Remaining")));
        Long numMutationRequestsLimit = this.toLong((Optional<Collection<String>>)Optional.fromNullable(headers.get("X-Ratelimit-Mutate-Counters-Limit")));
        Long numMutationRequestsRemaining = this.toLong((Optional<Collection<String>>)Optional.fromNullable(headers.get("X-Ratelimit-Mutate-Counters-Limit")));
        return new Quota(numAccessRequestsLimit, numAccessRequestsRemaining, numMutationRequestsLimit, numMutationRequestsRemaining);
    }

    private Long toLong(Optional<Collection<String>> optHeaderValues) {
        Preconditions.checkNotNull(optHeaderValues);
        if (optHeaderValues.isPresent()) {
            Collection headerValues = (Collection)optHeaderValues.get();
            if (headerValues.isEmpty()) {
                return 0L;
            }
            String firstHeaderValueAsString = (String)headerValues.iterator().next();
            try {
                return Long.parseLong(firstHeaderValueAsString);
            }
            catch (NumberFormatException nfe) {
                this.logger.severe(String.format("Invalid Header value \"%s\" should have been a Long!", firstHeaderValueAsString));
                return 0L;
            }
        }
        return 0L;
    }

    private GetShardedCounterResponse constructGetShardedCounterResponse(Response response) throws IOException {
        Optional<Reader> optReader = this.constructReader(response);
        if (optReader.isPresent()) {
            ShardedCounter shardedCounter = (ShardedCounter)this.objectMapper.readValue((Reader)optReader.get(), ShardedCounter.class);
            return new GetShardedCounterResponse(response, this.constructQuota(response), shardedCounter);
        }
        throw new RuntimeException(String.format("Unable to construct ShardedCounter from Response Body: %s", response.body()));
    }

    private IncrementShardedCounterResponse constructIncrementCounterResponse(Response response) throws IOException {
        if (response.status() == 201) {
            Optional<Reader> optReader = this.constructReader(response);
            if (optReader.isPresent()) {
                ShardedCounterOperation counterOperation = (ShardedCounterOperation)this.objectMapper.readValue((Reader)optReader.get(), ShardedCounterOperation.class);
                return new IncrementShardedCounterResponse(response, this.constructQuota(response), (Optional<ShardedCounterOperation>)Optional.of((Object)counterOperation));
            }
            throw new RuntimeException(String.format("Unable to construct CounterOperation from Response Body: %s", response.body()));
        }
        return new IncrementShardedCounterResponse(response, this.constructQuota(response), (Optional<ShardedCounterOperation>)Optional.absent());
    }

    private GetShardedCounterOperationResponse constructGetCounterOperationResponse(Response response) throws IOException {
        Optional<Reader> optReader = this.constructReader(response);
        if (optReader.isPresent()) {
            ShardedCounterOperation counterOperation = (ShardedCounterOperation)this.objectMapper.readValue((Reader)optReader.get(), ShardedCounterOperation.class);
            return new GetShardedCounterOperationResponse(response, this.constructQuota(response), counterOperation);
        }
        throw new RuntimeException(String.format("Unable to construct CounterOperation from Response Body: %s", response.body()));
    }

    private DecrementShardedCounterResponse constructDecrementCounterResponse(Response response) throws IOException {
        if (response.status() == 201) {
            Optional<Reader> optReader = this.constructReader(response);
            if (optReader.isPresent()) {
                ShardedCounterOperation counterOperation = (ShardedCounterOperation)this.objectMapper.readValue((Reader)optReader.get(), ShardedCounterOperation.class);
                return new DecrementShardedCounterResponse(response, this.constructQuota(response), (Optional<ShardedCounterOperation>)Optional.of((Object)counterOperation));
            }
            throw new RuntimeException(String.format("Unable to construct CounterOperation from Response Body: %s", response.body()));
        }
        return new DecrementShardedCounterResponse(response, this.constructQuota(response), (Optional<ShardedCounterOperation>)Optional.absent());
    }

    private CreateShardedCounterResponse constructCreateShardedCounterResponse(Response response) throws IOException {
        return new CreateShardedCounterResponse(response, this.constructQuota(response), this.constructCounterLocationInfo(response));
    }

    private Optional<CounterLocationInfo> constructCounterLocationInfo(Response response) {
        Optional optCounterInfo;
        Collection locationHeaders = (Collection)response.headers().get("Location");
        if (!locationHeaders.isEmpty()) {
            String location = (String)locationHeaders.iterator().next();
            HttpUrl httpUrl = HttpUrl.parse((String)location);
            Preconditions.checkNotNull((Object)httpUrl);
            String counterName = (String)httpUrl.pathSegments().get(1);
            CounterLocationInfo counterLocationHeaderInfo = new CounterLocationInfo(location, counterName);
            optCounterInfo = Optional.fromNullable((Object)counterLocationHeaderInfo);
        } else {
            optCounterInfo = Optional.absent();
        }
        return optCounterInfo;
    }

    private UpdateShardedCounterResponse constructUpdateShardedCounterResponse(Response response) throws IOException {
        Optional<Reader> optReader = this.constructReader(response);
        if (optReader.isPresent()) {
            ShardedCounter shardedCounter = (ShardedCounter)this.objectMapper.readValue((Reader)optReader.get(), ShardedCounter.class);
            return new UpdateShardedCounterResponse(response, this.constructQuota(response), shardedCounter);
        }
        throw new RuntimeException(String.format("Unable to construct ShardedCounter from Response Body: %s", response.body()));
    }
}

