/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client.decoders;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import feign.Response;
import io.instacount.client.exceptions.InstacountClientException;
import io.instacount.client.model.Errors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public abstract class AbstractInstacountDecoder {
    protected final ObjectMapper objectMapper;

    public AbstractInstacountDecoder(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    protected Optional<Reader> constructReader(Response response) throws IOException {
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull((Object)response.body());
        Reader reader = response.body().asReader();
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return Optional.absent();
            }
            reader.reset();
        }
        catch (RuntimeJsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
        return Optional.fromNullable((Object)reader);
    }

    protected Errors constructErrorsResponse(Response response) throws InstacountClientException {
        try {
            Errors errorsWithoutHttpCode = (Errors)this.objectMapper.readValue(response.body().asInputStream(), Errors.class);
            return new Errors(response.status(), errorsWithoutHttpCode.getErrors());
        }
        catch (Exception e) {
            throw new InstacountClientException(e, Errors.empty(response.status()));
        }
    }
}

