/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client;

import com.google.common.base.Preconditions;
import feign.Client;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.okhttp.OkHttpClient;

public interface InstacountClientParams
extends RequestInterceptor {
    public String getInstacountApplicationId();

    public String getInstacountReadOnlyApplicationKey();

    public String getInstacountReadWriteApplicationKey();

    public String getClientIdentifier();

    public String getInstacountRootUrl();

    public Client getClient();

    public static abstract class AbstractInstacountClientParams
    implements InstacountClientParams {
        private final boolean readOnly;

        protected AbstractInstacountClientParams(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void apply(RequestTemplate requestTemplate) {
            String instacountApplicationId = this.getInstacountApplicationId();
            if (instacountApplicationId != null && instacountApplicationId.length() > 0) {
                requestTemplate.header("X-Instacount-Application-Id", new String[]{instacountApplicationId});
            }
            if (this.readOnly) {
                String instacountReadOnlyApplicationKey = this.getInstacountReadOnlyApplicationKey();
                if (instacountReadOnlyApplicationKey != null && instacountReadOnlyApplicationKey.length() > 0) {
                    requestTemplate.header("X-Instacount-API-Key", new String[]{instacountReadOnlyApplicationKey});
                }
            } else {
                String instacountReadWriteApplicationKey = this.getInstacountReadWriteApplicationKey();
                if (instacountReadWriteApplicationKey != null && instacountReadWriteApplicationKey.length() > 0) {
                    requestTemplate.header("X-Instacount-API-Key", new String[]{instacountReadWriteApplicationKey});
                }
            }
            Preconditions.checkNotNull((Object)this.getClientIdentifier(), (Object)"You must specify a client identifier in order to make calls against the Instacount API!");
            requestTemplate.header("X-Instacount-Client-Id", new String[]{this.getClientIdentifier()});
            requestTemplate.header("User-Agent", new String[]{this.getClientIdentifier()});
        }

        @Override
        public String getClientIdentifier() {
            return "Instacount Java Client v1.0.2";
        }

        @Override
        public String getInstacountRootUrl() {
            return "https://api.instacount.io";
        }

        @Override
        public Client getClient() {
            return new OkHttpClient();
        }
    }
}

