/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import feign.Feign;
import feign.Param;
import feign.RequestInterceptor;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonEncoder;
import io.instacount.client.InstacountClientParams;
import io.instacount.client.decoders.InstacountErrorDecoder;
import io.instacount.client.decoders.InstacountJacksonDecoder;
import io.instacount.client.exceptions.InstacountClientException;
import io.instacount.client.interceptors.InstacountVersionRequestInterceptor;
import io.instacount.client.jackson.InstacountClientObjectMapper;
import io.instacount.client.model.shardedcounters.inputs.CreateShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.DecrementShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.IncrementShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.UpdateShardedCounterInput;
import io.instacount.client.model.shardedcounters.responses.CreateShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.DecrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.DeleteShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.GetShardedCounterOperationResponse;
import io.instacount.client.model.shardedcounters.responses.GetShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.IncrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.UpdateShardedCounterResponse;

public interface Instacount {
    public CreateShardedCounterResponse createShardedCounter() throws InstacountClientException;

    public CreateShardedCounterResponse createShardedCounter(CreateShardedCounterInput var1) throws InstacountClientException;

    public GetShardedCounterResponse getShardedCounter(String var1) throws InstacountClientException;

    public UpdateShardedCounterResponse updateShardedCounter(String var1, UpdateShardedCounterInput var2) throws InstacountClientException;

    public DeleteShardedCounterResponse deleteShardedCounter(String var1) throws InstacountClientException;

    public IncrementShardedCounterResponse incrementShardedCounter(String var1) throws InstacountClientException;

    public DecrementShardedCounterResponse decrementShardedCounter(String var1) throws InstacountClientException;

    public IncrementShardedCounterResponse incrementShardedCounter(String var1, IncrementShardedCounterInput var2) throws InstacountClientException;

    public DecrementShardedCounterResponse decrementShardedCounter(String var1, DecrementShardedCounterInput var2) throws InstacountClientException;

    public GetShardedCounterOperationResponse getShardedCounterOperation(String var1, Integer var2, String var3) throws InstacountClientException;

    public static class Builder {
        public static Instacount build(InstacountClientParams instacountClientParams, RequestInterceptor ... additionalRequestInterceptors) {
            InstacountClientObjectMapper objectMapper = new InstacountClientObjectMapper();
            ImmutableList.Builder requestInterceptorsBuilder = ImmutableList.builder();
            requestInterceptorsBuilder.add((Object)new InstacountVersionRequestInterceptor.Impl());
            requestInterceptorsBuilder.add((Object)instacountClientParams);
            requestInterceptorsBuilder.add((Object[])additionalRequestInterceptors);
            return new InstacountWrapper((InstacountFeign)Feign.builder().client(instacountClientParams.getClient()).errorDecoder((ErrorDecoder)new InstacountErrorDecoder(objectMapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)objectMapper)).decoder((Decoder)new InstacountJacksonDecoder(objectMapper)).requestInterceptors((Iterable)requestInterceptorsBuilder.build()).target(InstacountFeign.class, instacountClientParams.getInstacountRootUrl()));
        }

        private static class InstacountWrapper
        implements Instacount {
            private final Instacount instacount;

            private InstacountWrapper(InstacountFeign instacountFeign) {
                this.instacount = (Instacount)Preconditions.checkNotNull((Object)instacountFeign);
            }

            @Override
            public CreateShardedCounterResponse createShardedCounter() throws InstacountClientException {
                return this.instacount.createShardedCounter();
            }

            @Override
            public CreateShardedCounterResponse createShardedCounter(CreateShardedCounterInput createCounterInput) throws InstacountClientException {
                Preconditions.checkNotNull((Object)createCounterInput);
                return this.instacount.createShardedCounter(createCounterInput);
            }

            @Override
            public GetShardedCounterResponse getShardedCounter(@Param(value="counterName") String counterName) throws InstacountClientException {
                this.validateCounterName(counterName);
                return this.instacount.getShardedCounter(counterName);
            }

            @Override
            public UpdateShardedCounterResponse updateShardedCounter(@Param(value="counterName") String counterName, UpdateShardedCounterInput updateCounterInput) throws InstacountClientException {
                this.validateCounterName(counterName);
                Preconditions.checkNotNull((Object)updateCounterInput);
                return this.instacount.updateShardedCounter(counterName, updateCounterInput);
            }

            @Override
            public DeleteShardedCounterResponse deleteShardedCounter(@Param(value="counterName") String counterName) throws InstacountClientException {
                this.validateCounterName(counterName);
                return this.instacount.deleteShardedCounter(counterName);
            }

            @Override
            public IncrementShardedCounterResponse incrementShardedCounter(@Param(value="counterName") String counterName) throws InstacountClientException {
                this.validateCounterName(counterName);
                return this.instacount.incrementShardedCounter(counterName);
            }

            @Override
            public DecrementShardedCounterResponse decrementShardedCounter(@Param(value="counterName") String counterName) throws InstacountClientException {
                this.validateCounterName(counterName);
                return this.instacount.decrementShardedCounter(counterName);
            }

            @Override
            public IncrementShardedCounterResponse incrementShardedCounter(@Param(value="counterName") String counterName, IncrementShardedCounterInput incrementCounterInput) throws InstacountClientException {
                this.validateCounterName(counterName);
                Preconditions.checkNotNull((Object)incrementCounterInput);
                return this.instacount.incrementShardedCounter(counterName, incrementCounterInput);
            }

            @Override
            public DecrementShardedCounterResponse decrementShardedCounter(@Param(value="counterName") String counterName, DecrementShardedCounterInput decrementCounterInput) throws InstacountClientException {
                this.validateCounterName(counterName);
                Preconditions.checkNotNull((Object)decrementCounterInput);
                return this.instacount.decrementShardedCounter(counterName, decrementCounterInput);
            }

            @Override
            public GetShardedCounterOperationResponse getShardedCounterOperation(@Param(value="counterName") String counterName, @Param(value="shardIndex") Integer shardIndex, @Param(value="operationId") String operationId) throws InstacountClientException {
                this.validateCounterName(counterName);
                Preconditions.checkNotNull((Object)shardIndex);
                Preconditions.checkNotNull((Object)operationId);
                this.validateCounterName(operationId);
                return this.instacount.getShardedCounterOperation(counterName, shardIndex, operationId);
            }

            private void validateCounterName(String counterName) {
                Preconditions.checkNotNull((Object)counterName);
                Preconditions.checkArgument((counterName.length() > 0 ? 1 : 0) != 0);
            }
        }
    }

    public static interface InstacountFeign
    extends Instacount {
        @Override
        @RequestLine(value="POST /sharded_counters")
        public CreateShardedCounterResponse createShardedCounter() throws InstacountClientException;

        @Override
        @RequestLine(value="POST /sharded_counters")
        public CreateShardedCounterResponse createShardedCounter(CreateShardedCounterInput var1) throws InstacountClientException;

        @Override
        @RequestLine(value="GET /sharded_counters/{counterName}")
        public GetShardedCounterResponse getShardedCounter(@Param(value="counterName") String var1) throws InstacountClientException;

        @Override
        @RequestLine(value="PUT /sharded_counters/{counterName}")
        public UpdateShardedCounterResponse updateShardedCounter(@Param(value="counterName") String var1, UpdateShardedCounterInput var2) throws InstacountClientException;

        @Override
        @RequestLine(value="DELETE /sharded_counters/{counterName}")
        public DeleteShardedCounterResponse deleteShardedCounter(@Param(value="counterName") String var1) throws InstacountClientException;

        @Override
        @RequestLine(value="POST /sharded_counters/{counterName}/increments")
        public IncrementShardedCounterResponse incrementShardedCounter(@Param(value="counterName") String var1) throws InstacountClientException;

        @Override
        @RequestLine(value="POST /sharded_counters/{counterName}/decrements")
        public DecrementShardedCounterResponse decrementShardedCounter(@Param(value="counterName") String var1) throws InstacountClientException;

        @Override
        @RequestLine(value="POST /sharded_counters/{counterName}/increments")
        public IncrementShardedCounterResponse incrementShardedCounter(@Param(value="counterName") String var1, IncrementShardedCounterInput var2) throws InstacountClientException;

        @Override
        @RequestLine(value="POST /sharded_counters/{counterName}/decrements")
        public DecrementShardedCounterResponse decrementShardedCounter(@Param(value="counterName") String var1, DecrementShardedCounterInput var2) throws InstacountClientException;

        @Override
        @RequestLine(value="GET /sharded_counters/{counterName}/shards/{shardIndex}/operations/{operationId}")
        public GetShardedCounterOperationResponse getShardedCounterOperation(@Param(value="counterName") String var1, @Param(value="shardIndex") Integer var2, @Param(value="operationId") String var3) throws InstacountClientException;
    }
}

