/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client;

import com.google.common.base.Preconditions;
import feign.RequestInterceptor;
import feign.RequestTemplate;

interface InstacountOAuth2BearerRequestInterceptor
extends RequestInterceptor {
    public static final String GOOGLE_OAUTH2_SCOPE = "https://www.googleapis.com/auth/userinfo.email";

    public static class Impl
    implements InstacountOAuth2BearerRequestInterceptor {
        private final String accessToken;

        public Impl(String accessToken) {
            this.accessToken = (String)Preconditions.checkNotNull((Object)accessToken);
        }

        public void apply(RequestTemplate requestTemplate) {
            if (this.accessToken != null && this.accessToken.length() > 0) {
                requestTemplate.header("Authorization", new String[]{"Bearer " + this.accessToken});
            }
        }
    }
}

