/*
 * Decompiled with CFR 0.152.
 */
package io.instacount.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import feign.RequestInterceptor;
import io.instacount.client.Instacount;
import io.instacount.client.InstacountClientParams;
import io.instacount.client.InstacountOAuth2BearerRequestInterceptor;
import io.instacount.client.exceptions.InstacountClientException;
import io.instacount.client.model.Errors;
import io.instacount.client.model.InstacountResponse;
import io.instacount.client.model.shardedcounters.ShardedCounter;
import io.instacount.client.model.shardedcounters.ShardedCounterOperation;
import io.instacount.client.model.shardedcounters.inputs.CreateShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.DecrementShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.IncrementShardedCounterInput;
import io.instacount.client.model.shardedcounters.inputs.ShardedCounterStatusInput;
import io.instacount.client.model.shardedcounters.inputs.UpdateShardedCounterInput;
import io.instacount.client.model.shardedcounters.responses.CounterLocationInfo;
import io.instacount.client.model.shardedcounters.responses.CreateShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.DecrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.GetShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.IncrementShardedCounterResponse;
import io.instacount.client.model.shardedcounters.responses.UpdateShardedCounterResponse;
import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class InstacountClientTest {
    private static final boolean SYNC = false;
    private static final boolean ASYNC = true;
    private static Instacount client;

    @BeforeClass
    public static void before() {
        InstacountClientParams.AbstractInstacountClientParams params = new InstacountClientParams.AbstractInstacountClientParams(false){

            public String getInstacountApplicationId() {
                return (String)Preconditions.checkNotNull((Object)System.getenv("INSTACOUNT_APPLICATION_ID"), (Object)"System Env variable 'INSTACOUNT_APPLICATION_ID' not specified!");
            }

            public String getInstacountReadOnlyApplicationKey() {
                return (String)Preconditions.checkNotNull((Object)System.getenv("INSTACOUNT_READ_ONLY_KEY"), (Object)"System Env variable 'INSTACOUNT_READ_ONLY_KEY' not specified!");
            }

            public String getInstacountReadWriteApplicationKey() {
                return (String)Preconditions.checkNotNull((Object)System.getenv("INSTACOUNT_READ_WRITE_KEY"), (Object)"System Env variable 'INSTACOUNT_READ_WRITE_KEY' not specified!");
            }
        };
        String accessToken = System.getenv("GOOGLE_ACCOUNTS_OAUTH_ACCESS_TOKEN");
        if (!StringUtils.isBlank((CharSequence)accessToken)) {
            InstacountOAuth2BearerRequestInterceptor.Impl oauth2 = new InstacountOAuth2BearerRequestInterceptor.Impl(accessToken);
            client = Instacount.Builder.build((InstacountClientParams)params, (RequestInterceptor[])new RequestInterceptor[]{oauth2});
        } else {
            client = Instacount.Builder.build((InstacountClientParams)params, (RequestInterceptor[])new RequestInterceptor[0]);
        }
    }

    @Test
    public void testShardedCounterHappyPath() throws InstacountClientException {
        try {
            String counterName = UUID.randomUUID().toString();
            CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName);
            CreateShardedCounterResponse createdCounterResponse = client.createShardedCounter(createCounterInput);
            this.doBasicAssertions((InstacountResponse)createdCounterResponse, 201);
            GetShardedCounterResponse createdShardedCounterResponse = client.getShardedCounter(counterName);
            this.doBasicAssertions((InstacountResponse)createdShardedCounterResponse, 200);
            this.doShardedCounterAssertions(createdShardedCounterResponse.getShardedCounter(), counterName, (Optional<String>)Optional.absent(), 3, ShardedCounter.CounterStatus.AVAILABLE);
            IncrementShardedCounterResponse incrementShardedCounterResponse = client.incrementShardedCounter(counterName);
            this.doBasicAssertions((InstacountResponse)incrementShardedCounterResponse, 201);
            IncrementShardedCounterResponse incrementShardedCounterResponse2 = client.incrementShardedCounter(counterName, new IncrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(false)));
            this.doBasicAssertions((InstacountResponse)incrementShardedCounterResponse2, 201);
            DecrementShardedCounterResponse decrementShardedCounterResponse = client.decrementShardedCounter(counterName);
            this.doBasicAssertions((InstacountResponse)decrementShardedCounterResponse, 201);
            DecrementShardedCounterResponse decrementShardedCounterResponse2 = client.decrementShardedCounter(counterName, new DecrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(false)));
            this.doBasicAssertions((InstacountResponse)decrementShardedCounterResponse2, 201);
            GetShardedCounterResponse response = client.getShardedCounter(counterName);
            MatcherAssert.assertThat((Object)response.getHttpResponseCode(), (Matcher)Is.is((Object)200));
            this.doShardedCounterAssertions(response.getShardedCounter(), counterName, (Optional<String>)Optional.absent(), 3, ShardedCounter.CounterStatus.AVAILABLE);
            MatcherAssert.assertThat((Object)response.getShardedCounter().getCount(), (Matcher)Is.is((Object)BigInteger.ZERO));
        }
        catch (InstacountClientException e) {
            MatcherAssert.assertThat((Object)e.getErrors().getHttpResponseCode(), (Matcher)Is.is((Object)400));
            throw e;
        }
    }

    @Test(expected=NullPointerException.class)
    public void testCreateCounter_WithPayload_Null() throws InstacountClientException {
        client.createShardedCounter(null);
    }

    @Test
    public void testCreateCounter() throws InstacountClientException {
        CreateShardedCounterResponse actualResponse = client.createShardedCounter();
        this.doBasicAssertions((InstacountResponse)actualResponse, 201);
        CounterLocationInfo counterInfo = (CounterLocationInfo)actualResponse.getOptCounterInfo().get();
        MatcherAssert.assertThat((Object)counterInfo.getCounterName(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)counterInfo.getLocationUrl().startsWith("https://api.instacount.io"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCreateCounter_WithPayload_WithName() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName);
        CreateShardedCounterResponse actualResponse = client.createShardedCounter(createCounterInput);
        this.doBasicAssertions((InstacountResponse)actualResponse, 201);
        CounterLocationInfo counterInfo = (CounterLocationInfo)actualResponse.getOptCounterInfo().get();
        MatcherAssert.assertThat((Object)counterInfo.getCounterName(), (Matcher)Is.is((Object)counterName));
        MatcherAssert.assertThat((Object)counterInfo.getLocationUrl(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + counterName)));
        this.doShardedCounterAssertions(client.getShardedCounter(counterName).getShardedCounter(), counterName, (Optional<String>)Optional.absent(), 3, ShardedCounter.CounterStatus.AVAILABLE);
    }

    @Test
    public void testCreateCounter_WithPayload_WithNameAndDescription() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        String counterDescription = "Sample description from ClientTestHarness.java\"";
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName, "Sample description from ClientTestHarness.java\"");
        CreateShardedCounterResponse actualResponse = client.createShardedCounter(createCounterInput);
        this.doBasicAssertions((InstacountResponse)actualResponse, 201);
        CounterLocationInfo counterInfo = (CounterLocationInfo)actualResponse.getOptCounterInfo().get();
        MatcherAssert.assertThat((Object)counterInfo.getCounterName(), (Matcher)Is.is((Object)counterName));
        MatcherAssert.assertThat((Object)counterInfo.getLocationUrl(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + counterName)));
        this.doShardedCounterAssertions(client.getShardedCounter(counterName).getShardedCounter(), counterName, (Optional<String>)Optional.of((Object)"Sample description from ClientTestHarness.java\""), 3, ShardedCounter.CounterStatus.AVAILABLE);
    }

    @Test
    public void testCreateCounter_WithPayload_WithExistingCounterName() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName);
        CreateShardedCounterResponse actualResponse = client.createShardedCounter(createCounterInput);
        this.doBasicAssertions((InstacountResponse)actualResponse, 201);
        try {
            client.createShardedCounter(createCounterInput);
        }
        catch (InstacountClientException e) {
            MatcherAssert.assertThat((Object)e.getErrors(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            MatcherAssert.assertThat((Object)e.getErrors().getHttpResponseCode(), (Matcher)Is.is((Object)409));
            MatcherAssert.assertThat((Object)e.getErrors().getErrors(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            MatcherAssert.assertThat((Object)e.getErrors().getErrors().size(), (Matcher)Is.is((Object)1));
            Errors.Error error = (Errors.Error)e.getErrors().getErrors().get(0);
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Is.is((Object)"This counter already exists!"));
            MatcherAssert.assertThat((Object)error.getDeveloperMessage(), (Matcher)Is.is((Object)"A sharded counter with the specified name already exists!"));
            MatcherAssert.assertThat((Object)error.getMoreInfo(), (Matcher)Is.is((Object)"https://instacount.readme.io"));
        }
    }

    @Test
    public void testCreateCounter_WithFullPayload() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        String counterDescription = "Sample description from ClientTestHarness.java\"";
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName, Optional.of((Object)"Sample description from ClientTestHarness.java\""), 3, ShardedCounterStatusInput.READ_ONLY_COUNT);
        CreateShardedCounterResponse actualResponse = client.createShardedCounter(createCounterInput);
        this.doBasicAssertions((InstacountResponse)actualResponse, 201);
        CounterLocationInfo counterInfo = (CounterLocationInfo)actualResponse.getOptCounterInfo().get();
        MatcherAssert.assertThat((Object)counterInfo.getCounterName(), (Matcher)Is.is((Object)counterName));
        MatcherAssert.assertThat((Object)counterInfo.getLocationUrl(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + counterName)));
        ShardedCounter createdShardedCounter = client.getShardedCounter(counterName).getShardedCounter();
        this.doShardedCounterAssertions(createdShardedCounter, counterName, (Optional<String>)Optional.of((Object)"Sample description from ClientTestHarness.java\""), 3, ShardedCounter.CounterStatus.READ_ONLY_COUNT);
    }

    @Test(expected=NullPointerException.class)
    public void testGetCounter_NullCounterName() throws InstacountClientException {
        client.getShardedCounter(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCounter_EmptCounterName() throws InstacountClientException {
        client.getShardedCounter("");
    }

    @Test
    public void testGetCounter_NonExistentCounterName() throws InstacountClientException {
        try {
            String counterName = UUID.randomUUID().toString();
            CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName);
            client.createShardedCounter(createCounterInput);
            client.getShardedCounter(counterName);
        }
        catch (InstacountClientException e) {
            this.doNotFoundAssertions(e.getErrors());
        }
    }

    @Test
    public void testGetCounter() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName);
        CreateShardedCounterResponse createResponse = client.createShardedCounter(createCounterInput);
        GetShardedCounterResponse shardedCounter = client.getShardedCounter(((CounterLocationInfo)createResponse.getOptCounterInfo().get()).getCounterName());
        this.doShardedCounterAssertions(shardedCounter.getShardedCounter(), counterName, (Optional<String>)Optional.absent(), 3, ShardedCounter.CounterStatus.AVAILABLE);
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateCounter_NullCounterName() throws InstacountClientException {
        client.updateShardedCounter(null, (UpdateShardedCounterInput)Mockito.mock(UpdateShardedCounterInput.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUpdateCounter_EmptyCounterName() throws InstacountClientException {
        client.updateShardedCounter("", (UpdateShardedCounterInput)Mockito.mock(UpdateShardedCounterInput.class));
    }

    @Test(expected=NullPointerException.class)
    public void testUpdateCounter_NullCounterInput() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.updateShardedCounter(counterName, null);
    }

    @Test
    public void testUpdateCounter_NonExistentCounterName() throws InstacountClientException {
        try {
            UpdateShardedCounterInput updateCounterInput = new UpdateShardedCounterInput("foo");
            client.updateShardedCounter("foo", updateCounterInput);
        }
        catch (InstacountClientException e) {
            this.doNotFoundAssertions(e.getErrors());
        }
    }

    @Test
    public void testUpdateCounter() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        CreateShardedCounterInput createCounterInput = new CreateShardedCounterInput(counterName, Optional.absent(), 1, ShardedCounterStatusInput.AVAILABLE);
        client.createShardedCounter(createCounterInput);
        UpdateShardedCounterInput updateCounterInput = new UpdateShardedCounterInput(counterName, Optional.of((Object)"New Description"), 3, ShardedCounterStatusInput.READ_ONLY_COUNT);
        UpdateShardedCounterResponse updatedShardedCounterResponse = client.updateShardedCounter(counterName, updateCounterInput);
        MatcherAssert.assertThat((Object)updatedShardedCounterResponse.getHttpResponseCode(), (Matcher)Is.is((Object)200));
        ShardedCounter updatedShardedCounter = updatedShardedCounterResponse.getShardedCounter();
        MatcherAssert.assertThat((Object)updatedShardedCounter.getName(), (Matcher)Is.is((Object)counterName));
        MatcherAssert.assertThat((Object)updatedShardedCounter.getCounterStatus(), (Matcher)Is.is((Object)ShardedCounter.CounterStatus.READ_ONLY_COUNT));
        MatcherAssert.assertThat((Object)updatedShardedCounter.getOptDescription().get(), (Matcher)Is.is((Object)"New Description"));
        MatcherAssert.assertThat((Object)updatedShardedCounter.getNumShards(), (Matcher)Is.is((Object)3));
    }

    @Test(expected=NullPointerException.class)
    public void testIncrement_NullCounterName() throws InstacountClientException {
        client.incrementShardedCounter(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIncrement_EmptyCounterName() throws InstacountClientException {
        client.incrementShardedCounter("");
    }

    @Test(expected=NullPointerException.class)
    public void testIncrement_NullPayload() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.incrementShardedCounter(counterName, null);
    }

    @Test
    public void testIncrement_NoPayload() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.incrementShardedCounter(counterName);
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getShardedCounter().getCount(), (Matcher)Is.is((Object)BigInteger.valueOf(1L)));
    }

    @Test
    public void testIncrement_Sync() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        IncrementShardedCounterResponse response = client.incrementShardedCounter(counterName, new IncrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(false)));
        MatcherAssert.assertThat((Object)response.getOptCounterOperation().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getAmount(), (Matcher)Is.is((Object)BigInteger.TEN));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getCounterOperationType(), (Matcher)Is.is((Object)ShardedCounterOperation.CounterOperationType.INCREMENT));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getShardIndex(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)0), (Matcher)Is.is((Object)1), (Matcher)Is.is((Object)2)));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getId(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getShardedCounter().getCount(), (Matcher)Is.is((Object)BigInteger.TEN));
    }

    @Test
    public void testIncrement_Async() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        IncrementShardedCounterResponse response = client.incrementShardedCounter(counterName, new IncrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(true)));
        MatcherAssert.assertThat((Object)response.getHttpResponseCode(), (Matcher)Is.is((Object)202));
        MatcherAssert.assertThat((Object)response.getOptCounterOperation().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getHttpResponseCode(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)200), (Matcher)Is.is((Object)404)));
    }

    @Test(expected=NullPointerException.class)
    public void testDecrement_NullCounterName() throws InstacountClientException {
        client.decrementShardedCounter(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecrement_EmptyCounterName() throws InstacountClientException {
        client.decrementShardedCounter("");
    }

    @Test(expected=NullPointerException.class)
    public void testDecrement_NullPayload() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.decrementShardedCounter(counterName, null);
    }

    @Test
    public void testDecrement_NoPayload() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.decrementShardedCounter(counterName);
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getShardedCounter().getCount(), (Matcher)Is.is((Object)BigInteger.valueOf(-1L)));
    }

    @Test
    public void testDecrement_Sync() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        DecrementShardedCounterResponse response = client.decrementShardedCounter(counterName, new DecrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(false)));
        MatcherAssert.assertThat((Object)response.getOptCounterOperation().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getAmount(), (Matcher)Is.is((Object)BigInteger.TEN));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getCounterOperationType(), (Matcher)Is.is((Object)ShardedCounterOperation.CounterOperationType.DECREMENT));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getShardIndex(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)0), (Matcher)Is.is((Object)1), (Matcher)Is.is((Object)2)));
        MatcherAssert.assertThat((Object)((ShardedCounterOperation)response.getOptCounterOperation().get()).getId(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getShardedCounter().getCount(), (Matcher)Is.is((Object)BigInteger.valueOf(-10L)));
    }

    @Test
    public void testDecrement_Async() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        DecrementShardedCounterResponse response = client.decrementShardedCounter(counterName, new DecrementShardedCounterInput(BigInteger.TEN, Boolean.valueOf(true)));
        MatcherAssert.assertThat((Object)response.getHttpResponseCode(), (Matcher)Is.is((Object)202));
        MatcherAssert.assertThat((Object)response.getOptCounterOperation().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)client.getShardedCounter(counterName).getHttpResponseCode(), (Matcher)CoreMatchers.anyOf((Matcher)Is.is((Object)200), (Matcher)Is.is((Object)404)));
    }

    @Test(expected=NullPointerException.class)
    public void testGetCounterOperation_NullCounterName() throws InstacountClientException {
        client.getShardedCounterOperation(null, Integer.valueOf(0), UUID.randomUUID().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCounterOperation_EmptyCounterName() throws InstacountClientException {
        client.getShardedCounterOperation("", Integer.valueOf(0), UUID.randomUUID().toString());
    }

    @Test(expected=NullPointerException.class)
    public void testGetCounterOperation_NullShardIndex() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.getShardedCounterOperation(counterName, null, UUID.randomUUID().toString());
    }

    @Test(expected=NullPointerException.class)
    public void testGetCounterOperation_NullOperationId() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.getShardedCounterOperation(counterName, Integer.valueOf(1), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCounterOperation_EmptyOperationId() throws InstacountClientException {
        String counterName = UUID.randomUUID().toString();
        client.getShardedCounterOperation(counterName, Integer.valueOf(1), "");
    }

    @Test
    public void testGetCounterOperationIndex() throws InstacountClientException {
        CreateShardedCounterResponse result = client.createShardedCounter();
        String counterName = ((CounterLocationInfo)result.getOptCounterInfo().get()).getCounterName();
        ShardedCounterOperation createdCounterOperation = (ShardedCounterOperation)client.incrementShardedCounter(counterName).getOptCounterOperation().get();
        ShardedCounterOperation loadedCounterOperation = client.getShardedCounterOperation(counterName, createdCounterOperation.getShardIndex(), createdCounterOperation.getId()).getCounterOperation();
        this.doCounterOperationAssertions(createdCounterOperation, counterName, loadedCounterOperation.getId(), loadedCounterOperation.getShardIndex(), loadedCounterOperation.getCounterOperationType(), loadedCounterOperation.getAmount());
    }

    private void doShardedCounterAssertions(ShardedCounter actualShardedCounter, String expectedCounterName, Optional<String> optExpectedDescription, int expectedNumShards, ShardedCounter.CounterStatus expectedCounterStatus) {
        MatcherAssert.assertThat((Object)actualShardedCounter.getMeta().getSelfLink().getHrefUrl().toString(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + expectedCounterName)));
        MatcherAssert.assertThat((Object)actualShardedCounter.getMeta().getIncrementsLink().getHrefUrl().toString(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + expectedCounterName + "/increments")));
        MatcherAssert.assertThat((Object)actualShardedCounter.getMeta().getDecrementsLink().getHrefUrl().toString(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + expectedCounterName + "/decrements")));
        MatcherAssert.assertThat((Object)actualShardedCounter.getName(), (Matcher)Is.is((Object)expectedCounterName));
        if (optExpectedDescription.isPresent()) {
            MatcherAssert.assertThat((Object)actualShardedCounter.getOptDescription().isPresent(), (Matcher)Is.is((Object)true));
            MatcherAssert.assertThat((Object)actualShardedCounter.getOptDescription().get(), (Matcher)Is.is((Object)optExpectedDescription.get()));
        } else {
            MatcherAssert.assertThat((Object)actualShardedCounter.getOptDescription().isPresent(), (Matcher)Is.is((Object)false));
        }
        MatcherAssert.assertThat((Object)actualShardedCounter.getNumShards(), (Matcher)Is.is((Object)expectedNumShards));
        MatcherAssert.assertThat((Object)actualShardedCounter.getCounterStatus(), (Matcher)Is.is((Object)expectedCounterStatus));
        MatcherAssert.assertThat((Object)actualShardedCounter.getCreatedDateTime(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    private void doCounterOperationAssertions(ShardedCounterOperation counterOperation, String expectedCounterName, String expectedOperationId, int expectedShardIndex, ShardedCounterOperation.CounterOperationType expectedCounterOperationType, BigInteger expectedAmount) {
        MatcherAssert.assertThat((Object)counterOperation.getMeta().getSelfLink().getHrefUrl().toString(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + expectedCounterName + "/shards/" + expectedShardIndex + "/operations/" + expectedOperationId)));
        MatcherAssert.assertThat((Object)counterOperation.getMeta().getCounterLink().getHrefUrl().toString(), (Matcher)Is.is((Object)("https://api.instacount.io/sharded_counters/" + expectedCounterName)));
        MatcherAssert.assertThat((Object)counterOperation.getId(), (Matcher)Is.is((Object)expectedOperationId));
        MatcherAssert.assertThat((Object)counterOperation.getShardIndex(), (Matcher)Is.is((Object)expectedShardIndex));
        MatcherAssert.assertThat((Object)counterOperation.getCounterOperationType(), (Matcher)Is.is((Object)expectedCounterOperationType));
        MatcherAssert.assertThat((Object)counterOperation.getAmount(), (Matcher)Is.is((Object)expectedAmount));
        MatcherAssert.assertThat((Object)counterOperation.getCreatedDateTime(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    private void doBasicAssertions(InstacountResponse instacountResponse, int expectedHttpResponseCode) {
        MatcherAssert.assertThat((Object)instacountResponse.getHttpResponseCode(), (Matcher)Is.is((Object)expectedHttpResponseCode));
        MatcherAssert.assertThat((Object)instacountResponse.getQuota(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)(instacountResponse.getQuota().getNumAccessRequestsLimit() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(instacountResponse.getQuota().getNumMutationRequestsLimit() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(instacountResponse.getQuota().getNumAccessRequestsRemaining() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)(instacountResponse.getQuota().getNumAccessRequestsRemaining() > 0L ? 1 : 0), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)instacountResponse.getResponse(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    private void doNotFoundAssertions(Errors errors) {
        MatcherAssert.assertThat((Object)errors, (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)errors.getHttpResponseCode(), (Matcher)Is.is((Object)404));
        MatcherAssert.assertThat((Object)errors.getErrors(), (Matcher)Is.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        MatcherAssert.assertThat((Object)errors.getErrors().size(), (Matcher)Is.is((Object)1));
        Errors.Error error = (Errors.Error)errors.getErrors().get(0);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Is.is((Object)"What you requested does not exist."));
        MatcherAssert.assertThat((Object)error.getDeveloperMessage(), (Matcher)Is.is((Object)"The requested resource was not found!"));
        MatcherAssert.assertThat((Object)error.getMoreInfo(), (Matcher)Is.is((Object)"https://instacount.readme.io"));
    }
}

