/*
 * Decompiled with CFR 0.152.
 */
package io.ino.time;

import io.ino.time.Clock$;

public interface Clock {
    public static MutableClock mutable() {
        return Clock$.MODULE$.mutable();
    }

    public static SystemClock systemDefault() {
        return Clock$.MODULE$.systemDefault();
    }

    public long millis();

    public static class MutableClock
    implements Clock {
        private long _millis = 0L;

        @Override
        public long millis() {
            return this._millis;
        }

        public void set(long millis) {
            this._millis = millis;
        }

        public void advance(long by) {
            this._millis += by;
        }

        public void resetToZero() {
            this._millis = 0L;
        }

        public void resetToSystemMillis() {
            this._millis = System.currentTimeMillis();
        }
    }

    public static class SystemClock
    implements Clock {
        @Override
        public long millis() {
            return System.currentTimeMillis();
        }
    }
}

