/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs.future;

import io.ino.solrs.future.Future;
import io.ino.solrs.future.Promise;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class FutureBase<T>
implements Future<T> {
    public <A, B> void mapSuccess(Promise<B> promise, Function1<A, B> f, A value) {
        try {
            promise.success(f.apply(value));
        }
        catch (Throwable err) {
            promise.failure(err);
        }
    }

    public <A, B> void flatMapSuccess(Promise<B> p, Function1<A, Future<B>> f, A value) {
        try {
            ((Future)f.apply(value)).onComplete((JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    Object x = ((Success)try_).value();
                    p.success(x);
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    p.failure(t);
                    return;
                }
                throw new MatchError((Object)try_);
            });
        }
        catch (Throwable err) {
            p.failure(err);
        }
    }

    public <U> void handleFailure(Promise<U> p, PartialFunction<Throwable, U> pf, Throwable t) {
        try {
            if (pf.isDefinedAt((Object)t)) {
                p.success(pf.apply((Object)t));
            } else {
                p.failure(t);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable pft = throwable3 = (Throwable)option.get();
                p.failure(pft);
            }
            throw throwable;
        }
    }

    public <U> Object handleWithFailure(Promise<U> p, PartialFunction<Throwable, Future<U>> pf, Throwable t) {
        BoxedUnit boxedUnit;
        try {
            Future x = (Future)pf.applyOrElse((Object)t, (Function1 & Serializable)_$1 -> this);
            boxedUnit = x.map((JProcedure1 & Serializable)v -> p.success(v)).handle(new Serializable(p){
                private final Promise p$3;
                {
                    this.p$3 = p$4;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        this.p$3.failure(e);
                        return BoxedUnit.UNIT;
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                throw throwable;
            }
            Throwable e = throwable2 = (Throwable)option.get();
            p.failure(e);
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }
}

