/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.LoadBalancer;
import io.ino.solrs.LoadBalancer$NoSolrServersAvailableException$;
import io.ino.solrs.RoundRobinLB$;
import io.ino.solrs.ShardReplica$;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.Utils$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.apache.solr.client.solrj.SolrRequest;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class RoundRobinLB
implements LoadBalancer {
    private final SolrServers solrServers;
    private final boolean isUpdatesToLeaders;
    private final AtomicInteger idx;
    private final IntUnaryOperator op;

    public static RoundRobinLB apply(IndexedSeq<String> indexedSeq, boolean bl) {
        return RoundRobinLB$.MODULE$.apply(indexedSeq, bl);
    }

    public static RoundRobinLB apply(SolrServers solrServers) {
        return RoundRobinLB$.MODULE$.apply(solrServers);
    }

    public static RoundRobinLB apply(SolrServers solrServers, boolean bl) {
        return RoundRobinLB$.MODULE$.apply(solrServers, bl);
    }

    public static RoundRobinLB create(java.lang.Iterable<String> iterable) {
        return RoundRobinLB$.MODULE$.create(iterable);
    }

    public static RoundRobinLB create(java.lang.Iterable<String> iterable, boolean bl) {
        return RoundRobinLB$.MODULE$.create(iterable, bl);
    }

    public static boolean apply$default$2() {
        return RoundRobinLB$.MODULE$.apply$default$2();
    }

    public RoundRobinLB(SolrServers solrServers, boolean isUpdatesToLeaders) {
        this.solrServers = solrServers;
        this.isUpdatesToLeaders = isUpdatesToLeaders;
        this.idx = new AtomicInteger(1);
        this.op = new IntUnaryOperator(){

            public int applyAsInt(int operand) {
                if (operand == Integer.MAX_VALUE) {
                    return 0;
                }
                return operand + 1;
            }
        };
    }

    @Override
    public SolrServers solrServers() {
        return this.solrServers;
    }

    public RoundRobinLB(SolrServers solrServers) {
        this(solrServers, false);
    }

    @Override
    public Try<SolrServer> solrServer(SolrRequest<?> r, Option<SolrServer> preferred) {
        return this.solrServers().matching(r).flatMap((Function1 & Serializable)matching -> {
            IndexedSeq servers = (IndexedSeq)matching.filter((Function1 & Serializable)_$1 -> _$1.isEnabled());
            if (servers.isEmpty()) {
                return Failure$.MODULE$.apply((Throwable)LoadBalancer$NoSolrServersAvailableException$.MODULE$.apply((Iterable<SolrServer>)matching));
            }
            if (preferred.isDefined() && servers.exists((Function1 & Serializable)_$2 -> {
                String string = _$2.baseUrl();
                String string2 = ((SolrServer)preferred.get()).baseUrl();
                return !(string != null ? !string.equals(string2) : string2 != null);
            })) {
                return Success$.MODULE$.apply(preferred.get());
            }
            if (this.isUpdatesToLeaders && this.isUpdateToLeader((SolrRequest)r, servers)) {
                return Utils$.MODULE$.OptionOps(this.solrServers().findLeader((Iterable<SolrServer>)servers)).toTry("no leader found");
            }
            IndexedSeq<SolrServer> preferred = ShardReplica$.MODULE$.filterByShardPreference(r, (IndexedSeq<SolrServer>)servers);
            int next = this.idx.getAndUpdate(this.op);
            int newIndex = next % preferred.length();
            return Success$.MODULE$.apply(preferred.apply(newIndex));
        });
    }

    public Option<SolrServer> solrServer$default$2() {
        return None$.MODULE$;
    }
}

