/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.Promise;
import java.io.Serializable;
import org.apache.solr.client.solrj.SolrRequest;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.util.Success$;
import scala.util.Try;

public class ReloadingSolrServers<F>
implements SolrServers {
    private final String url;
    private final Function1<byte[], IndexedSeq<SolrServer>> extractor;
    private final AsyncHttpClient httpClient;
    private final FutureFactory<F> futureFactory;
    public final Logger io$ino$solrs$ReloadingSolrServers$$logger;
    private IndexedSeq<SolrServer> solrServers;

    public ReloadingSolrServers(String url, Function1<byte[], IndexedSeq<SolrServer>> extractor, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this.url = url;
        this.extractor = extractor;
        this.httpClient = httpClient;
        this.futureFactory = futureFactory;
        this.io$ino$solrs$ReloadingSolrServers$$logger = LoggerFactory.getLogger(this.getClass());
        this.solrServers = (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
    }

    public IndexedSeq<SolrServer> all() {
        return this.solrServers;
    }

    @Override
    public Try<IndexedSeq<SolrServer>> matching(SolrRequest<?> r) {
        return Success$.MODULE$.apply(this.solrServers);
    }

    public F reload() {
        Future f = this.loadUrl().map((Function1 & Serializable)data -> {
            IndexedSeq<SolrServer> oldServers = this.solrServers;
            this.solrServers = (IndexedSeq)this.extractor.apply(data);
            this.io$ino$solrs$ReloadingSolrServers$$logger.info(new StringBuilder(30).append("Changed solr servers from ").append(oldServers).append(" to ").append(this.solrServers).toString());
            return this.solrServers;
        });
        return (F)this.futureFactory.toBase().apply(f);
    }

    public Future<byte[]> loadUrl() {
        Promise promise = this.futureFactory.newPromise();
        this.httpClient.prepareGet(this.url).execute((AsyncHandler)new AsyncCompletionHandler<Response>(promise, this){
            private final Promise promise$1;
            private final /* synthetic */ ReloadingSolrServers $outer;
            {
                this.promise$1 = promise$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Response onCompleted(Response response) {
                this.promise$1.success(response.getResponseBodyAsBytes());
                return response;
            }

            public void onThrowable(Throwable t) {
                this.$outer.io$ino$solrs$ReloadingSolrServers$$logger.error("Could not load solr server list.", t);
                this.promise$1.failure(t);
            }
        });
        return promise.future();
    }
}

