/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClientAware;
import io.ino.solrs.Enabled$;
import io.ino.solrs.FastestServerLB$;
import io.ino.solrs.FastestServerLB$Builder$;
import io.ino.solrs.FastestServerLBJmxSupport;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.LoadBalancer$NoSolrServersAvailableException$;
import io.ino.solrs.PerformanceStats;
import io.ino.solrs.ServerStateChangeObservable;
import io.ino.solrs.ServerStateChangeObservable$Removed$;
import io.ino.solrs.ServerStateChangeObservable$StateChanged$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.ShardReplica$;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServerId;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StateChangeObserver;
import io.ino.solrs.Utils$;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.FutureFactory$;
import io.ino.solrs.future.JavaFutureFactory$;
import io.ino.time.Clock;
import io.ino.time.Units;
import io.ino.time.Units$Millisecond$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public class FastestServerLB<F>
implements LoadBalancer,
AsyncSolrClientAware<F>,
FastestServerLBJmxSupport<F> {
    private final SolrServers solrServers;
    private final Function1 collectionAndTestQuery;
    private final Duration minDelay;
    private final Duration maxDelay;
    private final int initialTestRuns;
    private final Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> filterFastServers;
    private final Function1 mapPredictedResponseTime;
    private final boolean isUpdatesToLeaders;
    private final Clock clock;
    public final FutureFactory<F> io$ino$solrs$FastestServerLB$$futureFactory;
    public final Logger io$ino$solrs$FastestServerLB$$logger;
    private AsyncSolrClient<F> client;
    private final ScheduledExecutorService scheduler;
    private final TrieMap statsByServer;
    private final Map serverTestTimestamp;
    private scala.collection.immutable.Map fastServersByCollection;
    private final AtomicInteger lastServerIdx;

    public static String TestQueryClass() {
        return FastestServerLB$.MODULE$.TestQueryClass();
    }

    public static Builder builder(SolrServers solrServers, Function<SolrServer, Tuple2<String, SolrQuery>> function) {
        return FastestServerLB$.MODULE$.builder(solrServers, function);
    }

    public static <F> Duration $lessinit$greater$default$3() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> Duration $lessinit$greater$default$4() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> int $lessinit$greater$default$5() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F> Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> $lessinit$greater$default$6() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$6();
    }

    public static <F> Function1<Object, Object> $lessinit$greater$default$7() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$7();
    }

    public static <F> boolean $lessinit$greater$default$8() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$8();
    }

    public static <F> Clock $lessinit$greater$default$9() {
        return FastestServerLB$.MODULE$.$lessinit$greater$default$9();
    }

    public FastestServerLB(SolrServers solrServers, Function1<SolrServer, Tuple2<String, SolrQuery>> collectionAndTestQuery, Duration minDelay, Duration maxDelay, int initialTestRuns, Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> filterFastServers, Function1<Object, Object> mapPredictedResponseTime, boolean isUpdatesToLeaders, Clock clock, FutureFactory<F> futureFactory) {
        this.solrServers = solrServers;
        this.collectionAndTestQuery = collectionAndTestQuery;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.initialTestRuns = initialTestRuns;
        this.filterFastServers = filterFastServers;
        this.mapPredictedResponseTime = mapPredictedResponseTime;
        this.isUpdatesToLeaders = isUpdatesToLeaders;
        this.clock = clock;
        this.io$ino$solrs$FastestServerLB$$futureFactory = futureFactory;
        this.io$ino$solrs$FastestServerLB$$logger = LoggerFactory.getLogger(this.getClass());
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.statsByServer = TrieMap$.MODULE$.empty();
        this.serverTestTimestamp = TrieMap$.MODULE$.empty().withDefaultValue((Object)new Units.Millisecond(Units$Millisecond$.MODULE$.apply(0L)));
        this.fastServersByCollection = Predef$.MODULE$.Map().empty().withDefaultValue((Object)Predef$.MODULE$.Set().empty());
        this.lastServerIdx = new AtomicInteger(-1);
        this.init();
    }

    @Override
    public SolrServers solrServers() {
        return this.solrServers;
    }

    public Function1<SolrServer, Tuple2<String, SolrQuery>> collectionAndTestQuery() {
        return this.collectionAndTestQuery;
    }

    public Function1<Object, Object> mapPredictedResponseTime() {
        return this.mapPredictedResponseTime;
    }

    public TrieMap<String, PerformanceStats> statsByServer() {
        return this.statsByServer;
    }

    public Map<String, Units.Millisecond> serverTestTimestamp() {
        return this.serverTestTimestamp;
    }

    public scala.collection.immutable.Map<String, Set<String>> fastServersByCollection() {
        return this.fastServersByCollection;
    }

    public void fastServersByCollection_$eq(scala.collection.immutable.Map<String, Set<String>> x$1) {
        this.fastServersByCollection = x$1;
    }

    private String collection(SolrServer server) {
        return (String)((Tuple2)this.collectionAndTestQuery().apply((Object)server))._1();
    }

    private SolrQuery testQuery(SolrServer server) {
        return (SolrQuery)((Tuple2)this.collectionAndTestQuery().apply((Object)server))._2();
    }

    public void init() {
        this.subscribeToServerChanges();
        this.scheduleTests();
        this.scheduleUpdateStats();
        this.initJmx();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdownNow();
        this.shutdownJmx();
    }

    public void subscribeToServerChanges() {
        SolrServers solrServers = this.solrServers();
        if (solrServers instanceof ServerStateChangeObservable) {
            ServerStateChangeObservable observable = (ServerStateChangeObservable)((Object)solrServers);
            observable.register(new StateChangeObserver(this){
                private final /* synthetic */ FastestServerLB $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onStateChange(ServerStateChangeObservable.StateChange event) {
                    ServerStateChangeObservable.StateChange stateChange = event;
                    if (stateChange instanceof ServerStateChangeObservable.Removed) {
                        ServerStateChangeObservable.Removed removed = ServerStateChangeObservable$Removed$.MODULE$.unapply((ServerStateChangeObservable.Removed)stateChange);
                        SolrServer solrServer = removed._1();
                        String string = removed._2();
                        SolrServer server = solrServer;
                        if (server.isEnabled()) {
                            this.$outer.statsByServer().remove((Object)new SolrServerId(server.id()));
                            this.$outer.serverTestTimestamp().remove((Object)new SolrServerId(server.id()));
                            return;
                        }
                    }
                    if (stateChange instanceof ServerStateChangeObservable.StateChanged) {
                        ServerStateChangeObservable.StateChanged stateChanged = ServerStateChangeObservable$StateChanged$.MODULE$.unapply((ServerStateChangeObservable.StateChanged)stateChange);
                        SolrServer solrServer = stateChanged._1();
                        SolrServer solrServer2 = stateChanged._2();
                        String string = stateChanged._3();
                        SolrServer from = solrServer;
                        SolrServer to = solrServer2;
                        if (from.isEnabled() && !to.isEnabled()) {
                            this.$outer.statsByServer().remove((Object)new SolrServerId(from.id()));
                            this.$outer.serverTestTimestamp().remove((Object)new SolrServerId(from.id()));
                            return;
                        }
                    }
                }
            });
            return;
        }
    }

    public void scheduleTests() {
        this.scheduler.schedule(new Runnable(this){
            private final /* synthetic */ FastestServerLB $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                Seq maybeTestFutures = (Seq)((IterableOps)this.$outer.solrServers().all().filter(FastestServerLB::io$ino$solrs$FastestServerLB$$anon$3$$_$_$$anonfun$2)).map((Function1 & Serializable)server -> this.$outer.io$ino$solrs$FastestServerLB$$testWithMinDelay((SolrServer)server));
                Seq testFutures = (Seq)maybeTestFutures.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Option x) {
                        Option option = x;
                        if (option instanceof Some) {
                            Future future = (Future)((Some)option).value();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Option x, Function1 function1) {
                        Option option = x;
                        if (option instanceof Some) {
                            Future future = (Future)((Some)option).value();
                            return future;
                        }
                        return function1.apply((Object)x);
                    }
                });
                FutureFactory$.MODULE$.sequence(testFutures, BuildFrom$.MODULE$.buildFromIterableOps(), this.$outer.io$ino$solrs$FastestServerLB$$futureFactory).onComplete((JProcedure1 & Serializable)_$6 -> this.$outer.scheduleTests());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$ino$solrs$FastestServerLB$$anon$3$$_$_$$anonfun$2(io.ino.solrs.SolrServer ), $anonfun$3(io.ino.solrs.SolrServer ), run$$anonfun$1(scala.util.Try )}, serializedLambda);
            }
        }, this.maxDelay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void scheduleUpdateStats() {
        long initialDelay = this.clock.millis() % 1000L;
        this.scheduler.scheduleAtFixedRate(new Runnable(this){
            private final /* synthetic */ FastestServerLB $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                try {
                    this.$outer.updateStats();
                }
                catch (Throwable e) {
                    this.$outer.io$ino$solrs$FastestServerLB$$logger.error("An error occurred when trying to updateStats().", e);
                }
            }
        }, initialDelay, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setAsyncSolrClient(AsyncSolrClient<F> client) {
        this.client = client;
        Seq futures = (Seq)((IterableOps)this.solrServers().all().filter((Function1 & Serializable)_$7 -> _$7.isEnabled())).map((Function1 & Serializable)server -> (Future)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.initialTestRuns).foldLeft(this.io$ino$solrs$FastestServerLB$$futureFactory.successful(BoxedUnit.UNIT), (Function2 & Serializable)(res, _$8) -> this.$anonfun$5$$anonfun$1((SolrServer)server, (Future)res, BoxesRunTime.unboxToInt((Object)_$8))));
        FutureFactory$.MODULE$.sequence(futures, BuildFrom$.MODULE$.buildFromIterableOps(), this.io$ino$solrs$FastestServerLB$$futureFactory).onComplete((JProcedure1 & Serializable)_$11 -> this.updateStats());
    }

    @Override
    public Try<SolrServer> solrServer(SolrRequest<?> r, Option<SolrServer> preferred) {
        return this.solrServers().matching(r).flatMap((Function1 & Serializable)matching -> {
            IndexedSeq servers = (IndexedSeq)matching.filter((Function1 & Serializable)_$12 -> _$12.isEnabled());
            if (servers.isEmpty()) {
                return Failure$.MODULE$.apply((Throwable)LoadBalancer$NoSolrServersAvailableException$.MODULE$.apply((Iterable<SolrServer>)matching));
            }
            if (this.isUpdatesToLeaders && this.isUpdateToLeader((SolrRequest)r, servers)) {
                return Utils$.MODULE$.OptionOps(this.solrServers().findLeader((Iterable<SolrServer>)servers)).toTry("no leader found");
            }
            IndexedSeq<SolrServer> preferredReplicas = ShardReplica$.MODULE$.filterByShardPreference(r, (IndexedSeq<SolrServer>)servers);
            Tuple2<Object, SolrServer> tuple2 = this.findBestServer(preferredReplicas, this.lastServerIdx.get(), preferred);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int serverIdx = BoxesRunTime.unboxToInt((Object)tuple2._1());
            SolrServer result = (SolrServer)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)serverIdx), (Object)result);
            int serverIdx2 = BoxesRunTime.unboxToInt((Object)tuple22._1());
            SolrServer result2 = (SolrServer)tuple22._2();
            this.lastServerIdx.lazySet(serverIdx2);
            return Success$.MODULE$.apply((Object)result2);
        });
    }

    public Option<SolrServer> solrServer$default$2() {
        return None$.MODULE$;
    }

    @Override
    public <T extends SolrResponse> Future<T> interceptRequest(Function2<SolrServer, SolrRequest<? extends T>, Future<T>> f, SolrServer solrServer, SolrRequest<? extends T> r) {
        Future res = (Future)f.apply((Object)solrServer, r);
        this.solrServers().matching(r).foreach((Function1)(JProcedure1 & Serializable)matchingServers -> ((IterableOnceOps)matchingServers.filter((Function1 & Serializable)server -> {
            Set fastServers = (Set)this.fastServersByCollection().apply((Object)this.collection((SolrServer)server));
            return server.isEnabled() && fastServers.contains((Object)new SolrServerId(server.id()));
        })).foreach((Function1 & Serializable)server -> this.io$ino$solrs$FastestServerLB$$testWithMinDelay((SolrServer)server)));
        return res;
    }

    private Tuple2<Object, SolrServer> findBestServer(IndexedSeq<SolrServer> servers, int lastServerIdx, Option<SolrServer> preferred) {
        Seq serversByDuration = (Seq)servers.groupBy((Function1 & Serializable)server -> this.mapPredictedResponseTime().apply$mcJJ$sp(this.stats((SolrServer)server).predictDuration(FastestServerLB$.MODULE$.TestQueryClass()))).toSeq().sortBy((Function1 & Serializable)_$13 -> BoxesRunTime.unboxToLong((Object)_$13._1()), (Ordering)Ordering.Long$.MODULE$);
        IndexedSeq fastestServers = (IndexedSeq)((Tuple2)serversByDuration.head())._2();
        if (preferred.isDefined() && fastestServers.exists((Function1 & Serializable)s -> {
            String string = s.baseUrl();
            String string2 = ((SolrServer)preferred.get()).baseUrl();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            ServerStatus serverStatus = s.status();
            Enabled$ enabled$ = Enabled$.MODULE$;
            if (serverStatus == null) {
                if (enabled$ == null) return true;
                return false;
            } else {
                if (!serverStatus.equals(enabled$)) return false;
                return true;
            }
        })) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lastServerIdx), preferred.get());
        }
        int idx = lastServerIdx + 1 < fastestServers.size() ? lastServerIdx + 1 : 0;
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)idx), fastestServers.apply(idx));
    }

    public Option<Future<QueryResponse>> io$ino$solrs$FastestServerLB$$testWithMinDelay(SolrServer server) {
        if (this.clock.millis() > ((Units.Millisecond)this.serverTestTimestamp().apply((Object)new SolrServerId(server.id()))).value() + this.minDelay.toMillis()) {
            return Some$.MODULE$.apply(this.test(server));
        }
        return None$.MODULE$;
    }

    public Future<QueryResponse> test(SolrServer server) {
        this.serverTestTimestamp().update((Object)new SolrServerId(server.id()), (Object)new Units.Millisecond(Units$Millisecond$.MODULE$.apply(this.clock.millis())));
        PerformanceStats.RequestHandle request = this.stats(server).requestStarted(FastestServerLB$.MODULE$.TestQueryClass());
        Future<QueryResponse> res = this.client.doExecute(server, new QueryRequest((SolrParams)this.testQuery(server)), SolrResponseFactory$.MODULE$.queryResponseFactory());
        res.onComplete((JProcedure1 & Serializable)_$14 -> {
            request.finished();
            this.serverTestTimestamp().update((Object)new SolrServerId(server.id()), (Object)new Units.Millisecond(Units$Millisecond$.MODULE$.apply(this.clock.millis())));
        });
        return res;
    }

    public void updateStats() {
        this.statsByServer().values().foreach((Function1)(JProcedure1 & Serializable)_$15 -> _$15.updateStats());
        this.updateFastServers();
    }

    public void updateFastServers() {
        if (this.statsByServer().nonEmpty()) {
            scala.collection.immutable.Map statsByCollection = this.statsByServer().values().groupBy((Function1 & Serializable)stats -> this.collection(stats.solrServer()));
            statsByCollection.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Set fastServers;
                    String collection = (String)tuple2._1();
                    Iterable stats = (Iterable)tuple2._2();
                    scala.collection.immutable.Map durationByServer = ((IterableOnceOps)stats.map((Function1 & Serializable)s -> {
                        SolrServer solrServer = (SolrServer)Predef$.MODULE$.ArrowAssoc((Object)s.solrServer());
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)solrServer, (Object)BoxesRunTime.boxToLong((long)s.predictDuration(FastestServerLB$.MODULE$.TestQueryClass())));
                    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    long average = BoxesRunTime.unboxToLong((Object)durationByServer.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)durationByServer.size();
                    Function1 serverFilter = (Function1)this.filterFastServers.apply((Object)BoxesRunTime.boxToLong((long)average));
                    Set set = fastServers = ((IterableOnceOps)durationByServer.collect((PartialFunction)new Serializable(serverFilter){
                        private final Function1 serverFilter$1;
                        {
                            this.serverFilter$1 = serverFilter$2;
                        }

                        public final boolean isDefinedAt(Tuple2 x) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                SolrServer solrServer = (SolrServer)tuple2._1();
                                long l = BoxesRunTime.unboxToLong((Object)tuple2._2());
                                if (solrServer != null) {
                                    long duration;
                                    SolrServer server = solrServer;
                                    if (true && BoxesRunTime.unboxToBoolean((Object)this.serverFilter$1.apply((Object)Tuple2$.MODULE$.apply((Object)server, (Object)BoxesRunTime.boxToLong((long)(duration = l)))))) {
                                        return true;
                                    }
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Tuple2 x, Function1 function1) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                SolrServer solrServer = (SolrServer)tuple2._1();
                                long l = BoxesRunTime.unboxToLong((Object)tuple2._2());
                                if (solrServer != null) {
                                    long duration;
                                    SolrServer server = solrServer;
                                    if (true && BoxesRunTime.unboxToBoolean((Object)this.serverFilter$1.apply((Object)Tuple2$.MODULE$.apply((Object)server, (Object)BoxesRunTime.boxToLong((long)(duration = l)))))) {
                                        return new SolrServerId(server.id());
                                    }
                                }
                            }
                            return function1.apply((Object)x);
                        }
                    })).toSet();
                    Object object = this.fastServersByCollection().apply((Object)collection);
                    if (set == null ? object != null : !set.equals(object)) {
                        this.onBeforeFastServersChanged(collection, (Set<String>)fastServers, (scala.collection.immutable.Map<SolrServer, Object>)durationByServer, average);
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)collection);
                        this.fastServersByCollection_$eq((scala.collection.immutable.Map<String, Set<String>>)((scala.collection.immutable.Map)this.fastServersByCollection().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)fastServers))));
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public void onBeforeFastServersChanged(String collection, Set<String> fastServers, scala.collection.immutable.Map<SolrServer, Object> durationByServer, long average) {
        if (this.io$ino$solrs$FastestServerLB$$logger.isDebugEnabled()) {
            this.io$ino$solrs$FastestServerLB$$logger.debug(new StringBuilder(58).append("Updating fast servers (").append(collection).append("): ").append(fastServers).append(" (average: ").append(average).append(", durationByServer: ").append(durationByServer.mkString(", ")).append(")").toString());
            return;
        }
    }

    public PerformanceStats stats(SolrServer server) {
        return (PerformanceStats)this.statsByServer().getOrElseUpdate((Object)new SolrServerId(server.id()), () -> this.stats$$anonfun$1(server));
    }

    public long initialPredictedResponseTime() {
        return 1000L;
    }

    public static final /* synthetic */ boolean io$ino$solrs$FastestServerLB$$anon$3$$_$_$$anonfun$2(SolrServer _$5) {
        ServerStatus serverStatus = _$5.status();
        Enabled$ enabled$ = Enabled$.MODULE$;
        return !(serverStatus != null ? !serverStatus.equals(enabled$) : enabled$ != null);
    }

    private final /* synthetic */ Future $anonfun$5$$anonfun$1(SolrServer server$1, Future res, int _$8) {
        return res.flatMap((Function1 & Serializable)_$9 -> this.test(server$1).map((JProcedure1 & Serializable)_$10 -> {}));
    }

    private final PerformanceStats stats$$anonfun$1(SolrServer server$4) {
        return new PerformanceStats(server$4, this.initialPredictedResponseTime(), this.clock);
    }

    public static class Builder
    implements Product,
    Serializable {
        private final SolrServers solrServers;
        private final Function1 collectionAndTestQuery;
        private final Duration minDelay;
        private final Duration maxDelay;
        private final int initialTestRuns;
        private final Function1 filterFastServers;
        private final Function1 mapPredictedResponseTime;
        private final boolean isUpdatesToLeaders;
        private final Clock clock;

        public static Builder apply(SolrServers solrServers, Function1<SolrServer, Tuple2<String, SolrQuery>> function1, Duration duration, Duration duration2, int n, Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> function12, Function1<Object, Object> function13, boolean bl, Clock clock) {
            return FastestServerLB$Builder$.MODULE$.apply(solrServers, function1, duration, duration2, n, function12, function13, bl, clock);
        }

        public static Builder fromProduct(Product product) {
            return FastestServerLB$Builder$.MODULE$.fromProduct(product);
        }

        public static Builder unapply(Builder builder) {
            return FastestServerLB$Builder$.MODULE$.unapply(builder);
        }

        public static Duration $lessinit$greater$default$3() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$3();
        }

        public static Duration $lessinit$greater$default$4() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$4();
        }

        public static int $lessinit$greater$default$5() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$5();
        }

        public static Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> $lessinit$greater$default$6() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$6();
        }

        public static Function1<Object, Object> $lessinit$greater$default$7() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$7();
        }

        public static boolean $lessinit$greater$default$8() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$8();
        }

        public static Clock $lessinit$greater$default$9() {
            return FastestServerLB$Builder$.MODULE$.$lessinit$greater$default$9();
        }

        public Builder(SolrServers solrServers, Function1<SolrServer, Tuple2<String, SolrQuery>> collectionAndTestQuery, Duration minDelay, Duration maxDelay, int initialTestRuns, Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> filterFastServers, Function1<Object, Object> mapPredictedResponseTime, boolean isUpdatesToLeaders, Clock clock) {
            this.solrServers = solrServers;
            this.collectionAndTestQuery = collectionAndTestQuery;
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.initialTestRuns = initialTestRuns;
            this.filterFastServers = filterFastServers;
            this.mapPredictedResponseTime = mapPredictedResponseTime;
            this.isUpdatesToLeaders = isUpdatesToLeaders;
            this.clock = clock;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.solrServers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.collectionAndTestQuery()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.minDelay()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.maxDelay()));
            n = Statics.mix((int)n, (int)this.initialTestRuns());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.filterFastServers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.mapPredictedResponseTime()));
            n = Statics.mix((int)n, (int)(this.isUpdatesToLeaders() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clock()));
            return Statics.finalizeHash((int)n, (int)9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Builder)) return false;
            Builder builder = (Builder)object;
            if (this.initialTestRuns() != builder.initialTestRuns()) return false;
            if (this.isUpdatesToLeaders() != builder.isUpdatesToLeaders()) return false;
            SolrServers solrServers = this.solrServers();
            SolrServers solrServers2 = builder.solrServers();
            if (solrServers == null) {
                if (solrServers2 != null) {
                    return false;
                }
            } else if (!solrServers.equals(solrServers2)) return false;
            Function1<SolrServer, Tuple2<String, SolrQuery>> function1 = this.collectionAndTestQuery();
            Function1<SolrServer, Tuple2<String, SolrQuery>> function12 = builder.collectionAndTestQuery();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Duration duration = this.minDelay();
            Duration duration2 = builder.minDelay();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            Duration duration3 = this.maxDelay();
            Duration duration4 = builder.maxDelay();
            if (duration3 == null) {
                if (duration4 != null) {
                    return false;
                }
            } else if (!duration3.equals(duration4)) return false;
            Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> function13 = this.filterFastServers();
            Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> function14 = builder.filterFastServers();
            if (function13 == null) {
                if (function14 != null) {
                    return false;
                }
            } else if (!function13.equals(function14)) return false;
            Function1<Object, Object> function15 = this.mapPredictedResponseTime();
            Function1<Object, Object> function16 = builder.mapPredictedResponseTime();
            if (function15 == null) {
                if (function16 != null) {
                    return false;
                }
            } else if (!function15.equals(function16)) return false;
            Clock clock = this.clock();
            Clock clock2 = builder.clock();
            if (clock == null) {
                if (clock2 != null) {
                    return false;
                }
            } else if (!clock.equals(clock2)) return false;
            if (!builder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Builder;
        }

        public int productArity() {
            return 9;
        }

        public String productPrefix() {
            return "Builder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this._8());
                }
                case 8: {
                    return this._9();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "solrServers";
                }
                case 1: {
                    return "collectionAndTestQuery";
                }
                case 2: {
                    return "minDelay";
                }
                case 3: {
                    return "maxDelay";
                }
                case 4: {
                    return "initialTestRuns";
                }
                case 5: {
                    return "filterFastServers";
                }
                case 6: {
                    return "mapPredictedResponseTime";
                }
                case 7: {
                    return "isUpdatesToLeaders";
                }
                case 8: {
                    return "clock";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SolrServers solrServers() {
            return this.solrServers;
        }

        public Function1<SolrServer, Tuple2<String, SolrQuery>> collectionAndTestQuery() {
            return this.collectionAndTestQuery;
        }

        public Duration minDelay() {
            return this.minDelay;
        }

        public Duration maxDelay() {
            return this.maxDelay;
        }

        public int initialTestRuns() {
            return this.initialTestRuns;
        }

        public Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> filterFastServers() {
            return this.filterFastServers;
        }

        public Function1<Object, Object> mapPredictedResponseTime() {
            return this.mapPredictedResponseTime;
        }

        public boolean isUpdatesToLeaders() {
            return this.isUpdatesToLeaders;
        }

        public Clock clock() {
            return this.clock;
        }

        public Builder withMinDelay(long value, TimeUnit unit) {
            FiniteDuration finiteDuration = FiniteDuration$.MODULE$.apply(value, unit);
            SolrServers solrServers = this.copy$default$1();
            Function1<SolrServer, Tuple2<String, SolrQuery>> function1 = this.copy$default$2();
            Duration duration = this.copy$default$4();
            int n = this.copy$default$5();
            Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> function12 = this.copy$default$6();
            Function1<Object, Object> function13 = this.copy$default$7();
            boolean bl = this.copy$default$8();
            Clock clock = this.copy$default$9();
            return this.copy(solrServers, function1, (Duration)finiteDuration, duration, n, function12, function13, bl, clock);
        }

        public Builder withMaxDelay(long value, TimeUnit unit) {
            FiniteDuration finiteDuration = FiniteDuration$.MODULE$.apply(value, unit);
            SolrServers solrServers = this.copy$default$1();
            Function1<SolrServer, Tuple2<String, SolrQuery>> function1 = this.copy$default$2();
            Duration duration = this.copy$default$3();
            int n = this.copy$default$5();
            Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> function12 = this.copy$default$6();
            Function1<Object, Object> function13 = this.copy$default$7();
            boolean bl = this.copy$default$8();
            Clock clock = this.copy$default$9();
            return this.copy(solrServers, function1, duration, (Duration)finiteDuration, n, function12, function13, bl, clock);
        }

        public Builder withInitialTestRuns(int count) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), count, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
        }

        public Builder withFilterFastServers(LongFunction<BiFunction<SolrServer, Long, Boolean>> filter) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), (Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>>)(Function1 & Serializable)average -> this.withFilterFastServers$$anonfun$1(filter, BoxesRunTime.unboxToLong((Object)average)), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
        }

        public Builder withMapPredictedResponseTime(Function<Long, Long> mapPredictedResponseTime) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), (Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)input -> Predef$.MODULE$.Long2long((Long)mapPredictedResponseTime.apply(Predef$.MODULE$.long2Long(input))), this.copy$default$8(), this.copy$default$9());
        }

        public Builder withUpdatesToLeaders(boolean isUpdatesToLeaders) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), isUpdatesToLeaders, this.copy$default$9());
        }

        public Builder withClock(Clock clock) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), clock);
        }

        public FastestServerLB<CompletionStage> build() {
            return this.build(JavaFutureFactory$.MODULE$);
        }

        public <F> FastestServerLB<F> build(FutureFactory<F> futureFactory) {
            return new FastestServerLB<F>(this.solrServers(), this.collectionAndTestQuery(), this.minDelay(), this.maxDelay(), this.initialTestRuns(), this.filterFastServers(), this.mapPredictedResponseTime(), this.isUpdatesToLeaders(), this.clock(), futureFactory);
        }

        public Builder copy(SolrServers solrServers, Function1<SolrServer, Tuple2<String, SolrQuery>> collectionAndTestQuery, Duration minDelay, Duration maxDelay, int initialTestRuns, Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> filterFastServers, Function1<Object, Object> mapPredictedResponseTime, boolean isUpdatesToLeaders, Clock clock) {
            return new Builder(solrServers, collectionAndTestQuery, minDelay, maxDelay, initialTestRuns, filterFastServers, mapPredictedResponseTime, isUpdatesToLeaders, clock);
        }

        public SolrServers copy$default$1() {
            return this.solrServers();
        }

        public Function1<SolrServer, Tuple2<String, SolrQuery>> copy$default$2() {
            return this.collectionAndTestQuery();
        }

        public Duration copy$default$3() {
            return this.minDelay();
        }

        public Duration copy$default$4() {
            return this.maxDelay();
        }

        public int copy$default$5() {
            return this.initialTestRuns();
        }

        public Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> copy$default$6() {
            return this.filterFastServers();
        }

        public Function1<Object, Object> copy$default$7() {
            return this.mapPredictedResponseTime();
        }

        public boolean copy$default$8() {
            return this.isUpdatesToLeaders();
        }

        public Clock copy$default$9() {
            return this.clock();
        }

        public SolrServers _1() {
            return this.solrServers();
        }

        public Function1<SolrServer, Tuple2<String, SolrQuery>> _2() {
            return this.collectionAndTestQuery();
        }

        public Duration _3() {
            return this.minDelay();
        }

        public Duration _4() {
            return this.maxDelay();
        }

        public int _5() {
            return this.initialTestRuns();
        }

        public Function1<Object, Function1<Tuple2<SolrServer, Object>, Object>> _6() {
            return this.filterFastServers();
        }

        public Function1<Object, Object> _7() {
            return this.mapPredictedResponseTime();
        }

        public boolean _8() {
            return this.isUpdatesToLeaders();
        }

        public Clock _9() {
            return this.clock();
        }

        private final /* synthetic */ Function1 withFilterFastServers$$anonfun$1(LongFunction filter$1, long average) {
            return (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    SolrServer server = (SolrServer)tuple2._1();
                    long duration = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    return Predef$.MODULE$.Boolean2boolean((Boolean)((BiFunction)filter$1.apply(average)).apply(server, Predef$.MODULE$.long2Long(duration)));
                }
                throw new MatchError((Object)tuple2);
            };
        }
    }
}

