/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.CodaHaleMetrics$;
import io.ino.solrs.Metrics;
import java.util.concurrent.TimeUnit;

public class CodaHaleMetrics<F>
implements Metrics {
    private final MetricRegistry registry;
    private final Timer requestTimer;
    private final Meter remoteSolrExceptionCounter;
    private final Meter exceptionCounter;

    public static <F> MetricRegistry $lessinit$greater$default$1() {
        return CodaHaleMetrics$.MODULE$.$lessinit$greater$default$1();
    }

    public CodaHaleMetrics(MetricRegistry registry) {
        this.registry = registry;
        this.requestTimer = registry.timer(MetricRegistry.name(AsyncSolrClient.class, (String[])new String[]{"requests"}));
        this.remoteSolrExceptionCounter = registry.meter(MetricRegistry.name(AsyncSolrClient.class, (String[])new String[]{"remote-exceptions"}));
        Meter transformResponseExceptionCounter = registry.meter(MetricRegistry.name(AsyncSolrClient.class, (String[])new String[]{"transform-response-exceptions"}));
        this.exceptionCounter = registry.meter(MetricRegistry.name(AsyncSolrClient.class, (String[])new String[]{"other-exceptions"}));
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    @Override
    public void requestTime(long timeInMillis) {
        this.requestTimer.update(timeInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void countRemoteException() {
        this.remoteSolrExceptionCounter.mark();
    }

    @Override
    public void countException() {
        this.exceptionCounter.mark();
    }
}

