/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClientAware;
import io.ino.solrs.CloudSolrServers$;
import io.ino.solrs.CloudSolrServers$Builder$;
import io.ino.solrs.CloudSolrServers$CollectionInfo$;
import io.ino.solrs.CloudSolrServers$UnknownCollectionException$;
import io.ino.solrs.CloudSolrServers$WarmupQueries$;
import io.ino.solrs.ServerStateChangeObservable;
import io.ino.solrs.ShardReplica;
import io.ino.solrs.ShardReplica$;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StateChangeObserver;
import io.ino.solrs.ZkClusterStateUpdateTF;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.FutureFactory$;
import io.ino.solrs.future.JavaFutureFactory$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class CloudSolrServers<F>
implements SolrServers,
AsyncSolrClientAware<F>,
ServerStateChangeObservable {
    private final String zkHost;
    private final Duration zkClientTimeout;
    private final Duration zkConnectTimeout;
    private final Duration clusterStateUpdateInterval;
    private final Option<String> defaultCollection;
    private final Option<WarmupQueries> warmupQueries;
    private final FutureFactory<F> futureFactory;
    private Option<ZkStateReader> maybeZk;
    private volatile Map<String, CollectionInfo> collections;
    private volatile Option<Aliases> aliases;
    private final ScheduledExecutorService scheduledExecutor;
    private AsyncSolrClient<F> asyncSolrClient;
    private final ListBuffer<StateChangeObserver> serverChangeStateObservers;

    public static Builder builder(String string) {
        return CloudSolrServers$.MODULE$.builder(string);
    }

    public static Iterable<ServerStateChangeObservable.StateChange> diff(Map<String, Seq<SolrServer>> map, Map<String, Seq<SolrServer>> map2) {
        return CloudSolrServers$.MODULE$.diff(map, map2);
    }

    public static Map<String, CollectionInfo> getCollections(ClusterState clusterState) {
        return CloudSolrServers$.MODULE$.getCollections(clusterState);
    }

    public static <F> Duration $lessinit$greater$default$2() {
        return CloudSolrServers$.MODULE$.$lessinit$greater$default$2();
    }

    public static <F> Duration $lessinit$greater$default$3() {
        return CloudSolrServers$.MODULE$.$lessinit$greater$default$3();
    }

    public static <F> Duration $lessinit$greater$default$4() {
        return CloudSolrServers$.MODULE$.$lessinit$greater$default$4();
    }

    public static <F> Option<String> $lessinit$greater$default$5() {
        return CloudSolrServers$.MODULE$.$lessinit$greater$default$5();
    }

    public static <F> Option<WarmupQueries> $lessinit$greater$default$6() {
        return CloudSolrServers$.MODULE$.$lessinit$greater$default$6();
    }

    public CloudSolrServers(String zkHost, Duration zkClientTimeout, Duration zkConnectTimeout, Duration clusterStateUpdateInterval, Option<String> defaultCollection, Option<WarmupQueries> warmupQueries, FutureFactory<F> futureFactory) {
        this.zkHost = zkHost;
        this.zkClientTimeout = zkClientTimeout;
        this.zkConnectTimeout = zkConnectTimeout;
        this.clusterStateUpdateInterval = clusterStateUpdateInterval;
        this.defaultCollection = defaultCollection;
        this.warmupQueries = warmupQueries;
        this.futureFactory = futureFactory;
        this.maybeZk = None$.MODULE$;
        this.collections = Predef$.MODULE$.Map().empty();
        this.aliases = None$.MODULE$;
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, new ZkClusterStateUpdateTF());
        this.serverChangeStateObservers = ListBuffer$.MODULE$.empty();
    }

    private Map<String, IndexedSeq<ShardReplica>> collectionToServers() {
        return ((IterableOnceOps)this.collections.toSeq().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply(c._1(), ((CollectionInfo)c._2()).servers()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void setAsyncSolrClient(AsyncSolrClient<F> client) {
        this.asyncSolrClient = client;
        this.io$ino$solrs$CloudSolrServers$$createZkStateReader();
    }

    @Override
    public Option<ShardReplica> findLeader(Iterable<SolrServer> servers) {
        return ShardReplica$.MODULE$.findLeader(servers);
    }

    public void io$ino$solrs$CloudSolrServers$$createZkStateReader() {
        try {
            this.maybeZk = Some$.MODULE$.apply((Object)new ZkStateReader(this.zkHost, (int)this.zkClientTimeout.toMillis(), (int)this.zkConnectTimeout.toMillis()));
            CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.info(new StringBuilder(26).append("Connected to zookeeper at ").append(this.zkHost).toString());
            this.maybeZk.foreach((Function1)(JProcedure1 & Serializable)zkStateReader -> this.io$ino$solrs$CloudSolrServers$$initZkStateReader((ZkStateReader)zkStateReader));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.warn(new StringBuilder(84).append("Could not connect to ZK, seems to be unavailable. Retrying in ").append(this.zkConnectTimeout).append(". Original exception: ").append(e).toString());
                this.scheduledExecutor.schedule(new Runnable(this){
                    private final /* synthetic */ CloudSolrServers $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        this.$outer.io$ino$solrs$CloudSolrServers$$createZkStateReader();
                    }
                }, this.zkConnectTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            throw throwable;
        }
    }

    public void io$ino$solrs$CloudSolrServers$$initZkStateReader(ZkStateReader zkStateReader) {
        try {
            zkStateReader.createClusterStateWatchersAndUpdate();
            CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.info(new StringBuilder(50).append("Successfully created ZK cluster state watchers at ").append(this.zkHost).toString());
            this.io$ino$solrs$CloudSolrServers$$updateFromClusterState(zkStateReader);
            this.io$ino$solrs$CloudSolrServers$$scheduleUpdateFromClusterState(zkStateReader);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.warn(new StringBuilder(93).append("Could not initialize ZkStateReader, this can happen when there are no solr servers connected.").append(new StringBuilder(35).append(" Retrying in ").append(this.zkConnectTimeout).append(". Original exception: ").append(e).toString()).toString());
                this.scheduledExecutor.schedule(new Runnable(zkStateReader, this){
                    private final ZkStateReader zkStateReader$1;
                    private final /* synthetic */ CloudSolrServers $outer;
                    {
                        this.zkStateReader$1 = zkStateReader$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        this.$outer.io$ino$solrs$CloudSolrServers$$initZkStateReader(this.zkStateReader$1);
                    }
                }, this.zkConnectTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            throw throwable;
        }
    }

    public void io$ino$solrs$CloudSolrServers$$scheduleUpdateFromClusterState(ZkStateReader zkStateReader) {
        this.scheduledExecutor.schedule(new Runnable(zkStateReader, this){
            private final ZkStateReader zkStateReader$2;
            private final /* synthetic */ CloudSolrServers $outer;
            {
                this.zkStateReader$2 = zkStateReader$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.io$ino$solrs$CloudSolrServers$$updateFromClusterState(this.zkStateReader$2).onComplete((JProcedure1 & Serializable)_$4 -> this.$outer.io$ino$solrs$CloudSolrServers$$scheduleUpdateFromClusterState(this.zkStateReader$2));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$1(scala.util.Try )}, serializedLambda);
            }
        }, this.clusterStateUpdateInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<BoxedUnit> io$ino$solrs$CloudSolrServers$$updateFromClusterState(ZkStateReader zkStateReader) {
        Future<Object> future;
        this.aliases = Some$.MODULE$.apply((Object)zkStateReader.getAliases());
        ClusterState clusterState = zkStateReader.getClusterState();
        try {
            Map<String, CollectionInfo> newCollections;
            Map<String, CollectionInfo> map = newCollections = CloudSolrServers$.MODULE$.getCollections(clusterState);
            Map<String, CollectionInfo> map2 = this.collections;
            if (map == null ? map2 != null : !map.equals(map2)) {
                Option<WarmupQueries> option = this.warmupQueries;
                if (option instanceof Some) {
                    WarmupQueries warmup = (WarmupQueries)((Some)option).value();
                    future = this.warmUpNewServers((Map<String, IndexedSeq<SolrServer>>)((IterableOnceOps)newCollections.toSeq().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply(c._1(), ((CollectionInfo)c._2()).servers()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), warmup).map((JProcedure1 & Serializable)_$5 -> this.set$1(clusterState, newCollections));
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    this.set$1(clusterState, newCollections);
                    future = this.futureFactory.successful(BoxedUnit.UNIT);
                }
                return future;
            } else {
                future = this.futureFactory.successful(BoxedUnit.UNIT);
            }
            return future;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) throw throwable;
            Throwable e = throwable2 = (Throwable)option.get();
            CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.error(new StringBuilder(80).append("Could not process cluster state, server list might get outdated. Cluster state: ").append(clusterState).toString(), e);
            future = this.futureFactory.failed(e);
            return future;
        }
    }

    public Future<Iterable<Try<QueryResponse>>> warmUpNewServers(Map<String, IndexedSeq<SolrServer>> newCollectionToServers, WarmupQueries warmUp) {
        Seq perCollectionResponses = (Seq)newCollectionToServers.toSeq().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                IndexedSeq indexedSeq = (IndexedSeq)tuple2._2();
                if (string != null) {
                    String collection = string;
                    if (indexedSeq instanceof IndexedSeq) {
                        IndexedSeq solrServers = indexedSeq;
                        IndexedSeq existingServers = (IndexedSeq)this.collectionToServers().getOrElse((Object)collection, CloudSolrServers::$anonfun$2);
                        IndexedSeq newActiveServers = (IndexedSeq)solrServers.filter((Function1 & Serializable)s -> s.isEnabled() && !existingServers.contains(s));
                        return (IndexedSeq)newActiveServers.map((Function1 & Serializable)_$6 -> this.warmupNewServer(collection, (SolrServer)_$6, (Seq<SolrQuery>)((Seq)warmUp.queriesByCollection().apply((Object)collection)), warmUp.count()));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return FutureFactory$.MODULE$.sequence(perCollectionResponses, BuildFrom$.MODULE$.buildFromIterableOps(), this.futureFactory).map((Function1 & Serializable)_$7 -> (Seq)_$7.flatten(Predef$.MODULE$.$conforms()));
    }

    public Future<Seq<Try<QueryResponse>>> warmupNewServer(String collection, SolrServer s, Seq<SolrQuery> queries, int count) {
        return (Future)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foldLeft(this.futureFactory.successful(package$.MODULE$.Seq().empty()), (Function2 & Serializable)(res, round) -> this.warmupNewServer$$anonfun$1(s, queries, (Future)res, BoxesRunTime.unboxToInt((Object)round)));
    }

    public void shutdown() {
        this.maybeZk.foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.close());
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public IndexedSeq<SolrServer> all() {
        return ((IterableOnceOps)this.collections.values().flatMap((Function1 & Serializable)_$11 -> _$11.servers())).toIndexedSeq();
    }

    @Override
    public Try<IndexedSeq<SolrServer>> matching(SolrRequest<?> r) {
        CollectionInfo collectionInfo;
        SolrParams params = r.getParams();
        String collection = (String)Option$.MODULE$.apply((Object)params.get("collection")).orElse(this::$anonfun$5).map((Function1 & Serializable)_$12 -> _$12.split(",")[0]).getOrElse(CloudSolrServers::$anonfun$7);
        String resolvedCollection = (String)this.aliases.map((Function1 & Serializable)_$13 -> (String)_$13.resolveAliases(collection).get(0)).getOrElse(() -> CloudSolrServers.$anonfun$9(collection));
        Option option = this.collections.get((Object)resolvedCollection);
        if (option instanceof Some && (collectionInfo = (CollectionInfo)((Some)option).value()) != null) {
            CollectionInfo collectionInfo2 = CloudSolrServers$CollectionInfo$.MODULE$.unapply(collectionInfo);
            DocCollection docCollection = collectionInfo2._1();
            IndexedSeq<ShardReplica> indexedSeq = collectionInfo2._2();
            DocCollection docCollection2 = docCollection;
            IndexedSeq<ShardReplica> servers = indexedSeq;
            String shardKeys = params.get("_route_");
            Collection slices = docCollection2.getRouter().getSearchSlices(shardKeys, params, docCollection2);
            Set serverUrls = CloudSolrServers$.MODULE$.io$ino$solrs$CloudSolrServers$$$mapSliceReplicas(slices, (Function1 & Serializable)repl -> SolrServer$.MODULE$.fixUrl(repl.getCoreUrl())).toSet();
            return Success$.MODULE$.apply(servers.filter((Function1 & Serializable)server -> serverUrls.contains((Object)server.baseUrl())));
        }
        if (None$.MODULE$.equals(option)) {
            return Failure$.MODULE$.apply((Throwable)CloudSolrServers$UnknownCollectionException$.MODULE$.apply(collection));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void register(StateChangeObserver listener) {
        this.serverChangeStateObservers.$plus$eq((Object)listener);
    }

    private void notifyObservers(Map<String, Seq<SolrServer>> oldState, Map<String, Seq<SolrServer>> newState) {
        CloudSolrServers$.MODULE$.diff(oldState, newState).foreach((Function1)(JProcedure1 & Serializable)event -> this.serverChangeStateObservers.foreach((Function1)(JProcedure1 & Serializable)_$14 -> _$14.onStateChange((ServerStateChangeObservable.StateChange)event)));
    }

    private final void set$1(ClusterState clusterState$1, Map newCollections) {
        this.notifyObservers(this.collectionToServers(), (Map<String, Seq<SolrServer>>)((IterableOnceOps)newCollections.toSeq().map((Function1 & Serializable)c -> Tuple2$.MODULE$.apply(c._1(), ((CollectionInfo)c._2()).servers()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.collections = newCollections;
        if (CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.isDebugEnabled()) {
            CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.debug(new StringBuilder(39).append("Updated server map: ").append(this.collectionToServers()).append(" from ClusterState ").append(clusterState$1).toString());
            return;
        }
        CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.info(new StringBuilder(20).append("Updated server map: ").append(this.collectionToServers()).toString());
    }

    private static final IndexedSeq $anonfun$2() {
        return (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
    }

    private final /* synthetic */ Future warmupNewServer$$anonfun$1(SolrServer s$1, Seq queries$1, Future res, int round) {
        return res.flatMap((Function1 & Serializable)_$8 -> {
            Seq warmupResponses = (Seq)queries$1.map((Function1 & Serializable)q -> this.asyncSolrClient.doExecute(s$1, new QueryRequest((SolrParams)q), SolrResponseFactory$.MODULE$.queryResponseFactory()).map((Function1 & Serializable)_$9 -> Success$.MODULE$.apply(_$9)).handle(new Serializable((SolrQuery)q){
                private final SolrQuery q$1;
                {
                    this.q$1 = q$2;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Option option;
                    Throwable throwable = x;
                    if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                        Throwable throwable2;
                        Throwable e = throwable2 = (Throwable)option.get();
                        CloudSolrServers$.io$ino$solrs$CloudSolrServers$$$logger.warn(new StringBuilder(20).append("Warmup query ").append(this.q$1).append(" failed").toString(), e);
                        return Failure$.MODULE$.apply(e);
                    }
                    return function1.apply((Object)x);
                }
            }));
            return FutureFactory$.MODULE$.sequence(warmupResponses, BuildFrom$.MODULE$.buildFromIterableOps(), this.futureFactory);
        });
    }

    private final Option $anonfun$5() {
        return this.defaultCollection;
    }

    private static final String $anonfun$7() {
        throw new SolrServerException("No collection param specified on request and no default collection has been set.");
    }

    private static final String $anonfun$9(String collection$3) {
        return collection$3;
    }

    public static class Builder
    implements Product,
    Serializable {
        private final String zkHost;
        private final Duration zkClientTimeout;
        private final Duration zkConnectTimeout;
        private final Duration clusterStateUpdateInterval;
        private final Option defaultCollection;
        private final Option warmupQueries;

        public static Builder apply(String string, Duration duration, Duration duration2, Duration duration3, Option<String> option, Option<WarmupQueries> option2) {
            return CloudSolrServers$Builder$.MODULE$.apply(string, duration, duration2, duration3, option, option2);
        }

        public static Builder fromProduct(Product product) {
            return CloudSolrServers$Builder$.MODULE$.fromProduct(product);
        }

        public static Builder unapply(Builder builder) {
            return CloudSolrServers$Builder$.MODULE$.unapply(builder);
        }

        public static Duration $lessinit$greater$default$2() {
            return CloudSolrServers$Builder$.MODULE$.$lessinit$greater$default$2();
        }

        public static Duration $lessinit$greater$default$3() {
            return CloudSolrServers$Builder$.MODULE$.$lessinit$greater$default$3();
        }

        public static Duration $lessinit$greater$default$4() {
            return CloudSolrServers$Builder$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<String> $lessinit$greater$default$5() {
            return CloudSolrServers$Builder$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<WarmupQueries> $lessinit$greater$default$6() {
            return CloudSolrServers$Builder$.MODULE$.$lessinit$greater$default$6();
        }

        public Builder(String zkHost, Duration zkClientTimeout, Duration zkConnectTimeout, Duration clusterStateUpdateInterval, Option<String> defaultCollection, Option<WarmupQueries> warmupQueries) {
            this.zkHost = zkHost;
            this.zkClientTimeout = zkClientTimeout;
            this.zkConnectTimeout = zkConnectTimeout;
            this.clusterStateUpdateInterval = clusterStateUpdateInterval;
            this.defaultCollection = defaultCollection;
            this.warmupQueries = warmupQueries;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Builder)) return false;
            Builder builder = (Builder)object;
            String string = this.zkHost();
            String string2 = builder.zkHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Duration duration = this.zkClientTimeout();
            Duration duration2 = builder.zkClientTimeout();
            if (duration == null) {
                if (duration2 != null) {
                    return false;
                }
            } else if (!duration.equals(duration2)) return false;
            Duration duration3 = this.zkConnectTimeout();
            Duration duration4 = builder.zkConnectTimeout();
            if (duration3 == null) {
                if (duration4 != null) {
                    return false;
                }
            } else if (!duration3.equals(duration4)) return false;
            Duration duration5 = this.clusterStateUpdateInterval();
            Duration duration6 = builder.clusterStateUpdateInterval();
            if (duration5 == null) {
                if (duration6 != null) {
                    return false;
                }
            } else if (!duration5.equals(duration6)) return false;
            Option<String> option = this.defaultCollection();
            Option<String> option2 = builder.defaultCollection();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<WarmupQueries> option3 = this.warmupQueries();
            Option<WarmupQueries> option4 = builder.warmupQueries();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!builder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Builder;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Builder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "zkHost";
                }
                case 1: {
                    return "zkClientTimeout";
                }
                case 2: {
                    return "zkConnectTimeout";
                }
                case 3: {
                    return "clusterStateUpdateInterval";
                }
                case 4: {
                    return "defaultCollection";
                }
                case 5: {
                    return "warmupQueries";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String zkHost() {
            return this.zkHost;
        }

        public Duration zkClientTimeout() {
            return this.zkClientTimeout;
        }

        public Duration zkConnectTimeout() {
            return this.zkConnectTimeout;
        }

        public Duration clusterStateUpdateInterval() {
            return this.clusterStateUpdateInterval;
        }

        public Option<String> defaultCollection() {
            return this.defaultCollection;
        }

        public Option<WarmupQueries> warmupQueries() {
            return this.warmupQueries;
        }

        public Builder withZkClientTimeout(long value, TimeUnit unit) {
            FiniteDuration finiteDuration = FiniteDuration$.MODULE$.apply(value, unit);
            String string = this.copy$default$1();
            Duration duration = this.copy$default$3();
            Duration duration2 = this.copy$default$4();
            Option<String> option = this.copy$default$5();
            Option<WarmupQueries> option2 = this.copy$default$6();
            return this.copy(string, (Duration)finiteDuration, duration, duration2, option, option2);
        }

        public Builder withZkConnectTimeout(long value, TimeUnit unit) {
            FiniteDuration finiteDuration = FiniteDuration$.MODULE$.apply(value, unit);
            String string = this.copy$default$1();
            Duration duration = this.copy$default$2();
            Duration duration2 = this.copy$default$4();
            Option<String> option = this.copy$default$5();
            Option<WarmupQueries> option2 = this.copy$default$6();
            return this.copy(string, duration, (Duration)finiteDuration, duration2, option, option2);
        }

        public Builder withClusterStateUpdateInterval(long value, TimeUnit unit) {
            FiniteDuration finiteDuration = FiniteDuration$.MODULE$.apply(value, unit);
            String string = this.copy$default$1();
            Duration duration = this.copy$default$2();
            Duration duration2 = this.copy$default$3();
            Option<String> option = this.copy$default$5();
            Option<WarmupQueries> option2 = this.copy$default$6();
            return this.copy(string, duration, duration2, (Duration)finiteDuration, option, option2);
        }

        public Builder withDefaultCollection(String collection) {
            Some some = Some$.MODULE$.apply((Object)collection);
            String string = this.copy$default$1();
            Duration duration = this.copy$default$2();
            Duration duration2 = this.copy$default$3();
            Duration duration3 = this.copy$default$4();
            Option<WarmupQueries> option = this.copy$default$6();
            return this.copy(string, duration, duration2, duration3, (Option<String>)some, option);
        }

        public Builder withWarmupQueries(Function<String, java.lang.Iterable<SolrQuery>> queriesByCollection, int count) {
            Some some = Some$.MODULE$.apply((Object)CloudSolrServers$WarmupQueries$.MODULE$.apply((Function1<String, Seq<SolrQuery>>)(Function1 & Serializable)collection -> this.delegate$1(queriesByCollection, (String)collection), count));
            String string = this.copy$default$1();
            Duration duration = this.copy$default$2();
            Duration duration2 = this.copy$default$3();
            Duration duration3 = this.copy$default$4();
            Option<String> option = this.copy$default$5();
            return this.copy(string, duration, duration2, duration3, option, (Option<WarmupQueries>)some);
        }

        public CloudSolrServers<CompletionStage> build() {
            return new CloudSolrServers<CompletionStage>(this.zkHost(), this.zkConnectTimeout(), this.zkConnectTimeout(), this.clusterStateUpdateInterval(), this.defaultCollection(), this.warmupQueries(), JavaFutureFactory$.MODULE$);
        }

        public <F> CloudSolrServers<F> build(FutureFactory<F> futureFactory) {
            return new CloudSolrServers<F>(this.zkHost(), this.zkConnectTimeout(), this.zkConnectTimeout(), this.clusterStateUpdateInterval(), this.defaultCollection(), this.warmupQueries(), futureFactory);
        }

        public Builder copy(String zkHost, Duration zkClientTimeout, Duration zkConnectTimeout, Duration clusterStateUpdateInterval, Option<String> defaultCollection, Option<WarmupQueries> warmupQueries) {
            return new Builder(zkHost, zkClientTimeout, zkConnectTimeout, clusterStateUpdateInterval, defaultCollection, warmupQueries);
        }

        public String copy$default$1() {
            return this.zkHost();
        }

        public Duration copy$default$2() {
            return this.zkClientTimeout();
        }

        public Duration copy$default$3() {
            return this.zkConnectTimeout();
        }

        public Duration copy$default$4() {
            return this.clusterStateUpdateInterval();
        }

        public Option<String> copy$default$5() {
            return this.defaultCollection();
        }

        public Option<WarmupQueries> copy$default$6() {
            return this.warmupQueries();
        }

        public String _1() {
            return this.zkHost();
        }

        public Duration _2() {
            return this.zkClientTimeout();
        }

        public Duration _3() {
            return this.zkConnectTimeout();
        }

        public Duration _4() {
            return this.clusterStateUpdateInterval();
        }

        public Option<String> _5() {
            return this.defaultCollection();
        }

        public Option<WarmupQueries> _6() {
            return this.warmupQueries();
        }

        private final Seq delegate$1(Function queriesByCollection$1, String collection) {
            java.lang.Iterable res = (java.lang.Iterable)queriesByCollection$1.apply(collection);
            return CollectionConverters$.MODULE$.IterableHasAsScala(res).asScala().toList();
        }
    }

    public static final class CollectionInfo
    implements Product,
    Serializable {
        private final DocCollection collection;
        private final IndexedSeq servers;

        public static CollectionInfo apply(DocCollection docCollection, IndexedSeq<ShardReplica> indexedSeq) {
            return CloudSolrServers$CollectionInfo$.MODULE$.apply(docCollection, indexedSeq);
        }

        public static CollectionInfo fromProduct(Product product) {
            return CloudSolrServers$CollectionInfo$.MODULE$.fromProduct(product);
        }

        public static CollectionInfo unapply(CollectionInfo collectionInfo) {
            return CloudSolrServers$CollectionInfo$.MODULE$.unapply(collectionInfo);
        }

        public CollectionInfo(DocCollection collection, IndexedSeq<ShardReplica> servers) {
            this.collection = collection;
            this.servers = servers;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CollectionInfo)) return false;
            CollectionInfo collectionInfo = (CollectionInfo)object;
            DocCollection docCollection = this.collection();
            DocCollection docCollection2 = collectionInfo.collection();
            if (docCollection == null) {
                if (docCollection2 != null) {
                    return false;
                }
            } else if (!docCollection.equals(docCollection2)) return false;
            IndexedSeq<ShardReplica> indexedSeq = this.servers();
            IndexedSeq<ShardReplica> indexedSeq2 = collectionInfo.servers();
            if (indexedSeq == null) {
                if (indexedSeq2 == null) return true;
                return false;
            } else {
                if (!indexedSeq.equals(indexedSeq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CollectionInfo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CollectionInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "collection";
            }
            if (1 == n2) {
                return "servers";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public DocCollection collection() {
            return this.collection;
        }

        public IndexedSeq<ShardReplica> servers() {
            return this.servers;
        }

        public CollectionInfo copy(DocCollection collection, IndexedSeq<ShardReplica> servers) {
            return new CollectionInfo(collection, servers);
        }

        public DocCollection copy$default$1() {
            return this.collection();
        }

        public IndexedSeq<ShardReplica> copy$default$2() {
            return this.servers();
        }

        public DocCollection _1() {
            return this.collection();
        }

        public IndexedSeq<ShardReplica> _2() {
            return this.servers();
        }
    }

    public static final class UnknownCollectionException
    extends IllegalArgumentException
    implements Product {
        private final String collection;

        public static UnknownCollectionException apply(String string) {
            return CloudSolrServers$UnknownCollectionException$.MODULE$.apply(string);
        }

        public static UnknownCollectionException fromProduct(Product product) {
            return CloudSolrServers$UnknownCollectionException$.MODULE$.fromProduct(product);
        }

        public static UnknownCollectionException unapply(UnknownCollectionException unknownCollectionException) {
            return CloudSolrServers$UnknownCollectionException$.MODULE$.unapply(unknownCollectionException);
        }

        public UnknownCollectionException(String collection) {
            this.collection = collection;
            super(new StringBuilder(30).append("The collection '").append(collection).append("' is not known").toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UnknownCollectionException)) return false;
            UnknownCollectionException unknownCollectionException = (UnknownCollectionException)object;
            String string = this.collection();
            String string2 = unknownCollectionException.collection();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof UnknownCollectionException;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "UnknownCollectionException";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "collection";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String collection() {
            return this.collection;
        }

        public UnknownCollectionException copy(String collection) {
            return new UnknownCollectionException(collection);
        }

        public String copy$default$1() {
            return this.collection();
        }

        public String _1() {
            return this.collection();
        }
    }

    public static class WarmupQueries
    implements Product,
    Serializable {
        private final Function1 queriesByCollection;
        private final int count;

        public static WarmupQueries apply(Function1<String, Seq<SolrQuery>> function1, int n) {
            return CloudSolrServers$WarmupQueries$.MODULE$.apply(function1, n);
        }

        public static WarmupQueries fromProduct(Product product) {
            return CloudSolrServers$WarmupQueries$.MODULE$.fromProduct(product);
        }

        public static WarmupQueries unapply(WarmupQueries warmupQueries) {
            return CloudSolrServers$WarmupQueries$.MODULE$.unapply(warmupQueries);
        }

        public WarmupQueries(Function1<String, Seq<SolrQuery>> queriesByCollection, int count) {
            this.queriesByCollection = queriesByCollection;
            this.count = count;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queriesByCollection()));
            n = Statics.mix((int)n, (int)this.count());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WarmupQueries)) return false;
            WarmupQueries warmupQueries = (WarmupQueries)object;
            if (this.count() != warmupQueries.count()) return false;
            Function1<String, Seq<SolrQuery>> function1 = this.queriesByCollection();
            Function1<String, Seq<SolrQuery>> function12 = warmupQueries.queriesByCollection();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!warmupQueries.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WarmupQueries;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WarmupQueries";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "queriesByCollection";
            }
            if (1 == n2) {
                return "count";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<String, Seq<SolrQuery>> queriesByCollection() {
            return this.queriesByCollection;
        }

        public int count() {
            return this.count;
        }

        public WarmupQueries copy(Function1<String, Seq<SolrQuery>> queriesByCollection, int count) {
            return new WarmupQueries(queriesByCollection, count);
        }

        public Function1<String, Seq<SolrQuery>> copy$default$1() {
            return this.queriesByCollection();
        }

        public int copy$default$2() {
            return this.count();
        }

        public Function1<String, Seq<SolrQuery>> _1() {
            return this.queriesByCollection();
        }

        public int _2() {
            return this.count();
        }
    }
}

