/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.BetterFiles$;
import io.ino.solrs.SolrCloudRunner$;
import io.ino.solrs.SolrCollection;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.Exception$;

public class SolrCloudRunner {
    private final int numServers;
    private final List<SolrCollection> collections;
    private final Option<String> defaultCollection;
    private final Option<Object> maybeZkPort;
    private final Option<Path> maybeSolrHome;
    private volatile ZkTestServer zookeeper;
    private volatile MiniSolrCloudCluster miniSolrCloudCluster;
    private final Path baseDir;
    private final Path solrHome;

    public static List<SolrCollection> $lessinit$greater$default$2() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<SolrCollection> start$default$2() {
        return SolrCloudRunner$.MODULE$.start$default$2();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> start$default$3() {
        return SolrCloudRunner$.MODULE$.start$default$3();
    }

    public static Option<Object> start$default$4() {
        return SolrCloudRunner$.MODULE$.start$default$4();
    }

    public static Option<Path> $lessinit$greater$default$5() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Path> start$default$5() {
        return SolrCloudRunner$.MODULE$.start$default$5();
    }

    public SolrCloudRunner(int numServers, List<SolrCollection> collections, Option<String> defaultCollection, Option<Object> maybeZkPort, Option<Path> maybeSolrHome) {
        this.numServers = numServers;
        this.collections = collections;
        this.defaultCollection = defaultCollection;
        this.maybeZkPort = maybeZkPort;
        this.maybeSolrHome = maybeSolrHome;
        this.baseDir = this.createBaseDir();
        this.solrHome = this.makeSolrHomeDirIn(this.baseDir());
        System.setProperty("solr.install.dir", this.baseDir().toAbsolutePath().toString());
        System.setProperty("pkiHandlerPrivateKeyPath", this.getClass().getClassLoader().getResource("cryptokeys/priv_key512_pkcs8.pem").toExternalForm());
        System.setProperty("pkiHandlerPublicKeyPath", this.getClass().getClassLoader().getResource("cryptokeys/pub_key512.der").toExternalForm());
        System.setProperty("solr.log.dir", this.baseDir().toAbsolutePath().toString());
        System.setProperty("jetty.testMode", "true");
        System.setProperty("zookeeper.maxCnxns", "10");
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat");
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            private final /* synthetic */ SolrCloudRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.shutdown();
            }
        });
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public Path solrHome() {
        return this.solrHome;
    }

    public SolrCloudRunner start() {
        if (this.miniSolrCloudCluster != null) {
            throw new IllegalStateException("Cluster already running.");
        }
        if (this.zookeeper != null) {
            throw new IllegalStateException("Solr ZK Test Server already running.");
        }
        this.timed("Starting Solr ZK Test Server", (Function0 & Serializable)() -> {
            this.start$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        this.timed(new StringBuilder(46).append("Starting Mini Solr Cloud cluster with ").append(this.numServers).append(" node(s)").toString(), (Function0 & Serializable)() -> {
            this.start$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        this.collections.foreach((Function1)(JProcedure1 & Serializable)coll -> {
            String collectionName;
            String configName = collectionName = coll.name();
            Path confDir = this.solrHome().resolve(collectionName).resolve("conf");
            this.timed(new StringBuilder(43).append("Uploading config '").append(configName).append("' for collection '").append(collectionName).append("' from ").append(confDir).toString(), (Function0 & Serializable)() -> {
                this.start$$anonfun$3$$anonfun$1(configName, confDir);
                return BoxedUnit.UNIT;
            });
            CollectionAdminResponse result = (CollectionAdminResponse)this.timed(new StringBuilder(49).append("Creating collection '").append(collectionName).append("' with replicas=").append(coll.replicas()).append(" and shards=").append(coll.shards()).toString(), () -> this.$anonfun$1(coll, collectionName, configName));
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(19).append("Success: ").append(result.isSuccess()).append(", Status: ").append(result.getCollectionStatus()).toString());
        });
        ((IterableOps)this.solrCoreUrls().zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String url = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String url = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(24).append("Jetty core #").append(idx).append(" running at ").append(url).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.defaultCollection.foreach((Function1)(JProcedure1 & Serializable)coll -> this.miniSolrCloudCluster.getSolrClient().setDefaultCollection(coll));
        return this;
    }

    public void shutdown() {
        if (this.miniSolrCloudCluster != null) {
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Shutting down Solr Cloud cluster");
            this.miniSolrCloudCluster.shutdown();
            this.miniSolrCloudCluster = null;
        }
        if (this.zookeeper != null) {
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Shutting down Zookeeper");
            this.zookeeper.shutdown();
            this.zookeeper = null;
        }
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class})).apply((Function0 & Serializable)() -> {
            this.shutdown$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public CloudSolrClient solrJClient() {
        return this.miniSolrCloudCluster.getSolrClient();
    }

    public List<JettySolrRunner> jettySolrRunners() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.miniSolrCloudCluster.getJettySolrRunners()).asScala().toList();
    }

    public String zkAddress() {
        return this.zookeeper.getZkAddress();
    }

    public void restartZookeeper() {
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(49).append("Restarting Zookeeper with zkDir = ").append(this.zookeeper.getZkDir()).append(" and port = ").append(this.zookeeper.getPort()).append("...").toString());
        this.zookeeper.shutdown();
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Zookeeper was stopped, starting new one...");
        this.zookeeper = new ZkTestServer(this.zookeeper.getZkDir(), this.zookeeper.getPort());
        this.startZk(this.zookeeper);
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("New Zookeeper was started");
    }

    private void startZk(ZkTestServer zk) {
        zk.setViolationReportAction(ZkTestServer.LimitViolationAction.IGNORE);
        zk.getLimiter().setAction(ZkTestServer.LimitViolationAction.IGNORE);
        zk.run();
    }

    public List<String> solrCoreUrls() {
        return this.jettySolrRunners().flatMap((Function1 & Serializable)jetty -> (IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(jetty.getCoreContainer().getAllCoreNames()).asScala().map((Function1 & Serializable)coreName -> new StringBuilder(1).append(jetty.getBaseUrl()).append("/").append((String)coreName).toString()));
    }

    private Path makeSolrHomeDirIn(Path baseDir) {
        File solrHomeSourceDir = (File)this.maybeSolrHome.map((Function1 & Serializable)_$3 -> _$3.toFile()).getOrElse(SolrCloudRunner::$anonfun$3);
        Path solrHome = Files.createDirectories(baseDir.resolve("solrhome"), new FileAttribute[0]);
        BetterFiles$.MODULE$.copyDirectory(solrHomeSourceDir.toPath(), solrHome);
        return solrHome;
    }

    private Path createBaseDir() {
        return Files.createDirectories(this.tmpDir().resolve(new StringBuilder(4).append("base").append(System.currentTimeMillis()).toString()), new FileAttribute[0]);
    }

    private Path tmpDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    private <T> T timed(String description, Function0<T> f) {
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(description);
        long start = System.nanoTime();
        Object res = f.apply();
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(9).append(description).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)).append(" ms").toString());
        return (T)res;
    }

    private static final /* synthetic */ ZkTestServer start$$anonfun$1$$anonfun$1(Path dataDir$1, int zkPort) {
        return new ZkTestServer(dataDir$1, zkPort);
    }

    private static final ZkTestServer start$$anonfun$1$$anonfun$2(Path dataDir$2) {
        return new ZkTestServer(dataDir$2);
    }

    private final void start$$anonfun$1() {
        Path dataDir = this.baseDir().resolve("zookeeper/server1/data");
        this.zookeeper = (ZkTestServer)this.maybeZkPort.map((Function1 & Serializable)zkPort -> SolrCloudRunner.start$$anonfun$1$$anonfun$1(dataDir, BoxesRunTime.unboxToInt((Object)zkPort))).getOrElse(() -> SolrCloudRunner.start$$anonfun$1$$anonfun$2(dataDir));
        this.startZk(this.zookeeper);
    }

    private final void start$$anonfun$2() {
        boolean formatZkServer = false;
        this.miniSolrCloudCluster = new MiniSolrCloudCluster(this.numServers, this.solrHome(), MiniSolrCloudCluster.DEFAULT_CLOUD_SOLR_XML, new JettyConfig.Builder().build(), this.zookeeper, formatZkServer);
    }

    private final void start$$anonfun$3$$anonfun$1(String configName$1, Path confDir$1) {
        this.miniSolrCloudCluster.uploadConfigSet(confDir$1, configName$1);
    }

    private final CollectionAdminResponse $anonfun$1(SolrCollection coll$1, String collectionName$1, String configName$2) {
        return (CollectionAdminResponse)CollectionAdminRequest.createCollection((String)collectionName$1, (String)configName$2, (int)coll$1.shards(), (int)coll$1.replicas()).process((SolrClient)this.miniSolrCloudCluster.getSolrClient());
    }

    private final void shutdown$$anonfun$1() {
        FileUtils.deleteDirectory((File)this.baseDir().toFile());
    }

    private static final File $anonfun$3() {
        return Paths.get("./src/test/resources/solr", new String[0]).toAbsolutePath().normalize().toFile();
    }
}

