/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.SolrRunner$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.Filter;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.params.SolrParams;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.control.NonFatal$;

public class SolrRunner {
    private final int port;
    private final String context;
    private final Map<Class<? extends Filter>, String> extraFilters;
    private final Option<Path> maybeSolrHome;
    private final String url;
    private JettySolrRunner jetty;
    private final Path baseDir;
    private final Path solrHome;

    public static String DefaultContext() {
        return SolrRunner$.MODULE$.DefaultContext();
    }

    public static Map<Class<? extends Filter>, String> DefaultExtraFilters() {
        return SolrRunner$.MODULE$.DefaultExtraFilters();
    }

    public static void restartJetty(JettySolrRunner jettySolrRunner) {
        SolrRunner$.MODULE$.restartJetty(jettySolrRunner);
    }

    public static void startJetty(JettySolrRunner jettySolrRunner) {
        SolrRunner$.MODULE$.startJetty(jettySolrRunner);
    }

    public static SolrRunner startOnce(int n) {
        return SolrRunner$.MODULE$.startOnce(n);
    }

    public static SolrRunner startOnce(int n, String string, Map<Class<? extends Filter>, String> map, Option<Path> option) {
        return SolrRunner$.MODULE$.startOnce(n, string, map, option);
    }

    public static void stopJetty(JettySolrRunner jettySolrRunner) {
        SolrRunner$.MODULE$.stopJetty(jettySolrRunner);
    }

    public static String start$default$2() {
        return SolrRunner$.MODULE$.start$default$2();
    }

    public static String startOnce$default$2() {
        return SolrRunner$.MODULE$.startOnce$default$2();
    }

    public static Map<Class<? extends Filter>, String> start$default$3() {
        return SolrRunner$.MODULE$.start$default$3();
    }

    public static Map<Class<? extends Filter>, String> startOnce$default$3() {
        return SolrRunner$.MODULE$.startOnce$default$3();
    }

    public static Option<Path> start$default$4() {
        return SolrRunner$.MODULE$.start$default$4();
    }

    public static Option<Path> startOnce$default$4() {
        return SolrRunner$.MODULE$.startOnce$default$4();
    }

    public SolrRunner(int port, String context, Map<Class<? extends Filter>, String> extraFilters, Option<Path> maybeSolrHome) {
        this.port = port;
        this.context = context;
        this.extraFilters = extraFilters;
        this.maybeSolrHome = maybeSolrHome;
        this.url = new StringBuilder(17).append("http://localhost:").append(port).append(context).toString();
        this.baseDir = this.createBaseDir();
        this.solrHome = this.makeSolrHomeDirIn(this.baseDir());
    }

    public int port() {
        return this.port;
    }

    public String context() {
        return this.context;
    }

    public String url() {
        return this.url;
    }

    public JettySolrRunner jetty() {
        return this.jetty;
    }

    public void jetty_$eq(JettySolrRunner x$1) {
        this.jetty = x$1;
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public Path solrHome() {
        return this.solrHome;
    }

    public SolrRunner start() {
        if (this.jetty() != null) {
            throw new IllegalStateException("Start can only be invoked once. You probably want to use 'stop()' + 'start()'.");
        }
        SolrRunner$.io$ino$solrs$SolrRunner$$$logger.info(new StringBuilder(38).append("Starting Solr on port ").append(this.port()).append(" with Solr home ").append(this.solrHome().toAbsolutePath().toString()).toString());
        System.setProperty("solr.solr.home", this.solrHome().toAbsolutePath().toString());
        System.setProperty("solr.default.confdir", this.solrHome().resolve("/collection1/conf").toString());
        System.setProperty("solr.lock.type", "single");
        JettyConfig jettyConfig = JettyConfig.builder().setContext(this.context()).setPort(this.port()).withFilters(CollectionConverters$.MODULE$.MapHasAsJava(this.extraFilters).asJava()).build();
        this.jetty_$eq(new JettySolrRunner(this.solrHome().toAbsolutePath().toString(), jettyConfig));
        SolrRunner$.MODULE$.startJetty(this.jetty());
        return this;
    }

    public SolrRunner awaitReady(long value, TimeUnit unit) {
        return this.awaitReady((Duration)Duration$.MODULE$.apply(value, unit));
    }

    public SolrRunner awaitReady(Duration timeout) {
        HttpSolrClient solrClient = new HttpSolrClient.Builder(new StringBuilder(29).append("http://localhost:").append(this.port()).append(this.context()).append("/collection1").toString()).build();
        return this.await$1(timeout, solrClient, timeout);
    }

    public boolean isStarted() {
        return this.jetty() != null && this.jetty().isRunning();
    }

    public void stop() {
        if (this.isStarted()) {
            SolrRunner$.io$ino$solrs$SolrRunner$$$logger.info(new StringBuilder(36).append("Stopping Solr Jetty running on port ").append(this.port()).toString());
            SolrRunner$.MODULE$.stopJetty(this.jetty());
            this.jetty_$eq(null);
            return;
        }
    }

    private Path createBaseDir() {
        return Files.createDirectories(SolrRunner$.MODULE$.io$ino$solrs$SolrRunner$$$tmpDir().resolve(new StringBuilder(4).append("base").append(System.currentTimeMillis()).toString()), new FileAttribute[0]);
    }

    private Path makeSolrHomeDirIn(Path baseDir) {
        File solrHomeSourceDir = (File)this.maybeSolrHome.map((Function1 & Serializable)_$2 -> _$2.toFile()).getOrElse(this::$anonfun$2);
        Path solrHomeTargetInTemp = Files.createDirectories(baseDir.resolve("solrhome"), new FileAttribute[0]);
        FileUtils.copyDirectory((File)solrHomeSourceDir, (File)solrHomeTargetInTemp.toFile());
        return solrHomeTargetInTemp;
    }

    public boolean canEqual(Object other) {
        return other instanceof SolrRunner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof SolrRunner)) return false;
        SolrRunner that = (SolrRunner)object;
        if (!that.canEqual(this)) return false;
        String string = this.url();
        String string2 = that.url();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public int hashCode() {
        Seq state = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.url()}));
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)state.map((Function1 & Serializable)_$3 -> _$3.hashCode())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    private final SolrRunner await$1(Duration timeout$1, HttpSolrClient solrClient$1, Duration left) {
        SolrRunner solrRunner;
        while (true) {
            if (left.toMillis() <= 0L) {
                throw new TimeoutException(new StringBuilder(25).append("Solr not available after ").append(timeout$1).toString());
            }
            try {
                solrClient$1.query((SolrParams)new SolrQuery("*:*"));
                solrRunner = this;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3 = (Throwable)option.get();
                    Thread.sleep(50L);
                    left = left.$minus((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis());
                    continue;
                }
                throw throwable;
            }
            break;
        }
        return solrRunner;
    }

    private final File $anonfun$2() {
        return new File(this.getClass().getResource("/solr-home").toURI());
    }
}

