/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClientMocks$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.FastestServerLB;
import io.ino.solrs.FastestServerLB$;
import io.ino.solrs.Fixtures$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.ShardReplica;
import io.ino.solrs.ShardReplica$;
import io.ino.solrs.SolrMatchers$;
import io.ino.solrs.SolrResponseFactory;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.StaticSolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.time.Clock;
import io.ino.time.Clock$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.SolrParams;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funspec.AnyFunSpecLike;
import org.scalatest.matchers.TypeMatcherHelper$;
import org.scalatest.matchers.dsl.ResultOfATypeInvocation;
import scala.CanEqual$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public class FastestServerLBSpec
extends StandardFunSpec {
    public FastestServerLB<scala.concurrent.Future> io$ino$solrs$FastestServerLBSpec$$cut;
    private final SolrServer server1 = SolrServer$.MODULE$.apply("host1");
    private final SolrServer server2 = SolrServer$.MODULE$.apply("host2");
    private final SolrServer server3 = SolrServer$.MODULE$.apply("host3");
    private final StaticSolrServers solrServers = new StaticSolrServers((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrServer[]{this.server1, this.server2, this.server3})));
    private final SolrQuery q = new SolrQuery("foo");
    private final QueryRequest r = new QueryRequest((SolrParams)this.q);
    private final Clock.MutableClock clock;
    private final AsyncSolrClient<scala.concurrent.Future> solrs;

    public FastestServerLBSpec() {
        Function1 & Serializable classifyQuery = (Function1 & Serializable)solrQuery -> "foo";
        this.clock = Clock$.MODULE$.mutable();
        this.solrs = (AsyncSolrClient)this.mock(Tag$.MODULE$.apply(AsyncSolrClient.class, LightTypeTag$.MODULE$.parse(180112681, "\u0001\u0000\u001cio.ino.solrs.AsyncSolrClient\u0001\u0000\u0003\u0000\u0001\u0000\u0001T\u0001\u0000\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0002\u0001\u0000\u0001", "\u0000\u0001\u0003\u0000\u0001\u0000\u0001T\u0001\u0000\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0001\u0002\u0001\u0000\u0090\u0003\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0001\u0001\u0000\u001ascala.concurrent.Awaitable\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0001\u0002\u0000\u0001\u001cio.ino.solrs.AsyncSolrClient\u0001\u0001\u0003\u0000\u0001\u000fscala.Matchable\u0001\u0001\u0000\u0001\tscala.Any\u0001\u0001\u0000\u0001\u0010java.lang.Object\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21)));
        FastestServerLBSpec AnyFunSpecLike_this = this;
        Position pos$proxy18 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64);
        AnyFunSpecLike_this.org$scalatest$funspec$AnyFunSpecLike$$inline$describeImpl("FastestServerLB", (Function0 & Serializable)() -> {
            this.$init$$$anonfun$2();
            return BoxedUnit.UNIT;
        }, pos$proxy18);
    }

    @Override
    public void beforeEach() {
        Mockito.reset((Object[])new AsyncSolrClient[]{this.solrs});
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(this.solrs, (Function0<SolrServer>)((Function0 & Serializable)FastestServerLBSpec::beforeEach$$anonfun$1), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.clock);
        this.clock.set(0L);
    }

    @Override
    public void afterEach() {
        this.io$ino$solrs$FastestServerLBSpec$$cut.shutdown();
    }

    private Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> spiedClient(Duration minDelay, Duration maxDelay, Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit> mockRequests) {
        SolrQuery testQuery = new SolrQuery("testQuery");
        this.io$ino$solrs$FastestServerLBSpec$$cut = new FastestServerLB((SolrServers)this.solrServers, (Function1 & Serializable)_$2 -> Tuple2$.MODULE$.apply((Object)"collection1", (Object)testQuery), minDelay, maxDelay, FastestServerLB$.MODULE$.$lessinit$greater$default$5(), FastestServerLB$.MODULE$.$lessinit$greater$default$6(), FastestServerLB$.MODULE$.$lessinit$greater$default$7(), (Clock)this.clock, (FutureFactory)this.futureFactory());
        ObjectRef spyClient = ObjectRef.create(null);
        AsyncSolrClient realClient = new AsyncSolrClient.Builder<scala.concurrent.Future, AsyncSolrClient<scala.concurrent.Future>>(mockRequests, spyClient, this){
            private final Function1 mockRequests$1;
            private final ObjectRef spyClient$9;
            {
                this.mockRequests$1 = mockRequests$2;
                this.spyClient$9 = spyClient$12;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.io$ino$solrs$FastestServerLBSpec$$cut, $outer.ascFactory(), (FutureFactory)$outer.futureFactory());
            }

            public void setOnAsyncSolrClientAwares(AsyncSolrClient solr) {
                AsyncSolrClient asyncSolrClient = (AsyncSolrClient)Mockito.spy((Object)solr);
                this.spyClient$9.elem = asyncSolrClient;
                asyncSolrClient = null;
                this.mockRequests$1.apply((Object)((AsyncSolrClient)this.spyClient$9.elem));
                super.setOnAsyncSolrClientAwares((AsyncSolrClient)this.spyClient$9.elem);
            }
        }.build();
        return Tuple3$.MODULE$.apply((Object)testQuery, this.io$ino$solrs$FastestServerLBSpec$$cut, (Object)((AsyncSolrClient)spyClient.elem));
    }

    private Duration spiedClient$default$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds();
    }

    private Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit> spiedClient$default$3() {
        return (JProcedure1 & Serializable)spyClient -> AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)FastestServerLBSpec::spiedClient$default$3$$anonfun$1$$anonfun$1), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.clock);
    }

    private FastestServerLB<scala.concurrent.Future> newDynamicLB(SolrServers solrServers, SolrQuery q, Clock clock, Duration minDelay, Function1<Object, Object> mapPredictedResponseTime) {
        this.io$ino$solrs$FastestServerLBSpec$$cut = new FastestServerLB<scala.concurrent.Future>(solrServers, q, clock, minDelay, mapPredictedResponseTime, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                Function1 function1 = FastestServerLBSpec.io$ino$solrs$FastestServerLBSpec$$_$$anon$superArg$1$1(q$1);
                FiniteDuration finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds();
                Function1 function12 = FastestServerLB$.MODULE$.$lessinit$greater$default$6();
                super(solrServers$1, function1, minDelay$1, (Duration)finiteDuration, 1, function12, mapPredictedResponseTime$1, clock$1, (FutureFactory)$outer.futureFactory());
            }

            public void scheduleTests() {
            }

            public void scheduleUpdateStats() {
            }
        };
        this.io$ino$solrs$FastestServerLBSpec$$cut.setAsyncSolrClient(this.solrs);
        return this.io$ino$solrs$FastestServerLBSpec$$cut;
    }

    private Duration newDynamicLB$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
    }

    private Function1<Object, Object> newDynamicLB$default$5() {
        return (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
    }

    private <T> T atSecond(long second, Function0<T> f) {
        this.clock.set(TimeUnit.SECONDS.toMillis(second));
        return (T)f.apply();
    }

    private void runTests(FastestServerLB<scala.concurrent.Future> cut, SolrServer server, long fromSecond, long toSecond, long startResponseTime, long endResponseTime) {
        long deltaPerStep = (endResponseTime - startResponseTime) / (toSecond - fromSecond);
        new RichLong(Predef$.MODULE$.longWrapper(fromSecond)).to((Object)BoxesRunTime.boxToLong((long)toSecond)).foreach((Function1 & Serializable)second -> this.runTests$$anonfun$1(cut, server, fromSecond, startResponseTime, deltaPerStep, BoxesRunTime.unboxToLong((Object)second)));
    }

    private final Assertion testFun$proxy1$1() {
        SolrServers nonMatchingServers = new SolrServers(){

            public Seq all() {
                return package$.MODULE$.Nil();
            }

            public Try matching(SolrRequest r) {
                return Success$.MODULE$.apply((Object)package$.MODULE$.Vector().empty());
            }
        };
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB(nonMatchingServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        Try leftSideValue$proxy1 = cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2());
        Position pos$proxy1 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73);
        ResultOfATypeInvocation aType$proxy1 = this.a(ClassTag$.MODULE$.apply(Failure.class));
        return TypeMatcherHelper$.MODULE$.assertAType((Object)leftSideValue$proxy1, aType$proxy1, Prettifier$.MODULE$.default(), pos$proxy1);
    }

    private final Object fun$proxy2$1$$anonfun$1() {
        return this.testFun$proxy1$1();
    }

    private final Assertion testFun$proxy2$1() {
        IndexedSeq servers = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrServer[]{SolrServer$.MODULE$.apply("host1"), SolrServer$.MODULE$.apply("host2")}));
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)new StaticSolrServers(servers), this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)SolrServer$.MODULE$.apply("host1"))));
        this.runTests(cut, this.server1, 1L, 2L, 1000L, 1000L);
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)SolrServer$.MODULE$.apply("host2"))));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)SolrServer$.MODULE$.apply("host2"))));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Enabled$.MODULE$);
        ((SolrServer)servers.apply(1)).status_$eq((ServerStatus)Failed$.MODULE$);
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)SolrServer$.MODULE$.apply("host1"))));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)SolrServer$.MODULE$.apply("host1"))));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
        Try leftSideValue$proxy2 = cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2());
        Position pos$proxy3 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99);
        ResultOfATypeInvocation aType$proxy2 = this.a(ClassTag$.MODULE$.apply(Failure.class));
        return TypeMatcherHelper$.MODULE$.assertAType((Object)leftSideValue$proxy2, aType$proxy2, Prettifier$.MODULE$.default(), pos$proxy3);
    }

    private final Object fun$proxy2$1$$anonfun$2() {
        return this.testFun$proxy2$1();
    }

    private final Assertion testFun$proxy3$1() {
        ShardReplica server1 = Fixtures$.MODULE$.shardReplica("host1", Fixtures$.MODULE$.shardReplica$default$2(), Fixtures$.MODULE$.shardReplica$default$3(), true);
        ShardReplica server2 = Fixtures$.MODULE$.shardReplica("host2", Fixtures$.MODULE$.shardReplica$default$2(), Fixtures$.MODULE$.shardReplica$default$3(), false);
        IndexedSeq servers = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShardReplica[]{server1, server2}));
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)new StaticSolrServers(servers){

            public Option findLeader(Iterable servers) {
                return ShardReplica$.MODULE$.findLeader(servers);
            }
        }, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        UpdateRequest r = new UpdateRequest();
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        this.runTests(cut, (SolrServer)server1, 1L, 2L, 1000L, 1000L);
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)));
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Enabled$.MODULE$);
        ((SolrServer)servers.apply(1)).status_$eq((ServerStatus)Failed$.MODULE$);
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        this.should((Object)cut.solrServer((SolrRequest)r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
        Try leftSideValue$proxy3 = cut.solrServer((SolrRequest)r, cut.solrServer$default$2());
        Position pos$proxy5 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134);
        ResultOfATypeInvocation aType$proxy3 = this.a(ClassTag$.MODULE$.apply(Failure.class));
        return TypeMatcherHelper$.MODULE$.assertAType((Object)leftSideValue$proxy3, aType$proxy3, Prettifier$.MODULE$.default(), pos$proxy5);
    }

    private final Object fun$proxy2$1$$anonfun$3() {
        return this.testFun$proxy3$1();
    }

    private static final QueryRequest q$4(Seq replicaTypes) {
        return new QueryRequest((SolrParams)new SolrQuery("foo").setParam("shards.preference", new String[]{new StringBuilder(23).append("replica.location:local,").append(replicaTypes.mkString(new StringBuilder(13).append("replica.type").append(":").toString(), new StringBuilder(14).append(",").append("replica.type").append(":").toString(), "")).toString()}));
    }

    private final Assertion testFun$proxy4$1() {
        ShardReplica server1 = Fixtures$.MODULE$.shardReplica("host1", Fixtures$.MODULE$.shardReplica$default$2(), Replica.Type.NRT, Fixtures$.MODULE$.shardReplica$default$4());
        ShardReplica server2 = Fixtures$.MODULE$.shardReplica("host2", Fixtures$.MODULE$.shardReplica$default$2(), Replica.Type.TLOG, Fixtures$.MODULE$.shardReplica$default$4());
        ShardReplica server3 = Fixtures$.MODULE$.shardReplica("host3", Fixtures$.MODULE$.shardReplica$default$2(), Replica.Type.PULL, Fixtures$.MODULE$.shardReplica$default$4());
        IndexedSeq servers = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ShardReplica[]{server1, server2, server3}));
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)new StaticSolrServers(servers), this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.PULL})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server3)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.PULL})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server3)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.TLOG})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.TLOG})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.NRT})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.NRT})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.TLOG, Replica.Type.PULL})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)).or(this.be().apply((Object)Success$.MODULE$.apply((Object)server3))));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.PULL, Replica.Type.TLOG})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server2)).or(this.be().apply((Object)Success$.MODULE$.apply((Object)server3))));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.NRT, Replica.Type.PULL})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)).or(this.be().apply((Object)Success$.MODULE$.apply((Object)server3))));
        this.should((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.PULL, Replica.Type.NRT})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)server1)).or(this.be().apply((Object)Success$.MODULE$.apply((Object)server3))));
        ((SolrServer)servers.apply(0)).status_$eq((ServerStatus)Disabled$.MODULE$);
        return this.shouldBe((Object)cut.solrServer((SolrRequest)FastestServerLBSpec.q$4((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Replica.Type[]{Replica.Type.NRT, Replica.Type.PULL})), cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170), Prettifier$.MODULE$.default(), Success$.MODULE$.apply((Object)server3), CanEqual$.MODULE$.canEqualAny());
    }

    private final Object fun$proxy2$1$$anonfun$4() {
        return this.testFun$proxy4$1();
    }

    private final Assertion testFun$proxy5$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        Mockito.when((Object)this.solrs.doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)ArgumentMatchers.any(), (SolrResponseFactory)ArgumentMatchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(1L, this.clock));
        cut.test(this.server1);
        Mockito.when((Object)this.solrs.doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)ArgumentMatchers.any(), (SolrResponseFactory)ArgumentMatchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(10L, this.clock));
        cut.test(this.server2);
        Mockito.when((Object)this.solrs.doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)ArgumentMatchers.any(), (SolrResponseFactory)ArgumentMatchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(20L, this.clock));
        cut.test(this.server3);
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        return this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
    }

    private final Object fun$proxy2$1$$anonfun$5() {
        return this.testFun$proxy5$1();
    }

    private final Assertion testFun$proxy6$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        this.runTests(cut, this.server1, 1L, 5L, 1L, 1L);
        this.runTests(cut, this.server2, 1L, 5L, 1L, 1L);
        this.runTests(cut, this.server3, 1L, 5L, 1L, 1L);
        cut.updateStats();
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server3)));
        return this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
    }

    private final Object fun$proxy2$1$$anonfun$6() {
        return this.testFun$proxy6$1();
    }

    private final Assertion testFun$proxy7$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        Success preferred = Success$.MODULE$.apply((Object)this.server2);
        this.runTests(cut, this.server1, 1L, 5L, 1L, 1L);
        this.runTests(cut, this.server2, 1L, 5L, 1L, 1L);
        this.runTests(cut, this.server3, 1L, 5L, 10L, 10L);
        cut.updateStats();
        this.should((Object)cut.solrServer((SolrRequest)this.r, (Option)Some$.MODULE$.apply((Object)this.server2)), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, (Option)Some$.MODULE$.apply((Object)this.server2)), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, (Option)Some$.MODULE$.apply((Object)this.server3)), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        return this.should((Object)cut.solrServer((SolrRequest)this.r, (Option)Some$.MODULE$.apply((Object)this.server3)), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
    }

    private final Object fun$proxy2$1$$anonfun$7() {
        return this.testFun$proxy7$1();
    }

    private final Assertion testFun$proxy8$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), this.newDynamicLB$default$5());
        this.runTests(cut, this.server1, 1L, 5L, 10L, 10L);
        this.runTests(cut, this.server2, 1L, 5L, 20L, 20L);
        this.runTests(cut, this.server3, 1L, 5L, 20L, 20L);
        cut.updateStats();
        this.runTests(cut, this.server1, 6L, 10L, 10L, 20L);
        this.runTests(cut, this.server2, 6L, 10L, 20L, 10L);
        cut.updateStats();
        return this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
    }

    private final Object fun$proxy2$1$$anonfun$8() {
        return this.testFun$proxy8$1();
    }

    private final Assertion testFun$proxy9$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, this.newDynamicLB$default$4(), (Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)t -> t / 5L);
        this.runTests(cut, this.server1, 1L, 5L, 1L, 1L);
        this.runTests(cut, this.server2, 1L, 5L, 2L, 2L);
        this.runTests(cut, this.server3, 1L, 5L, 3L, 3L);
        cut.updateStats();
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server2)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server3)));
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        this.runTests(cut, this.server2, 6L, 10L, 10L, 10L);
        this.runTests(cut, this.server3, 6L, 10L, 10L, 10L);
        cut.updateStats();
        this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
        return this.should((Object)cut.solrServer((SolrRequest)this.r, cut.solrServer$default$2()), Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340), Prettifier$.MODULE$.default(), this.be().apply((Object)Success$.MODULE$.apply((Object)this.server1)));
    }

    private final Object fun$proxy2$1$$anonfun$9() {
        return this.testFun$proxy9$1();
    }

    private final void testFun$proxy10$1() {
        FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers, this.q, (Clock)this.clock, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis(), this.newDynamicLB$default$5());
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify(this.solrs)).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)this.q), (SolrResponseFactory)ArgumentMatchers.any()));
    }

    private final Object fun$proxy2$1$$anonfun$10() {
        this.testFun$proxy10$1();
        return BoxedUnit.UNIT;
    }

    private static final SolrServer testFun$proxy11$1$$anonfun$2() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    private final void testFun$proxy11$1() {
        this.clock.set(0L);
        FiniteDuration minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
        Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)minDelay, this.spiedClient$default$2(), this.spiedClient$default$3());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        SolrQuery testQuery = (SolrQuery)tuple3._1();
        FastestServerLB cut = (FastestServerLB)tuple3._2();
        AsyncSolrClient spyClient = (AsyncSolrClient)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testQuery, (Object)cut, (Object)spyClient);
        SolrQuery testQuery2 = (SolrQuery)tuple32._1();
        FastestServerLB cut2 = (FastestServerLB)tuple32._2();
        AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple32._3();
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.atLeastOnce())).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
        Mockito.reset((Object[])new AsyncSolrClient[]{spyClient2});
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient2, (Function0<SolrServer>)((Function0 & Serializable)FastestServerLBSpec::testFun$proxy11$1$$anonfun$2), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.clock);
        this.clock.set(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds().toMillis());
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.never())).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
        SolrQuery realQuery = new SolrQuery("foo");
        spyClient2.query((SolrParams)realQuery);
        ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)ArgumentMatchers.any());
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
        realQuery = new SolrQuery("bar");
        spyClient2.query((SolrParams)realQuery);
        ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)ArgumentMatchers.any());
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
        this.clock.advance(minDelay.toMillis());
        realQuery = new SolrQuery("baz");
        spyClient2.query((SolrParams)realQuery);
        ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)ArgumentMatchers.any());
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)2))).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
    }

    private final Object fun$proxy2$1$$anonfun$11() {
        this.testFun$proxy11$1();
        return BoxedUnit.UNIT;
    }

    private final SolrServer mockRequests$3$$anonfun$1() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server1);
    }

    private final SolrServer mockRequests$3$$anonfun$2() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server2);
    }

    private final SolrServer mockRequests$3$$anonfun$3() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server3);
    }

    private final void mockRequests$3(AsyncSolrClient spyClient) {
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$3$$anonfun$1), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(8)).millis(), this.clock);
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$3$$anonfun$2), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(12)).millis(), this.clock);
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$3$$anonfun$3), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).millis(), this.clock);
    }

    private final Future testFun$proxy12$1() {
        this.clock.set(0L);
        FiniteDuration minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
        Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)minDelay, this.spiedClient$default$2(), (Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit>)(JProcedure1 & Serializable)spyClient -> this.mockRequests$3((AsyncSolrClient)spyClient));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        SolrQuery testQuery = (SolrQuery)tuple3._1();
        FastestServerLB cut = (FastestServerLB)tuple3._2();
        AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testQuery, (Object)cut, (Object)spyClient2);
        SolrQuery testQuery2 = (SolrQuery)tuple32._1();
        FastestServerLB cut2 = (FastestServerLB)tuple32._2();
        AsyncSolrClient spyClient3 = (AsyncSolrClient)tuple32._3();
        Mockito.reset((Object[])new AsyncSolrClient[]{spyClient3});
        this.mockRequests$3(spyClient3);
        this.clock.set(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds().toMillis());
        SolrQuery realQuery = new SolrQuery("foo");
        spyClient3.query((SolrParams)realQuery);
        ((AsyncSolrClient)Mockito.verify((Object)spyClient3)).doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)ArgumentMatchers.any());
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrServer[]{this.server1, this.server2}))).foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient3, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any()));
        return ((AsyncSolrClient)Mockito.verify((Object)spyClient3, (VerificationMode)Mockito.never())).doExecute((SolrServer)ArgumentMatchers.eq((Object)this.server3), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)ArgumentMatchers.any());
    }

    private final Object fun$proxy2$1$$anonfun$12() {
        return this.testFun$proxy12$1();
    }

    private final SolrServer mockRequests$4$$anonfun$1() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server1);
    }

    private final SolrServer mockRequests$4$$anonfun$2() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server2);
    }

    private final SolrServer mockRequests$4$$anonfun$3() {
        return (SolrServer)ArgumentMatchers.eq((Object)this.server3);
    }

    private final void mockRequests$4(AsyncSolrClient spyClient) {
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$4$$anonfun$1), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(4)).millis(), this.clock);
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$4$$anonfun$2), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(6)).millis(), this.clock);
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)((Function0 & Serializable)this::mockRequests$4$$anonfun$3), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), this.clock);
    }

    private final void fun$proxy1$1(SolrQuery testQuery$7, AsyncSolrClient spyClient$7) {
        this.solrServers.all().foreach((Function1 & Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient$7, (VerificationMode)Mockito.atLeastOnce())).doExecute((SolrServer)ArgumentMatchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery$7), (SolrResponseFactory)ArgumentMatchers.any()));
    }

    private final void testFun$proxy13$1$$anonfun$1(SolrQuery testQuery$10, AsyncSolrClient spyClient$10) {
        this.fun$proxy1$1(testQuery$10, spyClient$10);
    }

    private final void testFun$proxy13$1() {
        this.clock.set(0L);
        FiniteDuration minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis();
        FiniteDuration maxDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
        Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)minDelay, (Duration)maxDelay, (Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit>)(JProcedure1 & Serializable)spyClient -> this.mockRequests$4((AsyncSolrClient)spyClient));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        SolrQuery testQuery = (SolrQuery)tuple3._1();
        FastestServerLB cut = (FastestServerLB)tuple3._2();
        AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)testQuery, (Object)cut, (Object)spyClient2);
        SolrQuery testQuery2 = (SolrQuery)tuple32._1();
        FastestServerLB cut2 = (FastestServerLB)tuple32._2();
        AsyncSolrClient spyClient3 = (AsyncSolrClient)tuple32._3();
        Mockito.reset((Object[])new AsyncSolrClient[]{spyClient3});
        this.mockRequests$4(spyClient3);
        this.clock.advance(maxDelay.toMillis());
        Thread.sleep(maxDelay.toMillis());
        AbstractPatienceConfiguration.PatienceConfig config$proxy1 = Eventually$.MODULE$.patienceConfig();
        Retrying retrying$proxy1 = Retrying$.MODULE$.retryingNatureOfT();
        Position pos$proxy16 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447);
        Eventually$.MODULE$.callRetry(retrying$proxy1, config$proxy1.timeout(), config$proxy1.interval(), pos$proxy16, (Function0 & Serializable)() -> {
            this.testFun$proxy13$1$$anonfun$1(testQuery2, spyClient3);
            return BoxedUnit.UNIT;
        });
    }

    private final Object fun$proxy2$1$$anonfun$13() {
        this.testFun$proxy13$1();
        return BoxedUnit.UNIT;
    }

    private final void fun$proxy2$1() {
        AnyFunSpecLike.ItWord ItWord_this = this.it();
        ArraySeq testTags$proxy1 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy2 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66);
        ItWord_this.inline$applyImpl("should return a Failure if no solr server matches", (Seq)testTags$proxy1, this::fun$proxy2$1$$anonfun$1, pos$proxy2);
        AnyFunSpecLike.ItWord ItWord_this2 = this.it();
        ArraySeq testTags$proxy2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy4 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76);
        ItWord_this2.inline$applyImpl("should only return active solr servers", (Seq)testTags$proxy2, this::fun$proxy2$1$$anonfun$2, pos$proxy4);
        AnyFunSpecLike.ItWord ItWord_this3 = this.it();
        ArraySeq testTags$proxy3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy6 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102);
        ItWord_this3.inline$applyImpl("should return the active leader for update requests", (Seq)testTags$proxy3, this::fun$proxy2$1$$anonfun$3, pos$proxy6);
        AnyFunSpecLike.ItWord ItWord_this4 = this.it();
        ArraySeq testTags$proxy4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy7 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137);
        ItWord_this4.inline$applyImpl("should return replicas matching the given shard preferences / replica type", (Seq)testTags$proxy4, this::fun$proxy2$1$$anonfun$4, pos$proxy7);
        AnyFunSpecLike.ItWord ItWord_this5 = this.it();
        ArraySeq testTags$proxy5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy8 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173);
        ItWord_this5.inline$applyImpl("should return the fastest server by default", (Seq)testTags$proxy5, this::fun$proxy2$1$$anonfun$5, pos$proxy8);
        AnyFunSpecLike.ItWord ItWord_this6 = this.it();
        ArraySeq testTags$proxy6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy9 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191);
        ItWord_this6.inline$applyImpl("should round robin equally fast servers", (Seq)testTags$proxy6, this::fun$proxy2$1$$anonfun$6, pos$proxy9);
        AnyFunSpecLike.ItWord ItWord_this7 = this.it();
        ArraySeq testTags$proxy7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy10 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220);
        ItWord_this7.inline$applyImpl("should consider the preferred server if it's one of the fastest servers", (Seq)testTags$proxy7, this::fun$proxy2$1$$anonfun$7, pos$proxy10);
        AnyFunSpecLike.ItWord ItWord_this8 = this.it();
        ArraySeq testTags$proxy8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy11 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252);
        ItWord_this8.inline$applyImpl("should return the server with a better predicted response time", (Seq)testTags$proxy8, this::fun$proxy2$1$$anonfun$8, pos$proxy11);
        AnyFunSpecLike.ItWord ItWord_this9 = this.it();
        ArraySeq testTags$proxy9 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy12 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296);
        ItWord_this9.inline$applyImpl("should allow to quantize / consider (very) similar predicted response times to be equal", (Seq)testTags$proxy9, this::fun$proxy2$1$$anonfun$9, pos$proxy12);
        AnyFunSpecLike.ItWord ItWord_this10 = this.it();
        ArraySeq testTags$proxy10 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy13 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343);
        ItWord_this10.inline$applyImpl("should initially test servers to gather performance stats", (Seq)testTags$proxy10, this::fun$proxy2$1$$anonfun$10, pos$proxy13);
        AnyFunSpecLike.ItWord ItWord_this11 = this.it();
        ArraySeq testTags$proxy11 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy14 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349);
        ItWord_this11.inline$applyImpl("should test servers based on the real query rate restricted by min delay", (Seq)testTags$proxy11, this::fun$proxy2$1$$anonfun$11, pos$proxy14);
        AnyFunSpecLike.ItWord ItWord_this12 = this.it();
        ArraySeq testTags$proxy12 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy15 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393);
        ItWord_this12.inline$applyImpl("should test slow servers less frequently", (Seq)testTags$proxy12, this::fun$proxy2$1$$anonfun$12, pos$proxy15);
        AnyFunSpecLike.ItWord ItWord_this13 = this.it();
        ArraySeq testTags$proxy13 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position pos$proxy17 = Position$.MODULE$.apply("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423);
        ItWord_this13.inline$applyImpl("should test slow/all servers according to the specified maxDelay", (Seq)testTags$proxy13, this::fun$proxy2$1$$anonfun$13, pos$proxy17);
    }

    private final void $init$$$anonfun$2() {
        this.fun$proxy2$1();
    }

    private static final SolrServer beforeEach$$anonfun$1() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    private static final SolrServer spiedClient$default$3$$anonfun$1$$anonfun$1() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    public static final Function1 io$ino$solrs$FastestServerLBSpec$$_$$anon$superArg$1$1(SolrQuery q$2) {
        return (Function1 & Serializable)_$3 -> Tuple2$.MODULE$.apply((Object)"collection1", (Object)q$2);
    }

    private final Future runTests$$anonfun$1$$anonfun$1(FastestServerLB cut$2, SolrServer server$2, long fromSecond$2, long startResponseTime$2, long deltaPerStep$2, long second$1) {
        long responseTime = startResponseTime$2 + (second$1 - fromSecond$2) * deltaPerStep$2;
        Mockito.when((Object)this.solrs.doExecute((SolrServer)ArgumentMatchers.any(), (SolrRequest)ArgumentMatchers.any(), (SolrResponseFactory)ArgumentMatchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(responseTime, this.clock));
        return cut$2.test(server$2);
    }

    private final /* synthetic */ Future runTests$$anonfun$1(FastestServerLB cut$1, SolrServer server$1, long fromSecond$1, long startResponseTime$1, long deltaPerStep$1, long second) {
        return (Future)this.atSecond(second, () -> this.runTests$$anonfun$1$$anonfun$1(cut$1, server$1, fromSecond$1, startResponseTime$1, deltaPerStep$1, second));
    }
}

