/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.BetterFiles$;
import io.ino.solrs.SolrCloudRunner$;
import io.ino.solrs.SolrCollection;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.control.Exception$;

public class SolrCloudRunner {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SolrCloudRunner.class.getDeclaredField("solrJClient$lzy1"));
    private final int numServers;
    private final List<SolrCollection> collections;
    private final Option<String> defaultCollection;
    private final Option<Object> maybeZkPort;
    private final Option<Path> maybeSolrHome;
    private volatile Option<ZkTestServer> maybeZookeeper;
    private volatile MiniSolrCloudCluster miniSolrCloudCluster;
    private final Path baseDir;
    private final Path solrHome;
    private final Option<Path> maybeSecurityJson;
    private volatile Object solrJClient$lzy1;

    public static List<SolrCollection> $lessinit$greater$default$2() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<SolrCollection> start$default$2() {
        return SolrCloudRunner$.MODULE$.start$default$2();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> start$default$3() {
        return SolrCloudRunner$.MODULE$.start$default$3();
    }

    public static Option<Object> start$default$4() {
        return SolrCloudRunner$.MODULE$.start$default$4();
    }

    public static Option<Path> $lessinit$greater$default$5() {
        return SolrCloudRunner$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Path> start$default$5() {
        return SolrCloudRunner$.MODULE$.start$default$5();
    }

    public SolrCloudRunner(int numServers, List<SolrCollection> collections, Option<String> defaultCollection, Option<Object> maybeZkPort, Option<Path> maybeSolrHome) {
        None$ none$;
        this.numServers = numServers;
        this.collections = collections;
        this.defaultCollection = defaultCollection;
        this.maybeZkPort = maybeZkPort;
        this.maybeSolrHome = maybeSolrHome;
        this.maybeZookeeper = None$.MODULE$;
        this.baseDir = this.createBaseDir();
        this.solrHome = this.makeSolrHomeDirIn(this.baseDir());
        File file = this.solrHome().resolve("security.json").toFile();
        if (file.exists()) {
            if (maybeZkPort.isDefined()) {
                throw new IllegalArgumentException("maybeZkPort is defined and a solrHome with a security.json is chosen - this combination is not supported");
            }
            none$ = Some$.MODULE$.apply((Object)file.toPath());
        } else {
            none$ = None$.MODULE$;
        }
        this.maybeSecurityJson = none$;
        System.setProperty("solr.install.dir", this.baseDir().toAbsolutePath().toString());
        System.setProperty("pkiHandlerPrivateKeyPath", this.getClass().getClassLoader().getResource("cryptokeys/priv_key512_pkcs8.pem").toExternalForm());
        System.setProperty("pkiHandlerPublicKeyPath", this.getClass().getClassLoader().getResource("cryptokeys/pub_key512.der").toExternalForm());
        System.setProperty("solr.log.dir", this.baseDir().toAbsolutePath().toString());
        System.setProperty("jetty.testMode", "true");
        System.setProperty("zookeeper.maxCnxns", "10");
        System.setProperty("zookeeper.4lw.commands.whitelist", "stat");
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            private final /* synthetic */ SolrCloudRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.shutdown();
            }
        });
    }

    public Path baseDir() {
        return this.baseDir;
    }

    public Path solrHome() {
        return this.solrHome;
    }

    public SolrCloudRunner start() {
        if (this.miniSolrCloudCluster != null) {
            throw new IllegalStateException("Cluster already running.");
        }
        if (this.maybeZookeeper.isDefined()) {
            throw new IllegalStateException("Solr ZK Test Server already running.");
        }
        this.maybeZkPort.foreach((Function1)(JFunction1.mcVI.sp & Serializable)zkPort -> this.timed("Starting Solr ZK Test Server", (Function0 & Serializable)() -> {
            this.start$$anonfun$1$$anonfun$1(zkPort);
            return BoxedUnit.UNIT;
        }));
        this.timed(new StringBuilder(46).append("Starting Mini Solr Cloud cluster with ").append(this.numServers).append(" node(s)").toString(), (Function0 & Serializable)() -> {
            this.start$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        this.collections.foreach((Function1)(JProcedure1 & Serializable)coll -> {
            String collectionName;
            String configName = collectionName = coll.name();
            Path confDir = this.solrHome().resolve(collectionName).resolve("conf");
            this.timed(new StringBuilder(43).append("Uploading config '").append(configName).append("' for collection '").append(collectionName).append("' from ").append(confDir).toString(), (Function0 & Serializable)() -> {
                this.start$$anonfun$3$$anonfun$1(configName, confDir);
                return BoxedUnit.UNIT;
            });
            CollectionAdminResponse result = (CollectionAdminResponse)this.timed(new StringBuilder(49).append("Creating collection '").append(collectionName).append("' with replicas=").append(coll.replicas()).append(" and shards=").append(coll.shards()).toString(), () -> this.$anonfun$1(coll, collectionName, configName));
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(19).append("Success: ").append(result.isSuccess()).append(", Status: ").append(result.getCollectionStatus()).toString());
        });
        ((IterableOps)this.solrCoreUrls().zipWithIndex()).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String url = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String url = (String)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(24).append("Jetty core #").append(idx).append(" running at ").append(url).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.defaultCollection.foreach((Function1)(JProcedure1 & Serializable)coll -> this.solrJClient().setDefaultCollection(coll));
        return this;
    }

    public void shutdown() {
        if (this.miniSolrCloudCluster != null) {
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Shutting down Solr Cloud cluster");
            this.miniSolrCloudCluster.shutdown();
            this.miniSolrCloudCluster = null;
        }
        this.maybeZookeeper.foreach((Function1)(JProcedure1 & Serializable)zookeeper -> {
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Shutting down Zookeeper");
            zookeeper.shutdown();
            this.maybeZookeeper = None$.MODULE$;
        });
        Exception$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class})).apply((Function0 & Serializable)() -> {
            this.shutdown$$anonfun$2();
            return BoxedUnit.UNIT;
        });
    }

    public CloudSolrClient solrJClient() {
        Object object = this.solrJClient$lzy1;
        if (object instanceof CloudSolrClient) {
            return (CloudSolrClient)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CloudSolrClient)this.solrJClient$lzyINIT1();
    }

    private Object solrJClient$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.solrJClient$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CloudHttp2SolrClient cloudHttp2SolrClient = null;
                    try {
                        Http2SolrClient.Builder http2ClientBuilder = new Http2SolrClient.Builder().withBasicAuthCredentials("solr", "SolrRocks");
                        cloudHttp2SolrClient = new CloudSolrClient.Builder(Arrays.asList(this.miniSolrCloudCluster.getZkServer().getZkAddress()), Optional.empty()).withInternalClientBuilder(http2ClientBuilder).build();
                        object2 = cloudHttp2SolrClient == null ? LazyVals.NullValue$.MODULE$ : cloudHttp2SolrClient;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.solrJClient$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.solrJClient$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return cloudHttp2SolrClient;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<JettySolrRunner> jettySolrRunners() {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.miniSolrCloudCluster.getJettySolrRunners()).asScala().toList();
    }

    public String zkAddress() {
        return this.miniSolrCloudCluster.getZkServer().getZkAddress();
    }

    public void restartZookeeper() {
        this.maybeZookeeper.foreach((Function1)(JProcedure1 & Serializable)zookeeper -> {
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(49).append("Restarting Zookeeper with zkDir = ").append(zookeeper.getZkDir()).append(" and port = ").append(zookeeper.getPort()).append("...").toString());
            zookeeper.shutdown();
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("Zookeeper was stopped, starting new one...");
            this.maybeZookeeper = Some$.MODULE$.apply((Object)new ZkTestServer(zookeeper.getZkDir(), zookeeper.getPort()));
            this.startZk((ZkTestServer)this.maybeZookeeper.get());
            SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info("New Zookeeper was started");
        });
    }

    private void startZk(ZkTestServer zk) {
        zk.setViolationReportAction(ZkTestServer.LimitViolationAction.IGNORE);
        zk.getLimiter().setAction(ZkTestServer.LimitViolationAction.IGNORE);
        zk.run();
    }

    public List<String> solrCoreUrls() {
        return this.jettySolrRunners().flatMap((Function1 & Serializable)jetty -> (IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(jetty.getCoreContainer().getAllCoreNames()).asScala().map((Function1 & Serializable)coreName -> new StringBuilder(1).append(jetty.getBaseUrl()).append("/").append((String)coreName).toString()));
    }

    private Path makeSolrHomeDirIn(Path baseDir) {
        Path solrHomeSourceDir = (Path)this.maybeSolrHome.getOrElse(SolrCloudRunner::$anonfun$2);
        Path solrHome = Files.createDirectories(baseDir.resolve("solrhome"), new FileAttribute[0]);
        BetterFiles$.MODULE$.copyDirectory(solrHomeSourceDir, solrHome);
        return solrHome;
    }

    private Path createBaseDir() {
        return Files.createDirectories(this.tmpDir().resolve(new StringBuilder(4).append("base").append(System.currentTimeMillis()).toString()), new FileAttribute[0]);
    }

    private Path tmpDir() {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    private <T> T timed(String description, Function0<T> f) {
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(description);
        long start = System.nanoTime();
        Object res = f.apply();
        SolrCloudRunner$.io$ino$solrs$SolrCloudRunner$$$logger.info(new StringBuilder(9).append(description).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)).append(" ms").toString());
        return (T)res;
    }

    private final void start$$anonfun$1$$anonfun$1(int zkPort$1) {
        Path dataDir = this.baseDir().resolve("zookeeper/server1/data");
        this.maybeZookeeper = Some$.MODULE$.apply((Object)new ZkTestServer(dataDir, zkPort$1));
        this.startZk((ZkTestServer)this.maybeZookeeper.get());
    }

    /*
     * Unable to fully structure code
     */
    private final void start$$anonfun$2() {
        block5: {
            block3: {
                block4: {
                    var1_1 = Tuple2$.MODULE$.apply(this.maybeZookeeper, this.maybeSecurityJson);
                    if (var1_1 == null) ** GOTO lbl23
                    var2_2 = (Option)var1_1._1();
                    var3_3 = (Option)var1_1._2();
                    if (!None$.MODULE$.equals(var2_2)) break block3;
                    if (!None$.MODULE$.equals(var3_3)) break block4;
                    v0 = new MiniSolrCloudCluster.Builder(this.numServers, this.solrHome()).withSolrXml(MiniSolrCloudCluster.DEFAULT_CLOUD_SOLR_XML).build();
                    break block5;
                }
                if (!(var3_3 instanceof Some)) break block3;
                securityJson = (Path)((Some)var3_3).value();
                v0 = new MiniSolrCloudCluster.Builder(this.numServers, this.solrHome()).withSolrXml(MiniSolrCloudCluster.DEFAULT_CLOUD_SOLR_XML).withSecurityJson(securityJson).build();
                break block5;
            }
            if (!(var2_2 instanceof Some)) ** GOTO lbl23
            zookeeper = (ZkTestServer)((Some)var2_2).value();
            if (None$.MODULE$.equals(var3_3)) {
                formatZkServer = false;
                v0 = new MiniSolrCloudCluster(this.numServers, this.solrHome(), MiniSolrCloudCluster.DEFAULT_CLOUD_SOLR_XML, new JettyConfig.Builder().build(), zookeeper, formatZkServer);
            } else {
                if (var3_3 instanceof Some) {
                    throw new IllegalArgumentException("This is not supported");
                }
lbl23:
                // 4 sources

                throw new MatchError((Object)var1_1);
            }
        }
        this.miniSolrCloudCluster = v0;
    }

    private final void start$$anonfun$3$$anonfun$1(String configName$1, Path confDir$1) {
        this.miniSolrCloudCluster.uploadConfigSet(confDir$1, configName$1);
    }

    private final CollectionAdminResponse $anonfun$1(SolrCollection coll$1, String collectionName$1, String configName$2) {
        return (CollectionAdminResponse)CollectionAdminRequest.createCollection((String)collectionName$1, (String)configName$2, (int)coll$1.shards(), (int)coll$1.replicas()).process((SolrClient)this.solrJClient());
    }

    private final void shutdown$$anonfun$2() {
        FileUtils.deleteDirectory((File)this.baseDir().toFile());
    }

    private static final Path $anonfun$2() {
        return Paths.get("./src/test/resources/solr", new String[0]).toAbsolutePath().normalize();
    }
}

