/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.ShardReplica;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import java.io.Serializable;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.cloud.Replica;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class ShardReplica$
implements Serializable {
    private static final Regex replicaTypePattern;
    public static final ShardReplica$ MODULE$;

    private ShardReplica$() {
    }

    static {
        MODULE$ = new ShardReplica$();
        replicaTypePattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(17).append("replica.type").append(":(").append(Replica.Type.NRT).append("|").append(Replica.Type.TLOG).append("|").append(Replica.Type.PULL).append(")").toString()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShardReplica$.class);
    }

    public ShardReplica apply(String baseUrl, Replica underlying) {
        Mirror.Singleton singleton;
        ShardReplica res = new ShardReplica(SolrServer$.MODULE$.fixUrl(baseUrl), underlying);
        Replica.State state = underlying.getState();
        Replica.State state2 = Replica.State.ACTIVE;
        Replica.State state3 = state;
        if (!(state2 != null ? !state2.equals(state3) : state3 != null)) {
            singleton = Enabled$.MODULE$;
        } else {
            Replica.State state4 = Replica.State.RECOVERING;
            Replica.State state5 = state;
            if (!(state4 != null ? !state4.equals(state5) : state5 != null)) {
                singleton = Disabled$.MODULE$;
            } else {
                Replica.State state6 = Replica.State.RECOVERY_FAILED;
                Replica.State state7 = state;
                if (!(state6 != null ? !state6.equals(state7) : state7 != null)) {
                    singleton = Failed$.MODULE$;
                } else {
                    Replica.State state8 = Replica.State.DOWN;
                    Replica.State state9 = state;
                    if (!(state8 != null ? !state8.equals(state9) : state9 != null)) {
                        singleton = Failed$.MODULE$;
                    } else {
                        throw new MatchError((Object)state);
                    }
                }
            }
        }
        res.status_$eq((ServerStatus)singleton);
        return res;
    }

    public Option<ShardReplica> findLeader(Iterable<SolrServer> servers) {
        return servers.collectFirst((PartialFunction)new Serializable(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(SolrServer x) {
                ShardReplica s;
                SolrServer solrServer = x;
                return solrServer instanceof ShardReplica && (s = (ShardReplica)solrServer).isLeader();
            }

            public final Object applyOrElse(SolrServer x, Function1 function1) {
                ShardReplica s;
                SolrServer solrServer = x;
                if (solrServer instanceof ShardReplica && (s = (ShardReplica)solrServer).isLeader()) {
                    return s;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public IndexedSeq<SolrServer> filterByShardPreference(SolrRequest<?> r, IndexedSeq<SolrServer> servers) {
        if (r.getParams() == null || r.getParams().get("shards.preference") == null) {
            return servers;
        }
        String string = r.getParams().get("shards.preference");
        String preference = string;
        if (preference.contains("replica.type") && this.hasShardReplicas(servers)) {
            Set replicaTypes = (Set)replicaTypePattern.findAllMatchIn((CharSequence)preference).foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Set res = (Set)tuple2._1();
                    Regex.Match m = (Regex.Match)tuple2._2();
                    return (Set)res.$plus((Object)Replica.Type.valueOf((String)m.group(1)));
                }
                throw new MatchError((Object)tuple2);
            });
            IndexedSeq preferredReplicas = (IndexedSeq)servers.collect((PartialFunction)new Serializable(replicaTypes){
                private final Set replicaTypes$1;
                {
                    this.replicaTypes$1 = replicaTypes$2;
                }

                public final boolean isDefinedAt(SolrServer x) {
                    ShardReplica s;
                    SolrServer solrServer = x;
                    return solrServer instanceof ShardReplica && this.replicaTypes$1.contains((Object)(s = (ShardReplica)solrServer).replicaType());
                }

                public final Object applyOrElse(SolrServer x, Function1 function1) {
                    ShardReplica s;
                    SolrServer solrServer = x;
                    if (solrServer instanceof ShardReplica && this.replicaTypes$1.contains((Object)(s = (ShardReplica)solrServer).replicaType())) {
                        return s;
                    }
                    return function1.apply((Object)x);
                }
            });
            if (preferredReplicas.nonEmpty()) {
                return preferredReplicas;
            }
            return servers;
        }
        return servers;
    }

    private boolean hasShardReplicas(IndexedSeq<SolrServer> servers) {
        return servers.nonEmpty() && servers.apply(0) instanceof ShardReplica;
    }
}

