/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.PingStatusObserver$;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StaticSolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.FutureFactory$;
import io.ino.solrs.future.Promise;
import io.ino.solrs.future.ScalaFutureFactory$;
import java.io.Serializable;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Success$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

public class PingStatusObserver<F>
implements ServerStateObserver<F> {
    private final SolrServers solrServers;
    private final AsyncHttpClient httpClient;
    private final FutureFactory<F> futureFactory;
    public final Logger io$ino$solrs$PingStatusObserver$$logger;

    public static <F> ScalaFutureFactory$ $lessinit$greater$default$3(Seq<SolrServer> seq, AsyncHttpClient asyncHttpClient) {
        return PingStatusObserver$.MODULE$.$lessinit$greater$default$3(seq, asyncHttpClient);
    }

    public PingStatusObserver(SolrServers solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this.solrServers = solrServers;
        this.httpClient = httpClient;
        this.futureFactory = futureFactory;
        this.io$ino$solrs$PingStatusObserver$$logger = LoggerFactory.getLogger(this.getClass());
    }

    public PingStatusObserver(Seq<SolrServer> solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this(new StaticSolrServers((IndexedSeq<SolrServer>)solrServers.toIndexedSeq()), httpClient, futureFactory);
    }

    @Override
    public Future<BoxedUnit> checkServerStatus() {
        Seq futures = (Seq)this.solrServers.all().map((Function1 & Serializable)server -> {
            String url = new StringBuilder(32).append(server.baseUrl()).append("/admin/ping?action=status&wt=xml").toString();
            Promise promise = this.futureFactory.newPromise();
            this.httpClient.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandler<Response>(server, url, promise, this){
                private final SolrServer server$1;
                private final String url$1;
                private final Promise promise$1;
                private final /* synthetic */ PingStatusObserver $outer;
                {
                    this.server$1 = server$2;
                    this.url$1 = url$2;
                    this.promise$1 = promise$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Response onCompleted(Response response) {
                    this.$outer.io$ino$solrs$PingStatusObserver$$updateServerStatus(this.server$1, response, this.url$1);
                    Success$.MODULE$.apply((Object)this.server$1.status());
                    this.promise$1.success(BoxedUnit.UNIT);
                    return response;
                }

                public void onThrowable(Throwable t) {
                    ServerStatus serverStatus = this.server$1.status();
                    Failed$ failed$ = Failed$.MODULE$;
                    if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                        this.$outer.io$ino$solrs$PingStatusObserver$$logger.error(new StringBuilder(82).append("An error occurred when trying to get ping status from ").append(this.url$1).append(", changing status to Failed.").toString(), t);
                        this.server$1.status_$eq(Failed$.MODULE$);
                    }
                    this.promise$1.failure(t);
                }
            });
            return promise.future();
        });
        return FutureFactory$.MODULE$.sequence(futures, BuildFrom$.MODULE$.buildFromIterableOps(), this.futureFactory).map((JProcedure1 & Serializable)_$4 -> {});
    }

    public void io$ino$solrs$PingStatusObserver$$updateServerStatus(SolrServer server, Response response, String url) {
        if (response.getStatusCode() != 200) {
            this.io$ino$solrs$PingStatusObserver$$logger.warn(new StringBuilder(58).append("Got ping response status != 200 (").append(response.getStatusCode()).append(") from ").append(url).append(", with response '").append(new String(response.getResponseBodyAsBytes())).append("'").toString());
            server.status_$eq(Failed$.MODULE$);
            return;
        }
        Elem xml = (Elem)XML$.MODULE$.load(response.getResponseBodyAsStream());
        Option option = xml.$bslash$bslash("response").$bslash("str").find((Function1 & Serializable)node -> {
            String string = node.$bslash("@name").text();
            String string2 = "status";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (None$.MODULE$.equals(option)) {
            ServerStatus serverStatus = server.status();
            Failed$ failed$ = Failed$.MODULE$;
            if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                this.io$ino$solrs$PingStatusObserver$$logger.warn(new StringBuilder(83).append("Could not find status in ping response from ").append(url).append(", changing status to Failed. Response:\n").append(xml).toString());
                server.status_$eq(Failed$.MODULE$);
                return;
            }
            return;
        }
        if (option instanceof Some) {
            Node statusNode = (Node)((Some)option).value();
            String string = statusNode.text();
            String string2 = "enabled";
            ServerStatus status = (ServerStatus)(!(string != null ? !string.equals(string2) : string2 != null) ? Enabled$.MODULE$ : Disabled$.MODULE$);
            ServerStatus serverStatus = server.status();
            ServerStatus serverStatus2 = status;
            if (serverStatus == null ? serverStatus2 != null : !serverStatus.equals(serverStatus2)) {
                this.io$ino$solrs$PingStatusObserver$$logger.info(new StringBuilder(38).append("Changing status for server ").append(server.baseUrl()).append(" from ").append(server.status()).append(" to ").append(status).append(".").toString());
                server.status_$eq(status);
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }
}

