/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.PerformanceStats$EvictingArray$;
import io.ino.solrs.SolrServer;
import io.ino.time.Clock;
import java.io.Serializable;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class PerformanceStats {
    private final SolrServer solrServer;
    private final long initialPredictedResponseTime;
    public final Clock io$ino$solrs$PerformanceStats$$clock;
    private final Logger logger;
    private final int currentRequestsSizeCheckLimit;
    private final long currentRequestsRemoveThreshold;
    private final Map<String, Tuple2<Object, Object>> emptyMap;
    private long lastCalculatedSecond;
    public final scala.collection.mutable.Map<String, NavigableSet<RequestHandle>> io$ino$solrs$PerformanceStats$$currentRequests;
    private final TrieMap<Object, Bucket> buckets;
    private final EvictingArray<Map<String, Tuple2<Object, Object>>> requestAveragesPerSecond;
    private final Map<String, Object>[] requestAveragesPer10Seconds;
    private final scala.collection.mutable.Map<String, Tuple2<Object, Object>> totalCountAndDuration;

    public PerformanceStats(SolrServer solrServer, long initialPredictedResponseTime, Clock clock) {
        this.solrServer = solrServer;
        this.initialPredictedResponseTime = initialPredictedResponseTime;
        this.io$ino$solrs$PerformanceStats$$clock = clock;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.currentRequestsSizeCheckLimit = 10000;
        this.currentRequestsRemoveThreshold = 10000L;
        this.emptyMap = Predef$.MODULE$.Map().empty();
        this.lastCalculatedSecond = -1L;
        this.io$ino$solrs$PerformanceStats$$currentRequests = TrieMap$.MODULE$.empty().withDefaultValue(new ConcurrentSkipListSet());
        this.buckets = TrieMap$.MODULE$.empty();
        this.requestAveragesPerSecond = PerformanceStats$EvictingArray$.MODULE$.fill(60, PerformanceStats::$init$$$anonfun$1, ClassTag$.MODULE$.apply(Map.class));
        this.requestAveragesPer10Seconds = (Map[])Array$.MODULE$.fill(6, PerformanceStats::$init$$$anonfun$2, ClassTag$.MODULE$.apply(Map.class));
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        this.totalCountAndDuration = TrieMap$.MODULE$.empty().withDefaultValue((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToLong((long)0L)));
    }

    public SolrServer solrServer() {
        return this.solrServer;
    }

    public int currentRequestsSizeCheckLimit() {
        return this.currentRequestsSizeCheckLimit;
    }

    public long currentRequestsRemoveThreshold() {
        return this.currentRequestsRemoveThreshold;
    }

    public NavigableSet<RequestHandle> io$ino$solrs$PerformanceStats$$currentRequestsFor(String queryClass) {
        return (NavigableSet)this.io$ino$solrs$PerformanceStats$$currentRequests.getOrElseUpdate((Object)queryClass, PerformanceStats::currentRequestsFor$$anonfun$1);
    }

    public Bucket io$ino$solrs$PerformanceStats$$bucket(long second) {
        return (Bucket)this.buckets.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)second), () -> PerformanceStats.bucket$$anonfun$1(second));
    }

    public RequestHandle requestStarted(String queryClass) {
        return new RequestHandle(queryClass, this){
            private final String queryClass$2;
            private final long startedAtMillis;
            private final /* synthetic */ PerformanceStats $outer;
            {
                this.queryClass$2 = queryClass$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.startedAtMillis = $outer.io$ino$solrs$PerformanceStats$$clock.millis();
                $outer.io$ino$solrs$PerformanceStats$$currentRequestsFor(queryClass$1).add(this);
            }

            public long startedAtMillis() {
                return this.startedAtMillis;
            }

            public void finished() {
                long finishedAtMillis = this.$outer.io$ino$solrs$PerformanceStats$$clock.millis();
                long finishedAtSecond = TimeUnit.MILLISECONDS.toSeconds(finishedAtMillis);
                this.$outer.io$ino$solrs$PerformanceStats$$bucket(finishedAtSecond).register().apply((Object)this.queryClass$2, (Object)BoxesRunTime.boxToLong((long)(finishedAtMillis - this.startedAtMillis())));
                ((Set)this.$outer.io$ino$solrs$PerformanceStats$$currentRequests.apply((Object)this.queryClass$2)).remove(this);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateStats() {
        NumericRange.Inclusive inclusive;
        long nowSecond = TimeUnit.MILLISECONDS.toSeconds(this.io$ino$solrs$PerformanceStats$$clock.millis());
        if (this.lastCalculatedSecond == -1L) {
            Option option = ((IterableOps)this.buckets.keys().toSeq().sorted((Ordering)Ordering.Long$.MODULE$)).headOption();
            if (option instanceof Some) {
                long second = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                inclusive = new RichLong(Predef$.MODULE$.longWrapper(second)).to((Object)BoxesRunTime.boxToLong((long)(nowSecond - 1L)));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                inclusive = (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
            }
        } else {
            inclusive = new RichLong(Predef$.MODULE$.longWrapper(this.lastCalculatedSecond + 1L)).to((Object)BoxesRunTime.boxToLong((long)(nowSecond - 1L)));
        }
        NumericRange.Inclusive seconds = inclusive;
        this.updateSecondsFromBuckets((IndexedSeq<Object>)seconds);
        this.lastCalculatedSecond = nowSecond - 1L;
        this.update10SecondAverages();
        this.io$ino$solrs$PerformanceStats$$currentRequests.values().foreach((Function1)(JProcedure1 & Serializable)requests -> {
            if (requests.size() > this.currentRequestsSizeCheckLimit()) {
                scala.collection.mutable.Set requestsToRemove = (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((Set)requests).asScala().filter((Function1 & Serializable)_$1 -> _$1.startedAtMillis() > this.currentRequestsRemoveThreshold());
                this.logger.warn(new java.lang.StringBuilder(63).append("Current requests exceed limit ").append(this.currentRequestsSizeCheckLimit()).append(", removing ").append(requestsToRemove.size()).append(" requests for cleanup.").toString());
                requestsToRemove.foreach((Function1 & Serializable)entry -> requests.remove(entry));
                return;
            }
        });
    }

    private void update10SecondAverages() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.requestAveragesPerSecond.values());
        Map[] allAverages = (Map[])ArrayOps$.MODULE$.reverse$extension(object);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            int from = idx * 10;
            int until = from + 10;
            Object object = Predef$.MODULE$.refArrayOps((Object[])allAverages);
            Object[] averages = (Map[])ArrayOps$.MODULE$.slice$extension(object, from, until);
            Object object2 = Predef$.MODULE$.refArrayOps(averages);
            Map countsAndDurationsByQueryClass = (Map)ArrayOps$.MODULE$.foldLeft$extension(object2, (Object)this.emptyMap.withDefault((Function1 & Serializable)queryClass -> {
                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToLong((long)0L));
            }), (Function2 & Serializable)(x$12, x$22) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$22);
                if (tuple2 != null) {
                    Map res = (Map)tuple2._1();
                    Map averagesForSecond = (Map)tuple2._2();
                    if (averagesForSecond.isEmpty()) {
                        return res;
                    }
                    return (Map)averagesForSecond.foldLeft((Object)res, (Function2 & Serializable)(x$1, x$2) -> {
                        Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            Map res2 = (Map)tuple2._1();
                            if (tuple22 != null) {
                                Tuple2 tuple23 = (Tuple2)tuple22._2();
                                String queryClass = (String)tuple22._1();
                                if (tuple23 != null) {
                                    int countForSecond = BoxesRunTime.unboxToInt((Object)tuple23._1());
                                    long averageForSecond = BoxesRunTime.unboxToLong((Object)tuple23._2());
                                    Tuple2 tuple24 = (Tuple2)res2.apply((Object)queryClass);
                                    if (tuple24 == null) {
                                        throw new MatchError((Object)tuple24);
                                    }
                                    int count = BoxesRunTime.unboxToInt((Object)tuple24._1());
                                    long durations = BoxesRunTime.unboxToLong((Object)tuple24._2());
                                    Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(count, durations);
                                    int count2 = sp2._1$mcI$sp();
                                    long durations2 = sp2._2$mcJ$sp();
                                    Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(count2 + countForSecond)));
                                    Map x = (Map)res2.updated((Object)queryClass, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToLong((long)(durations2 + (long)countForSecond * averageForSecond))));
                                    return x;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            this.requestAveragesPer10Seconds[idx] = ((IterableOnceOps)countsAndDurationsByQueryClass.toSeq().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String queryClass = (String)tuple2._1();
                    if (tuple22 != null) {
                        int count = BoxesRunTime.unboxToInt((Object)tuple22._1());
                        long durationSum = BoxesRunTime.unboxToLong((Object)tuple22._2());
                        return Tuple2$.MODULE$.apply((Object)queryClass, (Object)BoxesRunTime.boxToLong((long)(durationSum / (long)count)));
                    }
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        });
    }

    private void updateSecondsFromBuckets(IndexedSeq<Object> seconds) {
        seconds.foreach((Function1 & Serializable)second -> this.updateSecondsFromBuckets$$anonfun$1(BoxesRunTime.unboxToLong((Object)second)));
    }

    public Option<Object> averageDurationForSecond(String queryClass, int relativeSecond) {
        return ((MapOps)this.requestAveragesPerSecond.lastUpdate(relativeSecond)).get((Object)queryClass).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int count = BoxesRunTime.unboxToInt((Object)tuple2._1());
                long duration = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return duration;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void dumpStats(String queryClass) {
        StringBuilder sb = new StringBuilder();
        sb.append(new java.lang.StringBuilder(50).append("====== stats for [").append(this.solrServer().baseUrl()).append("][queryClass ").append(queryClass).append("] at ").append(this.io$ino$solrs$PerformanceStats$$clock.millis()).append(" millis ======").toString());
        CollectionConverters$.MODULE$.SetHasAsScala((Set)this.io$ino$solrs$PerformanceStats$$currentRequests.apply((Object)queryClass)).asScala().foreach((Function1 & Serializable)req -> sb.append(new java.lang.StringBuilder(18).append("\n[currentRequest] ").append(req).toString()));
        this.buckets.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long sec = BoxesRunTime.unboxToLong((Object)tuple2._1());
                Bucket bucket = (Bucket)tuple2._2();
                ((Option)bucket.averageDuration().apply((Object)queryClass)).foreach((Function1 & Serializable)duration -> sb.append(new java.lang.StringBuilder(16).append("\n[bucket(sec ").append(sec).append(")] ").append(BoxesRunTime.unboxToLong((Object)duration)).toString()));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.requestAveragesPer10Seconds);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Map queryClassAndDuratin = (Map)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                queryClassAndDuratin.get((Object)queryClass).foreach((Function1 & Serializable)duration -> sb.append(new java.lang.StringBuilder(18).append("\n[10seconds(").append(idx * 10).append(" - ").append((idx + 1) * 10).append(")] ").append(BoxesRunTime.unboxToLong((Object)duration)).toString()));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.logger.info(sb.toString());
        this.logger.info(new java.lang.StringBuilder(47).append("\n====== END OF stats for [").append(this.solrServer().baseUrl()).append("][queryClass ").append(queryClass).append("] ======").toString());
    }

    public Option<Object> averageDurationFor10Seconds(String queryClass, int relativeTenSeconds) {
        return this.requestAveragesPer10Seconds[scala.math.package$.MODULE$.abs(relativeTenSeconds)].get((Object)queryClass);
    }

    public long totalAverageDuration(String queryClass, long defaultValue) {
        Tuple2 tuple2 = (Tuple2)this.totalCountAndDuration.apply((Object)queryClass);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int count = BoxesRunTime.unboxToInt((Object)tuple2._1());
        long duration = BoxesRunTime.unboxToLong((Object)tuple2._2());
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(count, duration);
        int count2 = sp2._1$mcI$sp();
        long duration2 = sp2._2$mcJ$sp();
        if (count2 == 0) {
            return defaultValue;
        }
        return duration2 / (long)count2;
    }

    public long predictDuration(String queryClass) {
        long millis = this.io$ino$solrs$PerformanceStats$$clock.millis();
        long currentSecond = TimeUnit.MILLISECONDS.toSeconds(millis);
        long finishedRequestsAverage = BoxesRunTime.unboxToLong((Object)this.buckets.get((Object)BoxesRunTime.boxToLong((long)currentSecond)).flatMap((Function1 & Serializable)currentSecondBucket -> (Option)currentSecondBucket.averageDuration().apply((Object)queryClass)).getOrElse(() -> this.$anonfun$5(queryClass)));
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(((NavigableSet)this.io$ino$solrs$PerformanceStats$$currentRequests.apply((Object)queryClass)).pollFirst()).flatMap((Function1 & Serializable)oldestRunningRequest -> {
            if (millis - oldestRunningRequest.startedAtMillis() > finishedRequestsAverage) {
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(millis - oldestRunningRequest.startedAtMillis())));
            }
            return None$.MODULE$;
        }).getOrElse(() -> PerformanceStats.predictDuration$$anonfun$2(finishedRequestsAverage)));
    }

    private void updateTotalCountAndDuration(Map<String, Tuple2<Object, Object>> measurements) {
        measurements.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                String queryClass = (String)tuple2._1();
                if (tuple22 != null) {
                    int count = BoxesRunTime.unboxToInt((Object)tuple22._1());
                    long duration = BoxesRunTime.unboxToLong((Object)tuple22._2());
                    Tuple2 tuple23 = (Tuple2)this.totalCountAndDuration.apply((Object)queryClass);
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    int oldCount = BoxesRunTime.unboxToInt((Object)tuple23._1());
                    long oldDuration = BoxesRunTime.unboxToLong((Object)tuple23._2());
                    Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(oldCount, oldDuration);
                    int oldCount2 = sp2._1$mcI$sp();
                    long oldDuration2 = sp2._2$mcJ$sp();
                    Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(oldCount2 + count)));
                    this.totalCountAndDuration.update((Object)queryClass, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToLong((long)(oldDuration2 + (long)count * duration))));
                    return;
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Map $init$$$anonfun$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final Map $init$$$anonfun$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final NavigableSet currentRequestsFor$$anonfun$1() {
        return new ConcurrentSkipListSet();
    }

    private static final Bucket bucket$$anonfun$1(long second$1) {
        return new Bucket(second$1);
    }

    private final /* synthetic */ Option updateSecondsFromBuckets$$anonfun$1(long second) {
        Option option = this.buckets.get((Object)BoxesRunTime.boxToLong((long)second));
        if (option instanceof Some) {
            Bucket bucket = (Bucket)((Some)option).value();
            Map<String, Tuple2<Object, Object>> averageDurations = bucket.averageDurations();
            this.requestAveragesPerSecond.add(averageDurations);
            this.updateTotalCountAndDuration(averageDurations);
            return this.buckets.remove((Object)BoxesRunTime.boxToLong((long)second));
        }
        if (None$.MODULE$.equals(option)) {
            return this.requestAveragesPerSecond.add(this.emptyMap);
        }
        throw new MatchError((Object)option);
    }

    private final long $anonfun$5$$anonfun$1$$anonfun$1(String queryClass$8) {
        return this.totalAverageDuration(queryClass$8, this.initialPredictedResponseTime);
    }

    private final long $anonfun$5$$anonfun$1(String queryClass$7) {
        return BoxesRunTime.unboxToLong((Object)this.averageDurationFor10Seconds(queryClass$7, 0).getOrElse(() -> this.$anonfun$5$$anonfun$1$$anonfun$1(queryClass$7)));
    }

    private final long $anonfun$5(String queryClass$6) {
        return BoxesRunTime.unboxToLong((Object)this.averageDurationForSecond(queryClass$6, 0).getOrElse(() -> this.$anonfun$5$$anonfun$1(queryClass$6)));
    }

    private static final long predictDuration$$anonfun$2(long finishedRequestsAverage$2) {
        return finishedRequestsAverage$2;
    }

    public static class Bucket {
        private final CountsAndDurations serverStats = new CountsAndDurations();
        private final Function2 register = (Function2 & Serializable)(v1, v2) -> {
            this.$init$$$anonfun$3((String)v1, BoxesRunTime.unboxToLong((Object)v2));
            return BoxedUnit.UNIT;
        };

        public Bucket(long forSecond) {
        }

        public Function2<String, Object, BoxedUnit> register() {
            return this.register;
        }

        public Map<String, Tuple2<Object, Object>> averageDurations() {
            return this.serverStats.averageCountsAndDurations();
        }

        public Function1<String, Option<Object>> averageDuration() {
            return (Function1 & Serializable)queryClass -> this.serverStats.averageDuration((String)queryClass);
        }

        private final /* synthetic */ void $init$$$anonfun$3(String queryClass, long durationInMillis) {
            this.serverStats.record(queryClass, durationInMillis);
        }
    }

    public static class CountsAndDurations {
        private final scala.collection.mutable.Map<String, Object> requestCounts = TrieMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        private final scala.collection.mutable.Map<String, Object> requestDurationsInMillis = TrieMap$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));

        public Option<Object> averageDuration(String queryClass) {
            int count = BoxesRunTime.unboxToInt((Object)this.requestCounts.apply((Object)queryClass));
            if (count == 0) {
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.requestDurationsInMillis.apply((Object)queryClass)) / (long)count)));
        }

        public Map<String, Tuple2<Object, Object>> averageCountsAndDurations() {
            return this.requestCounts.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String queryClass = (String)tuple2._1();
                    int count = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)count));
                    return Tuple2$.MODULE$.apply((Object)queryClass, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.requestDurationsInMillis.apply((Object)queryClass)) / (long)count))));
                }
                throw new MatchError((Object)tuple2);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public void record(String queryClass, long durationInMillis) {
            this.requestCounts.update((Object)queryClass, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.requestCounts.apply((Object)queryClass)) + 1)));
            this.requestDurationsInMillis.update((Object)queryClass, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.requestDurationsInMillis.apply((Object)queryClass)) + durationInMillis)));
        }

        public void recordAll(Map<String, Object> records) {
            records.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String queryClass = (String)tuple2._1();
                    long duration = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    this.record(queryClass, duration);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public static class EvictingArray<T> {
        private final Object _values;
        private final ClassTag<T> evidence$1;
        private final int size;
        private int length;
        private int pos;

        public static <T> EvictingArray<T> fill(int n, Function0<T> function0, ClassTag<T> classTag) {
            return PerformanceStats$EvictingArray$.MODULE$.fill(n, function0, classTag);
        }

        public EvictingArray(Object _values, ClassTag<T> evidence$1) {
            this._values = _values;
            this.evidence$1 = evidence$1;
            this.size = ScalaRunTime$.MODULE$.array_length(_values);
            this.length = 0;
            this.pos = 0;
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public Object values() {
            if (this.length < this.size) {
                Object object = Predef$.MODULE$.genericArrayOps(this._values);
                return ArrayOps$.MODULE$.take$extension(object, this.length);
            }
            Object object = Predef$.MODULE$.genericArrayOps(this._values);
            Tuple2 tuple2 = ArrayOps$.MODULE$.splitAt$extension(object, this.pos);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object a = tuple2._1();
            Object b = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(a, b);
            Object a2 = tuple22._1();
            Object b2 = tuple22._2();
            Object object2 = Predef$.MODULE$.genericArrayOps(b2);
            Object object3 = Predef$.MODULE$.genericArrayOps(ArrayOps$.MODULE$.$plus$plus$extension(object2, a2, this.evidence$1));
            return ArrayOps$.MODULE$.take$extension(object3, this.length);
        }

        public Option<T> add(T value) {
            None$ res = this.length == this.size ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(this._values, this.pos)) : None$.MODULE$;
            ScalaRunTime$.MODULE$.array_update(this._values, this.pos, value);
            this.pos = this.pos == this.size - 1 ? 0 : ++this.pos;
            if (this.length < this.size) {
                ++this.length;
            }
            return res;
        }

        public int lastUpdatePos() {
            if (this.length == 0) {
                return -1;
            }
            if (this.pos == 0) {
                return this.size - 1;
            }
            return this.pos - 1;
        }

        public T lastUpdate(int relative) {
            if (relative > 0) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"the relative update must be <= 0");
            }
            if (scala.math.package$.MODULE$.abs(relative) > this.length) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(45).append("Not enough updates (").append(this.length).append(") for requested relative ").append(relative).toString());
            }
            int position = this.pos - 1 + relative;
            return (T)ScalaRunTime$.MODULE$.array_apply(this._values, position < 0 ? this.size + position : position);
        }

        public T apply(int index) throws IndexOutOfBoundsException {
            if (index >= this.length) {
                throw new IndexOutOfBoundsException(new java.lang.StringBuilder(25).append("Maximum index ").append(this.length - 1).append(" exceeded: ").append(index).toString());
            }
            if (this.length < this.size) {
                return (T)ScalaRunTime$.MODULE$.array_apply(this._values, index);
            }
            int d = this.pos + index;
            if (d >= this.size) {
                return (T)ScalaRunTime$.MODULE$.array_apply(this._values, d - this.size);
            }
            return (T)ScalaRunTime$.MODULE$.array_apply(this._values, d);
        }
    }

    public static interface RequestHandle
    extends Comparable<RequestHandle> {
        public long startedAtMillis();

        public void finished();

        public static int compareTo$(RequestHandle $this, RequestHandle o) {
            return $this.compareTo(o);
        }

        @Override
        default public int compareTo(RequestHandle o) {
            return (int)(this.startedAtMillis() - o.startedAtMillis());
        }

        public static String toString$(RequestHandle $this) {
            return $this.toString();
        }

        default public String toString() {
            return new java.lang.StringBuilder(25).append("RequestHandle[startedAt=").append(this.startedAtMillis()).append("]").toString();
        }
    }
}

