/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.AsyncSolrClient$Builder$;
import io.ino.solrs.AsyncSolrClientAware;
import io.ino.solrs.HttpUtils$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.MapConverter;
import io.ino.solrs.Metrics;
import io.ino.solrs.NoopMetrics$;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestContext;
import io.ino.solrs.RequestContext$;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RetryDecision;
import io.ino.solrs.RetryDecision$Result$Fail$;
import io.ino.solrs.RetryDecision$Result$Retry$;
import io.ino.solrs.RetryPolicy;
import io.ino.solrs.RetryServer;
import io.ino.solrs.RetryServer$;
import io.ino.solrs.ServerStateObservation;
import io.ino.solrs.ServerStateObservation$;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrServer;
import io.ino.solrs.StandardRetryDecision;
import io.ino.solrs.StandardRetryDecision$;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.Promise;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Function9;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class AsyncSolrClient<F> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AsyncSolrClient.class.getDeclaredField("binder$lzy1"));
    private final LoadBalancer loadBalancer;
    private final AsyncHttpClient httpClient;
    private final boolean shutdownHttpClient;
    private final Option<RequestInterceptor> requestInterceptor;
    private final RequestWriter requestWriter;
    private final ResponseParser responseParser;
    public final Metrics io$ino$solrs$AsyncSolrClient$$metrics;
    public final RetryPolicy io$ino$solrs$AsyncSolrClient$$retryPolicy;
    public final FutureFactory<F> io$ino$solrs$AsyncSolrClient$$futureFactory;
    private final String DEFAULT_PATH;
    private final String agent;
    public final Logger io$ino$solrs$AsyncSolrClient$$logger;
    private final Option<ScheduledFuture<?>> cancellableObservation;
    private volatile Object binder$lzy1;

    public static <F> AsyncSolrClient<F> apply(LoadBalancer loadBalancer, FutureFactory<F> futureFactory) {
        return AsyncSolrClient$.MODULE$.apply(loadBalancer, futureFactory);
    }

    public static <F> AsyncSolrClient<F> apply(String string, FutureFactory<F> futureFactory) {
        return AsyncSolrClient$.MODULE$.apply(string, futureFactory);
    }

    public static <F> AsyncSolrClient<F> ascFactory(LoadBalancer loadBalancer, AsyncHttpClient asyncHttpClient, boolean bl, Option<RequestInterceptor> option, RequestWriter requestWriter, ResponseParser responseParser, Metrics metrics, Option<ServerStateObservation<F>> option2, RetryPolicy retryPolicy, FutureFactory<F> futureFactory) {
        return AsyncSolrClient$.MODULE$.ascFactory(loadBalancer, asyncHttpClient, bl, option, requestWriter, responseParser, metrics, option2, retryPolicy, futureFactory);
    }

    public AsyncSolrClient(LoadBalancer loadBalancer, AsyncHttpClient httpClient, boolean shutdownHttpClient, Option<RequestInterceptor> requestInterceptor, RequestWriter requestWriter, ResponseParser responseParser, Metrics metrics, Option<ServerStateObservation<F>> serverStateObservation, RetryPolicy retryPolicy, FutureFactory<F> futureFactory) {
        this.loadBalancer = loadBalancer;
        this.httpClient = httpClient;
        this.shutdownHttpClient = shutdownHttpClient;
        this.requestInterceptor = requestInterceptor;
        this.requestWriter = requestWriter;
        this.responseParser = responseParser;
        this.io$ino$solrs$AsyncSolrClient$$metrics = metrics;
        this.io$ino$solrs$AsyncSolrClient$$retryPolicy = retryPolicy;
        this.io$ino$solrs$AsyncSolrClient$$futureFactory = futureFactory;
        String UTF_8 = "UTF-8";
        this.DEFAULT_PATH = "/select";
        this.agent = new java.lang.StringBuilder(10).append("Solr[").append(AsyncSolrClient.class.getName()).append("] 1.0").toString();
        this.io$ino$solrs$AsyncSolrClient$$logger = LoggerFactory.getLogger(this.getClass());
        this.cancellableObservation = serverStateObservation.map((Function1 & Serializable)observation -> {
            Runnable task = new Runnable((ServerStateObservation)observation){
                private final ServerStateObservation observation$1;
                {
                    this.observation$1 = observation$2;
                }

                public void run() {
                    this.observation$1.serverStateObserver().checkServerStatus();
                }
            };
            return observation.executorService().scheduleWithFixedDelay(task, 0L, observation.checkInterval().toMillis(), TimeUnit.MILLISECONDS);
        });
    }

    public LoadBalancer loadBalancer() {
        return this.loadBalancer;
    }

    private DocumentObjectBinder binder() {
        Object object = this.binder$lzy1;
        if (object instanceof DocumentObjectBinder) {
            return (DocumentObjectBinder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DocumentObjectBinder)this.binder$lzyINIT1();
    }

    private Object binder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.binder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DocumentObjectBinder documentObjectBinder = null;
                    try {
                        documentObjectBinder = new DocumentObjectBinder();
                        object2 = documentObjectBinder == null ? LazyVals.NullValue$.MODULE$ : documentObjectBinder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.binder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return documentObjectBinder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String sanitize(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            return baseUrl.substring(0, baseUrl.length() - 1);
        }
        if (baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException(new java.lang.StringBuilder(71).append("Invalid base url for solrj.  The base URL must not contain parameters: ").append(baseUrl).toString());
        }
        return baseUrl;
    }

    private UpdateRequest updateRequest(Option<String> collection, int commitWithinMs) {
        UpdateRequest req = new UpdateRequest();
        collection.foreach((Function1)(JProcedure1 & Serializable)_$9 -> req.setParam("collection", _$9));
        req.setCommitWithin(commitWithinMs);
        return req;
    }

    private int updateRequest$default$2() {
        return -1;
    }

    private ModifiableSolrParams queryParams(Option<String> collection, Option<SolrParams> q) {
        ModifiableSolrParams reqParams = new ModifiableSolrParams((SolrParams)q.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        collection.foreach((Function1 & Serializable)_$10 -> reqParams.set("collection", new String[]{_$10}));
        return reqParams;
    }

    public void shutdown() {
        this.cancellableObservation.foreach((Function1 & Serializable)_$11 -> _$11.cancel(true));
        if (this.shutdownHttpClient) {
            this.httpClient.close();
        }
        this.loadBalancer().shutdown();
    }

    public <T extends SolrResponse> F execute(SolrRequest<? extends T> r, SolrResponseFactory<T> evidence$1) {
        return (F)this.io$ino$solrs$AsyncSolrClient$$futureFactory.toBase().apply(this.io$ino$solrs$AsyncSolrClient$$loadBalanceRequest(RequestContext$.MODULE$.apply(r, RequestContext$.MODULE$.$lessinit$greater$default$2(), RequestContext$.MODULE$.$lessinit$greater$default$3()), evidence$1).map((Function1 & Serializable)_$12 -> (SolrResponse)_$12._1()));
    }

    public <T extends SolrResponse> F executePreferred(SolrRequest<? extends T> r, Option<SolrServer> preferred, SolrResponseFactory<T> evidence$2) {
        return (F)this.io$ino$solrs$AsyncSolrClient$$futureFactory.toBase().apply(this.io$ino$solrs$AsyncSolrClient$$loadBalanceRequest(RequestContext$.MODULE$.apply(r, preferred, RequestContext$.MODULE$.$lessinit$greater$default$3()), evidence$2));
    }

    public F addDocs(Option<String> collection, Iterable<SolrInputDocument> docs, int commitWithinMs) {
        return this.execute((SolrRequest)this.updateRequest(collection, commitWithinMs).add(CollectionConverters$.MODULE$.IterableHasAsJava(docs).asJavaCollection()), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> addDocs$default$1() {
        return None$.MODULE$;
    }

    public int addDocs$default$3() {
        return -1;
    }

    public F addDocs(String collection, Iterator<SolrInputDocument> docIterator) {
        UpdateRequest req = this.updateRequest((Option<String>)Some$.MODULE$.apply((Object)collection), this.updateRequest$default$2());
        req.setDocIterator(CollectionConverters$.MODULE$.IteratorHasAsJava(docIterator).asJava());
        return this.execute((SolrRequest)req, SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public F addDocs(Iterator<SolrInputDocument> docIterator) {
        UpdateRequest req = this.updateRequest((Option<String>)None$.MODULE$, this.updateRequest$default$2());
        req.setDocIterator(CollectionConverters$.MODULE$.IteratorHasAsJava(docIterator).asJava());
        return this.execute((SolrRequest)req, SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public F addDoc(Option<String> collection, SolrInputDocument doc, int commitWithinMs) {
        return this.execute((SolrRequest)this.updateRequest(collection, commitWithinMs).add(doc), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> addDoc$default$1() {
        return None$.MODULE$;
    }

    public int addDoc$default$3() {
        return -1;
    }

    public F addBean(Option<String> collection, Object obj, int commitWithinMs) {
        return this.addDoc(collection, this.binder().toSolrInputDocument(obj), commitWithinMs);
    }

    public Option<String> addBean$default$1() {
        return None$.MODULE$;
    }

    public int addBean$default$3() {
        return -1;
    }

    public F addBeans(Option<String> collection, Iterable<?> beans, int commitWithinMs) {
        return this.addDocs(collection, (Iterable<SolrInputDocument>)((Iterable)beans.map((Function1 & Serializable)x$0 -> this.binder().toSolrInputDocument(x$0))), commitWithinMs);
    }

    public Option<String> addBeans$default$1() {
        return None$.MODULE$;
    }

    public int addBeans$default$3() {
        return -1;
    }

    public F addBeans(String collection, Iterator<?> beanIterator) {
        return this.addDocs(collection, (Iterator<SolrInputDocument>)beanIterator.map((Function1 & Serializable)x$0 -> this.binder().toSolrInputDocument(x$0)));
    }

    public F addBeans(Iterator<?> beanIterator) {
        return this.addDocs((Iterator<SolrInputDocument>)beanIterator.map((Function1 & Serializable)x$0 -> this.binder().toSolrInputDocument(x$0)));
    }

    public F commit(Option<String> collection, boolean waitFlush, boolean waitSearcher, boolean softCommit) {
        return this.execute((SolrRequest)this.updateRequest(collection, this.updateRequest$default$2()).setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher, softCommit), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> commit$default$1() {
        return None$.MODULE$;
    }

    public boolean commit$default$2() {
        return true;
    }

    public boolean commit$default$3() {
        return true;
    }

    public boolean commit$default$4() {
        return false;
    }

    public F optimize(Option<String> collection, boolean waitFlush, boolean waitSearcher, int maxSegments) {
        return this.execute((SolrRequest)this.updateRequest(collection, this.updateRequest$default$2()).setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, waitFlush, waitSearcher, maxSegments), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> optimize$default$1() {
        return None$.MODULE$;
    }

    public boolean optimize$default$2() {
        return true;
    }

    public boolean optimize$default$3() {
        return true;
    }

    public int optimize$default$4() {
        return 1;
    }

    public F rollback(Option<String> collection) {
        return this.execute((SolrRequest)this.updateRequest(collection, this.updateRequest$default$2()).rollback(), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> rollback$default$1() {
        return None$.MODULE$;
    }

    public F deleteById(Option<String> collection, String id, int commitWithinMs) {
        return this.execute((SolrRequest)this.updateRequest(collection, commitWithinMs).deleteById(id), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> deleteById$default$1() {
        return None$.MODULE$;
    }

    public int deleteById$default$3() {
        return -1;
    }

    public F deleteByIds(Option<String> collection, Seq<String> ids, int commitWithinMs) {
        return this.execute((SolrRequest)this.updateRequest(collection, commitWithinMs).deleteById(CollectionConverters$.MODULE$.SeqHasAsJava(ids).asJava()), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> deleteByIds$default$1() {
        return None$.MODULE$;
    }

    public int deleteByIds$default$3() {
        return -1;
    }

    public F deleteByQuery(Option<String> collection, String query, int commitWithinMs) {
        return this.execute((SolrRequest)this.updateRequest(collection, commitWithinMs).deleteByQuery(query), SolrResponseFactory$.MODULE$.updateResponseFactory());
    }

    public Option<String> deleteByQuery$default$1() {
        return None$.MODULE$;
    }

    public int deleteByQuery$default$3() {
        return -1;
    }

    public F ping() {
        return this.execute((SolrRequest)new SolrPing(), SolrResponseFactory$.MODULE$.pingResponseFactory());
    }

    public F query(SolrParams q) {
        return this.query(q, SolrRequest.METHOD.GET);
    }

    public F query(SolrParams q, SolrRequest.METHOD method) {
        return this.execute((SolrRequest)new QueryRequest(q, method), SolrResponseFactory$.MODULE$.queryResponseFactory());
    }

    public F query(String collection, SolrParams q, SolrRequest.METHOD method) {
        return this.execute((SolrRequest)new QueryRequest((SolrParams)this.queryParams((Option<String>)Some$.MODULE$.apply((Object)collection), (Option<SolrParams>)Some$.MODULE$.apply((Object)q)), method), SolrResponseFactory$.MODULE$.queryResponseFactory());
    }

    public SolrRequest.METHOD query$default$3() {
        return SolrRequest.METHOD.GET;
    }

    public F queryAndStreamResponse(Option<String> collection, SolrParams q, StreamingResponseCallback callback) {
        StreamingBinaryResponseParser parser = new StreamingBinaryResponseParser(callback);
        QueryRequest req = new QueryRequest((SolrParams)this.queryParams(collection, (Option<SolrParams>)Some$.MODULE$.apply((Object)q)));
        req.setStreamingResponseCallback(callback);
        req.setResponseParser((ResponseParser)parser);
        return this.execute((SolrRequest)req, SolrResponseFactory$.MODULE$.queryResponseFactory());
    }

    public Option<String> queryAndStreamResponse$default$1() {
        return None$.MODULE$;
    }

    public F getById(Option<String> collection, String id, Option<SolrParams> params) {
        return (F)this.io$ino$solrs$AsyncSolrClient$$futureFactory.toBase().apply(this.doGetByIds(collection, (Iterable<String>)((Iterable)scala.package$.MODULE$.Iterable().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{id}))), params).map((Function1 & Serializable)_$13 -> CollectionConverters$.MODULE$.ListHasAsScala((List)_$13).asScala().headOption()));
    }

    public Option<String> getById$default$1() {
        return None$.MODULE$;
    }

    public Option<SolrParams> getById$default$3() {
        return None$.MODULE$;
    }

    public F getByIds(Option<String> collection, Iterable<String> ids, Option<SolrParams> params) {
        return (F)this.io$ino$solrs$AsyncSolrClient$$futureFactory.toBase().apply(this.doGetByIds(collection, ids, params));
    }

    public Option<String> getByIds$default$1() {
        return None$.MODULE$;
    }

    public Option<SolrParams> getByIds$default$3() {
        return None$.MODULE$;
    }

    public F queryPreferred(SolrQuery q, Option<SolrServer> preferred) {
        return this.executePreferred((SolrRequest)new QueryRequest((SolrParams)q), preferred, SolrResponseFactory$.MODULE$.queryResponseFactory());
    }

    private Future<SolrDocumentList> doGetByIds(Option<String> collection, Iterable<String> ids, Option<SolrParams> params) {
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("Must provide an identifier of a document to retrieve.");
        }
        ModifiableSolrParams reqParams = this.queryParams(collection, params);
        if (this.isEmpty(reqParams.get("qt"))) {
            reqParams.set("qt", new String[]{"/get"});
        }
        reqParams.set("ids", (String[])ids.toArray(ClassTag$.MODULE$.apply(String.class)));
        return this.io$ino$solrs$AsyncSolrClient$$loadBalanceRequest(RequestContext$.MODULE$.apply(new QueryRequest((SolrParams)reqParams), RequestContext$.MODULE$.$lessinit$greater$default$2(), RequestContext$.MODULE$.$lessinit$greater$default$3()), SolrResponseFactory$.MODULE$.queryResponseFactory()).map((Function1 & Serializable)_$14 -> (QueryResponse)_$14._1()).map((Function1 & Serializable)_$15 -> _$15.getResults());
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public <T extends SolrResponse> Future<Tuple2<T, SolrServer>> io$ino$solrs$AsyncSolrClient$$loadBalanceRequest(RequestContext<T> requestContext, SolrResponseFactory<T> evidence$3) {
        Try<SolrServer> try_ = this.loadBalancer().solrServer(requestContext.r(), requestContext.preferred());
        if (try_ instanceof Success) {
            SolrServer solrServer = (SolrServer)((Success)try_).value();
            return this.io$ino$solrs$AsyncSolrClient$$executeWithRetries(solrServer, requestContext, evidence$3);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            String msg = requestContext.failedRequests().isEmpty() ? new java.lang.StringBuilder(27).append("No solr server available: ").append(ex.getMessage()).append(".").toString() : new java.lang.StringBuilder(58).append("No next solr server available: ").append(ex.getMessage()).append(". These requests failed:\n- ").append(requestContext.failedRequests().mkString("\n- ")).toString();
            return this.io$ino$solrs$AsyncSolrClient$$futureFactory.failed((Throwable)new SolrServerException(msg, ex));
        }
        throw new MatchError(try_);
    }

    public <T extends SolrResponse> Future<Tuple2<T, SolrServer>> io$ino$solrs$AsyncSolrClient$$executeWithRetries(SolrServer server, RequestContext<T> requestContext, SolrResponseFactory<T> evidence$4) {
        long start = System.currentTimeMillis();
        return this.execute(server, requestContext.r(), evidence$4).map((Function1 & Serializable)_$16 -> {
            SolrResponse solrResponse = (SolrResponse)Predef$.MODULE$.ArrowAssoc(_$16);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)solrResponse, (Object)server);
        }).handleWith(new Serializable(server, requestContext, evidence$4, start, this){
            private final SolrServer server$2;
            private final RequestContext requestContext$1;
            private final SolrResponseFactory evidence$4$1;
            private final long start$1;
            private final /* synthetic */ AsyncSolrClient $outer;
            {
                this.server$2 = server$4;
                this.requestContext$1 = requestContext$2;
                this.evidence$4$1 = evidence$4$2;
                this.start$1 = start$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = (Throwable)option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Throwable throwable = x;
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    RequestContext<T> updatedContext;
                    Throwable throwable2 = (Throwable)option.get();
                    Throwable e = throwable2;
                    RetryDecision retryDecision = this.$outer.io$ino$solrs$AsyncSolrClient$$retryPolicy.shouldRetry(e, this.server$2, updatedContext = this.requestContext$1.failedRequest(this.server$2, (Duration)new package.DurationLong(package$.MODULE$.DurationLong(System.currentTimeMillis() - this.start$1)).millis(), e), this.$outer.loadBalancer());
                    if (retryDecision instanceof RetryServer) {
                        SolrServer solrServer;
                        RetryServer retryServer = RetryServer$.MODULE$.unapply((RetryServer)retryDecision);
                        SolrServer s = solrServer = retryServer._1();
                        this.$outer.io$ino$solrs$AsyncSolrClient$$logger.warn(new java.lang.StringBuilder(64).append("Request failed for server ").append(this.server$2).append(", trying next server ").append(s).append(". Exception was: ").append(e).toString());
                        return this.$outer.io$ino$solrs$AsyncSolrClient$$executeWithRetries(s, updatedContext, this.evidence$4$1);
                    }
                    if (retryDecision instanceof StandardRetryDecision) {
                        StandardRetryDecision standardRetryDecision = StandardRetryDecision$.MODULE$.unapply((StandardRetryDecision)retryDecision);
                        RetryDecision.Result result = standardRetryDecision._1();
                        if (RetryDecision$Result$Retry$.MODULE$.equals(result)) {
                            this.$outer.io$ino$solrs$AsyncSolrClient$$logger.warn(new java.lang.StringBuilder(101).append("Request failed for server ").append(this.server$2).append(", trying to get another server from loadBalancer for retry. Exception was: ").append(e).toString());
                            return this.$outer.io$ino$solrs$AsyncSolrClient$$loadBalanceRequest(updatedContext, this.evidence$4$1);
                        }
                        if (RetryDecision$Result$Fail$.MODULE$.equals(result)) {
                            this.$outer.io$ino$solrs$AsyncSolrClient$$logger.warn(new java.lang.StringBuilder(57).append("Request failed for server ").append(this.server$2).append(", not retrying. Exception was: ").append(e).toString(), e);
                            Object ex = e instanceof SolrException ? new RemoteSolrException(500, e.getMessage(), e) : e;
                            return this.$outer.io$ino$solrs$AsyncSolrClient$$futureFactory.failed((Throwable)ex);
                        }
                    }
                    throw new MatchError((Object)retryDecision);
                }
                return function1.apply((Object)x);
            }
        });
    }

    private <T extends SolrResponse> Future<T> execute(SolrServer solrServer, SolrRequest<? extends T> r, SolrResponseFactory<T> evidence$5) {
        Function2 & Serializable monitoredRequest = (Function2 & Serializable)(solrServer2, q) -> this.loadBalancer().interceptRequest((Function2 & Serializable)(solrServer, r) -> this.doExecute((SolrServer)solrServer, (SolrRequest)r, evidence$5), (SolrServer)solrServer2, q);
        return (Future)this.requestInterceptor.map((Function1 & Serializable)ri -> ri.interceptRequest(monitoredRequest, solrServer, r)).getOrElse(() -> AsyncSolrClient.execute$$anonfun$3(solrServer, r, monitoredRequest));
    }

    public <T extends SolrResponse> Future<T> doExecute(SolrServer solrServer, SolrRequest<? extends T> r, SolrResponseFactory<T> evidence$6) {
        ListenableFuture listenableFuture;
        BoundRequestBuilder boundRequestBuilder;
        ModifiableSolrParams wparams = new ModifiableSolrParams(r.getParams());
        if (this.responseParser != null && r.getResponseParser() == null) {
            wparams.set("wt", new String[]{this.responseParser.getWriterType()});
            wparams.set("version", new String[]{this.responseParser.getVersion()});
        }
        SolrServer s = solrServer;
        Promise promise = this.io$ino$solrs$AsyncSolrClient$$futureFactory.newPromise();
        long startTime = System.currentTimeMillis();
        String url = new java.lang.StringBuilder(0).append(solrServer.baseUrl()).append(this.getPath(r)).toString();
        Option maybeContentWriter = Option$.MODULE$.apply((Object)this.requestWriter.getContentWriter(r));
        SolrRequest.METHOD mETHOD = r.getMethod();
        SolrRequest.METHOD mETHOD2 = SolrRequest.METHOD.GET;
        if (!(mETHOD != null ? !mETHOD.equals(mETHOD2) : mETHOD2 != null)) {
            String fullQueryUrl = new java.lang.StringBuilder(0).append(url).append(wparams.toQueryString()).toString();
            if (maybeContentWriter.isDefined()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't use ContentWriter");
            }
            boundRequestBuilder = this.httpClient.prepareGet(fullQueryUrl);
        } else {
            boundRequestBuilder = (BoundRequestBuilder)maybeContentWriter.map((Function1 & Serializable)contentWriter -> {
                String fullQueryUrl = new java.lang.StringBuilder(0).append(url).append(wparams.toQueryString()).toString();
                SolrRequest.METHOD mETHOD = r.getMethod();
                SolrRequest.METHOD mETHOD2 = SolrRequest.METHOD.POST;
                BoundRequestBuilder req = !(mETHOD != null ? !mETHOD.equals(mETHOD2) : mETHOD2 != null) ? this.httpClient.preparePost(fullQueryUrl) : this.httpClient.preparePut(fullQueryUrl);
                BAOS baos = new BAOS();
                contentWriter.write((OutputStream)baos);
                ByteArrayInputStream is = new ByteArrayInputStream(baos.getbuf(), 0, baos.size());
                return (BoundRequestBuilder)req.setHeader((CharSequence)"Content-Type", contentWriter.getContentType()).setBody((InputStream)is);
            }).getOrElse(() -> this.$anonfun$3(r, wparams, url));
        }
        BoundRequestBuilder requestBuilder = boundRequestBuilder;
        Request request = requestBuilder.addHeader((CharSequence)"User-Agent", this.agent).build();
        try {
            listenableFuture = this.httpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(r, evidence$6, s, promise, startTime, url, this){
                private final SolrRequest r$5;
                private final SolrResponseFactory evidence$6$1;
                private final SolrServer s$1;
                private final Promise promise$1;
                private final long startTime$1;
                private final String url$3;
                private final /* synthetic */ AsyncSolrClient $outer;
                {
                    this.r$5 = r$6;
                    this.evidence$6$1 = evidence$6$2;
                    this.s$1 = s$2;
                    this.promise$1 = promise$2;
                    this.startTime$1 = startTime$2;
                    this.url$3 = url$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Response onCompleted(Response response) {
                    try {
                        T qr = this.$outer.toSolrResponse(this.r$5, response, this.url$3, this.startTime$1, this.evidence$6$1, this.s$1);
                        this.promise$1.success(qr);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            this.promise$1.failure(e);
                        }
                        throw throwable;
                    }
                    return response;
                }

                public void onThrowable(Throwable t) {
                    this.$outer.io$ino$solrs$AsyncSolrClient$$metrics.countException();
                    this.promise$1.failure(t);
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                throw throwable;
            }
            Throwable e = throwable2 = (Throwable)option.get();
            this.io$ino$solrs$AsyncSolrClient$$metrics.countException();
            promise.failure(e);
            listenableFuture = BoxedUnit.UNIT;
        }
        return promise.future();
    }

    public String getPath(SolrRequest<? extends SolrResponse> request) {
        String path = this.requestWriter.getPath(request);
        if (path != null && path.startsWith("/")) {
            return path;
        }
        return this.DEFAULT_PATH;
    }

    public <T extends SolrResponse> T toSolrResponse(SolrRequest<? extends T> r, Response response, String url, long startTime, SolrResponseFactory<T> evidence$7, SolrServer server) throws RemoteSolrException {
        NamedList rsp = null;
        this.withResponseParserFromRequest(r, (Function1)(JProcedure1 & Serializable)_$17 -> this.validateResponse(response, (ResponseParser)_$17, server));
        int httpStatus = response.getStatusCode();
        try {
            String charset = (String)HttpUtils$.MODULE$.getContentCharSet(response.getContentType()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            rsp = (NamedList)this.withResponseParserFromRequest(r, (Function1 & Serializable)_$18 -> _$18.processResponse(response.getResponseBodyAsStream(), charset));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.io$ino$solrs$AsyncSolrClient$$metrics.countRemoteException();
                throw new RemoteSolrException(httpStatus, e.getMessage(), e);
            }
            throw throwable;
        }
        if (httpStatus != 200) {
            this.io$ino$solrs$AsyncSolrClient$$metrics.countRemoteException();
            String reason = this.getErrorReason(url, rsp, response);
            throw new RemoteSolrException(httpStatus, reason, null);
        }
        T res = SolrResponseFactory$.MODULE$.apply(evidence$7).createResponse(r);
        res.setResponse(rsp);
        long elapsedTime = System.currentTimeMillis() - startTime;
        res.setElapsedTime(elapsedTime);
        this.io$ino$solrs$AsyncSolrClient$$metrics.requestTime(elapsedTime);
        return res;
    }

    private <T extends SolrResponse, R> R withResponseParserFromRequest(SolrRequest<? extends T> r, Function1<ResponseParser, R> f) {
        return (R)f.apply(Option$.MODULE$.apply((Object)r.getResponseParser()).getOrElse(this::withResponseParserFromRequest$$anonfun$1));
    }

    private void validateResponse(Response response, ResponseParser responseParser, SolrServer server) throws RemoteSolrException {
        this.validateMimeType(responseParser.getContentType(), response);
        int httpStatus = response.getStatusCode();
        if (httpStatus >= 400) {
            this.io$ino$solrs$AsyncSolrClient$$metrics.countRemoteException();
            Object msg = ((NamedList)responseParser.processResponse(response.getResponseBodyAsStream(), this.getResponseEncoding(response)).get("error")).get("msg");
            throw new RemoteSolrException(httpStatus, new java.lang.StringBuilder(47).append("Server at ").append(server.baseUrl()).append(" returned non ok status:").append(httpStatus).append(", message: ").append(response.getStatusText()).append(", ").append(msg).toString(), null);
        }
    }

    public void validateMimeType(String expectedContentType, Response response) throws RemoteSolrException {
        if (expectedContentType != null) {
            String expectedMimeType = (String)HttpUtils$.MODULE$.getMimeType(expectedContentType).map((Function1 & Serializable)_$19 -> _$19.toLowerCase(Locale.ROOT)).getOrElse(AsyncSolrClient::$anonfun$5);
            String actualMimeType = (String)HttpUtils$.MODULE$.getMimeType(response.getContentType()).map((Function1 & Serializable)_$20 -> _$20.toLowerCase(Locale.ROOT)).getOrElse(AsyncSolrClient::$anonfun$7);
            String string = expectedMimeType;
            String string2 = actualMimeType;
            if (string == null ? string2 != null : !string.equals(string2)) {
                String msg = new java.lang.StringBuilder(33).append("Expected mime type [").append(expectedMimeType).append("] but got [").append(actualMimeType).append("].").toString();
                String encoding = this.getResponseEncoding(response);
                try {
                    msg = new java.lang.StringBuilder(1).append(msg).append("\n").append(IOUtils.toString((InputStream)response.getResponseBodyAsStream(), (String)encoding)).toString();
                }
                catch (IOException e) {
                    this.io$ino$solrs$AsyncSolrClient$$metrics.countRemoteException();
                    throw new RemoteSolrException(response.getStatusCode(), new java.lang.StringBuilder(70).append(msg).append(" Unfortunately could not parse response (for debugging) with encoding ").append(encoding).toString(), e);
                }
                this.io$ino$solrs$AsyncSolrClient$$metrics.countRemoteException();
                throw new RemoteSolrException(response.getStatusCode(), msg, null);
            }
            return;
        }
    }

    public String getResponseEncoding(Response response) {
        String encoding = response.getHeader((CharSequence)"Content-Encoding");
        if (encoding == null) {
            return "UTF-8";
        }
        return encoding;
    }

    public String getErrorReason(String url, NamedList<?> rsp, Response response) {
        String reason = null;
        try {
            Object err = rsp.get("error");
            if (err != null) {
                reason = (String)((NamedList)err).get("msg");
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
            }
            throw throwable;
        }
        if (reason == null) {
            StringBuilder msg = new StringBuilder();
            msg.append(response.getStatusText());
            msg.append("\n\n");
            msg.append(new java.lang.StringBuilder(9).append("request: ").append(url).toString());
            reason = msg.toString();
        }
        return reason;
    }

    private static final Future execute$$anonfun$3(SolrServer solrServer$2, SolrRequest r$2, Function2 monitoredRequest$2) {
        return (Future)monitoredRequest$2.apply((Object)solrServer$2, (Object)r$2);
    }

    private final BoundRequestBuilder $anonfun$3(SolrRequest r$4, ModifiableSolrParams wparams$2, String url$2) {
        SolrRequest.METHOD mETHOD = r$4.getMethod();
        SolrRequest.METHOD mETHOD2 = SolrRequest.METHOD.POST;
        BoundRequestBuilder req = !(mETHOD != null ? !mETHOD.equals(mETHOD2) : mETHOD2 != null) ? this.httpClient.preparePost(url$2) : this.httpClient.preparePut(url$2);
        return (BoundRequestBuilder)req.setFormParams(MapConverter.convert(wparams$2.getMap()));
    }

    private final ResponseParser withResponseParserFromRequest$$anonfun$1() {
        return this.responseParser;
    }

    private static final String $anonfun$5() {
        return "";
    }

    private static final String $anonfun$7() {
        return "";
    }

    public static class BAOS
    extends ByteArrayOutputStream {
        public byte[] getbuf() {
            return this.buf;
        }
    }

    public static class Builder<F, ASC extends AsyncSolrClient<F>>
    implements Product,
    Serializable {
        private final LoadBalancer loadBalancer;
        private final Option httpClient;
        private final boolean shutdownHttpClient;
        private final Option requestInterceptor;
        private final Option requestWriter;
        private final Option responseParser;
        private final Option metrics;
        private final Option serverStateObservation;
        private final RetryPolicy retryPolicy;
        private final Function9 factory;
        private final FutureFactory<F> futureFactory;

        public static <F> Builder<F, AsyncSolrClient<F>> apply(LoadBalancer loadBalancer, FutureFactory<F> futureFactory) {
            return AsyncSolrClient$Builder$.MODULE$.apply(loadBalancer, futureFactory);
        }

        public static <F> Builder<F, AsyncSolrClient<F>> apply(String string, FutureFactory<F> futureFactory) {
            return AsyncSolrClient$Builder$.MODULE$.apply(string, futureFactory);
        }

        public static <F, ASC extends AsyncSolrClient<F>> Builder<F, ASC> unapply(Builder<F, ASC> builder) {
            return AsyncSolrClient$Builder$.MODULE$.unapply(builder);
        }

        public Builder(LoadBalancer loadBalancer, Option<AsyncHttpClient> httpClient, boolean shutdownHttpClient, Option<RequestInterceptor> requestInterceptor, Option<RequestWriter> requestWriter, Option<ResponseParser> responseParser, Option<Metrics> metrics, Option<ServerStateObservation<F>> serverStateObservation, RetryPolicy retryPolicy, Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> factory, FutureFactory<F> futureFactory) {
            this.loadBalancer = loadBalancer;
            this.httpClient = httpClient;
            this.shutdownHttpClient = shutdownHttpClient;
            this.requestInterceptor = requestInterceptor;
            this.requestWriter = requestWriter;
            this.responseParser = responseParser;
            this.metrics = metrics;
            this.serverStateObservation = serverStateObservation;
            this.retryPolicy = retryPolicy;
            this.factory = factory;
            this.futureFactory = futureFactory;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.loadBalancer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.httpClient()));
            n = Statics.mix((int)n, (int)(this.shutdownHttpClient() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.requestInterceptor()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.requestWriter()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.responseParser()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.metrics()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.serverStateObservation()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.retryPolicy()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.factory()));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Builder)) return false;
            Builder builder = (Builder)object;
            if (this.shutdownHttpClient() != builder.shutdownHttpClient()) return false;
            LoadBalancer loadBalancer = this.loadBalancer();
            LoadBalancer loadBalancer2 = builder.loadBalancer();
            if (loadBalancer == null) {
                if (loadBalancer2 != null) {
                    return false;
                }
            } else if (!loadBalancer.equals(loadBalancer2)) return false;
            Option<AsyncHttpClient> option = this.httpClient();
            Option<AsyncHttpClient> option2 = builder.httpClient();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<RequestInterceptor> option3 = this.requestInterceptor();
            Option<RequestInterceptor> option4 = builder.requestInterceptor();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<RequestWriter> option5 = this.requestWriter();
            Option<RequestWriter> option6 = builder.requestWriter();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<ResponseParser> option7 = this.responseParser();
            Option<ResponseParser> option8 = builder.responseParser();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<Metrics> option9 = this.metrics();
            Option<Metrics> option10 = builder.metrics();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            Option<ServerStateObservation<F>> option11 = this.serverStateObservation();
            Option<ServerStateObservation<F>> option12 = builder.serverStateObservation();
            if (option11 == null) {
                if (option12 != null) {
                    return false;
                }
            } else if (!option11.equals(option12)) return false;
            RetryPolicy retryPolicy = this.retryPolicy();
            RetryPolicy retryPolicy2 = builder.retryPolicy();
            if (retryPolicy == null) {
                if (retryPolicy2 != null) {
                    return false;
                }
            } else if (!retryPolicy.equals(retryPolicy2)) return false;
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.factory();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function92 = builder.factory();
            if (function9 == null) {
                if (function92 != null) {
                    return false;
                }
            } else if (!function9.equals(function92)) return false;
            if (!builder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Builder;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "Builder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "loadBalancer";
                }
                case 1: {
                    return "httpClient";
                }
                case 2: {
                    return "shutdownHttpClient";
                }
                case 3: {
                    return "requestInterceptor";
                }
                case 4: {
                    return "requestWriter";
                }
                case 5: {
                    return "responseParser";
                }
                case 6: {
                    return "metrics";
                }
                case 7: {
                    return "serverStateObservation";
                }
                case 8: {
                    return "retryPolicy";
                }
                case 9: {
                    return "factory";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LoadBalancer loadBalancer() {
            return this.loadBalancer;
        }

        public Option<AsyncHttpClient> httpClient() {
            return this.httpClient;
        }

        public boolean shutdownHttpClient() {
            return this.shutdownHttpClient;
        }

        public Option<RequestInterceptor> requestInterceptor() {
            return this.requestInterceptor;
        }

        public Option<RequestWriter> requestWriter() {
            return this.requestWriter;
        }

        public Option<ResponseParser> responseParser() {
            return this.responseParser;
        }

        public Option<Metrics> metrics() {
            return this.metrics;
        }

        public Option<ServerStateObservation<F>> serverStateObservation() {
            return this.serverStateObservation;
        }

        public RetryPolicy retryPolicy() {
            return this.retryPolicy;
        }

        public Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> factory() {
            return this.factory;
        }

        public Builder(LoadBalancer loadBalancer, Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> factory, FutureFactory<F> futureFactory) {
            None$ none$ = None$.MODULE$;
            Option<RequestInterceptor> option = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$4();
            Option<RequestWriter> option2 = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$5();
            Option<ResponseParser> option3 = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$6();
            Option<Metrics> option4 = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$7();
            None$ none$2 = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$8();
            RetryPolicy retryPolicy = AsyncSolrClient$Builder$.MODULE$.$lessinit$greater$default$9();
            this(loadBalancer, (Option<AsyncHttpClient>)none$, true, option, option2, option3, option4, (Option<ServerStateObservation<F>>)none$2, retryPolicy, factory, futureFactory);
        }

        public Builder(String baseUrl, Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> factory, FutureFactory<F> futureFactory) {
            this(new SingleServerLB(baseUrl), factory, futureFactory);
        }

        public Builder<F, ASC> withHttpClient(AsyncHttpClient httpClient) {
            Some some = Some$.MODULE$.apply((Object)httpClient);
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<RequestInterceptor> option = this.copy$default$4();
            Option<RequestWriter> option2 = this.copy$default$5();
            Option<ResponseParser> option3 = this.copy$default$6();
            Option<Metrics> option4 = this.copy$default$7();
            Option<ServerStateObservation<F>> option5 = this.copy$default$8();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, (Option<AsyncHttpClient>)some, false, option, option2, option3, option4, option5, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withRequestInterceptor(RequestInterceptor requestInterceptor) {
            Some some = Some$.MODULE$.apply((Object)requestInterceptor);
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<AsyncHttpClient> option = this.copy$default$2();
            boolean bl = this.copy$default$3();
            Option<RequestWriter> option2 = this.copy$default$5();
            Option<ResponseParser> option3 = this.copy$default$6();
            Option<Metrics> option4 = this.copy$default$7();
            Option<ServerStateObservation<F>> option5 = this.copy$default$8();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, option, bl, (Option<RequestInterceptor>)some, option2, option3, option4, option5, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withRequestWriter(RequestWriter requestWriter) {
            Some some = Some$.MODULE$.apply((Object)requestWriter);
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<AsyncHttpClient> option = this.copy$default$2();
            boolean bl = this.copy$default$3();
            Option<RequestInterceptor> option2 = this.copy$default$4();
            Option<ResponseParser> option3 = this.copy$default$6();
            Option<Metrics> option4 = this.copy$default$7();
            Option<ServerStateObservation<F>> option5 = this.copy$default$8();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, option, bl, option2, (Option<RequestWriter>)some, option3, option4, option5, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withResponseParser(ResponseParser responseParser) {
            Some some = Some$.MODULE$.apply((Object)responseParser);
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<AsyncHttpClient> option = this.copy$default$2();
            boolean bl = this.copy$default$3();
            Option<RequestInterceptor> option2 = this.copy$default$4();
            Option<RequestWriter> option3 = this.copy$default$5();
            Option<Metrics> option4 = this.copy$default$7();
            Option<ServerStateObservation<F>> option5 = this.copy$default$8();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, option, bl, option2, option3, (Option<ResponseParser>)some, option4, option5, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withMetrics(Metrics metrics) {
            Some some = Some$.MODULE$.apply((Object)metrics);
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<AsyncHttpClient> option = this.copy$default$2();
            boolean bl = this.copy$default$3();
            Option<RequestInterceptor> option2 = this.copy$default$4();
            Option<RequestWriter> option3 = this.copy$default$5();
            Option<ResponseParser> option4 = this.copy$default$6();
            Option<ServerStateObservation<F>> option5 = this.copy$default$8();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, option, bl, option2, option3, option4, (Option<Metrics>)some, option5, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withServerStateObservation(ServerStateObserver<F> serverStateObserver, FiniteDuration checkInterval, ScheduledExecutorService executorService) {
            Some some = Some$.MODULE$.apply(ServerStateObservation$.MODULE$.apply(serverStateObserver, checkInterval, executorService, this.futureFactory));
            LoadBalancer loadBalancer = this.copy$default$1();
            Option<AsyncHttpClient> option = this.copy$default$2();
            boolean bl = this.copy$default$3();
            Option<RequestInterceptor> option2 = this.copy$default$4();
            Option<RequestWriter> option3 = this.copy$default$5();
            Option<ResponseParser> option4 = this.copy$default$6();
            Option<Metrics> option5 = this.copy$default$7();
            RetryPolicy retryPolicy = this.copy$default$9();
            Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> function9 = this.copy$default$10();
            return this.copy(loadBalancer, option, bl, option2, option3, option4, option5, (Option<ServerStateObservation<F>>)some, retryPolicy, function9, this.futureFactory);
        }

        public Builder<F, ASC> withRetryPolicy(RetryPolicy retryPolicy) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), retryPolicy, this.copy$default$10(), this.futureFactory);
        }

        public AsyncHttpClient createHttpClient() {
            return new DefaultAsyncHttpClient();
        }

        public RequestWriter createRequestWriter() {
            return new BinaryRequestWriter();
        }

        public ResponseParser createResponseParser() {
            return new BinaryResponseParser();
        }

        public Metrics createMetrics() {
            return NoopMetrics$.MODULE$;
        }

        public void setOnAsyncSolrClientAwares(AsyncSolrClient<F> solr) {
            this.set$1(this.loadBalancer().solrServers(), solr);
            this.set$1(this.loadBalancer(), solr);
        }

        public ASC build() {
            AsyncSolrClient res = (AsyncSolrClient)this.factory().apply((Object)this.loadBalancer(), this.httpClient().getOrElse(this::$anonfun$8), (Object)BoxesRunTime.boxToBoolean((boolean)this.shutdownHttpClient()), this.requestInterceptor(), this.requestWriter().getOrElse(this::$anonfun$9), this.responseParser().getOrElse(this::$anonfun$10), this.metrics().getOrElse(this::$anonfun$11), this.serverStateObservation(), (Object)this.retryPolicy());
            this.setOnAsyncSolrClientAwares(res);
            return (ASC)res;
        }

        public <F, ASC extends AsyncSolrClient<F>> Builder<F, ASC> copy(LoadBalancer loadBalancer, Option<AsyncHttpClient> httpClient, boolean shutdownHttpClient, Option<RequestInterceptor> requestInterceptor, Option<RequestWriter> requestWriter, Option<ResponseParser> responseParser, Option<Metrics> metrics, Option<ServerStateObservation<F>> serverStateObservation, RetryPolicy retryPolicy, Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> factory, FutureFactory<F> futureFactory) {
            return new Builder<F, ASC>(loadBalancer, httpClient, shutdownHttpClient, requestInterceptor, requestWriter, responseParser, metrics, serverStateObservation, retryPolicy, factory, futureFactory);
        }

        public <F, ASC extends AsyncSolrClient<F>> LoadBalancer copy$default$1() {
            return this.loadBalancer();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<AsyncHttpClient> copy$default$2() {
            return this.httpClient();
        }

        public boolean copy$default$3() {
            return this.shutdownHttpClient();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<RequestInterceptor> copy$default$4() {
            return this.requestInterceptor();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<RequestWriter> copy$default$5() {
            return this.requestWriter();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<ResponseParser> copy$default$6() {
            return this.responseParser();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<Metrics> copy$default$7() {
            return this.metrics();
        }

        public <F, ASC extends AsyncSolrClient<F>> Option<ServerStateObservation<F>> copy$default$8() {
            return this.serverStateObservation();
        }

        public <F, ASC extends AsyncSolrClient<F>> RetryPolicy copy$default$9() {
            return this.retryPolicy();
        }

        public <F, ASC extends AsyncSolrClient<F>> Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> copy$default$10() {
            return this.factory();
        }

        public LoadBalancer _1() {
            return this.loadBalancer();
        }

        public Option<AsyncHttpClient> _2() {
            return this.httpClient();
        }

        public boolean _3() {
            return this.shutdownHttpClient();
        }

        public Option<RequestInterceptor> _4() {
            return this.requestInterceptor();
        }

        public Option<RequestWriter> _5() {
            return this.requestWriter();
        }

        public Option<ResponseParser> _6() {
            return this.responseParser();
        }

        public Option<Metrics> _7() {
            return this.metrics();
        }

        public Option<ServerStateObservation<F>> _8() {
            return this.serverStateObservation();
        }

        public RetryPolicy _9() {
            return this.retryPolicy();
        }

        public Function9<LoadBalancer, AsyncHttpClient, Object, Option<RequestInterceptor>, RequestWriter, ResponseParser, Metrics, Option<ServerStateObservation<F>>, RetryPolicy, ASC> _10() {
            return this.factory();
        }

        private final void set$1(Object maybeAware, AsyncSolrClient solr) {
            Object object = maybeAware;
            if (object instanceof AsyncSolrClientAware) {
                AsyncSolrClientAware aware = (AsyncSolrClientAware)object;
                aware.setAsyncSolrClient(solr);
                return;
            }
        }

        private final AsyncHttpClient $anonfun$8() {
            return this.createHttpClient();
        }

        private final RequestWriter $anonfun$9() {
            return this.createRequestWriter();
        }

        private final ResponseParser $anonfun$10() {
            return this.createResponseParser();
        }

        private final Metrics $anonfun$11() {
            return this.createMetrics();
        }
    }
}

