/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.CloudSolrServers;
import io.ino.solrs.FastestServerLB;
import io.ino.solrs.JavaAsyncSolrClient;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.RetryPolicy;
import io.ino.solrs.RoundRobinLB;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StaticSolrServers;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.Option;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;

public class JavaAPITest
extends JUnitSuite {
    private static final long serialVersionUID = 1L;
    private static SolrRunner solrRunner;

    @BeforeClass
    public static void beforeClass() {
        solrRunner = SolrRunner.startOnce(8888).awaitReady(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testAsyncSolrClientBuilderUrl() throws ExecutionException, InterruptedException {
        JavaAsyncSolrClient javaAsyncSolrClient = (JavaAsyncSolrClient)JavaAsyncSolrClient.builder((String)("http://localhost:" + solrRunner.port() + "/solr/collection1")).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
        CompletionStage completionStage = javaAsyncSolrClient.query((SolrParams)new SolrQuery("*:*"));
        completionStage.thenAccept(queryResponse -> System.out.println("found " + queryResponse.getResults().getNumFound() + " docs"));
        Assert.assertNotNull((Object)((QueryResponse)completionStage.toCompletableFuture().get()).getResults());
    }

    @Test
    public void testRoundRobinLB() {
        RoundRobinLB roundRobinLB = RoundRobinLB.create(Arrays.asList("http://localhost:8983/solr/collection1", "http://localhost:8984/solr/collection1"));
        Assert.assertNotNull((Object)roundRobinLB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFastestServerLB() {
        StaticSolrServers staticSolrServers = StaticSolrServers.create(Arrays.asList("http://localhost:8983/solr/collection1", "http://localhost:8984/solr/collection1"));
        Tuple2 tuple2 = new Tuple2((Object)"collection1", (Object)new SolrQuery("*:*").setRows(Integer.valueOf(0)));
        Function<SolrServer, Tuple2> function = solrServer -> tuple2;
        FastestServerLB fastestServerLB = null;
        try {
            fastestServerLB = FastestServerLB.builder((SolrServers)staticSolrServers, function).withMinDelay(50L, TimeUnit.MILLISECONDS).withMaxDelay(5L, TimeUnit.SECONDS).withFilterFastServers(l -> (solrServer, l2) -> l2 <= l).withMapPredictedResponseTime(l -> l * 10L).withInitialTestRuns(50).build();
            Assert.assertNotNull((Object)fastestServerLB);
            JavaAsyncSolrClient javaAsyncSolrClient = (JavaAsyncSolrClient)JavaAsyncSolrClient.builder((LoadBalancer)fastestServerLB).build();
            Assert.assertNotNull((Object)javaAsyncSolrClient.loadBalancer());
        }
        finally {
            if (fastestServerLB != null) {
                fastestServerLB.shutdown();
            }
        }
    }

    @Test
    public void testAsyncSolrClientBuilderLB() throws ExecutionException, InterruptedException {
        JavaAsyncSolrClient javaAsyncSolrClient = (JavaAsyncSolrClient)JavaAsyncSolrClient.builder((LoadBalancer)new SingleServerLB("http://localhost:" + solrRunner.port() + "/solr/collection1")).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
        CompletionStage completionStage = javaAsyncSolrClient.query((SolrParams)new SolrQuery("*:*"));
        completionStage.thenAccept(queryResponse -> System.out.println("found " + queryResponse.getResults().getNumFound() + " docs"));
        Assert.assertNotNull((Object)((QueryResponse)completionStage.toCompletableFuture().get()).getResults());
    }

    @Test
    public void testStaticSolrServers() {
        StaticSolrServers staticSolrServers = StaticSolrServers.create(Arrays.asList("http://localhost:8983/solr/collection1", "http://localhost:8984/solr/collection1"));
        Assert.assertNotNull((Object)staticSolrServers);
    }

    @Test
    public void testCloudSolrServers() {
        CloudSolrServers.Builder builder = CloudSolrServers.builder((String)"host1:2181,host2:2181").withZkClientTimeout(15L, TimeUnit.SECONDS).withZkConnectTimeout(10L, TimeUnit.SECONDS).withClusterStateUpdateInterval(1L, TimeUnit.SECONDS).withDefaultCollection("collection1").withWarmupQueries(string -> Collections.singletonList(new SolrQuery("*:*")), 10);
        Assert.assertNotNull((Object)builder);
        Assert.assertEquals((Object)"host1:2181,host2:2181", (Object)builder.zkHost());
        Assert.assertEquals((Object)FiniteDuration.apply((long)15L, (TimeUnit)TimeUnit.SECONDS), (Object)builder.zkClientTimeout());
        Assert.assertEquals((Object)FiniteDuration.apply((long)10L, (TimeUnit)TimeUnit.SECONDS), (Object)builder.zkConnectTimeout());
        Assert.assertEquals((Object)FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.SECONDS), (Object)builder.clusterStateUpdateInterval());
        Assert.assertEquals((Object)Option.apply((Object)"collection1"), (Object)builder.defaultCollection());
        Assert.assertTrue((boolean)builder.warmupQueries().isDefined());
        Assert.assertEquals((long)10L, (long)((CloudSolrServers.WarmupQueries)builder.warmupQueries().get()).count());
        CloudSolrServers cloudSolrServers = builder.build();
    }

    @Test
    public void testRetryPolicy() {
        Assert.assertNotNull((Object)RetryPolicy.AtMost((int)2));
        Assert.assertNotNull((Object)RetryPolicy.TryAvailableServers());
        Assert.assertNotNull((Object)RetryPolicy.TryOnce());
    }
}

