/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.AsyncSolrClientMocks$;
import io.ino.solrs.CloudSolrServers;
import io.ino.solrs.CloudSolrServers$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Equalities$;
import io.ino.solrs.Failed$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.SolrCloudRunner;
import io.ino.solrs.SolrCloudRunner$;
import io.ino.solrs.SolrCollection;
import io.ino.solrs.SolrCollection$;
import io.ino.solrs.SolrMatchers$;
import io.ino.solrs.SolrResponseFactory;
import io.ino.solrs.SolrRunner$;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.Promise;
import io.ino.time.Clock$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.embedded.JettySolrRunner;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funspec.AnyFunSpecLike;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class CloudSolrServersIntegrationSpec
extends StandardFunSpec
implements BeforeAndAfterEach {
    private final FiniteDuration awaitTimeout = new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds();
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig = Eventually$.MODULE$.PatienceConfig().apply(Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(1000L, (Units)Millis$.MODULE$)));
    private SolrCloudRunner solrRunner;
    private CloudSolrClient solrJClient;
    private Map<JettySolrRunner, AsyncSolrClient<scala.concurrent.Future>> asyncSolrClients;
    private CloudSolrServers<scala.concurrent.Future> cut;

    public CloudSolrServersIntegrationSpec() {
        CloudSolrServersIntegrationSpec AnyFunSpecLike_this = this;
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92);
        AnyFunSpecLike_this.org$scalatest$funspec$AnyFunSpecLike$$inline$describeImpl("CloudSolrServers", (Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }, position);
    }

    private String zkConnectString() {
        return this.solrRunner.zkAddress();
    }

    private List<String> solrServerUrls() {
        return this.solrRunner.solrCoreUrls();
    }

    private List<SolrServer> solrServerUrlsEnabled() {
        return this.solrServerUrls().map((Function1 & Serializable)_$2 -> SolrServer$.MODULE$.apply(_$2, (ServerStatus)Enabled$.MODULE$));
    }

    @Override
    public void beforeAll() {
        this.solrRunner = SolrCloudRunner$.MODULE$.start(4, (List<SolrCollection>)((List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrCollection[]{SolrCollection$.MODULE$.apply("collection1", 2, 2)}))), (Option<String>)Some$.MODULE$.apply((Object)"collection1"), SolrCloudRunner$.MODULE$.start$default$4(), SolrCloudRunner$.MODULE$.start$default$5());
        this.solrJClient = this.solrRunner.solrJClient();
        this.asyncSolrClients = this.solrRunner.jettySolrRunners().map((Function1 & Serializable)jetty -> {
            JettySolrRunner jettySolrRunner = (JettySolrRunner)Predef$.MODULE$.ArrowAssoc(jetty);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)jettySolrRunner, (Object)AsyncSolrClient$.MODULE$.apply(new StringBuilder(12).append(jetty.getBaseUrl()).append("/collection1").toString(), (FutureFactory)this.futureFactory()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        PatienceConfiguration.Timeout timeout$proxy1 = PatienceConfiguration.Timeout$.MODULE$.apply(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
        Retrying retrying$proxy1 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63);
        UpdateResponse cfr_ignored_0 = (UpdateResponse)Eventually$.MODULE$.callRetry(retrying$proxy1, timeout$proxy1.value(), this.patienceConfig.interval(), position, this::beforeAll$$anonfun$2);
        this.solrJClient.add(CollectionConverters$.MODULE$.IterableHasAsJava(SolrUtils$.MODULE$.someDocs()).asJavaCollection());
        this.solrJClient.commit();
    }

    @Override
    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.solrRunner.jettySolrRunners().foreach((Function1)(JProcedure1 & Serializable)jetty -> {
            if (jetty.isStopped()) {
                SolrRunner$.MODULE$.startJetty((JettySolrRunner)jetty);
                return;
            }
        });
    }

    @Override
    public void afterEach() {
        this.cut.shutdown();
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterAll() {
        this.asyncSolrClients.values().foreach((Function1)(JProcedure1 & Serializable)asyncSolrClient -> asyncSolrClient.shutdown());
        this.solrJClient.close();
        this.solrRunner.shutdown();
    }

    private List<SolrInputDocument> indexShardedDocs(Function1<Object, String> shardKey) {
        PatienceConfiguration.Timeout timeout$proxy2 = PatienceConfiguration.Timeout$.MODULE$.apply(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
        Retrying retrying$proxy9 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236);
        UpdateResponse cfr_ignored_0 = (UpdateResponse)Eventually$.MODULE$.callRetry(retrying$proxy9, timeout$proxy2.value(), this.patienceConfig.interval(), position, this::indexShardedDocs$$anonfun$1);
        List docs = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable)i -> SolrUtils$.MODULE$.newInputDoc(new StringBuilder(3).append(shardKey.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)))).append("!id").append(BoxesRunTime.unboxToInt((Object)i)).toString(), new StringBuilder(3).append("doc").append(BoxesRunTime.unboxToInt((Object)i)).toString(), new StringBuilder(3).append("cat").append(BoxesRunTime.unboxToInt((Object)i)).toString(), Int$.MODULE$.int2float(BoxesRunTime.unboxToInt((Object)i)))).toList();
        this.solrJClient.add(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)docs).asJavaCollection());
        this.solrJClient.commit();
        Retrying retrying$proxy10 = Retrying$.MODULE$.retryingNatureOfT();
        Position position2 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247);
        Assertion cfr_ignored_1 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy10, this.patienceConfig.timeout(), this.patienceConfig.interval(), position2, () -> this.indexShardedDocs$$anonfun$2(docs));
        return docs;
    }

    private static final SolrServer testFun$proxy1$1$$anonfun$1() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    private final Assertion fun$proxy2$1() {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs(this.solrServerUrlsEnabled(), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy1$1$$anonfun$2() {
        return this.fun$proxy2$1();
    }

    private final Assertion fun$proxy3$1(AsyncSolrClient client$1) {
        scala.concurrent.Future response = ((scala.concurrent.Future)client$1.query((SolrParams)new SolrQuery("*:*").setRows(Predef$.MODULE$.int2Integer(1000)))).map((Function1 & Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
        return this.should(this.await(response, (Duration)this.awaitTimeout), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs(SolrUtils$.MODULE$.someDocsIds(), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
    }

    private final Assertion testFun$proxy1$1$$anonfun$3$$anonfun$1(AsyncSolrClient client$2) {
        return this.fun$proxy3$1(client$2);
    }

    private final void testFun$proxy1$1() {
        String string = this.zkConnectString();
        FiniteDuration finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(100)).millis();
        Duration duration = CloudSolrServers$.MODULE$.$lessinit$greater$default$2();
        Duration duration2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$3();
        Option option = CloudSolrServers$.MODULE$.$lessinit$greater$default$5();
        Option option2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$6();
        this.cut = new CloudSolrServers(string, duration, duration2, (Duration)finiteDuration, option, option2, (FutureFactory)this.futureFactory());
        this.cut.setAsyncSolrClient(AsyncSolrClientMocks$.MODULE$.mockDoRequest((AsyncSolrClient)this.mock(Tag$.MODULE$.apply(AsyncSolrClient.class, LightTypeTag$.MODULE$.parse(107193623, "\u0001\u0001\u0001\u001cio.ino.solrs.AsyncSolrClient\u0001\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001", "\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ascala.concurrent.Awaitable\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30))), (Function0<SolrServer>)((Function0 & Serializable)CloudSolrServersIntegrationSpec::testFun$proxy1$1$$anonfun$1), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), Clock$.MODULE$.mutable()));
        Retrying retrying$proxy2 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98);
        Assertion cfr_ignored_0 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy2, this.patienceConfig.timeout(), this.patienceConfig.interval(), position, this::testFun$proxy1$1$$anonfun$2);
        this.asyncSolrClients.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                AsyncSolrClient client = (AsyncSolrClient)tuple2._2();
                Retrying retrying$proxy3 = Retrying$.MODULE$.retryingNatureOfT();
                Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104);
                return (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy3, this.patienceConfig.timeout(), this.patienceConfig.interval(), position, () -> this.testFun$proxy1$1$$anonfun$3$$anonfun$1(client));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Object fun$proxy9$1$$anonfun$1() {
        this.testFun$proxy1$1();
        return BoxedUnit.UNIT;
    }

    private static final SolrServer testFun$proxy2$1$$anonfun$1() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    private final Assertion fun$proxy4$1(List expectedSolrServers$1) {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)expectedSolrServers$1, Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy2$1$$anonfun$2(List expectedSolrServers$4) {
        return this.fun$proxy4$1(expectedSolrServers$4);
    }

    private final Assertion fun$proxy5$1(List expectedSolrServers$2) {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)expectedSolrServers$2, Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy2$1$$anonfun$3(List expectedSolrServers$5) {
        return this.fun$proxy5$1(expectedSolrServers$5);
    }

    private final Assertion fun$proxy6$1(List expectedSolrServers$3) {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)expectedSolrServers$3, Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy2$1$$anonfun$4(List expectedSolrServers$6) {
        return this.fun$proxy6$1(expectedSolrServers$6);
    }

    private final Assertion testFun$proxy2$1() {
        String string = this.zkConnectString();
        FiniteDuration finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(100)).millis();
        Duration duration = CloudSolrServers$.MODULE$.$lessinit$greater$default$2();
        Duration duration2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$3();
        Option option = CloudSolrServers$.MODULE$.$lessinit$greater$default$5();
        Option option2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$6();
        this.cut = new CloudSolrServers(string, duration, duration2, (Duration)finiteDuration, option, option2, (FutureFactory)this.futureFactory());
        this.cut.setAsyncSolrClient(AsyncSolrClientMocks$.MODULE$.mockDoRequest((AsyncSolrClient)this.mock(Tag$.MODULE$.apply(AsyncSolrClient.class, LightTypeTag$.MODULE$.parse(107193623, "\u0001\u0001\u0001\u001cio.ino.solrs.AsyncSolrClient\u0001\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001", "\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ascala.concurrent.Awaitable\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30))), (Function0<SolrServer>)((Function0 & Serializable)CloudSolrServersIntegrationSpec::testFun$proxy2$1$$anonfun$1), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), Clock$.MODULE$.mutable()));
        List<SolrServer> expectedSolrServers = this.solrServerUrlsEnabled();
        Retrying retrying$proxy4 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120);
        Assertion cfr_ignored_0 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy4, this.patienceConfig.timeout(), this.patienceConfig.interval(), position, () -> this.testFun$proxy2$1$$anonfun$2(expectedSolrServers));
        SolrRunner$.MODULE$.stopJetty((JettySolrRunner)this.solrRunner.jettySolrRunners().head());
        ((SolrServer)expectedSolrServers.head()).status_$eq((ServerStatus)Failed$.MODULE$);
        Retrying retrying$proxy5 = Retrying$.MODULE$.retryingNatureOfT();
        Position position2 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126);
        Assertion cfr_ignored_1 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy5, this.patienceConfig.timeout(), this.patienceConfig.interval(), position2, () -> this.testFun$proxy2$1$$anonfun$3(expectedSolrServers));
        SolrRunner$.MODULE$.startJetty((JettySolrRunner)this.solrRunner.jettySolrRunners().head());
        ((SolrServer)expectedSolrServers.head()).status_$eq((ServerStatus)Enabled$.MODULE$);
        Retrying retrying$proxy6 = Retrying$.MODULE$.retryingNatureOfT();
        Position position3 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132);
        return (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy6, this.patienceConfig.timeout(), this.patienceConfig.interval(), position3, () -> this.testFun$proxy2$1$$anonfun$4(expectedSolrServers));
    }

    private final Object fun$proxy9$1$$anonfun$2() {
        return this.testFun$proxy2$1();
    }

    private static final SolrServer testFun$proxy3$1$$anonfun$1() {
        return AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2();
    }

    private static final /* synthetic */ String $anonfun$2(int docNr) {
        return new StringBuilder(3).append("KEY").append(docNr).toString();
    }

    private static final boolean serverContainsDoc$1(String url, String id) {
        Http2SolrClient client = new Http2SolrClient.Builder(url).build();
        return client.query((SolrParams)new SolrQuery(new StringBuilder(5).append("id:\"").append(id).append("\"").toString()).setParam("shards", new String[]{url})).getResults().getNumFound() > 0L;
    }

    private final Assertion fun$proxy7$1(List solrServers$1) {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)solrServers$1, Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy3$1$$anonfun$3(List solrServers$4) {
        return this.fun$proxy7$1(solrServers$4);
    }

    private final void testFun$proxy3$1() {
        String string = this.zkConnectString();
        Some some = Some$.MODULE$.apply((Object)"collection1");
        FiniteDuration finiteDuration = new package.DurationInt(package$.MODULE$.DurationInt(100)).millis();
        Duration duration = CloudSolrServers$.MODULE$.$lessinit$greater$default$2();
        Duration duration2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$3();
        Option option = CloudSolrServers$.MODULE$.$lessinit$greater$default$6();
        this.cut = new CloudSolrServers(string, duration, duration2, (Duration)finiteDuration, (Option)some, option, (FutureFactory)this.futureFactory());
        this.cut.setAsyncSolrClient(AsyncSolrClientMocks$.MODULE$.mockDoRequest((AsyncSolrClient)this.mock(Tag$.MODULE$.apply(AsyncSolrClient.class, LightTypeTag$.MODULE$.parse(107193623, "\u0001\u0001\u0001\u001cio.ino.solrs.AsyncSolrClient\u0001\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001", "\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ascala.concurrent.Awaitable\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30))), (Function0<SolrServer>)((Function0 & Serializable)CloudSolrServersIntegrationSpec::testFun$proxy3$1$$anonfun$1), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), Clock$.MODULE$.mutable()));
        List<SolrInputDocument> docs = this.indexShardedDocs((Function1<Object, String>)(Function1 & Serializable)docNr -> CloudSolrServersIntegrationSpec.$anonfun$2(BoxesRunTime.unboxToInt((Object)docNr)));
        Map expectedServersByDoc = docs.map((Function1 & Serializable)doc -> {
            String id = doc.getFieldValue("id").toString();
            List expectedServers = this.solrServerUrls().filter((Function1 & Serializable)_$6 -> CloudSolrServersIntegrationSpec.serverContainsDoc$1(_$6, id));
            SolrInputDocument solrInputDocument = (SolrInputDocument)Predef$.MODULE$.ArrowAssoc(doc);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)solrInputDocument, (Object)expectedServers);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        expectedServersByDoc.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SolrInputDocument doc = (SolrInputDocument)tuple2._1();
                List expectedServers = (List)tuple2._2();
                String id = doc.getFieldValue("id").toString();
                String route = id.substring(0, id.indexOf(33) + 1);
                QueryRequest request = new QueryRequest((SolrParams)new SolrQuery("*:*").setParam("_route_", new String[]{route}));
                return this.should(this.cut.matching((SolrRequest)request).get(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)expectedServers.map((Function1 & Serializable)_$7 -> SolrServer$.MODULE$.apply(_$7, (ServerStatus)Enabled$.MODULE$)), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
            }
            throw new MatchError((Object)tuple2);
        });
        List<SolrServer> solrServers = this.solrServerUrlsEnabled();
        SolrRunner$.MODULE$.stopJetty((JettySolrRunner)this.solrRunner.jettySolrRunners().head());
        ((SolrServer)solrServers.head()).status_$eq((ServerStatus)Failed$.MODULE$);
        Retrying retrying$proxy7 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172);
        Assertion cfr_ignored_0 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy7, this.patienceConfig.timeout(), this.patienceConfig.interval(), position, () -> this.testFun$proxy3$1$$anonfun$3(solrServers));
        expectedServersByDoc.foreach((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                SolrInputDocument doc = (SolrInputDocument)tuple2._1();
                List expectedServers = (List)tuple2._2();
                String id = doc.getFieldValue("id").toString();
                String route = id.substring(0, id.indexOf(33) + 1);
                QueryRequest request = new QueryRequest((SolrParams)new SolrQuery("*:*").setParam("_route_", new String[]{route}));
                List expectedServersWithStatus = expectedServers.map((Function1 & Serializable)x$1 -> {
                    String string;
                    String serverUrl;
                    String string2 = serverUrl = (string = x$1);
                    String string3 = ((SolrServer)solrServers.head()).baseUrl();
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        return SolrServer$.MODULE$.apply(serverUrl, (ServerStatus)Failed$.MODULE$);
                    }
                    String serverUrl2 = string;
                    return SolrServer$.MODULE$.apply(serverUrl2, (ServerStatus)Enabled$.MODULE$);
                });
                return this.should(this.cut.matching((SolrRequest)request).get(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)expectedServersWithStatus, Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final Object fun$proxy9$1$$anonfun$3() {
        this.testFun$proxy3$1();
        return BoxedUnit.UNIT;
    }

    private final Assertion fun$proxy8$1() {
        return this.should((Object)this.cut.all(), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs(this.solrServerUrlsEnabled(), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equalities$.MODULE$.solrServerStatusEquality()));
    }

    private final Assertion testFun$proxy4$1$$anonfun$1() {
        return this.fun$proxy8$1();
    }

    private final void testFun$proxy4$1() {
        Seq queries = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrQuery[]{new SolrQuery("foo")}));
        CloudSolrServers.WarmupQueries warmupQueries = CloudSolrServers.WarmupQueries$.MODULE$.apply((Function1 & Serializable)_$8 -> queries, 2);
        String string = this.zkConnectString();
        Some some = Some$.MODULE$.apply((Object)warmupQueries);
        Duration duration = CloudSolrServers$.MODULE$.$lessinit$greater$default$2();
        Duration duration2 = CloudSolrServers$.MODULE$.$lessinit$greater$default$3();
        Duration duration3 = CloudSolrServers$.MODULE$.$lessinit$greater$default$4();
        Option option = CloudSolrServers$.MODULE$.$lessinit$greater$default$5();
        this.cut = new CloudSolrServers(string, duration, duration2, duration3, option, (Option)some, (FutureFactory)this.futureFactory());
        Promise standardResponsePromise = this.futureFactory().newPromise();
        Future standardResponse = standardResponsePromise.future();
        AsyncSolrClient asyncSolrClient = AsyncSolrClientMocks$.MODULE$.mockDoRequest((AsyncSolrClient)this.mock(Tag$.MODULE$.apply(AsyncSolrClient.class, LightTypeTag$.MODULE$.parse(107193623, "\u0001\u0001\u0001\u001cio.ino.solrs.AsyncSolrClient\u0001\u0000\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001", "\u0000\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u0017scala.concurrent.Future\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0003\u0001\u0001\u0000\u0000\u0000\u0001\u0001\u0001\u0001\u001ascala.concurrent.Awaitable\u0001\u0000\u0004\u0000\u0003\u0000\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30))), (Future<SolrResponse>)standardResponse);
        this.cut.setAsyncSolrClient(asyncSolrClient);
        Position pos$proxy1 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202);
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202);
        IndexedSeq indexedSeq = this.cut.all();
        Bool bool = Bool$.MODULE$.unaryMacroBool((Object)indexedSeq, "isEmpty", indexedSeq.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert(bool, (Object)"", position);
        standardResponsePromise.success((Object)new QueryResponse());
        Retrying retrying$proxy8 = Retrying$.MODULE$.retryingNatureOfT();
        Position position2 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207);
        Assertion cfr_ignored_0 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy8, this.patienceConfig.timeout(), this.patienceConfig.interval(), position2, this::testFun$proxy4$1$$anonfun$1);
        this.solrServerUrlsEnabled().foreach((Function1)(JProcedure1 & Serializable)solrServer -> ((IterableOnceOps)warmupQueries.queriesByCollection().apply((Object)"col1")).foreach((Function1 & Serializable)q -> ((AsyncSolrClient)Mockito.verify((Object)asyncSolrClient, (VerificationMode)Mockito.times((int)warmupQueries.count()))).doExecute(SolrMatchers$.MODULE$.hasBaseUrlOf((SolrServer)solrServer), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)q), (SolrResponseFactory)ArgumentMatchers.any())));
    }

    private final Object fun$proxy9$1$$anonfun$4() {
        this.testFun$proxy4$1();
        return BoxedUnit.UNIT;
    }

    private final void fun$proxy9$1() {
        AnyFunSpecLike.ItWord ItWord_this = this.it();
        ArraySeq testTags$proxy1 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94);
        ItWord_this.inline$applyImpl("should list available solr instances", (Seq)testTags$proxy1, this::fun$proxy9$1$$anonfun$1, position);
        AnyFunSpecLike.ItWord ItWord_this2 = this.it();
        ArraySeq testTags$proxy2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position2 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113);
        ItWord_this2.inline$applyImpl("should update available solr instances", (Seq)testTags$proxy2, this::fun$proxy9$1$$anonfun$2, position2);
        AnyFunSpecLike.ItWord ItWord_this3 = this.it();
        ArraySeq testTags$proxy3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position3 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137);
        ItWord_this3.inline$applyImpl("should route requests according to _route_ param", (Seq)testTags$proxy3, this::fun$proxy9$1$$anonfun$3, position3);
        AnyFunSpecLike.ItWord ItWord_this4 = this.it();
        ArraySeq testTags$proxy4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position4 = Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190);
        ItWord_this4.inline$applyImpl("should test solr instances according to the WarmupQueries", (Seq)testTags$proxy4, this::fun$proxy9$1$$anonfun$4, position4);
    }

    private final void $init$$$anonfun$1() {
        this.fun$proxy9$1();
    }

    private final UpdateResponse fun$proxy1$1() {
        return this.solrJClient.deleteByQuery("*:*");
    }

    private final UpdateResponse beforeAll$$anonfun$2() {
        return this.fun$proxy1$1();
    }

    private final UpdateResponse fun$proxy10$1() {
        return this.solrJClient.deleteByQuery("*:*");
    }

    private final UpdateResponse indexShardedDocs$$anonfun$1() {
        return this.fun$proxy10$1();
    }

    private final Assertion fun$proxy11$1(List docs$1) {
        scala.concurrent.Future response = ((scala.concurrent.Future)((AsyncSolrClient)this.asyncSolrClients.values().head()).query((SolrParams)new SolrQuery("*:*").setRows(Predef$.MODULE$.int2Integer(10)))).map((Function1 & Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
        return this.should(this.await(response, (Duration)this.awaitTimeout), Position$.MODULE$.apply("CloudSolrServersIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)docs$1.map((Function1 & Serializable)_$9 -> _$9.getFieldValue("id").toString()), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
    }

    private final Assertion indexShardedDocs$$anonfun$2(List docs$2) {
        return this.fun$proxy11$1(docs$2);
    }
}

