/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.Metrics;
import io.ino.solrs.PingStatusObserver;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RunningSolr;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funspec.AnyFunSpecLike;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.CanEqual$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.XML$;

public class AsyncSolrClientIntegrationSpec
extends StandardFunSpec
implements RunningSolr {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AsyncSolrClientIntegrationSpec.class.getDeclaredField("solrs$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AsyncSolrClientIntegrationSpec.class.getDeclaredField("solrUrl$lzy1"));
    private SolrRunner solrRunner;
    private Http2SolrClient solrJClient;
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig;
    private final FiniteDuration timeout;
    private final DefaultAsyncHttpClient httpClient;
    private volatile Object solrUrl$lzy1;
    private volatile Object solrs$lzy1;

    public AsyncSolrClientIntegrationSpec() {
        RunningSolr.$init$(this);
        this.patienceConfig = Eventually$.MODULE$.PatienceConfig().apply(Eventually$.MODULE$.scaled(Span$.MODULE$.apply(10000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20L, (Units)Millis$.MODULE$)));
        this.timeout = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
        this.httpClient = new DefaultAsyncHttpClient();
        AsyncSolrClientIntegrationSpec AnyFunSpecLike_this = this;
        Position position = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59);
        AnyFunSpecLike_this.org$scalatest$funspec$AnyFunSpecLike$$inline$describeImpl("Solr", (Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }, position);
    }

    @Override
    public SolrRunner solrRunner() {
        return this.solrRunner;
    }

    @Override
    public Http2SolrClient solrJClient() {
        return this.solrJClient;
    }

    @Override
    public void solrRunner_$eq(SolrRunner x$1) {
        this.solrRunner = x$1;
    }

    @Override
    public void solrJClient_$eq(Http2SolrClient x$1) {
        this.solrJClient = x$1;
    }

    private String solrUrl() {
        Object object = this.solrUrl$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.solrUrl$lzyINIT1();
    }

    private Object solrUrl$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.solrUrl$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = new StringBuilder(34).append("http://localhost:").append(this.solrRunner().port()).append("/solr/collection1").toString();
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.solrUrl$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs() {
        Object object = this.solrs$lzy1;
        if (object instanceof AsyncSolrClient) {
            return (AsyncSolrClient)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AsyncSolrClient)this.solrs$lzyINIT1();
    }

    private Object solrs$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.solrs$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AsyncSolrClient asyncSolrClient = null;
                    try {
                        asyncSolrClient = AsyncSolrClient$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory());
                        object2 = asyncSolrClient == null ? LazyVals.NullValue$.MODULE$ : asyncSolrClient;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.solrs$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return asyncSolrClient;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void beforeEach() {
        PatienceConfiguration.Timeout timeout$proxy1 = PatienceConfiguration.Timeout$.MODULE$.apply(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()));
        Retrying retrying$proxy1 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44);
        UpdateResponse cfr_ignored_0 = (UpdateResponse)Eventually$.MODULE$.callRetry(retrying$proxy1, timeout$proxy1.value(), this.patienceConfig.interval(), position, this::beforeEach$$anonfun$1);
        SolrInputDocument doc1 = SolrUtils$.MODULE$.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument doc2 = SolrUtils$.MODULE$.newInputDoc("id2", "doc2", "cat1", 20.0f);
        this.solrJClient().add(Arrays.asList(doc1, doc2));
        this.solrJClient().commit();
    }

    @Override
    public void afterAll() {
        RunningSolr.afterAll$(this);
        this.solrs().shutdown();
        this.httpClient.close();
    }

    private void enable(String solrUrl) {
        this.setStatus(solrUrl, "enable", 200, this.setStatus$default$4());
    }

    private void disable(String solrUrl) {
        this.setStatus(solrUrl, "disable", 503, this.setStatus$default$4());
    }

    private void setStatus(String solrUrl, String action, int expectedStatus, int attempt) {
        while (true) {
            Response response = (Response)this.httpClient.prepareGet(new StringBuilder(26).append(solrUrl).append("/admin/ping?action=").append(action).append("&wt=xml").toString()).execute().get();
            this.shouldBe((Object)BoxesRunTime.boxToInteger((int)response.getStatusCode()), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)200), CanEqual$.MODULE$.canEqualAny());
            int newStatusCode = ((Response)this.httpClient.prepareGet(new StringBuilder(18).append(solrUrl).append("/admin/ping?wt=xml").toString()).execute().get()).getStatusCode();
            if (newStatusCode != expectedStatus && attempt > 3) {
                throw new IllegalStateException(new StringBuilder(65).append("Could not reach expected status ").append(expectedStatus).append(" via action '").append(action).append("', reached ").append(newStatusCode).append(" instead.").toString());
            }
            if (newStatusCode == expectedStatus) break;
            Thread.sleep(20L);
            ++attempt;
        }
    }

    private int setStatus$default$4() {
        return 1;
    }

    private final Assertion testFun$proxy1$1() {
        scala.concurrent.Future response = ((scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("cat:cat1"))).map((Function1 & Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
        return this.should(this.await(response, (Duration)this.timeout), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default(), this.contain()).theSameElementsAs((Iterable)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2"})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
    }

    private final Object fun$proxy4$1$$anonfun$1() {
        return this.testFun$proxy1$1();
    }

    private final Assertion fun$proxy2$1(Seq solrServers$1) {
        return this.should((Object)((SolrServer)solrServers$1.apply(0)).status(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default(), this.be().apply((Object)Enabled$.MODULE$));
    }

    private final Assertion testFun$proxy2$1$$anonfun$1(Seq solrServers$3) {
        return this.fun$proxy2$1(solrServers$3);
    }

    private final Assertion fun$proxy3$1(Seq solrServers$2) {
        return this.should((Object)((SolrServer)solrServers$2.apply(0)).status(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default(), this.be().apply((Object)Disabled$.MODULE$));
    }

    private final Assertion testFun$proxy2$1$$anonfun$2(Seq solrServers$4) {
        return this.fun$proxy3$1(solrServers$4);
    }

    private final void testFun$proxy2$1() {
        Seq solrServers = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrServer[]{SolrServer$.MODULE$.apply(this.solrUrl())}));
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).withServerStateObservation((ServerStateObserver)new PingStatusObserver(solrServers, (AsyncHttpClient)this.httpClient, (FutureFactory)this.futureFactory()), new package.DurationInt(package$.MODULE$.DurationInt(20)).millis(), Executors.newSingleThreadScheduledExecutor()).build();
        this.enable(this.solrUrl());
        Retrying retrying$proxy2 = Retrying$.MODULE$.retryingNatureOfT();
        Position position = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77);
        Assertion cfr_ignored_0 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy2, this.patienceConfig.timeout(), this.patienceConfig.interval(), position, () -> this.testFun$proxy2$1$$anonfun$1(solrServers));
        this.disable(this.solrUrl());
        Retrying retrying$proxy3 = Retrying$.MODULE$.retryingNatureOfT();
        Position position2 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82);
        Assertion cfr_ignored_1 = (Assertion)Eventually$.MODULE$.callRetry(retrying$proxy3, this.patienceConfig.timeout(), this.patienceConfig.interval(), position2, () -> this.testFun$proxy2$1$$anonfun$2(solrServers));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$2() {
        this.testFun$proxy2$1();
        return BoxedUnit.UNIT;
    }

    private final Assertion testFun$proxy3$1() {
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).build();
        scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
        return this.should((Object)BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout)).getResults().getNumFound()), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
    }

    private final Object fun$proxy4$1$$anonfun$3() {
        return this.testFun$proxy3$1();
    }

    private final void testFun$proxy4$1() {
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).build();
        scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
        this.should((Object)BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout)).getResults().getNumFound()), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$4() {
        this.testFun$proxy4$1();
        return BoxedUnit.UNIT;
    }

    private final void testFun$proxy5$1() {
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
        scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
        this.should((Object)BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout)).getResults().getNumFound()), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$5() {
        this.testFun$proxy5$1();
        return BoxedUnit.UNIT;
    }

    private final void testFun$proxy6$1() {
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).build();
        GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, null, (SolrParams)new SolrQuery("cat:cat1").add("wt", new String[]{"xml"}));
        request.setResponseParser((ResponseParser)new NoOpResponseParser());
        scala.concurrent.Future response = (scala.concurrent.Future)solr.execute((SolrRequest)request, SolrResponseFactory$.MODULE$.simpleSolrResponseFactory());
        Elem xml = (Elem)XML$.MODULE$.loadString(((SimpleSolrResponse)this.await(response, (Duration)this.timeout)).getResponse().get("response").toString());
        this.should((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("result").$bslash("@numFound").text()))), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default(), this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$6() {
        this.testFun$proxy6$1();
        return BoxedUnit.UNIT;
    }

    private final Object testFun$proxy7$1$$anonfun$1(scala.concurrent.Future response$1) {
        return this.await(response$1, (Duration)this.timeout);
    }

    private final Object testFun$proxy7$1$$anonfun$2(scala.concurrent.Future response$2) {
        return this.await(response$2, (Duration)this.timeout);
    }

    private final Assertion testFun$proxy7$1() {
        scala.concurrent.Future response = (scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("fieldDoesNotExist:foo"));
        this.awaitReady(response, (Duration)this.timeout);
        this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142)).thrownBy(() -> this.testFun$proxy7$1$$anonfun$1(response));
        return this.should((Object)((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143)).thrownBy(() -> this.testFun$proxy7$1$$anonfun$2(response))).getMessage(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default(), this.include().apply("undefined field fieldDoesNotExist"));
    }

    private final Object fun$proxy4$1$$anonfun$7() {
        return this.testFun$proxy7$1();
    }

    private final Object testFun$proxy8$1$$anonfun$1(scala.concurrent.Future response$3) {
        return this.await(response$3, (Duration)this.timeout);
    }

    private final Object testFun$proxy8$1$$anonfun$2(scala.concurrent.Future response$4) {
        return this.await(response$4, (Duration)this.timeout);
    }

    private final void testFun$proxy8$1() {
        AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply(new StringBuilder(18).append("http://localhost:").append(this.solrRunner().port()).append("/").toString(), (FutureFactory)this.futureFactory());
        scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*"));
        this.awaitReady(response, (Duration)this.timeout);
        this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152)).thrownBy(() -> this.testFun$proxy8$1$$anonfun$1(response));
        this.should((Object)((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)).thrownBy(() -> this.testFun$proxy8$1$$anonfun$2(response))).getMessage(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default(), this.include().apply("Expected mime type [] but got [text/html]"));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$8() {
        this.testFun$proxy8$1();
        return BoxedUnit.UNIT;
    }

    private final void testFun$proxy9$1() {
        Metrics metrics = (Metrics)this.mock(Tag$.MODULE$.apply(Metrics.class, LightTypeTag$.MODULE$.parse(-2122545831, "\u0004\u0000\u0001\u0014io.ino.solrs.Metrics\u0001\u0001", "\u0000\u0000\u0000", 30)));
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withMetrics(metrics).build();
        this.await((scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*")), (Duration)this.timeout);
        ((Metrics)Mockito.verify((Object)metrics)).requestTime(ArgumentMatchers.anyLong());
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$9() {
        this.testFun$proxy9$1();
        return BoxedUnit.UNIT;
    }

    private final void testFun$proxy10$1() {
        ObjectRef capturedServer = ObjectRef.create(null);
        ObjectRef capturedRequest = ObjectRef.create(null);
        RequestInterceptor interceptor = new RequestInterceptor(capturedServer, capturedRequest){
            private final ObjectRef capturedServer$1;
            private final ObjectRef capturedRequest$1;
            {
                this.capturedServer$1 = capturedServer$2;
                this.capturedRequest$1 = capturedRequest$2;
            }

            public Future interceptRequest(Function2 f, SolrServer solrServer, SolrRequest r) {
                SolrServer solrServer2 = solrServer;
                this.capturedServer$1.elem = solrServer2;
                solrServer2 = null;
                SolrRequest solrRequest = r;
                this.capturedRequest$1.elem = solrRequest;
                solrRequest = null;
                return (Future)f.apply((Object)solrServer, (Object)r);
            }
        };
        AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withRequestInterceptor(interceptor).build();
        SolrQuery q = new SolrQuery("*:*");
        this.await((scala.concurrent.Future)solr.query((SolrParams)q), (Duration)this.timeout);
        this.should((Object)((SolrServer)capturedServer.elem), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186), Prettifier$.MODULE$.default(), this.be().apply((Object)SolrServer$.MODULE$.apply(this.solrUrl())));
        this.should((Object)((QueryRequest)((SolrRequest)capturedRequest.elem)).getParams(), Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187), Prettifier$.MODULE$.default(), this.be().apply((Object)q));
        solr.shutdown();
    }

    private final Object fun$proxy4$1$$anonfun$10() {
        this.testFun$proxy10$1();
        return BoxedUnit.UNIT;
    }

    private final void fun$proxy4$1() {
        AnyFunSpecLike.ItWord ItWord_this = this.it();
        ArraySeq testTags$proxy1 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61);
        ItWord_this.inline$applyImpl("should allow to transform the response", (Seq)testTags$proxy1, this::fun$proxy4$1$$anonfun$1, position);
        AnyFunSpecLike.ItWord ItWord_this2 = this.it();
        ArraySeq testTags$proxy2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position2 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67);
        ItWord_this2.inline$applyImpl("should allow to regularly observe the server status", (Seq)testTags$proxy2, this::fun$proxy4$1$$anonfun$2, position2);
        AnyFunSpecLike.ItWord ItWord_this3 = this.it();
        ArraySeq testTags$proxy3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position3 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89);
        ItWord_this3.inline$applyImpl("should be built with LoadBalancer", (Seq)testTags$proxy3, this::fun$proxy4$1$$anonfun$3, position3);
        AnyFunSpecLike.ItWord ItWord_this4 = this.it();
        ArraySeq testTags$proxy4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position4 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95);
        ItWord_this4.inline$applyImpl("should allow to set the http client", (Seq)testTags$proxy4, this::fun$proxy4$1$$anonfun$4, position4);
        AnyFunSpecLike.ItWord ItWord_this5 = this.it();
        ArraySeq testTags$proxy5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position5 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106);
        ItWord_this5.inline$applyImpl("should allow to set the response parser", (Seq)testTags$proxy5, this::fun$proxy4$1$$anonfun$5, position5);
        AnyFunSpecLike.ItWord ItWord_this6 = this.it();
        ArraySeq testTags$proxy6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position6 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117);
        ItWord_this6.inline$applyImpl("should allow to override the response parser per request", (Seq)testTags$proxy6, this::fun$proxy4$1$$anonfun$6, position6);
        AnyFunSpecLike.ItWord ItWord_this7 = this.it();
        ArraySeq testTags$proxy7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position7 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137);
        ItWord_this7.inline$applyImpl("should return failed future on request with bad query", (Seq)testTags$proxy7, this::fun$proxy4$1$$anonfun$7, position7);
        AnyFunSpecLike.ItWord ItWord_this8 = this.it();
        ArraySeq testTags$proxy8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position8 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146);
        ItWord_this8.inline$applyImpl("should return failed future on wrong request path", (Seq)testTags$proxy8, this::fun$proxy4$1$$anonfun$8, position8);
        AnyFunSpecLike.ItWord ItWord_this9 = this.it();
        ArraySeq testTags$proxy9 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position9 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159);
        ItWord_this9.inline$applyImpl("should gather request time metrics", (Seq)testTags$proxy9, this::fun$proxy4$1$$anonfun$9, position9);
        AnyFunSpecLike.ItWord ItWord_this10 = this.it();
        ArraySeq testTags$proxy10 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]);
        Position position10 = Position$.MODULE$.apply("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170);
        ItWord_this10.inline$applyImpl("should allow to intercept requests", (Seq)testTags$proxy10, this::fun$proxy4$1$$anonfun$10, position10);
    }

    private final void $init$$$anonfun$1() {
        this.fun$proxy4$1();
    }

    private final UpdateResponse fun$proxy1$1() {
        return this.solrJClient().deleteByQuery("*:*");
    }

    private final UpdateResponse beforeEach$$anonfun$1() {
        return this.fun$proxy1$1();
    }
}

