/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.PingStatusObserver$;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StaticSolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.FutureFactory$;
import io.ino.solrs.future.Promise;
import io.ino.solrs.future.ScalaFutureFactory$;
import java.io.Serializable;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\b\u0010\u0001YA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!AQ\b\u0001B\u0001B\u0003-a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003E\u0001\u0011\u00051\nC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u001d\u0004\u0001\u0015!\u0003b\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0001\b\u0001\"\u0003r\u000f%\t9aDA\u0001\u0012\u0003\tIA\u0002\u0005\u000f\u001f\u0005\u0005\t\u0012AA\u0006\u0011\u0019!5\u0002\"\u0001\u0002\u000e!I\u0011qB\u0006\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0002\u0013!&twm\u0015;biV\u001cxJY:feZ,'O\u0003\u0002\u0011#\u0005)1o\u001c7sg*\u0011!cE\u0001\u0004S:|'\"\u0001\u000b\u0002\u0005%|7\u0001A\u000b\u0003/\u0011\u001a2\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0019q\u0004\t\u0012\u000e\u0003=I!!I\b\u0003'M+'O^3s'R\fG/Z(cg\u0016\u0014h/\u001a:\u0011\u0005\r\"C\u0002\u0001\u0003\u0006K\u0001\u0011\rA\n\u0002\u0002\rV\u0011qEL\t\u0003Q-\u0002\"!G\u0015\n\u0005)R\"a\u0002(pi\"Lgn\u001a\t\u000331J!!\f\u000e\u0003\u0007\u0005s\u0017\u0010B\u00030I\t\u0007qE\u0001\u0003`I\u0011\u001a\u0014aC:pYJ\u001cVM\u001d<feN\u0004\"a\b\u001a\n\u0005Mz!aC*pYJ\u001cVM\u001d<feN\f!\u0002\u001b;ua\u000ec\u0017.\u001a8u!\t14(D\u00018\u0015\tA\u0014(A\bbgft7\r\u001b;ua\u000ed\u0017.\u001a8u\u0015\u0005Q\u0014aA8sO&\u0011Ah\u000e\u0002\u0010\u0003NLhn\u0019%uiB\u001cE.[3oi\u0006ia-\u001e;ve\u00164\u0015m\u0019;pef\u00042a\u0010\"#\u001b\u0005\u0001%BA!\u0010\u0003\u00191W\u000f^;sK&\u00111\t\u0011\u0002\u000e\rV$XO]3GC\u000e$xN]=\u0002\rqJg.\u001b;?)\r1\u0015J\u0013\u000b\u0003\u000f\"\u00032a\b\u0001#\u0011\u0015iD\u0001q\u0001?\u0011\u0015\u0001D\u00011\u00012\u0011\u0015!D\u00011\u00016)\raeJ\u0018\u000b\u0003\u000f6Cq!P\u0003\u0011\u0002\u0003\u000fa\bC\u00031\u000b\u0001\u0007q\nE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Q+\u0012A\u0002\u001fs_>$h(C\u0001\u001c\u0013\t9&$A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&aA*fc*\u0011qK\u0007\t\u0003?qK!!X\b\u0003\u0015M{GN]*feZ,'\u000fC\u00035\u000b\u0001\u0007Q'\u0001\u0004m_\u001e<WM]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011A-O\u0001\u0006g24GG[\u0005\u0003M\u000e\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0012G\",7m[*feZ,'o\u0015;biV\u001cH#\u00016\u0011\u0007}ZW.\u0003\u0002m\u0001\n1a)\u001e;ve\u0016\u0004\"!\u00078\n\u0005=T\"\u0001B+oSR\f!#\u001e9eCR,7+\u001a:wKJ\u001cF/\u0019;vgR!QN\u001d;z\u0011\u0015\u0019\u0018\u00021\u0001\\\u0003\u0019\u0019XM\u001d<fe\")Q/\u0003a\u0001m\u0006A!/Z:q_:\u001cX\r\u0005\u00027o&\u0011\u0001p\u000e\u0002\t%\u0016\u001c\bo\u001c8tK\")!0\u0003a\u0001w\u0006\u0019QO\u001d7\u0011\u0007q\f\tA\u0004\u0002~}B\u0011!KG\u0005\u0003\u007fj\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003\u000b\u0011aa\u0015;sS:<'BA@\u001b\u0003I\u0001\u0016N\\4Ti\u0006$Xo](cg\u0016\u0014h/\u001a:\u0011\u0005}Y1CA\u0006\u0019)\t\tI!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0005\u0003'\t\u0019\u0004\u0006\u0004\u0002\u0016\u0005=\u0012\u0011\u0007\u0016\u0005\u0003/\tiBD\u0002@\u00033I1!a\u0007A\u0003I\u00196-\u00197b\rV$XO]3GC\u000e$xN]=,\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000b\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003[\t\u0019CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQ\u0001M\u0007A\u0002=CQ\u0001N\u0007A\u0002U\"a!J\u0007C\u0002\u0005URcA\u0014\u00028\u00111q&a\rC\u0002\u001d\u0002")
public class PingStatusObserver<F>
implements ServerStateObserver<F> {
    private final SolrServers solrServers;
    private final AsyncHttpClient httpClient;
    private final FutureFactory<F> futureFactory;
    private final Logger io$ino$solrs$PingStatusObserver$$logger;

    public static <F> ScalaFutureFactory$ $lessinit$greater$default$3(Seq<SolrServer> solrServers, AsyncHttpClient httpClient) {
        return PingStatusObserver$.MODULE$.$lessinit$greater$default$3(solrServers, httpClient);
    }

    public Logger io$ino$solrs$PingStatusObserver$$logger() {
        return this.io$ino$solrs$PingStatusObserver$$logger;
    }

    @Override
    public Future<BoxedUnit> checkServerStatus() {
        Seq futures = (Seq)this.solrServers.all().map((Function1 & Serializable)server -> {
            String url = new StringBuilder(32).append(server.baseUrl()).append("/admin/ping?action=status&wt=xml").toString();
            Promise promise = $this.futureFactory.newPromise();
            $this.httpClient.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandler<Response>(this, server, url, promise){
                private final /* synthetic */ PingStatusObserver $outer;
                private final SolrServer server$1;
                private final String url$1;
                private final Promise promise$1;

                public Response onCompleted(Response response) {
                    this.$outer.io$ino$solrs$PingStatusObserver$$updateServerStatus(this.server$1, response, this.url$1);
                    new Success((Object)this.server$1.status());
                    this.promise$1.success(BoxedUnit.UNIT);
                    return response;
                }

                public void onThrowable(Throwable t) {
                    ServerStatus serverStatus = this.server$1.status();
                    Failed$ failed$ = Failed$.MODULE$;
                    if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                        this.$outer.io$ino$solrs$PingStatusObserver$$logger().error(new StringBuilder(82).append("An error occurred when trying to get ping status from ").append(this.url$1).append(", changing status to Failed.").toString(), t);
                        this.server$1.status_$eq(Failed$.MODULE$);
                    }
                    this.promise$1.failure(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.server$1 = server$1;
                    this.url$1 = url$1;
                    this.promise$1 = promise$1;
                }
            });
            return promise.future();
        });
        return FutureFactory$.MODULE$.sequence(futures, BuildFrom$.MODULE$.buildFromIterableOps(), this.futureFactory).map((Function1 & Serializable)x$1 -> {
            PingStatusObserver.$anonfun$checkServerStatus$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void io$ino$solrs$PingStatusObserver$$updateServerStatus(SolrServer server, Response response, String url) {
        if (response.getStatusCode() != 200) {
            this.io$ino$solrs$PingStatusObserver$$logger().warn(new StringBuilder(58).append("Got ping response status != 200 (").append(response.getStatusCode()).append(") from ").append(url).append(", with response '").append(new String(response.getResponseBodyAsBytes())).append("'").toString());
            server.status_$eq(Failed$.MODULE$);
            return;
        }
        Elem xml = (Elem)XML$.MODULE$.load(response.getResponseBodyAsStream());
        Option option = xml.$bslash$bslash("response").$bslash("str").find((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)PingStatusObserver.$anonfun$updateServerStatus$1(node)));
        if (None$.MODULE$.equals(option)) {
            ServerStatus serverStatus = server.status();
            Failed$ failed$ = Failed$.MODULE$;
            if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                this.io$ino$solrs$PingStatusObserver$$logger().warn(new StringBuilder(83).append("Could not find status in ping response from ").append(url).append(", changing status to Failed. Response:\n").append(xml).toString());
                server.status_$eq(Failed$.MODULE$);
                return;
            }
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Node statusNode = (Node)some.value();
            String string = statusNode.text();
            String string2 = "enabled";
            Product status = !(string != null ? !string.equals(string2) : string2 != null) ? Enabled$.MODULE$ : Disabled$.MODULE$;
            ServerStatus serverStatus = server.status();
            Product product = status;
            if (serverStatus == null ? product != null : !serverStatus.equals(product)) {
                this.io$ino$solrs$PingStatusObserver$$logger().info(new StringBuilder(38).append("Changing status for server ").append(server.baseUrl()).append(" from ").append(server.status()).append(" to ").append(status).append(".").toString());
                server.status_$eq((ServerStatus)status);
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$checkServerStatus$2(Seq x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$updateServerStatus$1(Node node) {
        String string = node.$bslash("@name").text();
        String string2 = "status";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PingStatusObserver(SolrServers solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this.solrServers = solrServers;
        this.httpClient = httpClient;
        this.futureFactory = futureFactory;
        this.io$ino$solrs$PingStatusObserver$$logger = LoggerFactory.getLogger(this.getClass());
    }

    public PingStatusObserver(Seq<SolrServer> solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this(new StaticSolrServers((IndexedSeq<SolrServer>)solrServers.toIndexedSeq()), httpClient, futureFactory);
    }
}

