/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.JavaAsyncSolrClient;
import io.ino.solrs.SolrResponseFactory;
import io.ino.solrs.SolrRunner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.beans.Field;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.json.DirectJsonQueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;

public class JavaAPIFunTest
extends JUnitSuite {
    private static final long serialVersionUID = 1L;
    private static SolrRunner solrRunner;
    private static SolrClient solr;
    private static JavaAsyncSolrClient solrs;

    @BeforeClass
    public static void beforeClass() {
        solrRunner = SolrRunner.startOnce(8888).awaitReady(10L, TimeUnit.SECONDS);
        String string = "http://localhost:" + solrRunner.port() + "/solr/collection1";
        solr = new Http2SolrClient.Builder(string).build();
        solrs = JavaAsyncSolrClient.create((String)string);
    }

    @Before
    public void before() throws IOException, SolrServerException {
        solr.deleteByQuery("*:*");
    }

    @AfterClass
    public static void afterClass() throws IOException {
        solr.close();
        solrs.shutdown();
    }

    @Test
    public void testExecuteQuery() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat2", 20.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2));
        solr.commit();
        DirectJsonQueryRequest directJsonQueryRequest = new DirectJsonQueryRequest("{\"query\": \"cat:cat1\"}");
        SolrResponseFactory solrResponseFactory = SolrResponseFactory.queryResponseFactory();
        SolrDocumentList solrDocumentList = ((QueryResponse)solrs.execute((SolrRequest)directJsonQueryRequest, solrResponseFactory).toCompletableFuture().get()).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)((SolrDocument)solrDocumentList.get(0)).getFieldValue("id"), (Matcher)CoreMatchers.is((Object)"id1"));
    }

    @Test
    public void testAddDocsAsCollection() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        solrs.addDocs(Arrays.asList(solrInputDocument, solrInputDocument2)).toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f), Float.valueOf(20.0f)}));
    }

    @Test
    public void testAddDocsAsIterator() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        solrs.addDocs(Arrays.asList(solrInputDocument, solrInputDocument2).iterator()).toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f), Float.valueOf(20.0f)}));
    }

    @Test
    public void testAddDoc() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        solrs.addDoc(this.newInputDoc("id1", "doc1", "cat1", 10.0f)).toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f)}));
    }

    @Test
    public void testAddBean() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        TestBean testBean = new TestBean("id1", "doc1", "cat1", 10.0f);
        solrs.addBean((Object)testBean).toCompletableFuture().get();
        solr.commit();
        QueryResponse queryResponse = solr.query((SolrParams)new SolrQuery("*:*"));
        MatcherAssert.assertThat((Object)queryResponse.getResults().getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)queryResponse.getBeans(TestBean.class), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new TestBean[]{testBean}));
    }

    @Test
    public void testAddBeansAsIterable() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        TestBean testBean = new TestBean("id1", "doc1", "cat1", 10.0f);
        TestBean testBean2 = new TestBean("id2", "doc2", "cat1", 20.0f);
        solrs.addBeans(Arrays.asList(testBean, testBean2)).toCompletableFuture().get();
        solr.commit();
        QueryResponse queryResponse = solr.query((SolrParams)new SolrQuery("*:*"));
        MatcherAssert.assertThat((Object)queryResponse.getResults().getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)queryResponse.getBeans(TestBean.class), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new TestBean[]{testBean, testBean2}));
    }

    @Test
    public void testAddBeansAsIterator() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        TestBean testBean = new TestBean("id1", "doc1", "cat1", 10.0f);
        TestBean testBean2 = new TestBean("id2", "doc2", "cat1", 20.0f);
        solrs.addBeans(Arrays.asList(testBean, testBean2).iterator()).toCompletableFuture().get();
        solr.commit();
        QueryResponse queryResponse = solr.query((SolrParams)new SolrQuery("*:*"));
        MatcherAssert.assertThat((Object)queryResponse.getResults().getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat((Object)queryResponse.getBeans(TestBean.class), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new TestBean[]{testBean, testBean2}));
    }

    @Test
    public void testCommit() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        solr.add(this.newInputDoc("id1", "doc1", "cat1", 10.0f));
        solrs.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f)}));
    }

    @Test
    public void testDeleteById() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2));
        solr.commit();
        solrs.deleteById("id1").toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(20.0f)}));
    }

    @Test
    public void testDeleteByIds() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        SolrInputDocument solrInputDocument3 = this.newInputDoc("id3", "doc3", "cat2", 30.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2, solrInputDocument3));
        solr.commit();
        solrs.deleteByIds(Arrays.asList("id1", "id2")).toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(30.0f)}));
    }

    @Test
    public void testDeleteByQuery() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        SolrInputDocument solrInputDocument3 = this.newInputDoc("id3", "doc3", "cat2", 30.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2, solrInputDocument3));
        solr.commit();
        solrs.deleteByQuery("cat:cat1").toCompletableFuture().get();
        solr.commit();
        SolrDocumentList solrDocumentList = solr.query((SolrParams)new SolrQuery("*:*")).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)1L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(30.0f)}));
    }

    @Test
    public void testQuery() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        SolrInputDocument solrInputDocument3 = this.newInputDoc("id3", "doc3", "cat2", 30.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2, solrInputDocument3));
        solr.commit();
        SolrDocumentList solrDocumentList = ((QueryResponse)solrs.query((SolrParams)new SolrQuery("cat:cat1")).toCompletableFuture().get()).getResults();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f), Float.valueOf(20.0f)}));
    }

    @Test
    public void testGetById() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2));
        solr.commit();
        MatcherAssert.assertThat(((Optional)solrs.getById("id1").toCompletableFuture().get()).map(this::getPrice), (Matcher)CoreMatchers.equalTo(Optional.of(Float.valueOf(10.0f))));
    }

    @Test
    public void testGetByIdAbsent() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        solr.add(this.newInputDoc("id1", "doc1", "cat1", 10.0f));
        solr.commit();
        Assert.assertFalse((boolean)((Optional)solrs.getById("id2").toCompletableFuture().get()).isPresent());
    }

    @Test
    public void testGetByIds() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        SolrInputDocument solrInputDocument = this.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument solrInputDocument2 = this.newInputDoc("id2", "doc2", "cat1", 20.0f);
        SolrInputDocument solrInputDocument3 = this.newInputDoc("id3", "doc3", "cat2", 30.0f);
        solr.add(Arrays.asList(solrInputDocument, solrInputDocument2, solrInputDocument3));
        solr.commit();
        SolrDocumentList solrDocumentList = (SolrDocumentList)solrs.getByIds(Arrays.asList("id1", "id2")).toCompletableFuture().get();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)2L));
        MatcherAssert.assertThat(solrDocumentList.stream().map(this::getPrice).collect(Collectors.toList()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Object[]{Float.valueOf(10.0f), Float.valueOf(20.0f)}));
    }

    @Test
    public void testGetByIdsAbsent() throws ExecutionException, InterruptedException, IOException, SolrServerException {
        solr.add(this.newInputDoc("id1", "doc1", "cat1", 10.0f));
        solr.commit();
        SolrDocumentList solrDocumentList = (SolrDocumentList)solrs.getByIds(Arrays.asList("id2", "id3")).toCompletableFuture().get();
        MatcherAssert.assertThat((Object)solrDocumentList.getNumFound(), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertTrue((boolean)solrDocumentList.isEmpty());
    }

    private SolrInputDocument newInputDoc(String string, String string2, String string3, float f) {
        SolrInputDocument solrInputDocument = new SolrInputDocument();
        solrInputDocument.addField("id", (Object)string);
        solrInputDocument.addField("name", (Object)string2);
        solrInputDocument.addField("cat", (Object)string3);
        solrInputDocument.addField("price", (Object)Float.valueOf(f));
        return solrInputDocument;
    }

    private Object getPrice(SolrDocument solrDocument) {
        return solrDocument.getFieldValue("price");
    }

    public static class TestBean {
        @Field
        private String id;
        @Field
        private String name;
        @Field
        private String category;
        @Field
        private float price;

        public TestBean() {
        }

        TestBean(String string, String string2, String string3, float f) {
            this.id = string;
            this.name = string2;
            this.category = string3;
            this.price = f;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String string) {
            this.category = string;
        }

        public float getPrice() {
            return this.price;
        }

        public void setPrice(float f) {
            this.price = f;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TestBean testBean = (TestBean)object;
            return Float.compare(testBean.price, this.price) == 0 && Objects.equals(this.id, testBean.id) && Objects.equals(this.name, testBean.name) && Objects.equals(this.category, testBean.category);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.category, Float.valueOf(this.price));
        }
    }
}

