/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.FutureFactory;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Closeable;
import java.io.Serializable;
import java.net.ConnectException;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Request;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005Q2AAB\u0004\u0001\u001d!)1\u0003\u0001C\u0001)!9a\u0003\u0001b\u0001\n\u00139\u0002B\u0002\u0014\u0001A\u0003%\u0001\u0004C\u0004(\u0001\t\u0007I1\u0002\u0015\t\rM\u0002\u0001\u0015!\u0003*\u0005M\t5/\u001f8d'>d'o\u00117jK:$8\u000b]3d\u0015\tA\u0011\"A\u0003t_2\u00148O\u0003\u0002\u000b\u0017\u0005\u0019\u0011N\\8\u000b\u00031\t!![8\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Ei\u0011aB\u0005\u0003%\u001d\u0011qb\u0015;b]\u0012\f'\u000f\u001a$v]N\u0003XmY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"\u0001\u0005\u0001\u0002\u000bE,XM]=\u0016\u0003a\u0001\"!\u0007\u0013\u000e\u0003iQ!a\u0007\u000f\u0002\u000bM|GN\u001d6\u000b\u0005uq\u0012AB2mS\u0016tGO\u0003\u0002 A\u0005!1o\u001c7s\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015R\"!C*pYJ\fV/\u001a:z\u0003\u0019\tX/\u001a:zA\u00059A/[7f_V$X#A\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00059z\u0013AC2p]\u000e,(O]3oi*\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023W\tqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011")
public class AsyncSolrClientSpec
extends StandardFunSpec {
    private final SolrQuery query = new SolrQuery("*:*");
    private final FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();

    private SolrQuery query() {
        return this.query;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    public AsyncSolrClientSpec() {
        this.describe("Solr", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.it().apply("should return failed future on connection refused", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply("http://localhost:12345/solr", (FutureFactory)this.futureFactory());
                Future response = (Future)solr.query((SolrParams)this.query());
                this.awaitReady(response, (Duration)this.timeout());
                return this.a(ClassTag$.MODULE$.apply(ConnectException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
            }, new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
            this.it().apply("should return failed future on AHC IOException", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                DefaultAsyncHttpClient ahc = new DefaultAsyncHttpClient();
                DefaultAsyncHttpClient ahcSpy = (DefaultAsyncHttpClient)Mockito.spy((Object)ahc);
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply("http://localhost:12345/solr", (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)ahcSpy).build();
                NoStackTrace ex = new NoStackTrace(null){

                    public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                        return super.fillInStackTrace();
                    }

                    public Throwable fillInStackTrace() {
                        return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
                    }
                    {
                        NoStackTrace.$init$((NoStackTrace)this);
                    }
                };
                ((DefaultAsyncHttpClient)Mockito.doThrow((Throwable[])new Throwable[]{ex}).when((Object)ahcSpy)).executeRequest((Request)ArgumentMatchers.any(), (AsyncHandler)ArgumentMatchers.any());
                Future response = (Future)solr.query((SolrParams)this.query());
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RuntimeException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                ahc.close();
            }, new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            this.it().apply("should shutdown http client if it was not provided", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncHttpClient ahcMock = (AsyncHttpClient)this.mock(Tag$.MODULE$.apply(AsyncHttpClient.class, LightTypeTag$.MODULE$.parse(1014395864, "\u0004\u0000\u0001#org.asynchttpclient.AsyncHttpClient\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001#org.asynchttpclient.AsyncHttpClient\u0001\u0001\u0002\u0004\u0000\u0001\u0011java.io.Closeable\u0001\u0001\u0004\u0000\u0001\u0017java.lang.AutoCloseable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21)));
                AsyncSolrClient solr = new AsyncSolrClient.Builder<?, AsyncSolrClient<Future>>(this, ahcMock){
                    private final AsyncHttpClient ahcMock$1;

                    public AsyncHttpClient createHttpClient() {
                        return this.ahcMock$1;
                    }
                    {
                        this.ahcMock$1 = ahcMock$1;
                        super("http://localhost:12345/solr", $outer.ascFactory(), (FutureFactory)$outer.futureFactory());
                    }
                }.build();
                solr.shutdown();
                ((Closeable)Mockito.verify((Object)ahcMock)).close();
            }, new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            this.it().apply("should not shutdown http client if it was provided", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncHttpClient ahcMock = (AsyncHttpClient)this.mock(Tag$.MODULE$.apply(AsyncHttpClient.class, LightTypeTag$.MODULE$.parse(1014395864, "\u0004\u0000\u0001#org.asynchttpclient.AsyncHttpClient\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001#org.asynchttpclient.AsyncHttpClient\u0001\u0001\u0002\u0004\u0000\u0001\u0011java.io.Closeable\u0001\u0001\u0004\u0000\u0001\u0017java.lang.AutoCloseable\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001", 21)));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply("http://localhost:12345/solr", (FutureFactory)this.futureFactory()).withHttpClient(ahcMock).build();
                solr.shutdown();
                ((Closeable)Mockito.verify((Object)ahcMock, (VerificationMode)Mockito.times((int)0))).close();
            }, new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        }, new Position("AsyncSolrClientSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 22));
    }
}

