/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.AsyncSolrClientIntegrationSpec$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.Metrics;
import io.ino.solrs.PingStatusObserver;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RunningSolr;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\t\u0012\u0001aAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013-A\u0005\u0003\u0004=\u0001\u0001\u0006I!\n\u0005\b{\u0001\u0011\r\u0011b\u0003?\u0011\u0019A\u0005\u0001)A\u0005\u007f!9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB)\u0001A\u0003%1\n\u0003\u0005S\u0001!\u0015\r\u0011\"\u0003T\u0011!\u0011\u0002\u0001#b\u0001\n\u0013a\u0006\"B:\u0001\t\u0003\"\b\"\u0002=\u0001\t\u0003\"\b\"B=\u0001\t\u0013Q\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011%\t\u0019\u0004AI\u0001\n\u0013\t)D\u0001\u0010Bgft7mU8me\u000ec\u0017.\u001a8u\u0013:$Xm\u001a:bi&|gn\u00159fG*\u0011!cE\u0001\u0006g>d'o\u001d\u0006\u0003)U\t1!\u001b8p\u0015\u00051\u0012AA5p\u0007\u0001\u00192\u0001A\r\u001e!\tQ2$D\u0001\u0012\u0013\ta\u0012CA\bTi\u0006tG-\u0019:e\rVt7\u000b]3d!\tQb$\u0003\u0002 #\tY!+\u001e8oS:<7k\u001c7s\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002\u001b\u0001\u0005q\u0001/\u0019;jK:\u001cWmQ8oM&<W#A\u0013\u0011\u0005\u0019BdBA\u00146\u001d\tA#G\u0004\u0002*_9\u0011!&L\u0007\u0002W)\u0011AfF\u0001\u0007yI|w\u000e\u001e \n\u00039\n1a\u001c:h\u0013\t\u0001\u0014'A\u0005tG\u0006d\u0017\r^3ti*\ta&\u0003\u00024i\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\n\u0014B\u0001\u001c8\u0003))e/\u001a8uk\u0006dG.\u001f\u0006\u0003gQJ!!\u000f\u001e\u0003\u001dA\u000bG/[3oG\u0016\u001cuN\u001c4jO&\u00111h\u000e\u0002\u001e\u0003\n\u001cHO]1diB\u000bG/[3oG\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006y\u0001/\u0019;jK:\u001cWmQ8oM&<\u0007%A\u0004uS6,w.\u001e;\u0016\u0003}\u0002\"\u0001\u0011$\u000e\u0003\u0005S!AQ\"\u0002\u0011\u0011,(/\u0019;j_:T!a\r#\u000b\u0003\u0015\u000bQa]2bY\u0006L!aR!\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006AA/[7f_V$\b%\u0001\u0006iiR\u00048\t\\5f]R,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001dF\nq\"Y:z]\u000eDG\u000f\u001e9dY&,g\u000e^\u0005\u0003!6\u0013a\u0003R3gCVdG/Q:z]\u000eDE\u000f\u001e9DY&,g\u000e^\u0001\fQR$\bo\u00117jK:$\b%A\u0004t_2\u0014XK\u001d7\u0016\u0003Q\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\t1\fgn\u001a\u0006\u00023\u0006!!.\u0019<b\u0013\tYfK\u0001\u0004TiJLgnZ\u000b\u0002;B\u0019!D\u00181\n\u0005}\u000b\"aD!ts:\u001c7k\u001c7s\u00072LWM\u001c;\u0016\u0005\u0005<\u0007c\u00012dK6\t1)\u0003\u0002e\u0007\n1a)\u001e;ve\u0016\u0004\"AZ4\r\u0001\u00111\u0001n\u0006CC\u0002-\u0014\u0011\u0001V\u0005\u0003U\u000e\fa\u0002\u00107pG\u0006d\u0007ER;ukJ,g(\u0005\u0002maB\u0011QN\\\u0007\u0002\t&\u0011q\u000e\u0012\u0002\b\u001d>$\b.\u001b8h!\ti\u0017/\u0003\u0002s\t\n\u0019\u0011I\\=\u0002\u0015\t,gm\u001c:f\u000b\u0006\u001c\u0007\u000eF\u0001v!\tig/\u0003\u0002x\t\n!QK\\5u\u0003!\tg\r^3s\u00032d\u0017AB3oC\ndW\r\u0006\u0002vw\")!\u000b\u0004a\u0001yB\u0019Q0a\u0001\u000f\u0005y|\bC\u0001\u0016E\u0013\r\t\t\u0001R\u0001\u0007!J,G-\u001a4\n\u0007m\u000b)AC\u0002\u0002\u0002\u0011\u000bq\u0001Z5tC\ndW\rF\u0002v\u0003\u0017AQAU\u0007A\u0002q\f\u0011b]3u'R\fG/^:\u0015\u0013U\f\t\"a\u0005\u0002\u0018\u0005\u0005\u0002\"\u0002*\u000f\u0001\u0004a\bBBA\u000b\u001d\u0001\u0007A0\u0001\u0004bGRLwN\u001c\u0005\b\u00033q\u0001\u0019AA\u000e\u00039)\u0007\u0010]3di\u0016$7\u000b^1ukN\u00042!\\A\u000f\u0013\r\ty\u0002\u0012\u0002\u0004\u0013:$\b\"CA\u0012\u001dA\u0005\t\u0019AA\u000e\u0003\u001d\tG\u000f^3naRD3ADA\u0014!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\bi\u0006LGN]3d\u0003M\u0019X\r^*uCR,8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9D\u000b\u0003\u0002\u001c\u0005e2FAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"\u0002BA!\u0003W\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\u0005\u0015\u0013q\b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AsyncSolrClientIntegrationSpec
extends StandardFunSpec
implements RunningSolr {
    private String solrUrl;
    private AsyncSolrClient<?> solrs;
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig;
    private final FiniteDuration timeout;
    private final DefaultAsyncHttpClient httpClient;
    private SolrRunner solrRunner;
    private HttpSolrClient solrJClient;
    private volatile byte bitmap$0;

    @Override
    public void beforeAll() {
        RunningSolr.beforeAll$(this);
    }

    @Override
    public SolrRunner solrRunner() {
        return this.solrRunner;
    }

    @Override
    public void solrRunner_$eq(SolrRunner x$1) {
        this.solrRunner = x$1;
    }

    @Override
    public HttpSolrClient solrJClient() {
        return this.solrJClient;
    }

    @Override
    public void solrJClient_$eq(HttpSolrClient x$1) {
        this.solrJClient = x$1;
    }

    private AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return this.patienceConfig;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    private DefaultAsyncHttpClient httpClient() {
        return this.httpClient;
    }

    private String solrUrl$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.solrUrl = new StringBuilder(34).append("http://localhost:").append(this.solrRunner().port()).append("/solr/collection1").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.solrUrl;
    }

    private String solrUrl() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.solrUrl$lzycompute();
        }
        return this.solrUrl;
    }

    private AsyncSolrClient<?> solrs$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.solrs = AsyncSolrClient$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.solrs;
    }

    private AsyncSolrClient<?> solrs() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.solrs$lzycompute();
        }
        return this.solrs;
    }

    @Override
    public void beforeEach() {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0 & Serializable)() -> this.solrJClient().deleteByQuery("*:*"), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        SolrInputDocument doc1 = SolrUtils$.MODULE$.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument doc2 = SolrUtils$.MODULE$.newInputDoc("id2", "doc2", "cat1", 20.0f);
        this.solrJClient().add(Arrays.asList((Object[])new SolrInputDocument[]{doc1, doc2}));
        this.solrJClient().commit();
    }

    @Override
    public void afterAll() {
        RunningSolr.afterAll$(this);
        this.solrs().shutdown();
        this.httpClient().close();
    }

    private void enable(String solrUrl) {
        this.setStatus(solrUrl, "enable", 200, this.setStatus$default$4());
    }

    private void disable(String solrUrl) {
        this.setStatus(solrUrl, "disable", 503, this.setStatus$default$4());
    }

    private void setStatus(String solrUrl, String action, int expectedStatus, int attempt) {
        while (true) {
            Response response = (Response)this.httpClient().prepareGet(new StringBuilder(26).append(solrUrl).append("/admin/ping?action=").append(action).append("&wt=xml").toString()).execute().get();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)response.getStatusCode()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)200));
            int newStatusCode = ((Response)this.httpClient().prepareGet(new StringBuilder(18).append(solrUrl).append("/admin/ping?wt=xml").toString()).execute().get()).getStatusCode();
            if (newStatusCode != expectedStatus && attempt > 3) {
                throw new IllegalStateException(new StringBuilder(65).append("Could not reach expected status ").append(expectedStatus).append(" via action '").append(action).append("', reached ").append(newStatusCode).append(" instead.").toString());
            }
            if (newStatusCode == expectedStatus) break;
            Thread.sleep(20L);
            ++attempt;
        }
    }

    private int setStatus$default$4() {
        return 1;
    }

    public static final /* synthetic */ Assertion $anonfun$new$5(AsyncSolrClientIntegrationSpec $this, Seq solrServers$1) {
        return $this.convertToAnyShouldWrapper(((SolrServer)solrServers$1.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).should($this.be().apply((Object)Enabled$.MODULE$));
    }

    public static final /* synthetic */ Assertion $anonfun$new$6(AsyncSolrClientIntegrationSpec $this, Seq solrServers$1) {
        return $this.convertToAnyShouldWrapper(((SolrServer)solrServers$1.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).should($this.be().apply((Object)Disabled$.MODULE$));
    }

    public AsyncSolrClientIntegrationSpec() {
        RunningSolr.$init$(this);
        this.patienceConfig = new AbstractPatienceConfiguration.PatienceConfig((AbstractPatienceConfiguration)Eventually$.MODULE$, Eventually$.MODULE$.scaled(Span$.MODULE$.apply(10000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20L, (Units)Millis$.MODULE$)));
        this.timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        this.httpClient = new DefaultAsyncHttpClient();
        this.describe("Solr", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.it().apply("should allow to transform the response", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                scala.concurrent.Future response = ((scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("cat:cat1"))).map((Function1 & Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
                return this.convertToAnyShouldWrapper(this.await(response, (Duration)this.timeout()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2"})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.it().apply("should allow to regularly observe the server status", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                .colon.colon solrServers = new .colon.colon((Object)SolrServer$.MODULE$.apply(this.solrUrl()), (List)Nil$.MODULE$);
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).withServerStateObservation((ServerStateObserver)new PingStatusObserver((Seq)solrServers, (AsyncHttpClient)this.httpClient(), (FutureFactory)this.futureFactory()), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), Executors.newSingleThreadScheduledExecutor()).build();
                this.enable(this.solrUrl());
                Eventually$.MODULE$.eventually(() -> AsyncSolrClientIntegrationSpec.$anonfun$new$5(this, (Seq)solrServers), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                this.disable(this.solrUrl());
                Eventually$.MODULE$.eventually(() -> AsyncSolrClientIntegrationSpec.$anonfun$new$6(this, (Seq)solrServers), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.it().apply("should be built with LoadBalancer", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.it().apply("should allow to set the http client", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.it().apply("should allow to set the response parser", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            this.it().apply("should allow to override the response parser per request", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).build();
                GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, null, (SolrParams)new SolrQuery("cat:cat1").add("wt", new String[]{"xml"}));
                request.setResponseParser((ResponseParser)new NoOpResponseParser());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.execute((SolrRequest)request, SolrResponseFactory$.MODULE$.simpleSolrResponseFactory());
                Elem xml = (Elem)XML$.MODULE$.loadString(((SimpleSolrResponse)this.await(response, (Duration)this.timeout())).getResponse().get("response").toString());
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("result").$bslash("@numFound").text()))), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.it().apply("should return failed future on request with bad query", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
                scala.concurrent.Future response = (scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("fieldDoesNotExist:foo"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                return this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).should(this.include().apply("undefined field fieldDoesNotExist"));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.it().apply("should return failed future on wrong request path", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply(new StringBuilder(18).append("http://localhost:").append(this.solrRunner().port()).append("/").toString(), (FutureFactory)this.futureFactory());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).should(this.include().apply("Expected mime type [] but got [text/html]"));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            this.it().apply("should gather request time metrics", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AsyncSolrClientIntegrationSpec.class.getClassLoader());
                public final class Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("io.ino.solrs.Metrics").asType().toTypeConstructor();
                    }

                    public Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(AsyncSolrClientIntegrationSpec $outer) {
                    }
                }
                Metrics metrics = (Metrics)this.mock(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(null)));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withMetrics(metrics).build();
                this.await((scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*")), (Duration)this.timeout());
                ((Metrics)Mockito.verify((Object)metrics)).requestTime(ArgumentMatchers.anyLong());
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.it().apply("should allow to intercept requests", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                ObjectRef capturedServer = ObjectRef.create(null);
                ObjectRef capturedRequest = ObjectRef.create(null);
                RequestInterceptor interceptor = new RequestInterceptor(null, capturedServer, capturedRequest){
                    private final ObjectRef capturedServer$1;
                    private final ObjectRef capturedRequest$1;

                    public <T extends SolrResponse> Future<T> interceptRequest(Function2<SolrServer, SolrRequest<? extends T>, Future<T>> f, SolrServer solrServer, SolrRequest<? extends T> r) {
                        this.capturedServer$1.elem = solrServer;
                        this.capturedRequest$1.elem = r;
                        return (Future)f.apply((Object)solrServer, r);
                    }
                    {
                        this.capturedServer$1 = capturedServer$1;
                        this.capturedRequest$1 = capturedRequest$1;
                    }
                };
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withRequestInterceptor(interceptor).build();
                SolrQuery q = new SolrQuery("*:*");
                this.await((scala.concurrent.Future)solr.query((SolrParams)q), (Duration)this.timeout());
                this.convertToAnyShouldWrapper((SolrServer)capturedServer.elem, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SolrServer$.MODULE$.apply(this.solrUrl())));
                this.convertToAnyShouldWrapper(((QueryRequest)((SolrRequest)capturedRequest.elem)).getParams(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187), Prettifier$.MODULE$.default()).should(this.be().apply((Object)q));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

