/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.AsyncSolrClientIntegrationSpec$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.Metrics;
import io.ino.solrs.PingStatusObserver;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RunningSolr;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\t\u0012\u0001aAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013-A\u0005\u0003\u0004=\u0001\u0001\u0006I!\n\u0005\b{\u0001\u0011\r\u0011b\u0003?\u0011\u0019A\u0005\u0001)A\u0005\u007f!9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB)\u0001A\u0003%1\n\u0003\u0005S\u0001!\u0015\r\u0011\"\u0003T\u0011!\u0011\u0002\u0001#b\u0001\n\u0013a\u0006\"B:\u0001\t\u0003\"\b\"\u0002=\u0001\t\u0003\"\b\"B=\u0001\t\u0013Q\b\"\u0002?\u0001\t\u0013i\bBB@\u0001\t\u0013\t\t\u0001C\u0005\u0002&\u0001\t\n\u0011\"\u0003\u0002(\tq\u0012i]=oGN{GN]\"mS\u0016tG/\u00138uK\u001e\u0014\u0018\r^5p]N\u0003Xm\u0019\u0006\u0003%M\tQa]8meNT!\u0001F\u000b\u0002\u0007%twNC\u0001\u0017\u0003\tIwn\u0001\u0001\u0014\u0007\u0001IR\u0004\u0005\u0002\u001b75\t\u0011#\u0003\u0002\u001d#\ty1\u000b^1oI\u0006\u0014HMR;o'B,7\r\u0005\u0002\u001b=%\u0011q$\u0005\u0002\f%Vtg.\u001b8h'>d'/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u0011!\u0004A\u0001\u000fa\u0006$\u0018.\u001a8dK\u000e{gNZ5h+\u0005)\u0003C\u0001\u00149\u001d\t9SG\u0004\u0002)e9\u0011\u0011f\f\b\u0003U5j\u0011a\u000b\u0006\u0003Y]\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021c\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002]%\u00111\u0007N\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u00192\u0013\t1t'\u0001\u0006Fm\u0016tG/^1mYfT!a\r\u001b\n\u0005eR$A\u0004)bi&,gnY3D_:4\u0017nZ\u0005\u0003w]\u0012Q$\u00112tiJ\f7\r\u001e)bi&,gnY3D_:4\u0017nZ;sCRLwN\\\u0001\u0010a\u0006$\u0018.\u001a8dK\u000e{gNZ5hA\u00059A/[7f_V$X#A \u0011\u0005\u00013U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005M\"%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\u000b%A\u0004$j]&$X\rR;sCRLwN\\\u0001\ti&lWm\\;uA\u0005Q\u0001\u000e\u001e;q\u00072LWM\u001c;\u0016\u0003-\u0003\"\u0001T(\u000e\u00035S!AT\u0019\u0002\u001f\u0005\u001c\u0018P\\2iiR\u00048\r\\5f]RL!\u0001U'\u0003-\u0011+g-Y;mi\u0006\u001b\u0018P\\2IiR\u00048\t\\5f]R\f1\u0002\u001b;ua\u000ec\u0017.\u001a8uA\u000591o\u001c7s+JdW#\u0001+\u0011\u0005UKfB\u0001,X!\tQC)\u0003\u0002Y\t\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAF)F\u0001^!\rQb\fY\u0005\u0003?F\u0011q\"Q:z]\u000e\u001cv\u000e\u001c:DY&,g\u000e^\u000b\u0003C\u001e\u00042AY2f\u001b\u0005\u0019\u0015B\u00013D\u0005\u00191U\u000f^;sKB\u0011am\u001a\u0007\u0001\t\u0019Aw\u0003\"b\u0001W\n\tA+\u0003\u0002kG\u0006qA\b\\8dC2\u0004c)\u001e;ve\u0016t\u0014C\u00017q!\tig.D\u0001E\u0013\tyGIA\u0004O_RD\u0017N\\4\u0011\u00055\f\u0018B\u0001:E\u0005\r\te._\u0001\u000bE\u00164wN]3FC\u000eDG#A;\u0011\u000554\u0018BA<E\u0005\u0011)f.\u001b;\u0002\u0011\u00054G/\u001a:BY2\fa!\u001a8bE2,GCA;|\u0011\u0015\u0011F\u00021\u0001U\u0003\u001d!\u0017n]1cY\u0016$\"!\u001e@\t\u000bIk\u0001\u0019\u0001+\u0002\u0013M,Go\u0015;biV\u001cH#C;\u0002\u0004\u0005\u0015\u0011\u0011BA\n\u0011\u0015\u0011f\u00021\u0001U\u0011\u0019\t9A\u0004a\u0001)\u00061\u0011m\u0019;j_:Dq!a\u0003\u000f\u0001\u0004\ti!\u0001\bfqB,7\r^3e'R\fG/^:\u0011\u00075\fy!C\u0002\u0002\u0012\u0011\u00131!\u00138u\u0011%\t)B\u0004I\u0001\u0002\u0004\ti!A\u0004biR,W\u000e\u001d;)\u00079\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0012\u0003;\u0011q\u0001^1jYJ,7-A\ntKR\u001cF/\u0019;vg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002*)\"\u0011QBA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\u0011\t\u0019$!\b\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA\u001c\u0003c\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AsyncSolrClientIntegrationSpec
extends StandardFunSpec
implements RunningSolr {
    private String solrUrl;
    private AsyncSolrClient<?> solrs;
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig;
    private final FiniteDuration timeout;
    private final DefaultAsyncHttpClient httpClient;
    private SolrRunner solrRunner;
    private HttpSolrClient solrJClient;
    private volatile byte bitmap$0;

    @Override
    public void beforeAll() {
        RunningSolr.beforeAll$(this);
    }

    @Override
    public SolrRunner solrRunner() {
        return this.solrRunner;
    }

    @Override
    public void solrRunner_$eq(SolrRunner x$1) {
        this.solrRunner = x$1;
    }

    @Override
    public HttpSolrClient solrJClient() {
        return this.solrJClient;
    }

    @Override
    public void solrJClient_$eq(HttpSolrClient x$1) {
        this.solrJClient = x$1;
    }

    private AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return this.patienceConfig;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    private DefaultAsyncHttpClient httpClient() {
        return this.httpClient;
    }

    private String solrUrl$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.solrUrl = new StringBuilder(34).append("http://localhost:").append(this.solrRunner().port()).append("/solr/collection1").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.solrUrl;
    }

    private String solrUrl() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.solrUrl$lzycompute() : this.solrUrl;
    }

    private AsyncSolrClient<?> solrs$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.solrs = AsyncSolrClient$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.solrs;
    }

    private AsyncSolrClient<?> solrs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.solrs$lzycompute() : this.solrs;
    }

    @Override
    public void beforeEach() {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0 & Serializable)() -> this.solrJClient().deleteByQuery("*:*"), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        SolrInputDocument doc1 = SolrUtils$.MODULE$.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument doc2 = SolrUtils$.MODULE$.newInputDoc("id2", "doc2", "cat1", 20.0f);
        this.solrJClient().add(Arrays.asList((Object[])new SolrInputDocument[]{doc1, doc2}));
        this.solrJClient().commit();
    }

    @Override
    public void afterAll() {
        RunningSolr.afterAll$(this);
        this.solrs().shutdown();
        this.httpClient().close();
    }

    private void enable(String solrUrl) {
        this.setStatus(solrUrl, "enable", 200, this.setStatus$default$4());
    }

    private void disable(String solrUrl) {
        this.setStatus(solrUrl, "disable", 503, this.setStatus$default$4());
    }

    private void setStatus(String solrUrl, String action, int expectedStatus, int attempt) {
        while (true) {
            Response response = (Response)this.httpClient().prepareGet(new StringBuilder(26).append(solrUrl).append("/admin/ping?action=").append(action).append("&wt=xml").toString()).execute().get();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)response.getStatusCode()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)200));
            int newStatusCode = ((Response)this.httpClient().prepareGet(new StringBuilder(18).append(solrUrl).append("/admin/ping?wt=xml").toString()).execute().get()).getStatusCode();
            if (newStatusCode != expectedStatus && attempt > 3) {
                throw new IllegalStateException(new StringBuilder(65).append("Could not reach expected status ").append(expectedStatus).append(" via action '").append(action).append("', reached ").append(newStatusCode).append(" instead.").toString());
            }
            if (newStatusCode == expectedStatus) break;
            Thread.sleep(20L);
            ++attempt;
        }
    }

    private int setStatus$default$4() {
        return 1;
    }

    public AsyncSolrClientIntegrationSpec() {
        RunningSolr.$init$(this);
        this.patienceConfig = new AbstractPatienceConfiguration.PatienceConfig((AbstractPatienceConfiguration)Eventually$.MODULE$, Eventually$.MODULE$.scaled(Span$.MODULE$.apply(10000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20L, (Units)Millis$.MODULE$)));
        this.timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        this.httpClient = new DefaultAsyncHttpClient();
        this.describe("Solr", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.it().apply("should allow to transform the response", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable)() -> {
                scala.concurrent.Future response = ((scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("cat:cat1"))).map((Function1 & Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
                return this.convertToAnyShouldWrapper(this.await(response, (Duration)this.timeout()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs((Iterable)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2"})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.it().apply("should allow to regularly observe the server status", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                Seq solrServers = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SolrServer[]{SolrServer$.MODULE$.apply(this.solrUrl())}));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).withServerStateObservation((ServerStateObserver)new PingStatusObserver(solrServers, (AsyncHttpClient)this.httpClient(), (FutureFactory)this.futureFactory()), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), Executors.newSingleThreadScheduledExecutor()).build();
                this.enable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Enabled$.MODULE$)), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                this.disable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Disabled$.MODULE$)), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.it().apply("should be built with LoadBalancer", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.it().apply("should allow to set the http client", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.it().apply("should allow to set the response parser", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            this.it().apply("should allow to override the response parser per request", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).build();
                GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, null, (SolrParams)new SolrQuery("cat:cat1").add("wt", new String[]{"xml"}));
                request.setResponseParser((ResponseParser)new NoOpResponseParser());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.execute((SolrRequest)request, SolrResponseFactory$.MODULE$.simpleSolrResponseFactory());
                Elem xml = (Elem)XML$.MODULE$.loadString(((SimpleSolrResponse)this.await(response, (Duration)this.timeout())).getResponse().get("response").toString());
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(xml.$bslash("result").$bslash("@numFound").text()))), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.it().apply("should return failed future on request with bad query", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable)() -> {
                scala.concurrent.Future response = (scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("fieldDoesNotExist:foo"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                return this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).should(this.include().apply("undefined field fieldDoesNotExist"));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.it().apply("should return failed future on wrong request path", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply(new StringBuilder(18).append("http://localhost:").append(this.solrRunner().port()).append("/").toString(), (FutureFactory)this.futureFactory());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)).thrownBy((Function0 & Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).should(this.include().apply("Expected mime type [] but got [text/html]"));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            this.it().apply("should gather request time metrics", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AsyncSolrClientIntegrationSpec.class.getClassLoader());
                public final class Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("io.ino.solrs.Metrics").asType().toTypeConstructor();
                    }

                    public Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(AsyncSolrClientIntegrationSpec $outer) {
                    }
                }
                Metrics metrics = (Metrics)this.mock(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(null)));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withMetrics(metrics).build();
                this.await((scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*")), (Duration)this.timeout());
                ((Metrics)Mockito.verify((Object)metrics)).requestTime(Matchers.anyLong());
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.it().apply("should allow to intercept requests", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                ObjectRef capturedServer = ObjectRef.create(null);
                ObjectRef capturedRequest = ObjectRef.create(null);
                RequestInterceptor interceptor = new RequestInterceptor(null, capturedServer, capturedRequest){
                    private final ObjectRef capturedServer$1;
                    private final ObjectRef capturedRequest$1;

                    public <T extends SolrResponse> Future<T> interceptRequest(Function2<SolrServer, SolrRequest<? extends T>, Future<T>> f, SolrServer solrServer, SolrRequest<? extends T> r) {
                        this.capturedServer$1.elem = solrServer;
                        this.capturedRequest$1.elem = r;
                        return (Future)f.apply((Object)solrServer, r);
                    }
                    {
                        this.capturedServer$1 = capturedServer$1;
                        this.capturedRequest$1 = capturedRequest$1;
                    }
                };
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withRequestInterceptor(interceptor).build();
                SolrQuery q = new SolrQuery("*:*");
                this.await((scala.concurrent.Future)solr.query((SolrParams)q), (Duration)this.timeout());
                this.convertToAnyShouldWrapper((SolrServer)capturedServer.elem, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SolrServer$.MODULE$.apply(this.solrUrl())));
                this.convertToAnyShouldWrapper(((QueryRequest)((SolrRequest)capturedRequest.elem)).getParams(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187), Prettifier$.MODULE$.default()).should(this.be().apply((Object)q));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

