/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.ShardReplica;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import java.io.Serializable;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.cloud.Replica;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class ShardReplica$ {
    public static ShardReplica$ MODULE$;
    private final Regex replicaTypePattern;

    static {
        new ShardReplica$();
    }

    public ShardReplica apply(String baseUrl, Replica underlying) {
        Product product;
        ShardReplica res = new ShardReplica(SolrServer$.MODULE$.fixUrl(baseUrl), underlying);
        Replica.State state = underlying.getState();
        if (Replica.State.ACTIVE.equals(state)) {
            product = Enabled$.MODULE$;
        } else if (Replica.State.RECOVERING.equals(state)) {
            product = Disabled$.MODULE$;
        } else if (Replica.State.RECOVERY_FAILED.equals(state)) {
            product = Failed$.MODULE$;
        } else if (Replica.State.DOWN.equals(state)) {
            product = Failed$.MODULE$;
        } else {
            throw new MatchError((Object)state);
        }
        res.status_$eq((ServerStatus)product);
        return res;
    }

    public Option<ShardReplica> findLeader(Iterable<SolrServer> servers) {
        return servers.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SolrServer, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ShardReplica shardReplica;
                A1 A1 = x1;
                Object object = A1 instanceof ShardReplica && (shardReplica = (ShardReplica)A1).isLeader() ? shardReplica : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SolrServer x1) {
                ShardReplica shardReplica;
                SolrServer solrServer = x1;
                boolean bl = solrServer instanceof ShardReplica && (shardReplica = (ShardReplica)solrServer).isLeader();
                return bl;
            }
        });
    }

    private Regex replicaTypePattern() {
        return this.replicaTypePattern;
    }

    public IndexedSeq<SolrServer> filterByShardPreference(SolrRequest<?> r, IndexedSeq<SolrServer> servers) {
        IndexedSeq<SolrServer> indexedSeq;
        if (r.getParams() == null || r.getParams().get("shards.preference") == null) {
            indexedSeq = servers;
        } else {
            Set replicaTypes;
            IndexedSeq<SolrServer> preferredReplicas;
            String string = r.getParams().get("shards.preference");
            IndexedSeq<SolrServer> indexedSeq2 = string.contains("replica.type") && this.hasShardReplicas(servers) ? ((preferredReplicas = (IndexedSeq<SolrServer>)servers.collect((PartialFunction)new scala.Serializable(replicaTypes = (Set)this.replicaTypePattern().findAllMatchIn((CharSequence)string).foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Set res = (Set)tuple2._1();
                Regex.Match m = (Regex.Match)tuple2._2();
                Set set = (Set)res.$plus((Object)Replica.Type.valueOf((String)m.group(1)));
                return set;
            })){
                public static final long serialVersionUID = 0L;
                private final Set replicaTypes$1;

                public final <A1 extends SolrServer, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    ShardReplica shardReplica;
                    A1 A1 = x2;
                    Object object = A1 instanceof ShardReplica && this.replicaTypes$1.contains((Object)(shardReplica = (ShardReplica)A1).replicaType()) ? shardReplica : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SolrServer x2) {
                    ShardReplica shardReplica;
                    SolrServer solrServer = x2;
                    boolean bl = solrServer instanceof ShardReplica && this.replicaTypes$1.contains((Object)(shardReplica = (ShardReplica)solrServer).replicaType());
                    return bl;
                }
                {
                    this.replicaTypes$1 = replicaTypes$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).nonEmpty() ? preferredReplicas : servers) : servers;
            indexedSeq = indexedSeq2;
        }
        return indexedSeq;
    }

    private boolean hasShardReplicas(IndexedSeq<SolrServer> servers) {
        return servers.nonEmpty() && servers.apply(0) instanceof ShardReplica;
    }

    private ShardReplica$() {
        MODULE$ = this;
        this.replicaTypePattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(17).append("replica.type").append(":(").append(Replica.Type.NRT).append("|").append(Replica.Type.TLOG).append("|").append(Replica.Type.PULL).append(")").toString())).r();
    }
}

