/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.AsyncSolrClientIntegrationSpec$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.Metrics;
import io.ino.solrs.PingStatusObserver;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RunningSolr;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001%\u0011a$Q:z]\u000e\u001cv\u000e\u001c:DY&,g\u000e^%oi\u0016<'/\u0019;j_:\u001c\u0006/Z2\u000b\u0005\r!\u0011!B:pYJ\u001c(BA\u0003\u0007\u0003\rIgn\u001c\u0006\u0002\u000f\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001!B\u0004\t\u0003\u00171i\u0011AA\u0005\u0003\u001b\t\u0011qb\u0015;b]\u0012\f'\u000f\u001a$v]N\u0003Xm\u0019\t\u0003\u0017=I!\u0001\u0005\u0002\u0003\u0017I+hN\\5oON{GN\u001d\u0005\u0006%\u0001!\taE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0001\"a\u0003\u0001\t\u000fY\u0001!\u0019!C\u0006/\u0005q\u0001/\u0019;jK:\u001cWmQ8oM&<W#\u0001\r\u0011\u0005eYcB\u0001\u000e)\u001d\tYRE\u0004\u0002\u001dE9\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004C\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\n1a\u001c:h\u0013\t\u0019C%A\u0005tG\u0006d\u0017\r^3ti*\t\u0011%\u0003\u0002'O\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r\"\u0013BA\u0015+\u0003))e/\u001a8uk\u0006dG.\u001f\u0006\u0003M\u001dJ!\u0001L\u0017\u0003\u001dA\u000bG/[3oG\u0016\u001cuN\u001c4jO&\u0011aF\u000b\u0002\u001e\u0003\n\u001cHO]1diB\u000bG/[3oG\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"1\u0001\u0007\u0001Q\u0001\na\tq\u0002]1uS\u0016t7-Z\"p]\u001aLw\r\t\u0005\be\u0001\u0011\r\u0011b\u00034\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\u000e\t\u0003kmj\u0011A\u000e\u0006\u0003oa\n\u0001\u0002Z;sCRLwN\u001c\u0006\u0003MeR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003yY\u0012aBR5oSR,G)\u001e:bi&|g\u000e\u0003\u0004?\u0001\u0001\u0006I\u0001N\u0001\ti&lWm\\;uA!9\u0001\t\u0001b\u0001\n\u0013\t\u0015A\u00035uiB\u001cE.[3oiV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002FI\u0005y\u0011m]=oG\"$H\u000f]2mS\u0016tG/\u0003\u0002H\t\n1B)\u001a4bk2$\u0018i]=oG\"#H\u000f]\"mS\u0016tG\u000f\u0003\u0004J\u0001\u0001\u0006IAQ\u0001\fQR$\bo\u00117jK:$\b\u0005\u0003\u0005L\u0001!\u0015\r\u0011\"\u0003M\u0003\u001d\u0019x\u000e\u001c:Ve2,\u0012!\u0014\t\u0003\u001dJs!a\u0014)\u0011\u0005uI\u0014BA):\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005EK\u0004\u0002C\u0002\u0001\u0011\u000b\u0007I\u0011\u0002,\u0016\u0003]\u00032a\u0003-[\u0013\tI&AA\bBgft7mU8me\u000ec\u0017.\u001a8u!\tYF,D\u00019\u0013\ti\u0006H\u0001\u0004GkR,(/\u001a\u0005\u0006?\u0002!\t\u0005Y\u0001\u000bE\u00164wN]3FC\u000eDG#A1\u0011\u0005\t\u001cW\"A\u001d\n\u0005\u0011L$\u0001B+oSRDQA\u001a\u0001\u0005B\u0001\f\u0001\"\u00194uKJ\fE\u000e\u001c\u0005\u0006Q\u0002!I![\u0001\u0007K:\f'\r\\3\u0015\u0005\u0005T\u0007\"B&h\u0001\u0004i\u0005\"\u00027\u0001\t\u0013i\u0017a\u00023jg\u0006\u0014G.\u001a\u000b\u0003C:DQaS6A\u00025CQ\u0001\u001d\u0001\u0005\nE\f\u0011b]3u'R\fG/^:\u0015\u000b\u0005\u00148/\u001e>\t\u000b-{\u0007\u0019A'\t\u000bQ|\u0007\u0019A'\u0002\r\u0005\u001cG/[8o\u0011\u00151x\u000e1\u0001x\u00039)\u0007\u0010]3di\u0016$7\u000b^1ukN\u0004\"A\u0019=\n\u0005eL$aA%oi\"91p\u001cI\u0001\u0002\u00049\u0018aB1ui\u0016l\u0007\u000f\u001e\u0015\u0003_v\u00042A`A\u0002\u001b\u0005y(bAA\u0001s\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0015qPA\u0004uC&d'/Z2\t\u0013\u0005%\u0001!%A\u0005\n\u0005-\u0011aE:fiN#\u0018\r^;tI\u0011,g-Y;mi\u0012\"TCAA\u0007U\r9\u0018qB\u0016\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/y\u0018!C;oG\",7m[3e\u0013\u0011\tY\"!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class AsyncSolrClientIntegrationSpec
extends StandardFunSpec
implements RunningSolr {
    private String solrUrl;
    private AsyncSolrClient<scala.concurrent.Future> solrs;
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig;
    private final FiniteDuration timeout;
    private final DefaultAsyncHttpClient httpClient;
    private SolrRunner solrRunner;
    private HttpSolrClient solrJClient;
    private volatile byte bitmap$0;

    @Override
    public void beforeAll() {
        RunningSolr.beforeAll$(this);
    }

    @Override
    public SolrRunner solrRunner() {
        return this.solrRunner;
    }

    @Override
    public void solrRunner_$eq(SolrRunner x$1) {
        this.solrRunner = x$1;
    }

    @Override
    public HttpSolrClient solrJClient() {
        return this.solrJClient;
    }

    @Override
    public void solrJClient_$eq(HttpSolrClient x$1) {
        this.solrJClient = x$1;
    }

    private AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return this.patienceConfig;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    private DefaultAsyncHttpClient httpClient() {
        return this.httpClient;
    }

    private String solrUrl$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.solrUrl = new StringBuilder(34).append("http://localhost:").append(this.solrRunner().port()).append("/solr/collection1").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.solrUrl;
    }

    private String solrUrl() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.solrUrl$lzycompute() : this.solrUrl;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.solrs = AsyncSolrClient$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.solrs;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.solrs$lzycompute() : this.solrs;
    }

    @Override
    public void beforeEach() {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0 & Serializable & scala.Serializable)() -> this.solrJClient().deleteByQuery("*:*"), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        SolrInputDocument doc1 = SolrUtils$.MODULE$.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument doc2 = SolrUtils$.MODULE$.newInputDoc("id2", "doc2", "cat1", 20.0f);
        this.solrJClient().add(Arrays.asList((Object[])new SolrInputDocument[]{doc1, doc2}));
        this.solrJClient().commit();
    }

    @Override
    public void afterAll() {
        RunningSolr.afterAll$(this);
        this.solrs().shutdown();
        this.httpClient().close();
    }

    private void enable(String solrUrl) {
        this.setStatus(solrUrl, "enable", 200, this.setStatus$default$4());
    }

    private void disable(String solrUrl) {
        this.setStatus(solrUrl, "disable", 503, this.setStatus$default$4());
    }

    private void setStatus(String solrUrl, String action, int expectedStatus, int attempt) {
        while (true) {
            Response response = (Response)this.httpClient().prepareGet(new StringBuilder(26).append(solrUrl).append("/admin/ping?action=").append(action).append("&wt=xml").toString()).execute().get();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)response.getStatusCode()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)200));
            int newStatusCode = ((Response)this.httpClient().prepareGet(new StringBuilder(18).append(solrUrl).append("/admin/ping?wt=xml").toString()).execute().get()).getStatusCode();
            if (newStatusCode != expectedStatus && attempt > 3) {
                throw new IllegalStateException(new StringBuilder(65).append("Could not reach expected status ").append(expectedStatus).append(" via action '").append(action).append("', reached ").append(newStatusCode).append(" instead.").toString());
            }
            if (newStatusCode == expectedStatus) break;
            Thread.sleep(20L);
            ++attempt;
        }
    }

    private int setStatus$default$4() {
        return 1;
    }

    public AsyncSolrClientIntegrationSpec() {
        RunningSolr.$init$(this);
        this.patienceConfig = new AbstractPatienceConfiguration.PatienceConfig((AbstractPatienceConfiguration)Eventually$.MODULE$, Eventually$.MODULE$.scaled(Span$.MODULE$.apply(10000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20L, (Units)Millis$.MODULE$)));
        this.timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        this.httpClient = new DefaultAsyncHttpClient();
        this.describe("Solr", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.it().apply("should allow to transform the response", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.concurrent.Future response = ((scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("cat:cat1"))).map((Function1 & Serializable & scala.Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
                return this.convertToAnyShouldWrapper(this.await(response, (Duration)this.timeout()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs(package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2"})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.it().apply("should allow to regularly observe the server status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq solrServers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SolrServer[]{SolrServer$.MODULE$.apply(this.solrUrl())}));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).withServerStateObservation((ServerStateObserver)new PingStatusObserver(solrServers, (AsyncHttpClient)this.httpClient(), (FutureFactory)this.futureFactory()), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), Executors.newSingleThreadScheduledExecutor()).build();
                this.enable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Enabled$.MODULE$)), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                this.disable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Disabled$.MODULE$)), this.patienceConfig(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            this.it().apply("should be built with LoadBalancer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            this.it().apply("should allow to set the http client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.it().apply("should allow to set the response parser", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            this.it().apply("should allow to override the response parser per request", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).build();
                GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, null, (SolrParams)new SolrQuery("cat:cat1").add("wt", new String[]{"xml"}));
                request.setResponseParser((ResponseParser)new NoOpResponseParser());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.execute((SolrRequest)request, SolrResponseFactory$.MODULE$.simpleSolrResponseFactory());
                Elem xml = (Elem)XML$.MODULE$.loadString(((SimpleSolrResponse)this.await(response, (Duration)this.timeout())).getResponse().get("response").toString());
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(xml.$bslash("result").$bslash("@numFound").text())).toInt()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.it().apply("should return failed future on request with bad query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.concurrent.Future response = (scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("fieldDoesNotExist:foo"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                return this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143), Prettifier$.MODULE$.default()).should(this.include().apply("undefined field fieldDoesNotExist"));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            this.it().apply("should return failed future on wrong request path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply(new StringBuilder(18).append("http://localhost:").append(this.solrRunner().port()).append("/").toString(), (FutureFactory)this.futureFactory());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154), Prettifier$.MODULE$.default()).should(this.include().apply("Expected mime type [] but got [text/html]"));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            this.it().apply("should gather request time metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AsyncSolrClientIntegrationSpec.class.getClassLoader());
                public final class Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("io.ino.solrs.Metrics").asType().toTypeConstructor();
                    }

                    public Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(AsyncSolrClientIntegrationSpec $outer) {
                    }
                }
                Metrics metrics = (Metrics)this.mock(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_ino_solrs_AsyncSolrClientIntegrationSpec$$typecreator1$1(null)));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withMetrics(metrics).build();
                this.await((scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*")), (Duration)this.timeout());
                ((Metrics)Mockito.verify((Object)metrics)).requestTime(Matchers.anyLong());
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.it().apply("should allow to intercept requests", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ObjectRef capturedServer = ObjectRef.create(null);
                ObjectRef capturedRequest = ObjectRef.create(null);
                RequestInterceptor interceptor = new RequestInterceptor(null, capturedServer, capturedRequest){
                    private final ObjectRef capturedServer$1;
                    private final ObjectRef capturedRequest$1;

                    public <T extends SolrResponse> Future<T> interceptRequest(Function2<SolrServer, SolrRequest<? extends T>, Future<T>> f, SolrServer solrServer, SolrRequest<? extends T> r) {
                        this.capturedServer$1.elem = solrServer;
                        this.capturedRequest$1.elem = r;
                        return (Future)f.apply((Object)solrServer, r);
                    }
                    {
                        this.capturedServer$1 = capturedServer$1;
                        this.capturedRequest$1 = capturedRequest$1;
                    }
                };
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withRequestInterceptor(interceptor).build();
                SolrQuery q = new SolrQuery("*:*");
                this.await((scala.concurrent.Future)solr.query((SolrParams)q), (Duration)this.timeout());
                this.convertToAnyShouldWrapper((SolrServer)capturedServer.elem, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SolrServer$.MODULE$.apply(this.solrUrl())));
                this.convertToAnyShouldWrapper(((QueryRequest)((SolrRequest)capturedRequest.elem)).getParams(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187), Prettifier$.MODULE$.default()).should(this.be().apply((Object)q));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }
}

