/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.LoadBalancer;
import io.ino.solrs.Metrics;
import io.ino.solrs.PingStatusObserver;
import io.ino.solrs.RemoteSolrException;
import io.ino.solrs.RequestInterceptor;
import io.ino.solrs.RunningSolr;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.SingleServerLB;
import io.ino.solrs.SolrResponseFactory$;
import io.ino.solrs.SolrRunner;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrUtils$;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Aggregating$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001\u0002\t\u0012\u0001aAQ\u0001\t\u0001\u0005\u0002\u0005Bqa\t\u0001C\u0002\u0013-A\u0005\u0003\u0004=\u0001\u0001\u0006I!\n\u0005\b{\u0001\u0011\r\u0011b\u0003?\u0011\u0019A\u0005\u0001)A\u0005\u007f!9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB)\u0001A\u0003%1\n\u0003\u0005S\u0001!\u0015\r\u0011\"\u0003T\u0011!\u0011\u0002\u0001#b\u0001\n\u0013a\u0006\"\u00023\u0001\t\u0003*\u0007\"\u00026\u0001\t\u0003*\u0007\"B6\u0001\t\u0013a\u0007\"\u00028\u0001\t\u0013y\u0007\"B9\u0001\t\u0013\u0011\b\"CA\u0005\u0001E\u0005I\u0011BA\u0006\u0005y\t5/\u001f8d'>d'o\u00117jK:$\u0018J\u001c;fOJ\fG/[8o'B,7M\u0003\u0002\u0013'\u0005)1o\u001c7sg*\u0011A#F\u0001\u0004S:|'\"\u0001\f\u0002\u0005%|7\u0001A\n\u0004\u0001ei\u0002C\u0001\u000e\u001c\u001b\u0005\t\u0012B\u0001\u000f\u0012\u0005=\u0019F/\u00198eCJ$g)\u001e8Ta\u0016\u001c\u0007C\u0001\u000e\u001f\u0013\ty\u0012CA\u0006Sk:t\u0017N\\4T_2\u0014\u0018A\u0002\u001fj]&$h\bF\u0001#!\tQ\u0002!\u0001\bqCRLWM\\2f\u0007>tg-[4\u0016\u0003\u0015\u0002\"A\n\u001d\u000f\u0005\u001d*dB\u0001\u00153\u001d\tIsF\u0004\u0002+[5\t1F\u0003\u0002-/\u00051AH]8pizJ\u0011AL\u0001\u0004_J<\u0017B\u0001\u00192\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001/\u0013\t\u0019D'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001M\u0019\n\u0005Y:\u0014AC#wK:$X/\u00197ms*\u00111\u0007N\u0005\u0003si\u0012a\u0002U1uS\u0016t7-Z\"p]\u001aLw-\u0003\u0002<o\ti\u0012IY:ue\u0006\u001cG\u000fU1uS\u0016t7-Z\"p]\u001aLw-\u001e:bi&|g.A\bqCRLWM\\2f\u0007>tg-[4!\u0003\u001d!\u0018.\\3pkR,\u0012a\u0010\t\u0003\u0001\u001ak\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003g\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0006\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\u0005uS6,w.\u001e;!\u0003)AG\u000f\u001e9DY&,g\u000e^\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*M\u0001\u0010CNLhn\u00195uiB\u001cG.[3oi&\u0011\u0001+\u0014\u0002\u0017\t\u00164\u0017-\u001e7u\u0003NLhn\u0019%uiB\u001cE.[3oi\u0006Y\u0001\u000e\u001e;q\u00072LWM\u001c;!\u0003\u001d\u0019x\u000e\u001c:Ve2,\u0012\u0001\u0016\t\u0003+fs!AV,\u0011\u0005)\"\u0015B\u0001-E\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a#U#A/\u0011\u0007iq\u0006-\u0003\u0002`#\ty\u0011i]=oGN{GN]\"mS\u0016tG\u000f\u0005\u0002bE6\t1)\u0003\u0002d\u0007\n1a)\u001e;ve\u0016\f!BY3g_J,W)Y2i)\u00051\u0007CA4i\u001b\u0005!\u0015BA5E\u0005\u0011)f.\u001b;\u0002\u0011\u00054G/\u001a:BY2\fa!\u001a8bE2,GC\u00014n\u0011\u0015\u0011F\u00021\u0001U\u0003\u001d!\u0017n]1cY\u0016$\"A\u001a9\t\u000bIk\u0001\u0019\u0001+\u0002\u0013M,Go\u0015;biV\u001cH#\u00024tiZ\\\b\"\u0002*\u000f\u0001\u0004!\u0006\"B;\u000f\u0001\u0004!\u0016AB1di&|g\u000eC\u0003x\u001d\u0001\u0007\u00010\u0001\bfqB,7\r^3e'R\fG/^:\u0011\u0005\u001dL\u0018B\u0001>E\u0005\rIe\u000e\u001e\u0005\by:\u0001\n\u00111\u0001y\u0003\u001d\tG\u000f^3naRD#A\u0004@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0005\u0005!a\u0002;bS2\u0014XmY\u0001\u0014g\u0016$8\u000b^1ukN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bQ3\u0001_A\bW\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\u0011\t9\"!\u0001\u0002\u0013Ut7\r[3dW\u0016$\u0017\u0002BA\u000e\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class AsyncSolrClientIntegrationSpec
extends StandardFunSpec
implements RunningSolr {
    private String solrUrl;
    private AsyncSolrClient<scala.concurrent.Future> solrs;
    private final AbstractPatienceConfiguration.PatienceConfig patienceConfig;
    private final FiniteDuration timeout;
    private final DefaultAsyncHttpClient httpClient;
    private SolrRunner solrRunner;
    private Http2SolrClient solrJClient;
    private volatile byte bitmap$0;

    @Override
    public void beforeAll() {
        RunningSolr.beforeAll$(this);
    }

    @Override
    public SolrRunner solrRunner() {
        return this.solrRunner;
    }

    @Override
    public void solrRunner_$eq(SolrRunner x$1) {
        this.solrRunner = x$1;
    }

    @Override
    public Http2SolrClient solrJClient() {
        return this.solrJClient;
    }

    @Override
    public void solrJClient_$eq(Http2SolrClient x$1) {
        this.solrJClient = x$1;
    }

    private AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return this.patienceConfig;
    }

    private FiniteDuration timeout() {
        return this.timeout;
    }

    private DefaultAsyncHttpClient httpClient() {
        return this.httpClient;
    }

    private String solrUrl$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.solrUrl = new StringBuilder(34).append("http://localhost:").append(this.solrRunner().port()).append("/solr/collection1").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.solrUrl;
    }

    private String solrUrl() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.solrUrl$lzycompute();
        }
        return this.solrUrl;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs$lzycompute() {
        AsyncSolrClientIntegrationSpec asyncSolrClientIntegrationSpec = this;
        synchronized (asyncSolrClientIntegrationSpec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.solrs = AsyncSolrClient$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.solrs;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.solrs$lzycompute();
        }
        return this.solrs;
    }

    @Override
    public void beforeEach() {
        Eventually$.MODULE$.eventually(new PatienceConfiguration.Timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds())), (Function0 & Serializable & scala.Serializable)() -> this.solrJClient().deleteByQuery("*:*"), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        SolrInputDocument doc1 = SolrUtils$.MODULE$.newInputDoc("id1", "doc1", "cat1", 10.0f);
        SolrInputDocument doc2 = SolrUtils$.MODULE$.newInputDoc("id2", "doc2", "cat1", 20.0f);
        this.solrJClient().add(Arrays.asList((Object[])new SolrInputDocument[]{doc1, doc2}));
        this.solrJClient().commit();
    }

    @Override
    public void afterAll() {
        RunningSolr.afterAll$(this);
        this.solrs().shutdown();
        this.httpClient().close();
    }

    private void enable(String solrUrl) {
        this.setStatus(solrUrl, "enable", 200, this.setStatus$default$4());
    }

    private void disable(String solrUrl) {
        this.setStatus(solrUrl, "disable", 503, this.setStatus$default$4());
    }

    private void setStatus(String solrUrl, String action, int expectedStatus, int attempt) {
        while (true) {
            Response response = (Response)this.httpClient().prepareGet(new StringBuilder(26).append(solrUrl).append("/admin/ping?action=").append(action).append("&wt=xml").toString()).execute().get();
            this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)response.getStatusCode()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)200));
            int newStatusCode = ((Response)this.httpClient().prepareGet(new StringBuilder(18).append(solrUrl).append("/admin/ping?wt=xml").toString()).execute().get()).getStatusCode();
            if (newStatusCode != expectedStatus && attempt > 3) {
                throw new IllegalStateException(new StringBuilder(65).append("Could not reach expected status ").append(expectedStatus).append(" via action '").append(action).append("', reached ").append(newStatusCode).append(" instead.").toString());
            }
            if (newStatusCode == expectedStatus) break;
            Thread.sleep(20L);
            ++attempt;
        }
    }

    private int setStatus$default$4() {
        return 1;
    }

    public AsyncSolrClientIntegrationSpec() {
        RunningSolr.$init$(this);
        this.patienceConfig = new AbstractPatienceConfiguration.PatienceConfig((AbstractPatienceConfiguration)Eventually$.MODULE$, Eventually$.MODULE$.scaled(Span$.MODULE$.apply(10000L, (Units)Millis$.MODULE$)), Eventually$.MODULE$.scaled(Span$.MODULE$.apply(20L, (Units)Millis$.MODULE$)));
        this.timeout = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
        this.httpClient = new DefaultAsyncHttpClient();
        this.describe("Solr", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.it().apply("should allow to transform the response", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.concurrent.Future response = ((scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("cat:cat1"))).map((Function1 & Serializable & scala.Serializable)resp -> SolrUtils$.MODULE$.getIds((QueryResponse)resp), ExecutionContext.Implicits$.MODULE$.global());
                return this.convertToAnyShouldWrapper(this.await(response, (Duration)this.timeout()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default()).should(this.contain()).theSameElementsAs(package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id2"})), Aggregating$.MODULE$.aggregatingNatureOfGenTraversable(Equality$.MODULE$.default()));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.it().apply("should allow to regularly observe the server status", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq solrServers = (Seq)new .colon.colon((Object)SolrServer$.MODULE$.apply(this.solrUrl()), (List)Nil$.MODULE$);
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).withServerStateObservation((ServerStateObserver)new PingStatusObserver(solrServers, (AsyncHttpClient)this.httpClient(), (FutureFactory)this.futureFactory()), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), Executors.newSingleThreadScheduledExecutor()).build();
                this.enable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Enabled$.MODULE$)), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                this.disable(this.solrUrl());
                Eventually$.MODULE$.eventually((Function0 & Serializable & scala.Serializable)() -> this.convertToAnyShouldWrapper(((SolrServer)solrServers.apply(0)).status(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).should(this.be().apply((Object)Disabled$.MODULE$)), this.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            this.it().apply("should be built with LoadBalancer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply((LoadBalancer)new SingleServerLB(this.solrUrl()), (FutureFactory)this.futureFactory()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                return this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            this.it().apply("should allow to set the http client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withHttpClient((AsyncHttpClient)new DefaultAsyncHttpClient()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.it().apply("should allow to set the response parser", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withResponseParser((ResponseParser)new XMLResponseParser()).build();
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("cat:cat1"));
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((QueryResponse)this.await(response, (Duration)this.timeout())).getResults().getNumFound()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            this.it().apply("should allow to override the response parser per request", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).build();
                GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.POST, null, (SolrParams)new SolrQuery("cat:cat1").add("wt", new String[]{"xml"}));
                request.setResponseParser((ResponseParser)new NoOpResponseParser(null){

                    public Collection<String> getContentTypes() {
                        return Arrays.asList((Object[])new String[]{"application/xml"});
                    }
                });
                scala.concurrent.Future response = (scala.concurrent.Future)solr.execute((SolrRequest)request, SolrResponseFactory$.MODULE$.simpleSolrResponseFactory());
                Elem xml = (Elem)XML$.MODULE$.loadString(((SimpleSolrResponse)this.await(response, (Duration)this.timeout())).getResponse().get("response").toString());
                this.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(xml.$bslash("result").$bslash("@numFound").text())).toInt()), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137), Prettifier$.MODULE$.default()).should(this.be().apply((Object)BoxesRunTime.boxToInteger((int)2)));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            this.it().apply("should return failed future on request with bad query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                scala.concurrent.Future response = (scala.concurrent.Future)this.solrs().query((SolrParams)new SolrQuery("fieldDoesNotExist:foo"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                return this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148), Prettifier$.MODULE$.default()).should(this.include().apply("undefined field fieldDoesNotExist"));
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            this.it().apply("should return failed future on wrong request path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AsyncSolrClient solr = AsyncSolrClient$.MODULE$.apply(new StringBuilder(18).append("http://localhost:").append(this.solrRunner().port()).append("/").toString(), (FutureFactory)this.futureFactory());
                scala.concurrent.Future response = (scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*"));
                this.awaitReady(response, (Duration)this.timeout());
                this.a(ClassTag$.MODULE$.apply(RemoteSolrException.class)).should(this.be(), Prettifier$.MODULE$.default(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()));
                String mimeTypesRegex = new StringBuilder(125).append("(").append("application/octet-stream").append(", ").append("application/vnd.apache.solr.javabin").append("|").append("application/vnd.apache.solr.javabin").append(", ").append("application/octet-stream").append(")").toString();
                this.convertToStringShouldWrapper(((Throwable)this.the(ClassTag$.MODULE$.apply(RemoteSolrException.class), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160)).thrownBy((Function0 & Serializable & scala.Serializable)() -> (QueryResponse)this.await(response, (Duration)this.timeout()))).getMessage(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160), Prettifier$.MODULE$.default()).should(this.include(), Predef$.MODULE$.$conforms()).regex(new StringBuilder(50).append("Expected a mime type of ").append("\\[").append(mimeTypesRegex).append("\\] but got \\[text/html\\]").toString());
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            this.it().apply("should gather request time metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Metrics metrics = (Metrics)this.mock(Tag$.MODULE$.apply(Metrics.class, LightTypeTag$.MODULE$.parse(1481086099, "\u0004\u0000\u0001\u0014io.ino.solrs.Metrics\u0001\u0001", "\u0000\u0000\u0000", 30)));
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withMetrics(metrics).build();
                this.await((scala.concurrent.Future)solr.query((SolrParams)new SolrQuery("*:*")), (Duration)this.timeout());
                ((Metrics)Mockito.verify((Object)metrics)).requestTime(ArgumentMatchers.anyLong());
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
            this.it().apply("should allow to intercept requests", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ObjectRef capturedServer = ObjectRef.create(null);
                ObjectRef capturedRequest = ObjectRef.create(null);
                RequestInterceptor interceptor = new RequestInterceptor(null, capturedServer, capturedRequest){
                    private final ObjectRef capturedServer$1;
                    private final ObjectRef capturedRequest$1;

                    public <T extends SolrResponse> Future<T> interceptRequest(Function2<SolrServer, SolrRequest<? extends T>, Future<T>> f, SolrServer solrServer, SolrRequest<? extends T> r) {
                        this.capturedServer$1.elem = solrServer;
                        this.capturedRequest$1.elem = r;
                        return (Future)f.apply((Object)solrServer, r);
                    }
                    {
                        this.capturedServer$1 = capturedServer$1;
                        this.capturedRequest$1 = capturedRequest$1;
                    }
                };
                AsyncSolrClient solr = AsyncSolrClient.Builder$.MODULE$.apply(this.solrUrl(), (FutureFactory)this.futureFactory()).withRequestInterceptor(interceptor).build();
                SolrQuery q = new SolrQuery("*:*");
                this.await((scala.concurrent.Future)solr.query((SolrParams)q), (Duration)this.timeout());
                this.convertToAnyShouldWrapper((SolrServer)capturedServer.elem, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193), Prettifier$.MODULE$.default()).should(this.be().apply((Object)SolrServer$.MODULE$.apply(this.solrUrl())));
                this.convertToAnyShouldWrapper(((QueryRequest)((SolrRequest)capturedRequest.elem)).getParams(), new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194), Prettifier$.MODULE$.default()).should(this.be().apply((Object)q));
                solr.shutdown();
            }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        }, new Position("AsyncSolrClientIntegrationSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }
}

