/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.PingStatusObserver$;
import io.ino.solrs.ServerStateObserver;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StaticSolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.solrs.future.FutureFactory$;
import io.ino.solrs.future.Promise;
import io.ino.solrs.future.ScalaFutureFactory$;
import java.io.Serializable;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\b\u0010\u0001YA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\ti\u0001\u0011\t\u0011)A\u0005k!AQ\b\u0001B\u0001B\u0003-a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003E\u0001\u0011\u00051\nC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u001d\u0004\u0001\u0015!\u0003b\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0001\b\u0001\"\u0003r\u000f%\t9aDA\u0001\u0012\u0003\tIA\u0002\u0005\u000f\u001f\u0005\u0005\t\u0012AA\u0006\u0011\u0019!5\u0002\"\u0001\u0002\u000e!I\u0011qB\u0006\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0002\u0013!&twm\u0015;biV\u001cxJY:feZ,'O\u0003\u0002\u0011#\u0005)1o\u001c7sg*\u0011!cE\u0001\u0004S:|'\"\u0001\u000b\u0002\u0005%|7\u0001A\u000b\u0003/\u0011\u001a2\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0019q\u0004\t\u0012\u000e\u0003=I!!I\b\u0003'M+'O^3s'R\fG/Z(cg\u0016\u0014h/\u001a:\u0011\u0005\r\"C\u0002\u0001\u0003\u0006K\u0001\u0011\rA\n\u0002\u0002\rV\u0011qEL\t\u0003Q-\u0002\"!G\u0015\n\u0005)R\"a\u0002(pi\"Lgn\u001a\t\u000331J!!\f\u000e\u0003\u0007\u0005s\u0017\u0010B\u00030I\t\u0007qEA\u0001`\u0003-\u0019x\u000e\u001c:TKJ4XM]:\u0011\u0005}\u0011\u0014BA\u001a\u0010\u0005-\u0019v\u000e\u001c:TKJ4XM]:\u0002\u0015!$H\u000f]\"mS\u0016tG\u000f\u0005\u00027w5\tqG\u0003\u00029s\u0005y\u0011m]=oG\"$H\u000f]2mS\u0016tGOC\u0001;\u0003\ry'oZ\u0005\u0003y]\u0012q\"Q:z]\u000eDE\u000f\u001e9DY&,g\u000e^\u0001\u000eMV$XO]3GC\u000e$xN]=\u0011\u0007}\u0012%%D\u0001A\u0015\t\tu\"\u0001\u0004gkR,(/Z\u0005\u0003\u0007\u0002\u0013QBR;ukJ,g)Y2u_JL\u0018A\u0002\u001fj]&$h\bF\u0002G\u0013*#\"a\u0012%\u0011\u0007}\u0001!\u0005C\u0003>\t\u0001\u000fa\bC\u00031\t\u0001\u0007\u0011\u0007C\u00035\t\u0001\u0007Q\u0007F\u0002M\u001dz#\"aR'\t\u000fu*\u0001\u0013!a\u0002}!)\u0001'\u0002a\u0001\u001fB\u0019\u0001\u000bW.\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u0016\u0003\u0019a$o\\8u}%\t1$\u0003\u0002X5\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005\r\u0019V-\u001d\u0006\u0003/j\u0001\"a\b/\n\u0005u{!AC*pYJ\u001cVM\u001d<fe\")A'\u0002a\u0001k\u00051An\\4hKJ,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003If\nQa\u001d7gi)L!AZ2\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0011c\u00195fG.\u001cVM\u001d<feN#\u0018\r^;t)\u0005Q\u0007cA l[&\u0011A\u000e\u0011\u0002\u0007\rV$XO]3\u0011\u0005eq\u0017BA8\u001b\u0005\u0011)f.\u001b;\u0002%U\u0004H-\u0019;f'\u0016\u0014h/\u001a:Ti\u0006$Xo\u001d\u000b\u0005[J$\u0018\u0010C\u0003t\u0013\u0001\u00071,\u0001\u0004tKJ4XM\u001d\u0005\u0006k&\u0001\rA^\u0001\te\u0016\u001c\bo\u001c8tKB\u0011ag^\u0005\u0003q^\u0012\u0001BU3ta>t7/\u001a\u0005\u0006u&\u0001\ra_\u0001\u0004kJd\u0007c\u0001?\u0002\u00029\u0011QP \t\u0003%jI!a \u000e\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\ty($\u0001\nQS:<7\u000b^1ukN|%m]3sm\u0016\u0014\bCA\u0010\f'\tY\u0001\u0004\u0006\u0002\u0002\n\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!a\u0005\u00024Q1\u0011QCA\u0018\u0003cQC!a\u0006\u0002\u001e9\u0019q(!\u0007\n\u0007\u0005m\u0001)\u0001\nTG\u0006d\u0017MR;ukJ,g)Y2u_JL8FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\"$\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000bAj\u0001\u0019A(\t\u000bQj\u0001\u0019A\u001b\u0005\r\u0015j!\u0019AA\u001b+\r9\u0013q\u0007\u0003\u0007_\u0005M\"\u0019A\u0014")
public class PingStatusObserver<F>
implements ServerStateObserver<F> {
    private final SolrServers solrServers;
    private final AsyncHttpClient httpClient;
    private final FutureFactory<F> futureFactory;
    private final Logger io$ino$solrs$PingStatusObserver$$logger;

    public static <F> ScalaFutureFactory$ $lessinit$greater$default$3(Seq<SolrServer> seq, AsyncHttpClient asyncHttpClient) {
        return PingStatusObserver$.MODULE$.$lessinit$greater$default$3(seq, asyncHttpClient);
    }

    public Logger io$ino$solrs$PingStatusObserver$$logger() {
        return this.io$ino$solrs$PingStatusObserver$$logger;
    }

    @Override
    public Future<BoxedUnit> checkServerStatus() {
        Seq futures = (Seq)this.solrServers.all().map((Function1 & Serializable & scala.Serializable)server -> {
            String url = new StringBuilder(32).append(server.baseUrl()).append("/admin/ping?action=status&wt=xml").toString();
            Promise promise = $this.futureFactory.newPromise();
            $this.httpClient.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandler<Response>(this, server, url, promise){
                private final /* synthetic */ PingStatusObserver $outer;
                private final SolrServer server$1;
                private final String url$1;
                private final Promise promise$1;

                public Response onCompleted(Response response) {
                    this.$outer.io$ino$solrs$PingStatusObserver$$updateServerStatus(this.server$1, response, this.url$1);
                    new Success((Object)this.server$1.status());
                    this.promise$1.success(BoxedUnit.UNIT);
                    return response;
                }

                public void onThrowable(Throwable t) {
                    ServerStatus serverStatus = this.server$1.status();
                    Failed$ failed$ = Failed$.MODULE$;
                    if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                        this.$outer.io$ino$solrs$PingStatusObserver$$logger().error(new StringBuilder(82).append("An error occurred when trying to get ping status from ").append(this.url$1).append(", changing status to Failed.").toString(), t);
                        this.server$1.status_$eq(Failed$.MODULE$);
                    }
                    this.promise$1.failure(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.server$1 = server$1;
                    this.url$1 = url$1;
                    this.promise$1 = promise$1;
                }
            });
            return promise.future();
        }, Seq$.MODULE$.canBuildFrom());
        return FutureFactory$.MODULE$.sequence(futures, Seq$.MODULE$.canBuildFrom(), this.futureFactory).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            PingStatusObserver.$anonfun$checkServerStatus$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void io$ino$solrs$PingStatusObserver$$updateServerStatus(SolrServer server, Response response, String url) {
        if (response.getStatusCode() != 200) {
            this.io$ino$solrs$PingStatusObserver$$logger().warn(new StringBuilder(58).append("Got ping response status != 200 (").append(response.getStatusCode()).append(") from ").append(url).append(", with response '").append(new String(response.getResponseBodyAsBytes())).append("'").toString());
            server.status_$eq(Failed$.MODULE$);
            return;
        }
        Elem xml = (Elem)XML$.MODULE$.load(response.getResponseBodyAsStream());
        Option option = xml.$bslash$bslash("response").$bslash("str").find((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)PingStatusObserver.$anonfun$updateServerStatus$1(node)));
        if (None$.MODULE$.equals(option)) {
            ServerStatus serverStatus = server.status();
            Failed$ failed$ = Failed$.MODULE$;
            if (serverStatus == null ? failed$ != null : !serverStatus.equals(failed$)) {
                this.io$ino$solrs$PingStatusObserver$$logger().warn(new StringBuilder(83).append("Could not find status in ping response from ").append(url).append(", changing status to Failed. Response:\n").append(xml).toString());
                server.status_$eq(Failed$.MODULE$);
                return;
            }
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Node statusNode = (Node)some.value();
            String string = statusNode.text();
            String string2 = "enabled";
            Product status = !(string != null ? !string.equals(string2) : string2 != null) ? Enabled$.MODULE$ : Disabled$.MODULE$;
            ServerStatus serverStatus = server.status();
            Product product = status;
            if (serverStatus == null ? product != null : !serverStatus.equals(product)) {
                this.io$ino$solrs$PingStatusObserver$$logger().info(new StringBuilder(38).append("Changing status for server ").append(server.baseUrl()).append(" from ").append(server.status()).append(" to ").append(status).append(".").toString());
                server.status_$eq((ServerStatus)status);
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$checkServerStatus$2(Seq x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$updateServerStatus$1(Node node) {
        String string = node.$bslash("@name").text();
        String string2 = "status";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public PingStatusObserver(SolrServers solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this.solrServers = solrServers;
        this.httpClient = httpClient;
        this.futureFactory = futureFactory;
        this.io$ino$solrs$PingStatusObserver$$logger = LoggerFactory.getLogger(this.getClass());
    }

    public PingStatusObserver(Seq<SolrServer> solrServers, AsyncHttpClient httpClient, FutureFactory<F> futureFactory) {
        this(new StaticSolrServers((IndexedSeq<SolrServer>)solrServers.toIndexedSeq()), httpClient, futureFactory);
    }
}

