/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import io.ino.solrs.AsyncSolrClient;
import io.ino.solrs.AsyncSolrClientMocks$;
import io.ino.solrs.Disabled$;
import io.ino.solrs.Enabled$;
import io.ino.solrs.Failed$;
import io.ino.solrs.FastestServerLB;
import io.ino.solrs.FastestServerLB$;
import io.ino.solrs.FastestServerLBSpec$;
import io.ino.solrs.ServerStatus;
import io.ino.solrs.SolrMatchers$;
import io.ino.solrs.SolrResponseFactory;
import io.ino.solrs.SolrServer;
import io.ino.solrs.SolrServer$;
import io.ino.solrs.SolrServers;
import io.ino.solrs.StandardFunSpec;
import io.ino.solrs.StaticSolrServers;
import io.ino.solrs.future.Future;
import io.ino.solrs.future.FutureFactory;
import io.ino.time.Clock;
import io.ino.time.Clock$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.SolrParams;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001%\u00111CR1ti\u0016\u001cHoU3sm\u0016\u0014HJQ*qK\u000eT!a\u0001\u0003\u0002\u000bM|GN]:\u000b\u0005\u00151\u0011aA5o_*\tq!\u0001\u0002j_\u000e\u00011C\u0001\u0001\u000b!\tYA\"D\u0001\u0003\u0013\ti!AA\bTi\u0006tG-\u0019:e\rVt7\u000b]3d\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\f\u0001\u0015!1\u0003\u0001\u0001\u0015\u0005=1\u0015m\u001d;fgR\u001cVM\u001d<fe2\u0013\u0005cA\u0006\u0016-%\u00111C\u0001\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t!bY8oGV\u0014(/\u001a8u\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u0019\u0005\u00191U\u000f^;sK\u0016!q\u0004\u0001\u0001!\u0005=\t5/\u001f8d'>d'o\u00117jK:$\bcA\u0006\"-%\u0011qD\u0001\u0005\nG\u0001\u0001\r\u00111A\u0005\n\u0011\n1aY;u+\u0005)\u0003C\u0001\u0014\u0013\u001b\u0005\u0001\u0001\"\u0003\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003*\u0003\u001d\u0019W\u000f^0%KF$\"A\u000b\u0018\u0011\u0005-bS\"\u0001\u000e\n\u00055R\"\u0001B+oSRDqaL\u0014\u0002\u0002\u0003\u0007Q%A\u0002yIEBa!\r\u0001!B\u0013)\u0013\u0001B2vi\u0002Bqa\r\u0001C\u0002\u0013%A'A\u0004tKJ4XM]\u0019\u0016\u0003U\u0002\"a\u0003\u001c\n\u0005]\u0012!AC*pYJ\u001cVM\u001d<fe\"1\u0011\b\u0001Q\u0001\nU\n\u0001b]3sm\u0016\u0014\u0018\u0007\t\u0005\bw\u0001\u0011\r\u0011\"\u00035\u0003\u001d\u0019XM\u001d<feJBa!\u0010\u0001!\u0002\u0013)\u0014\u0001C:feZ,'O\r\u0011\t\u000f}\u0002!\u0019!C\u0005i\u000591/\u001a:wKJ\u001c\u0004BB!\u0001A\u0003%Q'\u0001\u0005tKJ4XM]\u001a!\u0011\u001d\u0019\u0005A1A\u0005\n\u0011\u000b1b]8meN+'O^3sgV\tQ\t\u0005\u0002\f\r&\u0011qI\u0001\u0002\u0012'R\fG/[2T_2\u00148+\u001a:wKJ\u001c\bBB%\u0001A\u0003%Q)\u0001\u0007t_2\u00148+\u001a:wKJ\u001c\b\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0003E,\u0012!\u0014\t\u0003\u001dfk\u0011a\u0014\u0006\u0003!F\u000bQa]8me*T!AU*\u0002\r\rd\u0017.\u001a8u\u0015\t!V+\u0001\u0003t_2\u0014(B\u0001,X\u0003\u0019\t\u0007/Y2iK*\t\u0001,A\u0002pe\u001eL!AW(\u0003\u0013M{GN])vKJL\bB\u0002/\u0001A\u0003%Q*\u0001\u0002rA!9a\f\u0001b\u0001\n\u0013y\u0016!\u0001:\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY(\u0002\u000fI,\u0017/^3ti&\u0011QM\u0019\u0002\r#V,'/\u001f*fcV,7\u000f\u001e\u0005\u0007O\u0002\u0001\u000b\u0011\u00021\u0002\u0005I\u0004\u0003bB5\u0001\u0005\u0004%IA[\u0001\u000eG2\f7o]5gsF+XM]=\u0016\u0003-\u0004Ba\u000b7N]&\u0011QN\u0007\u0002\n\rVt7\r^5p]F\u0002\"a\u001c<\u000f\u0005A$\bCA9\u001b\u001b\u0005\u0011(BA:\t\u0003\u0019a$o\\8u}%\u0011QOG\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v5!1!\u0010\u0001Q\u0001\n-\fab\u00197bgNLg-_)vKJL\b\u0005C\u0004}\u0001\t\u0007I1B?\u0002\u000b\rdwnY6\u0016\u0003y\u00042a`A\u0006\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\t\u0005!A/[7f\u0013\u0011\tI!a\u0001\u0002\u000b\rcwnY6\n\t\u00055\u0011q\u0002\u0002\r\u001bV$\u0018M\u00197f\u00072|7m\u001b\u0006\u0005\u0003\u0013\t\u0019\u0001C\u0004\u0002\u0014\u0001\u0001\u000b\u0011\u0002@\u0002\r\rdwnY6!\u0011!\u0019\u0001A1A\u0005\n\u0005]QCAA\r!\t1c\u0004\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\r\u0003\u0019\u0019x\u000e\u001c:tA!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012A\u00032fM>\u0014X-R1dQR\t!\u0006C\u0004\u0002(\u0001!\t%a\t\u0002\u0013\u00054G/\u001a:FC\u000eD\u0007bBA\u0016\u0001\u0011%\u0011QF\u0001\fgBLW\rZ\"mS\u0016tG\u000f\u0006\u0005\u00020\u0005U\u0012QIA%!\u001dY\u0013\u0011G'&\u00033I1!a\r\u001b\u0005\u0019!V\u000f\u001d7fg!A\u0011qGA\u0015\u0001\u0004\tI$\u0001\u0005nS:$U\r\\1z!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA 1\u0005AA-\u001e:bi&|g.\u0003\u0003\u0002D\u0005u\"\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u0015\u0005\u001d\u0013\u0011\u0006I\u0001\u0002\u0004\tI$\u0001\u0005nCb$U\r\\1z\u0011)\tY%!\u000b\u0011\u0002\u0003\u0007\u0011QJ\u0001\r[>\u001c7NU3rk\u0016\u001cHo\u001d\t\u0006W1\fIB\u000b\u0005\b\u0003#\u0002A\u0011BA*\u00031qWm\u001e#z]\u0006l\u0017n\u0019'C)\u001d)\u0013QKA/\u0003?BqaQA(\u0001\u0004\t9\u0006E\u0002\f\u00033J1!a\u0017\u0003\u0005-\u0019v\u000e\u001c:TKJ4XM]:\t\u0015\u0005]\u0012q\nI\u0001\u0002\u0004\tI\u0004\u0003\u0006\u0002b\u0005=\u0003\u0013!a\u0001\u0003G\n\u0001$\\1q!J,G-[2uK\u0012\u0014Vm\u001d9p]N,G+[7f!\u0019YC.!\u001a\u0002fA\u00191&a\u001a\n\u0007\u0005%$D\u0001\u0003M_:<\u0007bBA7\u0001\u0011%\u0011qN\u0001\tCR\u001cVmY8oIV!\u0011\u0011OA=)\u0011\t\u0019(!&\u0015\t\u0005U\u00141\u0012\t\u0005\u0003o\nI\b\u0004\u0001\u0005\u0011\u0005m\u00141\u000eb\u0001\u0003{\u0012\u0011\u0001V\t\u0005\u0003\u007f\n)\tE\u0002,\u0003\u0003K1!a!\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aKAD\u0013\r\tII\u0007\u0002\u0004\u0003:L\b\"CAG\u0003W\"\t\u0019AAH\u0003\u00051\u0007#B\u0016\u0002\u0012\u0006U\u0014bAAJ5\tAAHY=oC6,g\b\u0003\u0005\u0002\u0018\u0006-\u0004\u0019AA3\u0003\u0019\u0019XmY8oI\"9\u00111\u0014\u0001\u0005\n\u0005u\u0015\u0001\u0003:v]R+7\u000f^:\u0015\u001b)\ny*!)\u0002&\u0006%\u0016QVAY\u0011\u0019\u0019\u0013\u0011\u0014a\u0001K!9\u00111UAM\u0001\u0004)\u0014AB:feZ,'\u000f\u0003\u0005\u0002(\u0006e\u0005\u0019AA3\u0003)1'o\\7TK\u000e|g\u000e\u001a\u0005\t\u0003W\u000bI\n1\u0001\u0002f\u0005AAo\\*fG>tG\r\u0003\u0005\u00020\u0006e\u0005\u0019AA3\u0003E\u0019H/\u0019:u%\u0016\u001c\bo\u001c8tKRKW.\u001a\u0005\t\u0003g\u000bI\n1\u0001\u0002f\u0005yQM\u001c3SKN\u0004xN\\:f)&lW\rC\u0005\u00028\u0002\t\n\u0011\"\u0003\u0002:\u00061b.Z<Es:\fW.[2M\u0005\u0012\"WMZ1vYR$#'\u0006\u0002\u0002<*\"\u0011\u0011HA_W\t\ty\f\u0005\u0003\u0002B\u0006-WBAAb\u0015\u0011\t)-a2\u0002\u0013Ut7\r[3dW\u0016$'bAAe5\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00171\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAi\u0001E\u0005I\u0011BAj\u0003YqWm\u001e#z]\u0006l\u0017n\u0019'CI\u0011,g-Y;mi\u0012\u001aTCAAkU\u0011\t\u0019'!0\t\u0013\u0005e\u0007!%A\u0005\n\u0005e\u0016!F:qS\u0016$7\t\\5f]R$C-\u001a4bk2$HE\r\u0005\n\u0003;\u0004\u0011\u0013!C\u0005\u0003?\fQc\u001d9jK\u0012\u001cE.[3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002b*\"\u0011QJA_\u0001")
public class FastestServerLBSpec
extends StandardFunSpec {
    private FastestServerLB<scala.concurrent.Future> io$ino$solrs$FastestServerLBSpec$$cut;
    private final SolrServer server1 = SolrServer$.MODULE$.apply("host1");
    private final SolrServer server2 = SolrServer$.MODULE$.apply("host2");
    private final SolrServer server3 = SolrServer$.MODULE$.apply("host3");
    private final StaticSolrServers solrServers = new StaticSolrServers((IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SolrServer[]{this.server1(), this.server2(), this.server3()})));
    private final SolrQuery io$ino$solrs$FastestServerLBSpec$$q = new SolrQuery("foo");
    private final QueryRequest r = new QueryRequest((SolrParams)this.io$ino$solrs$FastestServerLBSpec$$q());
    private final Function1<SolrQuery, String> classifyQuery = (Function1 & Serializable & scala.Serializable)solrQuery -> "foo";
    private final Clock.MutableClock io$ino$solrs$FastestServerLBSpec$$clock = Clock$.MODULE$.mutable();
    private final AsyncSolrClient<scala.concurrent.Future> solrs;

    public FastestServerLB<scala.concurrent.Future> io$ino$solrs$FastestServerLBSpec$$cut() {
        return this.io$ino$solrs$FastestServerLBSpec$$cut;
    }

    private void io$ino$solrs$FastestServerLBSpec$$cut_$eq(FastestServerLB<scala.concurrent.Future> x$1) {
        this.io$ino$solrs$FastestServerLBSpec$$cut = x$1;
    }

    private SolrServer server1() {
        return this.server1;
    }

    private SolrServer server2() {
        return this.server2;
    }

    private SolrServer server3() {
        return this.server3;
    }

    private StaticSolrServers solrServers() {
        return this.solrServers;
    }

    public SolrQuery io$ino$solrs$FastestServerLBSpec$$q() {
        return this.io$ino$solrs$FastestServerLBSpec$$q;
    }

    private QueryRequest r() {
        return this.r;
    }

    private Function1<SolrQuery, String> classifyQuery() {
        return this.classifyQuery;
    }

    public Clock.MutableClock io$ino$solrs$FastestServerLBSpec$$clock() {
        return this.io$ino$solrs$FastestServerLBSpec$$clock;
    }

    private AsyncSolrClient<scala.concurrent.Future> solrs() {
        return this.solrs;
    }

    @Override
    public void beforeEach() {
        Mockito.reset((Object[])new AsyncSolrClient[]{this.solrs()});
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(this.solrs(), (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2(), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.io$ino$solrs$FastestServerLBSpec$$clock());
        this.io$ino$solrs$FastestServerLBSpec$$clock().set(0L);
    }

    @Override
    public void afterEach() {
        this.io$ino$solrs$FastestServerLBSpec$$cut().shutdown();
    }

    private Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> spiedClient(Duration minDelay, Duration maxDelay, Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit> mockRequests) {
        SolrQuery testQuery = new SolrQuery("testQuery");
        StaticSolrServers x$12 = this.solrServers();
        Function1 & Serializable & scala.Serializable x$13 = (Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2((Object)"collection1", (Object)testQuery);
        Duration x$14 = minDelay;
        Duration x$15 = maxDelay;
        Clock.MutableClock x$16 = this.io$ino$solrs$FastestServerLBSpec$$clock();
        int x$17 = FastestServerLB$.MODULE$.$lessinit$greater$default$5();
        Function1 x$18 = FastestServerLB$.MODULE$.$lessinit$greater$default$6();
        Function1 x$19 = FastestServerLB$.MODULE$.$lessinit$greater$default$7();
        this.io$ino$solrs$FastestServerLBSpec$$cut_$eq((FastestServerLB<scala.concurrent.Future>)new FastestServerLB((SolrServers)x$12, (Function1)x$13, x$14, x$15, x$17, x$18, x$19, (Clock)x$16, (FutureFactory)this.futureFactory()));
        ObjectRef spyClient = ObjectRef.create(null);
        AsyncSolrClient realClient = new AsyncSolrClient.Builder<scala.concurrent.Future, AsyncSolrClient<scala.concurrent.Future>>(this, mockRequests, spyClient){
            private final Function1 mockRequests$1;
            private final ObjectRef spyClient$4;

            public void setOnAsyncSolrClientAwares(AsyncSolrClient<scala.concurrent.Future> solr) {
                this.spyClient$4.elem = (AsyncSolrClient)Mockito.spy(solr);
                this.mockRequests$1.apply((Object)((AsyncSolrClient)this.spyClient$4.elem));
                super.setOnAsyncSolrClientAwares((AsyncSolrClient)this.spyClient$4.elem);
            }
            {
                this.mockRequests$1 = mockRequests$1;
                this.spyClient$4 = spyClient$4;
                super($outer.io$ino$solrs$FastestServerLBSpec$$cut(), $outer.ascFactory(), (FutureFactory)$outer.futureFactory());
            }
        }.build();
        return new Tuple3((Object)testQuery, this.io$ino$solrs$FastestServerLBSpec$$cut(), (Object)((AsyncSolrClient)spyClient.elem));
    }

    private Duration spiedClient$default$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds();
    }

    private Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit> spiedClient$default$3() {
        return (Function1 & Serializable & scala.Serializable)spyClient -> {
            AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2(), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.io$ino$solrs$FastestServerLBSpec$$clock());
            return BoxedUnit.UNIT;
        };
    }

    private FastestServerLB<scala.concurrent.Future> newDynamicLB(SolrServers solrServers, Duration minDelay, Function1<Object, Object> mapPredictedResponseTime) {
        this.io$ino$solrs$FastestServerLBSpec$$cut_$eq(new FastestServerLB<scala.concurrent.Future>(this, solrServers, minDelay, mapPredictedResponseTime){

            public void scheduleTests() {
            }

            public void scheduleUpdateStats() {
            }
            {
                SolrServers x$20 = solrServers$1;
                scala.Serializable x$21 = new scala.Serializable($outer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FastestServerLBSpec $outer;

                    public final Tuple2<String, SolrQuery> apply(SolrServer x$5) {
                        return new Tuple2((Object)"collection1", (Object)this.$outer.io$ino$solrs$FastestServerLBSpec$$q());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                Duration x$22 = minDelay$1;
                FiniteDuration x$23 = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds();
                int x$24 = 1;
                Function1 x$25 = mapPredictedResponseTime$1;
                Clock.MutableClock x$26 = $outer.io$ino$solrs$FastestServerLBSpec$$clock();
                Function1 x$27 = FastestServerLB$.MODULE$.$lessinit$greater$default$6();
                super(x$20, (Function1)x$21, x$22, (Duration)x$23, x$24, x$27, x$25, (Clock)x$26, (FutureFactory)$outer.futureFactory());
            }
        });
        this.io$ino$solrs$FastestServerLBSpec$$cut().setAsyncSolrClient(this.solrs());
        return this.io$ino$solrs$FastestServerLBSpec$$cut();
    }

    private Duration newDynamicLB$default$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
    }

    private Function1<Object, Object> newDynamicLB$default$3() {
        return (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
    }

    private <T> T atSecond(long second, Function0<T> f) {
        this.io$ino$solrs$FastestServerLBSpec$$clock().set(TimeUnit.SECONDS.toMillis(second));
        return (T)f.apply();
    }

    private void runTests(FastestServerLB<scala.concurrent.Future> cut, SolrServer server, long fromSecond, long toSecond, long startResponseTime, long endResponseTime) {
        long deltaPerStep = (endResponseTime - startResponseTime) / (toSecond - fromSecond);
        new RichLong(Predef$.MODULE$.longWrapper(fromSecond)).to((Object)BoxesRunTime.boxToLong((long)toSecond)).foreach((Function1 & Serializable & scala.Serializable)second -> FastestServerLBSpec.$anonfun$runTests$1(this, cut, server, fromSecond, startResponseTime, deltaPerStep, BoxesRunTime.unboxToLong((Object)second)));
    }

    private final void mockRequests$2(AsyncSolrClient spyClient) {
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server1()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(8)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server2()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(12)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server3()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
    }

    private final void mockRequests$3(AsyncSolrClient spyClient) {
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server1()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(4)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server2()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(6)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
        AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> (SolrServer)Matchers.eq((Object)this.server3()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).millis(), this.io$ino$solrs$FastestServerLBSpec$$clock());
    }

    public static final /* synthetic */ Future $anonfun$runTests$1(FastestServerLBSpec $this, FastestServerLB cut$1, SolrServer server$1, long fromSecond$1, long startResponseTime$1, long deltaPerStep$1, long second) {
        return (Future)$this.atSecond(second, (Function0 & Serializable & scala.Serializable)() -> {
            long responseTime = startResponseTime$1 + (second - fromSecond$1) * deltaPerStep$1;
            Mockito.when((Object)$this.solrs().doExecute((SolrServer)Matchers.any(), (SolrRequest)Matchers.any(), (SolrResponseFactory)Matchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(responseTime, $this.io$ino$solrs$FastestServerLBSpec$$clock()));
            return cut$1.test(server$1);
        });
    }

    public FastestServerLBSpec() {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(FastestServerLBSpec.class.getClassLoader());
        public final class Io_ino_solrs_FastestServerLBSpec$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("io.ino.solrs.FastestServerLBSpec")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("io.ino.solrs.FastestServerLBSpec"), "AsyncSolrClient"), (List)Nil$.MODULE$);
            }

            public Io_ino_solrs_FastestServerLBSpec$$typecreator1$1(FastestServerLBSpec $outer) {
            }
        }
        this.solrs = (AsyncSolrClient)this.mock(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_ino_solrs_FastestServerLBSpec$$typecreator1$1(null)));
        this.describe("FastestServerLB", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.it().apply("should return None if no solr server matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                SolrServers nonMatchingServers = new SolrServers(null){

                    public Seq<SolrServer> all() {
                        return Nil$.MODULE$;
                    }

                    public IndexedSeq<SolrServer> matching(SolrRequest<?> r) {
                        return package$.MODULE$.Vector().empty();
                    }
                };
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB(nonMatchingServers, this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            this.it().apply("should only return active solr servers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                IndexedSeq servers = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SolrServer[]{SolrServer$.MODULE$.apply("host1"), SolrServer$.MODULE$.apply("host2")}));
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)new StaticSolrServers(servers), this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)SolrServer$.MODULE$.apply("host1"))));
                this.runTests(cut, this.server1(), 1L, 2L, 1000L, 1000L);
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)SolrServer$.MODULE$.apply("host2"))));
                ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)SolrServer$.MODULE$.apply("host2"))));
                ((SolrServer)servers.head()).status_$eq((ServerStatus)Enabled$.MODULE$);
                ((SolrServer)servers.apply(1)).status_$eq((ServerStatus)Failed$.MODULE$);
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)SolrServer$.MODULE$.apply("host1"))));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)SolrServer$.MODULE$.apply("host1"))));
                ((SolrServer)servers.head()).status_$eq((ServerStatus)Disabled$.MODULE$);
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82), Prettifier$.MODULE$.default()).should(this.be().apply((Object)None$.MODULE$));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            this.it().apply("should return the fastest server by default", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers(), this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                Mockito.when((Object)this.solrs().doExecute((SolrServer)Matchers.any(), (SolrRequest)Matchers.any(), (SolrResponseFactory)Matchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(1L, this.io$ino$solrs$FastestServerLBSpec$$clock()));
                cut.test(this.server1());
                Mockito.when((Object)this.solrs().doExecute((SolrServer)Matchers.any(), (SolrRequest)Matchers.any(), (SolrResponseFactory)Matchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(10L, this.io$ino$solrs$FastestServerLBSpec$$clock()));
                cut.test(this.server2());
                Mockito.when((Object)this.solrs().doExecute((SolrServer)Matchers.any(), (SolrRequest)Matchers.any(), (SolrResponseFactory)Matchers.any())).thenReturn(AsyncSolrClientMocks$.MODULE$.delayedResponse(20L, this.io$ino$solrs$FastestServerLBSpec$$clock()));
                cut.test(this.server3());
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            this.it().apply("should round robin equally fast servers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers(), this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                this.runTests(cut, this.server1(), 1L, 5L, 1L, 1L);
                this.runTests(cut, this.server2(), 1L, 5L, 1L, 1L);
                this.runTests(cut, this.server3(), 1L, 5L, 1L, 1L);
                cut.updateStats();
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server3())));
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.it().apply("should consider the preferred server if it's one of the fastest servers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers(), this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                Some preferred = new Some((Object)this.server2());
                this.runTests(cut, this.server1(), 1L, 5L, 1L, 1L);
                this.runTests(cut, this.server2(), 1L, 5L, 1L, 1L);
                this.runTests(cut, this.server3(), 1L, 5L, 10L, 10L);
                cut.updateStats();
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), (Option)new Some((Object)this.server2())), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), (Option)new Some((Object)this.server2())), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), (Option)new Some((Object)this.server3())), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), (Option)new Some((Object)this.server3())), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.it().apply("should return the server with a better predicted response time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers(), this.newDynamicLB$default$2(), this.newDynamicLB$default$3());
                this.runTests(cut, this.server1(), 1L, 5L, 10L, 10L);
                this.runTests(cut, this.server2(), 1L, 5L, 20L, 20L);
                this.runTests(cut, this.server3(), 1L, 5L, 20L, 20L);
                cut.updateStats();
                this.runTests(cut, this.server1(), 6L, 10L, 10L, 20L);
                this.runTests(cut, this.server2(), 6L, 10L, 20L, 10L);
                cut.updateStats();
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            this.it().apply("should allow to quantize / consider (very) similar predicted response times to be equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                StaticSolrServers x$6 = this.solrServers();
                JFunction1.mcJJ.sp & Serializable & scala.Serializable x$7 = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)t -> t / 5L;
                Duration x$8 = this.newDynamicLB$default$2();
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)x$6, x$8, (Function1<Object, Object>)x$7);
                this.runTests(cut, this.server1(), 1L, 5L, 1L, 1L);
                this.runTests(cut, this.server2(), 1L, 5L, 2L, 2L);
                this.runTests(cut, this.server3(), 1L, 5L, 3L, 3L);
                cut.updateStats();
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server2())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server3())));
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                this.runTests(cut, this.server2(), 6L, 10L, 10L, 10L);
                this.runTests(cut, this.server3(), 6L, 10L, 10L, 10L);
                cut.updateStats();
                this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
                return this.convertToAnyShouldWrapper(cut.solrServer((SolrRequest)this.r(), cut.solrServer$default$2()), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172), Prettifier$.MODULE$.default()).should(this.be().apply((Object)new Some((Object)this.server1())));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            this.it().apply("should initially test servers to gather performance stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                FastestServerLB<scala.concurrent.Future> cut = this.newDynamicLB((SolrServers)this.solrServers(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis(), this.newDynamicLB$default$3());
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify(this.solrs())).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)this.io$ino$solrs$FastestServerLBSpec$$q()), (SolrResponseFactory)Matchers.any()));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            this.it().apply("should test servers based on the real query rate restricted by min delay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.io$ino$solrs$FastestServerLBSpec$$clock().set(0L);
                FiniteDuration minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
                Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)minDelay, this.spiedClient$default$2(), this.spiedClient$default$3());
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                SolrQuery testQuery = (SolrQuery)tuple3._1();
                FastestServerLB cut = (FastestServerLB)tuple3._2();
                AsyncSolrClient spyClient = (AsyncSolrClient)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)testQuery, (Object)cut, (Object)spyClient);
                Tuple3 tuple33 = tuple32;
                SolrQuery testQuery2 = (SolrQuery)tuple33._1();
                FastestServerLB cut2 = (FastestServerLB)tuple33._2();
                AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple33._3();
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.atLeastOnce())).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
                Mockito.reset((Object[])new AsyncSolrClient[]{spyClient2});
                AsyncSolrClientMocks$.MODULE$.mockDoRequest(spyClient2, (Function0<SolrServer>)(Function0 & Serializable & scala.Serializable)() -> AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$2(), AsyncSolrClientMocks$.MODULE$.mockDoRequest$default$3(), this.io$ino$solrs$FastestServerLBSpec$$clock());
                this.io$ino$solrs$FastestServerLBSpec$$clock().set(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds().toMillis());
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.never())).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
                SolrQuery realQuery = new SolrQuery("foo");
                spyClient2.query((SolrParams)realQuery);
                ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)Matchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)Matchers.any());
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
                realQuery = new SolrQuery("bar");
                spyClient2.query((SolrParams)realQuery);
                ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)Matchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)Matchers.any());
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
                this.io$ino$solrs$FastestServerLBSpec$$clock().advance(minDelay.toMillis());
                realQuery = new SolrQuery("baz");
                spyClient2.query((SolrParams)realQuery);
                ((AsyncSolrClient)Mockito.verify((Object)spyClient2)).doExecute((SolrServer)Matchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)Matchers.any());
                this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient2, (VerificationMode)Mockito.times((int)2))).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            this.it().apply("should test slow servers less frequently", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                FiniteDuration minDelay;
                this.io$ino$solrs$FastestServerLBSpec$$clock().set(0L);
                FiniteDuration x$9 = minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
                Function1 & Serializable & scala.Serializable x$10 = (Function1 & Serializable & scala.Serializable)spyClient -> {
                    this.mockRequests$2(spyClient);
                    return BoxedUnit.UNIT;
                };
                Duration x$11 = this.spiedClient$default$2();
                Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)x$9, x$11, (Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit>)x$10);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                SolrQuery testQuery = (SolrQuery)tuple3._1();
                FastestServerLB cut = (FastestServerLB)tuple3._2();
                AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)testQuery, (Object)cut, (Object)spyClient2);
                Tuple3 tuple33 = tuple32;
                SolrQuery testQuery2 = (SolrQuery)tuple33._1();
                FastestServerLB cut2 = (FastestServerLB)tuple33._2();
                AsyncSolrClient spyClient3 = (AsyncSolrClient)tuple33._3();
                Mockito.reset((Object[])new AsyncSolrClient[]{spyClient3});
                this.mockRequests$2(spyClient3);
                this.io$ino$solrs$FastestServerLBSpec$$clock().set(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds().toMillis());
                SolrQuery realQuery = new SolrQuery("foo");
                spyClient3.query((SolrParams)realQuery);
                ((AsyncSolrClient)Mockito.verify((Object)spyClient3)).doExecute((SolrServer)Matchers.any(), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)realQuery), (SolrResponseFactory)Matchers.any());
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SolrServer[]{this.server1(), this.server2()})).foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient3, (VerificationMode)Mockito.times((int)1))).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any()));
                return ((AsyncSolrClient)Mockito.verify((Object)spyClient3, (VerificationMode)Mockito.never())).doExecute((SolrServer)Matchers.eq((Object)this.server3()), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any());
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            this.it().apply("should test slow/all servers according to the specified maxDelay", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.io$ino$solrs$FastestServerLBSpec$$clock().set(0L);
                FiniteDuration minDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis();
                FiniteDuration maxDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).millis();
                Tuple3<SolrQuery, FastestServerLB<scala.concurrent.Future>, AsyncSolrClient<scala.concurrent.Future>> tuple3 = this.spiedClient((Duration)minDelay, (Duration)maxDelay, (Function1<AsyncSolrClient<scala.concurrent.Future>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)spyClient -> {
                    this.mockRequests$3(spyClient);
                    return BoxedUnit.UNIT;
                });
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                SolrQuery testQuery = (SolrQuery)tuple3._1();
                FastestServerLB cut = (FastestServerLB)tuple3._2();
                AsyncSolrClient spyClient2 = (AsyncSolrClient)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)testQuery, (Object)cut, (Object)spyClient2);
                Tuple3 tuple33 = tuple32;
                SolrQuery testQuery2 = (SolrQuery)tuple33._1();
                FastestServerLB cut2 = (FastestServerLB)tuple33._2();
                AsyncSolrClient spyClient3 = (AsyncSolrClient)tuple33._3();
                Mockito.reset((Object[])new AsyncSolrClient[]{spyClient3});
                this.mockRequests$3(spyClient3);
                this.io$ino$solrs$FastestServerLBSpec$$clock().advance(maxDelay.toMillis());
                Thread.sleep(maxDelay.toMillis());
                Eventually$.MODULE$.eventually((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.solrServers().all().foreach((Function1 & Serializable & scala.Serializable)s -> ((AsyncSolrClient)Mockito.verify((Object)spyClient3, (VerificationMode)Mockito.atLeastOnce())).doExecute((SolrServer)Matchers.eq((Object)s), (SolrRequest)SolrMatchers$.MODULE$.hasQuery((SolrParams)testQuery2), (SolrResponseFactory)Matchers.any())), new AbstractPatienceConfiguration.PatienceConfig((AbstractPatienceConfiguration)Eventually$.MODULE$, Span$.MODULE$.convertDurationToSpan((Duration)maxDelay.$times(2L)), Span$.MODULE$.convertDurationToSpan((Duration)maxDelay.$div(10L))), new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        }, new Position("FastestServerLBSpec.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
    }
}

