/*
 * Decompiled with CFR 0.152.
 */
package io.ino.solrs;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import io.ino.solrs.AsyncSolrClient$;
import io.ino.solrs.HttpUtils$;
import io.ino.solrs.Metrics;
import io.ino.solrs.RemoteSolrException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMd\u0001B\u0001\u0003\u0001%\u0011q\"Q:z]\u000e\u001cv\u000e\u001c:DY&,g\u000e\u001e\u0006\u0003\u0007\u0011\tQa]8meNT!!\u0002\u0004\u0002\u0007%twNC\u0001\b\u0003\tIwn\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0015\r\u0011\"\u0001\u0013\u0003\u001d\u0011\u0017m]3Ve2,\u0012a\u0005\t\u0003)]q!aC\u000b\n\u0005Ya\u0011A\u0002)sK\u0012,g-\u0003\u0002\u00193\t11\u000b\u001e:j]\u001eT!A\u0006\u0007\t\u0011m\u0001!\u0011!Q\u0001\nM\t\u0001BY1tKV\u0013H\u000e\t\u0005\t;\u0001\u0011)\u0019!C\u0001=\u0005Q\u0001\u000e\u001e;q\u00072LWM\u001c;\u0016\u0003}\u0001\"\u0001I\u0015\u000e\u0003\u0005R!AI\u0012\u0002\r\rd\u0017.\u001a8u\u0015\t!S%\u0001\u0003iiR\u0004(B\u0001\u0014(\u0003\u0011q\u0017N\\4\u000b\u0003!\n1aY8n\u0013\tQ\u0013EA\bBgft7\r\u0013;ua\u000ec\u0017.\u001a8u\u0011!a\u0003A!A!\u0002\u0013y\u0012a\u00035uiB\u001cE.[3oi\u0002B\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000fe\u0016\u001c\bo\u001c8tKB\u000b'o]3s!\t\u0001$(D\u00012\u0015\t\u00114'A\u0003t_2\u0014(N\u0003\u0002#i)\u0011QGN\u0001\u0005g>d'O\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e2\u00059\u0011Vm\u001d9p]N,\u0007+\u0019:tKJD\u0001\"\u0010\u0001\u0003\u0006\u0004%\tAP\u0001\b[\u0016$(/[2t+\u0005y\u0004C\u0001!B\u001b\u0005\u0011\u0011B\u0001\"\u0003\u0005\u001diU\r\u001e:jGND\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006IaP\u0001\t[\u0016$(/[2tA!)a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"R\u0001S%K\u00172\u0003\"\u0001\u0011\u0001\t\u000bE)\u0005\u0019A\n\t\u000fu)\u0005\u0013!a\u0001?!9a&\u0012I\u0001\u0002\u0004y\u0003bB\u001fF!\u0003\u0005\ra\u0010\u0005\b\u001d\u0002\u0001\r\u0011\"\u0003P\u0003A\u0019\b.\u001e;e_^tW\t_3dkR|'/F\u0001Q!\tY\u0011+\u0003\u0002S\u0019\t9!i\\8mK\u0006t\u0007b\u0002+\u0001\u0001\u0004%I!V\u0001\u0015g\",H\u000fZ8x]\u0016CXmY;u_J|F%Z9\u0015\u0005YK\u0006CA\u0006X\u0013\tAFB\u0001\u0003V]&$\bb\u0002.T\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0004B\u0002/\u0001A\u0003&\u0001+A\ttQV$Hm\\<o\u000bb,7-\u001e;pe\u0002BqA\u0018\u0001C\u0002\u0013%q,A\u0003V)\u001a{\u0006(F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0003mC:<'\"A3\u0002\t)\fg/Y\u0005\u00031\tDa\u0001\u001b\u0001!\u0002\u0013\u0001\u0017AB+U\r~C\u0004\u0005C\u0004k\u0001\t\u0007I\u0011B0\u0002\u0019\u0011+e)Q+M)~\u0003\u0016\t\u0016%\t\r1\u0004\u0001\u0015!\u0003a\u00035!UIR!V\u0019R{\u0006+\u0011+IA!9a\u000e\u0001b\u0001\n\u0003y\u0016!B!H\u000b:#\u0006B\u00029\u0001A\u0003%\u0001-\u0001\u0004B\u000f\u0016sE\u000b\t\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0003\u0019awnZ4feV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002xq\u0005)1\u000f\u001c45U&\u0011\u0011P\u001e\u0002\u0007\u0019><w-\u001a:\t\rm\u0004\u0001\u0015!\u0003u\u0003\u001dawnZ4fe\u0002BQ! \u0001\u0005\ny\f\u0001b]1oSRL'0\u001a\u000b\u0003'}DQ!\u0005?A\u0002MAq!a\u0001\u0001\t\u0003\t)!A\u0003rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002\b\u0005}\u0001CBA\u0005\u0003\u001f\t\u0019\"\u0004\u0002\u0002\f)\u0019\u0011Q\u0002\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u0012\u0005-!A\u0002$viV\u0014X\r\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"M\u0001\te\u0016\u001c\bo\u001c8tK&!\u0011QDA\f\u00055\tV/\u001a:z%\u0016\u001c\bo\u001c8tK\"A\u0011\u0011EA\u0001\u0001\u0004\t\u0019#A\u0001r!\r\u0001\u0014QE\u0005\u0004\u0003O\t$!C*pYJ\fV/\u001a:zQ\u0019\t\t!a\u000b\u00028A)1\"!\f\u00022%\u0019\u0011q\u0006\u0007\u0003\rQD'o\\<t!\r\u0001\u00141G\u0005\u0004\u0003k\t$aE*pYJ\u001cVM\u001d<fe\u0016C8-\u001a9uS>t\u0017G\u0002\u0010\u0014\u0003s\tI'M\u0005$\u0003w\t\t%a\u0018\u0002DU\u0019!#!\u0010\u0005\u000f\u0005}\u0002B1\u0001\u0002J\t\tA+\u0003\u0003\u0002D\u0005\u0015\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002H1\ta\u0001\u001e5s_^\u001c\u0018\u0003BA&\u0003#\u00022aCA'\u0013\r\ty\u0005\u0004\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019&!\u0017\u000f\u0007-\t)&C\u0002\u0002X1\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\\\u0005u#!\u0003+ie><\u0018M\u00197f\u0015\r\t9\u0006D\u0019\nG\u0005\u0005\u00141MA3\u0003\u000fr1aCA2\u0013\r\t9\u0005D\u0019\u0006E-a\u0011q\r\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005E\u0002bBA\u0002\u0001\u0011\u0005\u0011QN\u000b\u0005\u0003_\n9\b\u0006\u0004\u0002r\u0005\u0005\u00151\u0011\t\u0007\u0003\u0013\ty!a\u001d\u0011\t\u0005U\u0014q\u000f\u0007\u0001\t!\ty$a\u001bC\u0002\u0005e\u0014\u0003BA&\u0003w\u00022aCA?\u0013\r\ty\b\u0004\u0002\u0004\u0003:L\b\u0002CA\u0011\u0003W\u0002\r!a\t\t\u0011\u0005\u0015\u00151\u000ea\u0001\u0003\u000f\u000b\u0011\u0003\u001e:b]N4wN]7SKN\u0004xN\\:f!\u001dY\u0011\u0011RA\n\u0003gJ1!a#\r\u0005%1UO\\2uS>t\u0017\u0007\u000b\u0004\u0002l\u0005-\u0012qR\u0019\u0007=M\t\t*a&2\u0013\r\nY$!\u0011\u0002\u0014\u0006\r\u0013'C\u0012\u0002b\u0005\r\u0014QSA$c\u0015\u00113\u0002DA4c\r1\u0013\u0011\u0007\u0005\b\u00037\u0003A\u0011BAO\u0003Q!(/\u001f+sC:\u001chm\u001c:n%\u0016\u001c\bo\u001c8tKV!\u0011qTA[)\u0019\t\t+a1\u0002FJA\u00111UAT\u0003o\u000biL\u0002\u0004\u0002&\u0002\u0001\u0011\u0011\u0015\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0007\u0003S\u000by+a-\u000e\u0005\u0005-&bAAW\u0019\u0005!Q\u000f^5m\u0013\u0011\t\t,a+\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002v\u0005UF\u0001CA \u00033\u0013\r!!\u001f\u0011\u0007-\tI,C\u0002\u0002<2\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002\f\u0003\u007fK1!!1\r\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\tI\"!'A\u0002\u0005M\u0001\u0002CAC\u00033\u0003\r!a2\u0011\u000f-\tI)a\u0005\u00024\"9\u00111\u001a\u0001\u0005\u0012\u00055\u0017aB4fiB\u000bG\u000f\u001b\u000b\u0004'\u0005=\u0007\u0002CA\u0002\u0003\u0013\u0004\r!a\t\t\u000f\u0005M\u0007\u0001\"\u0005\u0002V\u0006yAo\\)vKJL(+Z:q_:\u001cX\r\u0006\u0005\u0002\u0014\u0005]\u0017q\\Ar\u0011!\tI\"!5A\u0002\u0005e\u0007c\u0001\u0011\u0002\\&\u0019\u0011Q\\\u0011\u0003\u0011I+7\u000f]8og\u0016Dq!!9\u0002R\u0002\u00071#A\u0002ve2D\u0001\"!:\u0002R\u0002\u0007\u0011q]\u0001\ngR\f'\u000f\u001e+j[\u0016\u00042aCAu\u0013\r\tY\u000f\u0004\u0002\u0005\u0019>tw\rC\u0004\u0002p\u0002!I!!=\u0002!Y\fG.\u001b3bi\u0016\u0014Vm\u001d9p]N,G#\u0002,\u0002t\u0006U\b\u0002CA\r\u0003[\u0004\r!!7\t\r9\ni\u000f1\u00010Q\u0019\ti/!?\u0003\u0002A)1\"!\f\u0002|B\u0019\u0001)!@\n\u0007\u0005}(AA\nSK6|G/Z*pYJ,\u0005pY3qi&|g.\r\u0004\u001f'\t\r!\u0011B\u0019\nG\u0005m\u0012\u0011\tB\u0003\u0003\u0007\n\u0014bIA1\u0003G\u00129!a\u00122\u000b\tZA\"a\u001a2\u0007\u0019\nY\u0010C\u0004\u0003\u000e\u0001!\tAa\u0004\u0002!Y\fG.\u001b3bi\u0016l\u0015.\\3UsB,G#\u0002,\u0003\u0012\tU\u0001b\u0002B\n\u0005\u0017\u0001\raE\u0001\u0014Kb\u0004Xm\u0019;fI\u000e{g\u000e^3oiRK\b/\u001a\u0005\t\u00033\u0011Y\u00011\u0001\u0002Z\"9!\u0011\u0004\u0001\u0005\u0012\tm\u0011AD4fi\u0016\u0013(o\u001c:SK\u0006\u001cxN\u001c\u000b\b'\tu!q\u0004B\u001d\u0011\u001d\t\tOa\u0006A\u0002MA\u0001B!\t\u0003\u0018\u0001\u0007!1E\u0001\u0004eN\u0004\b\u0007\u0002B\u0013\u0005k\u0001bAa\n\u00030\tMRB\u0001B\u0015\u0015\u0011\tiKa\u000b\u000b\u0007\t5B'\u0001\u0004d_6lwN\\\u0005\u0005\u0005c\u0011ICA\u0005OC6,G\rT5tiB!\u0011Q\u000fB\u001b\t1\u00119Da\b\u0002\u0002\u0003\u0005)\u0011AA=\u0005\ryF%\r\u0005\t\u00033\u00119\u00021\u0001\u0002Z\u001eI!Q\b\u0002\u0002\u0002#\u0005!qH\u0001\u0010\u0003NLhnY*pYJ\u001cE.[3oiB\u0019\u0001I!\u0011\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005\u0007\u001a2A!\u0011\u000b\u0011\u001d1%\u0011\tC\u0001\u0005\u000f\"\"Aa\u0010\t\u0015\t-#\u0011II\u0001\n\u0003\u0011i%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001fR3a\bB)W\t\u0011\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B/\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005$q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B3\u0005\u0003\n\n\u0011\"\u0001\u0003h\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"A!\u001b+\u0007=\u0012\t\u0006\u0003\u0006\u0003n\t\u0005\u0013\u0013!C\u0001\u0005_\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TC\u0001B9U\ry$\u0011\u000b")
public class AsyncSolrClient {
    private final String baseUrl;
    private final AsyncHttpClient httpClient;
    private final ResponseParser responseParser;
    private final Metrics metrics;
    private boolean shutdownExecutor;
    private final String UTF_8;
    private final String DEFAULT_PATH;
    private final String AGENT;
    private final Logger logger;

    public static Metrics $lessinit$greater$default$4() {
        return AsyncSolrClient$.MODULE$.$lessinit$greater$default$4();
    }

    public static ResponseParser $lessinit$greater$default$3() {
        return AsyncSolrClient$.MODULE$.$lessinit$greater$default$3();
    }

    public static AsyncHttpClient $lessinit$greater$default$2() {
        return AsyncSolrClient$.MODULE$.$lessinit$greater$default$2();
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public AsyncHttpClient httpClient() {
        return this.httpClient;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    private boolean shutdownExecutor() {
        return this.shutdownExecutor;
    }

    private void shutdownExecutor_$eq(boolean x$1) {
        this.shutdownExecutor = x$1;
    }

    private String UTF_8() {
        return this.UTF_8;
    }

    private String DEFAULT_PATH() {
        return this.DEFAULT_PATH;
    }

    public String AGENT() {
        return this.AGENT;
    }

    private Logger logger() {
        return this.logger;
    }

    private String sanitize(String baseUrl) {
        String string;
        if (baseUrl.endsWith("/")) {
            string = baseUrl.substring(0, baseUrl.length() - 1);
        } else {
            if (baseUrl.indexOf(63) >= 0) {
                throw new RuntimeException(new StringBuilder().append((Object)"Invalid base url for solrj.  The base URL must not contain parameters: ").append((Object)baseUrl).toString());
            }
            string = baseUrl;
        }
        return string;
    }

    public Future<QueryResponse> query(SolrQuery q) throws SolrServerException {
        return this.query(q, (Function1)new Serializable(this){

            public final QueryResponse apply(QueryResponse x) {
                return (QueryResponse)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public <T> Future<T> query(SolrQuery q, Function1<QueryResponse, T> transformResponse) throws SolrServerException {
        BoxedUnit boxedUnit;
        ModifiableSolrParams wparams = new ModifiableSolrParams((SolrParams)q);
        if (this.responseParser == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            wparams.set("wt", new String[]{this.responseParser.getWriterType()});
            boxedUnit = wparams.set("version", new String[]{this.responseParser.getVersion()});
        }
        String url = new StringBuilder().append((Object)this.baseUrl()).append((Object)this.getPath(q)).append((Object)ClientUtils.toQueryString((SolrParams)wparams, (boolean)false)).toString();
        try {
            Promise promise = package$.MODULE$.promise();
            long startTime = System.currentTimeMillis();
            Request request = this.httpClient().prepareGet(url).addHeader("User-Agent", this.AGENT()).build();
            this.httpClient().executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(this, transformResponse, url, promise, startTime){
                private final /* synthetic */ AsyncSolrClient $outer;
                private final Function1 transformResponse$1;
                private final String url$1;
                private final Promise promise$1;
                private final long startTime$1;

                public Response onCompleted(Response response) {
                    this.promise$1.complete(this.$outer.io$ino$solrs$AsyncSolrClient$$tryTransformResponse(this.$outer.toQueryResponse(response, this.url$1, this.startTime$1), this.transformResponse$1));
                    return response;
                }

                public void onThrowable(Throwable t) {
                    this.$outer.metrics().countException();
                    this.promise$1.failure(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.transformResponse$1 = transformResponse$1;
                    this.url$1 = url$1;
                    this.promise$1 = promise$1;
                    this.startTime$1 = startTime$1;
                }
            });
            return promise.future();
        }
        catch (IOException iOException) {
            this.metrics().countIOException();
            throw new SolrServerException(new StringBuilder().append((Object)"IOException occured when talking to server at: ").append((Object)this.baseUrl()).toString(), (Throwable)iOException);
        }
    }

    public <T> Try<T> io$ino$solrs$AsyncSolrClient$$tryTransformResponse(QueryResponse response, Function1<QueryResponse, T> transformResponse) {
        Success success;
        try {
            success = new Success(transformResponse.apply((Object)response));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.metrics().countTransformResponseException();
            Failure failure = new Failure(e);
            success = failure;
        }
        return success;
    }

    public String getPath(SolrQuery query2) {
        String qt = query2.get("qt");
        if (qt != null && qt.startsWith("/")) {
            return qt;
        }
        return this.DEFAULT_PATH();
    }

    /*
     * WARNING - void declaration
     */
    public QueryResponse toQueryResponse(Response response, String url, long startTime) {
        NamedList rsp;
        block3: {
            rsp = null;
            this.validateResponse(response, this.responseParser);
            int httpStatus = response.getStatusCode();
            try {
                String charset = (String)HttpUtils$.MODULE$.getContentCharSet(response.getContentType()).orNull(Predef$.MODULE$.$conforms());
                rsp = this.responseParser.processResponse(response.getResponseBodyAsStream(), charset);
                if (httpStatus == 200) break block3;
                this.metrics().countRemoteException();
                String reason = this.getErrorReason(url, rsp, response);
                throw new RemoteSolrException(httpStatus, reason, null);
            }
            catch (Throwable throwable) {
                void var6_5;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.metrics().countRemoteException();
                throw new RemoteSolrException((int)var6_5, e.getMessage(), e);
            }
        }
        QueryResponse res = new QueryResponse(rsp, null);
        long elapsedTime = System.currentTimeMillis() - startTime;
        res.setElapsedTime(elapsedTime);
        this.metrics().requestTime(elapsedTime);
        return res;
    }

    private void validateResponse(Response response, ResponseParser responseParser) throws RemoteSolrException {
        this.validateMimeType(responseParser.getContentType(), response);
        int httpStatus = response.getStatusCode();
        if (httpStatus >= 400) {
            this.metrics().countRemoteException();
            throw new RemoteSolrException(httpStatus, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server at ", " returned non ok status:", ", message:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.baseUrl(), BoxesRunTime.boxToInteger((int)httpStatus), response.getStatusText()})), null);
        }
    }

    public void validateMimeType(String expectedContentType, Response response) {
        String actualMimeType;
        String expectedMimeType;
        block7: {
            block6: {
                if (expectedContentType == null) break block6;
                expectedMimeType = (String)HttpUtils$.MODULE$.getMimeType(expectedContentType).map((Function1)new Serializable(this){

                    public final String apply(String x$1) {
                        return x$1.toLowerCase(Locale.ROOT);
                    }
                }).getOrElse((Function0)new Serializable(this){

                    public final String apply() {
                        return "";
                    }
                });
                actualMimeType = (String)HttpUtils$.MODULE$.getMimeType(response.getContentType()).map((Function1)new Serializable(this){

                    public final String apply(String x$2) {
                        return x$2.toLowerCase(Locale.ROOT);
                    }
                }).getOrElse((Function0)new Serializable(this){

                    public final String apply() {
                        return "";
                    }
                });
                String string = expectedMimeType;
                String string2 = actualMimeType;
                if (string != null ? !string.equals(string2) : string2 != null) break block7;
            }
            return;
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected mime type [", "] but got [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expectedMimeType, actualMimeType}));
        String encoding = response.getHeader("Content-Encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            msg = new StringBuilder().append((Object)msg).append((Object)"\n").append((Object)IOUtils.toString((InputStream)response.getResponseBodyAsStream(), (String)encoding)).toString();
            this.metrics().countRemoteException();
            throw new RemoteSolrException(response.getStatusCode(), msg, null);
        }
        catch (IOException iOException) {
            this.metrics().countRemoteException();
            throw new RemoteSolrException(response.getStatusCode(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Unfortunately could not parse response (for debugging) with encoding ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, encoding})), iOException);
        }
    }

    public String getErrorReason(String url, NamedList<?> rsp, Response response) {
        String reason = null;
        try {
            Object err = rsp.get("error");
            if (err != null) {
                reason = (String)((NamedList)err).get("msg");
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (reason == null) {
            StringBuilder msg = new StringBuilder();
            msg.append(response.getStatusText());
            msg.append("\n\n");
            msg.append(new StringBuilder().append((Object)"request: ").append((Object)url).toString());
            reason = msg.toString();
        }
        return reason;
    }

    public AsyncSolrClient(String baseUrl, AsyncHttpClient httpClient, ResponseParser responseParser, Metrics metrics) {
        this.baseUrl = baseUrl;
        this.httpClient = httpClient;
        this.responseParser = responseParser;
        this.metrics = metrics;
        this.shutdownExecutor = false;
        this.UTF_8 = "UTF-8";
        this.DEFAULT_PATH = "/select";
        this.AGENT = new StringBuilder().append((Object)"Solr[").append((Object)AsyncSolrClient.class.getName()).append((Object)"] 1.0").toString();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

