package io.inai.android_sdk

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.fragment.app.DialogFragment

class InaiCheckoutDialog: DialogFragment() {
    private lateinit var _checkoutFragment: InaiCheckoutFragment
    companion object {
        fun newInstance(checkoutFragment: InaiCheckoutFragment): InaiCheckoutDialog {
            val dialog = InaiCheckoutDialog()
            dialog._checkoutFragment = checkoutFragment
            return dialog
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        val rootView: View = inflater.inflate(R.layout.inai_checkout, container, false)
        val fragmentTransaction = childFragmentManager.beginTransaction()
        fragmentTransaction.replace(R.id.inai_checkout_fragment, _checkoutFragment, "inai_checkout_fragment_30d9cb17_249c_4fb6")
        fragmentTransaction.commit()
        return rootView
    }

    override fun onResume() {
        super.onResume()
        //  Update the dialog to use Full screen width
        val params: ViewGroup.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        dialog!!.window!!.attributes = params as WindowManager.LayoutParams
    }
}