package io.inai.android_sdk

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.WindowManager
import androidx.fragment.app.DialogFragment
import io.inai.android_sdk.helpers.InaiBaseUtils

class InaiCheckoutDialog: DialogFragment() {
    private lateinit var _checkoutFragment: InaiCheckoutFragment
    private lateinit var presentationMode: InaiPresentationMode
    private var TAG = "InaiCheckoutDialog"
    companion object {
        fun newInstance(checkoutFragment: InaiCheckoutFragment, config: InaiBaseConfig): InaiCheckoutDialog {
            val dialog = InaiCheckoutDialog()
            dialog._checkoutFragment = checkoutFragment
            if(config is InaiConfig){
                if(config.presentationMode != null){
                    dialog.presentationMode = config.presentationMode
                }else{
                    dialog.presentationMode = InaiPresentationMode.Standard
                }
            }else if(config is InaiPayoutsConfig){
                if(config.presentationMode != null){
                    dialog.presentationMode = config.presentationMode
                }else{
                    dialog.presentationMode = InaiPresentationMode.Standard
                }
            }
            return dialog
        }
    }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onAttach", TAG)))
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        if(savedInstanceState != null){
            presentationMode = savedInstanceState.getString(InaiConstants.PRESENTATION_MODE)?.let { InaiPresentationMode.valueOf(it) }!!
        }
        if(::presentationMode.isInitialized){
            when(presentationMode){
                InaiPresentationMode.FullScreen -> {
                    setStyle(DialogFragment.STYLE_NO_FRAME, R.style.FullScreenDialog)
                }
            }
        }
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onCreate", TAG)))
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        context?.let { InaiBaseUtils().setup(it) }
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onCreateView", TAG)))
        if(!InaiCheckout.isCrashlyticsInitialized()){
            Thread.setDefaultUncaughtExceptionHandler(InaiCrashlyticsHandler.newInstance(Thread.getDefaultUncaughtExceptionHandler()))
        }
        retainInstance = true
        if(savedInstanceState != null){
            _checkoutFragment =
                savedInstanceState?.let {
                    childFragmentManager.getFragment(
                        it,
                        InaiConstants.INAICHECKOUT_FRAGMENT_KEY
                    )
                } as InaiCheckoutFragment
        }
        val rootView: View = inflater.inflate(R.layout.inai_checkout, container, false)
        try {
            val fragmentTransaction = childFragmentManager.beginTransaction()
            fragmentTransaction.replace(R.id.inai_checkout_fragment, _checkoutFragment, "inai_checkout_fragment_30d9cb17_249c_4fb6")
            fragmentTransaction.commit()
        } catch (e: Exception) {
            this.dismiss()
        }
        return rootView
    }

    override fun onStart() {
        super.onStart()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("Foreground", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onStart", TAG)))
    }

    override fun onResume() {
        super.onResume()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("Foreground", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onResume", TAG)))
        //  Update the dialog to use Full screen width
        val params: ViewGroup.LayoutParams = dialog!!.window!!.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.MATCH_PARENT
        dialog!!.window!!.attributes = params as WindowManager.LayoutParams
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        if(::presentationMode.isInitialized){
            outState.putString(InaiConstants.PRESENTATION_MODE, presentationMode.name)
        }
        childFragmentManager.putFragment(
            outState,
            InaiConstants.INAICHECKOUT_FRAGMENT_KEY,
            _checkoutFragment
        )
    }


    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        return object : Dialog(requireActivity(), theme) {
            override fun onBackPressed() {
                _checkoutFragment.showDismissConfirmationAlert()
            }
        }
    }
    override fun onPause() {
        super.onPause()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("Background", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onPause", TAG)))
    }

    override fun onStop() {
        super.onStop()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("Background", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onStop", TAG)))
    }

    override fun onDestroy() {
        super.onDestroy()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onDestroy", TAG)))
        InaiCrashlyticsHandler().deregisterCrashlyticsHandler()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        InaiBaseUtils.updateBreadCrumbsValues(InaiBaseUtils.BreadcrumbsValues("", "ui.lifecycle", "info", InaiBaseUtils.getCurrentTimestamp(), "navigation", InaiBaseUtils.BreadcrumbsData("onDestroyView", TAG)))
    }
}
