package io.inai.android_sdk

import kotlinx.serialization.Serializable

// Sample Inai Config object
/*
{
    token: string,
    orderId: string,
    planId: string,
    styles: {
        container: {
            "backgroundColor": string,
            "color": string,
            "fontFamily": string,
            "fontSize": string,
            "fontWeight": number,
            "width": string,
            "height": string,
            "margin": string,
            "padding": string
        },
        cta: {
            "backgroundColor": string,
            "color": string,
            "fontWeight": number,
            "fontSize": string,
            "minWidth": string,
            "borderRadius": string,
            "border": string,
            "outline": string,
            "padding": string,
            "cursor": string
        },
        errorText: {
            "color": string,
            "fontSize": string,
            "fontWeight": number
        }
    },

    ctaText: string,
    timeout: number,
    customer: {
        email: string,
        phoneNumber: string
    },
    countryCode: string,
    changeLocation: string,
    redirectUrl: string,
    availablePaymentMethodOptions: [string],
    usePaymentMethodOption: string
}
*/

@Serializable
sealed class InaiBaseConfig {

}

@Serializable
data class InaiPayoutsConfig(
    val token: String,
    val sessionToken: String,
    val countryCode: String? = null,
    val locale: String? = null
) : InaiBaseConfig()

@Serializable
data class InaiConfigStylesContainer(
    val backgroundColor: String? = null,
    val background: String? = null,
    val border: String? = null,
    val borderBottom: String? = null,
    val borderBottomColor: String? = null,
    val borderBottomLeftRadius: String? = null,
    val borderBottomRightRadius: String? = null,
    val borderBottomStyle: String? = null,
    val borderBottomWidth: String? = null,
    val borderColor: String? = null,
    val borderLeft: String? = null,
    val borderLeftColor: String? = null,
    val borderLeftStyle: String? = null,
    val borderLeftWidth: String? = null,
    val borderRadius: String? = null,
    val borderRight: String? = null,
    val borderRightColor: String? = null,
    val borderRightStyle: String? = null,
    val borderRightWidth: String? = null,
    val borderStyle: String? = null,
    val borderTop: String? = null,
    val borderTopColor: String? = null,
    val borderTopLeftRadius: String? = null,
    val borderTopRightRadius: String? = null,
    val borderTopStyle: String? = null,
    val borderTopWidth: String? = null,
    val borderWidth: String? = null,
    val boxShadow: String? = null,
    val color: String? = null,
    val webkitFontSmoothing: String? = null,
    val mozOsxFontSmoothing: String? = null,
    val fontFamily: String? = null,
    val fontSize: String? = null,
    val fontVariant: String? = null,
    val fontWeight: Int? = null,
    val fontSmoothing: String? = null,
    val height: String? = null,
    val letterSpacing: String? = null,
    val lineHeight: String? = null,
    val margin: String? = null,
    val marginBottom: String? = null,
    val marginLeft: String? = null,
    val marginRight: String? = null,
    val marginTop: String? = null,
    val outline: String? = null,
    val outlineOffset: String? = null,
    val padding: String? = null,
    val paddingBottom: String? = null,
    val paddingLeft: String? = null,
    val paddingRight: String? = null,
    val textDecoration: String? = null,
    val textShadow: String? = null,
    val textTransform: String? = null,
    val transition: String? = null,
    val width: String? = null,
    val display: String? = null,
    val alignItems: String? = null,
    val justifyContent: String? = null,
    val fontStyle: String? = null,
    val fill: String? = null,
    val clipPath:String ?= null
    )

@Serializable
data class InaiConfigStylesCta(
    val backgroundColor: String? = null,
    val color: String? = null,
    val fontWeight: Int? = null,
    val fontSize: String? = null,
    val borderRadius: String? = null,
    val border: String? = null,
    val outline: String? = null,
    val padding: String? = null,
    val background: String? = null,
    val borderBottom: String? = null,
    val borderBottomColor: String? = null,
    val borderBottomLeftRadius: String? = null,
    val borderBottomRightRadius: String? = null,
    val borderBottomStyle: String? = null,
    val borderBottomWidth: String? = null,
    val borderColor: String? = null,
    val borderLeft: String? = null,
    val borderLeftColor: String? = null,
    val borderLeftStyle: String? = null,
    val borderLeftWidth: String? = null,
    val borderRight: String? = null,
    val borderRightColor: String? = null,
    val borderRightStyle: String? = null,
    val borderRightWidth: String? = null,
    val borderStyle: String? = null,
    val borderTop: String? = null,
    val borderTopColor: String? = null,
    val borderTopLeftRadius: String? = null,
    val borderTopRightRadius: String? = null,
    val borderTopStyle: String? = null,
    val borderTopWidth: String? = null,
    val borderWidth: String? = null,
    val boxShadow: String? = null,
    val webkitFontSmoothing: String? = null,
    val mozOsxFontSmoothing: String? = null,
    val fontFamily: String? = null,
    val fontVariant: String? = null,
    val fontSmoothing: String? = null,
    val height: String? = null,
    val letterSpacing: String? = null,
    val lineHeight: String? = null,
    val margin: String? = null,
    val marginBottom: String? = null,
    val marginLeft: String? = null,
    val marginRight: String? = null,
    val marginTop: String? = null,
    val outlineOffset: String? = null,
    val paddingBottom: String? = null,
    val paddingLeft: String? = null,
    val paddingRight: String? = null,
    val textDecoration: String? = null,
    val textShadow: String? = null,
    val textTransform: String? = null,
    val transition: String? = null,
    val width: String? = null,
    val display: String? = null,
    val alignItems: String? = null,
    val justifyContent: String? = null,
    val fontStyle: String? = null,
    val fill: String? = null,
    val clipPath:String ?= null
)

@Serializable
data class InaiConfigStylesErrorText(
    val color: String? = null,
    val fontSize: String? = null,
    val fontWeight: Int? = null
)

@Serializable
data class InaiConfigStyles(
    val container: InaiConfigStylesContainer? = null,
    val cta: InaiConfigStylesCta? = null,
    val errorText: InaiConfigStylesErrorText? = null,
    val components: Array<InaiComponentStyles>? = null
) {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InaiConfigStyles

        if (container != other.container) return false
        if (cta != other.cta) return false
        if (errorText != other.errorText) return false
        if (components != null) {
            if (other.components == null) return false
            if (!components.contentEquals(other.components)) return false
        } else if (other.components != null) return false

        return true
    }

    override fun hashCode(): Int {
        var result = container?.hashCode() ?: 0
        result = 31 * result + (cta?.hashCode() ?: 0)
        result = 31 * result + (errorText?.hashCode() ?: 0)
        result = 31 * result + (components?.contentHashCode() ?: 0)
        return result
    }
}

@Serializable
data class InaiComponentStyles(
    val component: String? = null,
    val style: InaiConfigStylesContainer? = null
)

@Serializable
data class InaiConfigCustomer(
    val id: String? = null,
    val email: String? = null,
    val phoneNumber: String? = null
)

@Serializable
data class InaiConfig(
    val token: String,
    val orderId: String? = null,
    val planId: String? = null,
    val styles: InaiConfigStyles? = null,
    val ctaText: String? = null,
    val timeout: Int? = null,
    val countryCode: String? = null,
    var changeLocation: String? = null,
    val redirectUrl: String? = null,
    val customer: InaiConfigCustomer? = null,
    val availablePaymentMethodOptions: Array<String>? = null,
    val usePaymentMethodOption: String? = null,
    val locale: String? = null
) : InaiBaseConfig()

@Serializable
data class InaiCTAConfig(
    val text: String? = null,
    val styles: InaiConfigStyles? = null
)

@Serializable
data class InaiCryptoPurchaseDetails(
    val token: String,
    val cryptoCurrency: String,
    val country: String,
    val paymentMethodOption: String,
    val amount: String,
    val currency: String
): InaiBaseConfig()