package io.inai.android_sdk

import android.content.Context
import androidx.fragment.app.FragmentActivity
import org.json.JSONObject

class InaiCrypto {

    enum class InaiCryptoEstimateStatus {
        Success, Failed;

        companion object{
            fun valueOfOrElse(result: String): InaiCryptoEstimateStatus{
                return if (values().map { it.name }.contains(result)) {
                    valueOf(result)
                }else{
                    Failed
                }
            }
        }
    }

    data class InaiCryptoEstimateResult(
        var status: InaiCryptoEstimateStatus = InaiCryptoEstimateStatus.Failed,
        var data: JSONObject = JSONObject()
    )

    interface InaiCryptoEstimateDelegate {
        fun estimateReceived(result: InaiCryptoEstimateResult)
    }

    companion object {

        private const val sdkHostUrl = BuildConfig.InaiSdkHostUrl

        fun getPurchaseEstimate(
            purchaseDetails: InaiCryptoPurchaseDetails,
            context: Context,
            delegate: Any
        ) {
            val checkoutFragment = InaiCheckoutFragment.newInstance(
                sdkHostUrl,
                purchaseDetails,
                delegate,
                InaiViewMode.CryptoEstimate
            )
            val fragmentActivity = context as FragmentActivity
            val fragmentTransaction = fragmentActivity.supportFragmentManager.beginTransaction()
            val checkoutFragmentTransaction =
                fragmentTransaction.add(checkoutFragment, checkoutFragment.fragmentTag)
            checkoutFragmentTransaction.commit()
        }
    }
}