package io.inai.android_sdk

import kotlinx.serialization.Serializable

// Sample Inai Config object
/*
{
    token: string,
    orderId: string,
    planId: string,
    styles: {
        container: {
            "backgroundColor": string,
            "color": string,
            "fontFamily": string,
            "fontSize": string,
            "fontWeight": number,
            "width": string,
            "height": string,
            "margin": string,
            "padding": string
        },
        cta: {
            "backgroundColor": string,
            "color": string,
            "fontWeight": number,
            "fontSize": string,
            "minWidth": string,
            "borderRadius": string,
            "border": string,
            "outline": string,
            "padding": string,
            "cursor": string
        },
        errorText: {
            "color": string,
            "fontSize": string,
            "fontWeight": number
        }
    },

    ctaText: string,
    timeout: number,
    customer: {
        email: string,
        phoneNumber: string
    },
    countryCode: string,
    changeLocation: string,
    redirectUrl: string,
    availablePaymentMethodOptions: [string],
    usePaymentMethodOption: string
}
*/

@Serializable
sealed class InaiBaseConfig {

}

@Serializable
data class InaiPayoutsConfig(
    val token: String,
    val sessionToken: String,
    val countryCode: String? = null,
    val locale: String? = null
) : InaiBaseConfig()

@Serializable
data class InaiConfigStylesContainer(
    val backgroundColor: String? = null,
    val color: String? = null,
    val fontFamily: String? = null,
    val fontSize: String? = null,
    val fontWeight: Int? = null,
    val width: String? = null,
    val height: String? = null,
    val margin: String? = null,
    val padding: String? = null
)

@Serializable
data class InaiConfigStylesCta(
    val backgroundColor: String? = null,
    val color: String? = null,
    val fontWeight: Int? = null,
    val fontSize: String? = null,
    val minWidth: String? = null,
    val borderRadius: String? = null,
    val border: String? = null,
    val outline: String? = null,
    val padding: String? = null,
    val cursor: String? = null
)

@Serializable
data class InaiConfigStylesErrorText(
    val color: String? = null,
    val fontSize: String? = null,
    val fontWeight: Int? = null
)

@Serializable
data class InaiConfigStyles(
    val container: InaiConfigStylesContainer? = null,
    val cta: InaiConfigStylesCta? = null,
    val errorText: InaiConfigStylesErrorText? = null
)

@Serializable
data class InaiConfigCustomer(
    val id: String? = null,
    val email: String? = null,
    val phoneNumber: String? = null
)

@Serializable
data class InaiConfig(
    val token: String,
    val orderId: String? = null,
    val planId: String? = null,
    val styles: InaiConfigStyles? = null,
    val ctaText: String? = null,
    val timeout: Int? = null,
    val countryCode: String? = null,
    var changeLocation: String? = null,
    val redirectUrl: String? = null,
    val customer: InaiConfigCustomer? = null,
    val availablePaymentMethodOptions: Array<String>? = null,
    val usePaymentMethodOption: String? = null,
    val locale: String? = null
) : InaiBaseConfig()

@Serializable
data class InaiCTAConfig(
    val text: String? = null,
    val styles: InaiConfigStyles? = null
)

@Serializable
data class InaiCryptoPurchaseDetails(
    val token: String,
    val cryptoCurrency: String,
    val country: String,
    val paymentMethodOption: String,
    val amount: String,
    val currency: String
): InaiBaseConfig()