/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.stomp.jms.StompJmsExceptionSupport;
import org.fusesource.stomp.jms.message.StompJmsMessage;
import org.fusesource.stomp.jms.util.MarshallingSupport;

public class StompJmsStreamMessage
extends StompJmsMessage
implements StreamMessage {
    protected transient DataByteArrayOutputStream dataOut;
    protected transient DataInputStream dataIn;
    protected transient int remainingBytes = -1;

    @Override
    public StompJmsMessage.JmsMsgType getMsgType() {
        return StompJmsMessage.JmsMsgType.STREAM;
    }

    @Override
    public StompJmsMessage copy() throws JMSException {
        StompJmsStreamMessage other = new StompJmsStreamMessage();
        other.copy(this);
        return other;
    }

    public void copy(StompJmsStreamMessage other) throws JMSException {
        other.storeContent();
        super.copy(other);
        this.dataOut = null;
        this.dataIn = null;
    }

    @Override
    public void onSend() throws JMSException {
        super.onSend();
        this.storeContent();
    }

    @Override
    public void storeContent() throws JMSException {
        if (this.dataOut != null) {
            try {
                this.dataOut.close();
                Buffer bs = this.dataOut.toBuffer();
                this.setContent(bs);
                this.dataOut = null;
            }
            catch (IOException ioe) {
                throw StompJmsExceptionSupport.create(ioe.getMessage(), ioe);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.remainingBytes = -1;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(10);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 1) {
                return this.dataIn.readBoolean();
            }
            if (dataType == 9) {
                return Boolean.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to boolean.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a boolean type");
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(10);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 2) {
                return this.dataIn.readByte();
            }
            if (dataType == 9) {
                return Byte.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to byte.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a byte type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(17);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 4) {
                return this.dataIn.readShort();
            }
            if (dataType == 2) {
                return this.dataIn.readByte();
            }
            if (dataType == 9) {
                return Short.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to short.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a short type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(17);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 3) {
                return this.dataIn.readChar();
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to char.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a char type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(33);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 5) {
                return this.dataIn.readInt();
            }
            if (dataType == 4) {
                return this.dataIn.readShort();
            }
            if (dataType == 2) {
                return this.dataIn.readByte();
            }
            if (dataType == 9) {
                return Integer.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to int.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not an int type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 6) {
                return this.dataIn.readLong();
            }
            if (dataType == 5) {
                return this.dataIn.readInt();
            }
            if (dataType == 4) {
                return this.dataIn.readShort();
            }
            if (dataType == 2) {
                return this.dataIn.readByte();
            }
            if (dataType == 9) {
                return Long.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to long.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a long type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(33);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 8) {
                return this.dataIn.readFloat();
            }
            if (dataType == 9) {
                return Float.valueOf(this.dataIn.readUTF()).floatValue();
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to float.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a float type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 7) {
                return this.dataIn.readDouble();
            }
            if (dataType == 8) {
                return this.dataIn.readFloat();
            }
            if (dataType == 9) {
                return Double.valueOf(this.dataIn.readUTF());
            }
            if (dataType == 0) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert NULL value to double.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a double type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (EOFException e) {
            throw StompJmsExceptionSupport.createMessageEOFException(e);
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public String readString() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 0) {
                return null;
            }
            if (dataType == 13) {
                return this.dataIn.readUTF();
            }
            if (dataType == 9) {
                return this.dataIn.readUTF();
            }
            if (dataType == 6) {
                return new Long(this.dataIn.readLong()).toString();
            }
            if (dataType == 5) {
                return new Integer(this.dataIn.readInt()).toString();
            }
            if (dataType == 4) {
                return new Short(this.dataIn.readShort()).toString();
            }
            if (dataType == 2) {
                return new Byte(this.dataIn.readByte()).toString();
            }
            if (dataType == 8) {
                return new Float(this.dataIn.readFloat()).toString();
            }
            if (dataType == 7) {
                return new Double(this.dataIn.readDouble()).toString();
            }
            if (dataType == 1) {
                return (this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE).toString();
            }
            if (dataType == 3) {
                return new Character(this.dataIn.readChar()).toString();
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a String type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (IOException e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.initializeReading();
        try {
            if (value == null) {
                throw new NullPointerException();
            }
            if (this.remainingBytes == -1) {
                this.dataIn.mark(value.length + 1);
                int dataType = this.dataIn.read();
                if (dataType == -1) {
                    throw new MessageEOFException("reached end of data");
                }
                if (dataType != 10) {
                    throw new MessageFormatException("Not a byte array");
                }
                this.remainingBytes = this.dataIn.readInt();
            } else if (this.remainingBytes == 0) {
                this.remainingBytes = -1;
                return -1;
            }
            if (value.length <= this.remainingBytes) {
                this.remainingBytes -= value.length;
                this.dataIn.readFully(value);
                return value.length;
            }
            int rc = this.dataIn.read(value, 0, this.remainingBytes);
            this.remainingBytes = 0;
            return rc;
        }
        catch (Throwable e) {
            throw StompJmsExceptionSupport.createMessageFormatException(e);
        }
    }

    public Object readObject() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(65);
            int dataType = this.dataIn.read();
            if (dataType == -1) {
                throw new MessageEOFException("reached end of data");
            }
            if (dataType == 0) {
                return null;
            }
            if (dataType == 13) {
                return this.dataIn.readUTF();
            }
            if (dataType == 9) {
                return this.dataIn.readUTF();
            }
            if (dataType == 6) {
                return this.dataIn.readLong();
            }
            if (dataType == 5) {
                return this.dataIn.readInt();
            }
            if (dataType == 4) {
                return this.dataIn.readShort();
            }
            if (dataType == 2) {
                return this.dataIn.readByte();
            }
            if (dataType == 8) {
                return new Float(this.dataIn.readFloat());
            }
            if (dataType == 7) {
                return new Double(this.dataIn.readDouble());
            }
            if (dataType == 1) {
                return this.dataIn.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (dataType == 3) {
                return Character.valueOf(this.dataIn.readChar());
            }
            if (dataType == 10) {
                int len = this.dataIn.readInt();
                byte[] value = new byte[len];
                this.dataIn.readFully(value);
                return value;
            }
            this.dataIn.reset();
            throw new MessageFormatException("unknown type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                throw StompJmsExceptionSupport.createMessageFormatException(e);
            }
            throw mfe;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalBoolean(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalByte(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalShort(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalChar(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalInt(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalLong(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalFloat(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalDouble(this.dataOut, value);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeString(String value) throws JMSException {
        this.initializeWriting();
        try {
            if (value == null) {
                MarshallingSupport.marshalNull(this.dataOut);
            } else {
                MarshallingSupport.marshalString(this.dataOut, value);
            }
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            MarshallingSupport.marshalByteArray(this.dataOut, value, offset, length);
        }
        catch (IOException ioe) {
            throw StompJmsExceptionSupport.create(ioe);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.initializeWriting();
        if (value == null) {
            try {
                MarshallingSupport.marshalNull(this.dataOut);
            }
            catch (IOException ioe) {
                throw StompJmsExceptionSupport.create(ioe);
            }
        } else if (value instanceof String) {
            this.writeString(value.toString());
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else {
            throw new MessageFormatException("Unsupported Object type: " + value.getClass());
        }
    }

    public void reset() throws JMSException {
        this.storeContent();
        this.dataIn = null;
        this.dataOut = null;
        this.remainingBytes = -1;
        this.setReadOnlyBody(true);
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkReadOnlyBody();
        if (this.dataOut == null) {
            this.dataOut = new DataByteArrayOutputStream();
        }
    }

    protected void checkWriteOnlyBody() throws MessageNotReadableException {
        if (!this.readOnlyBody) {
            throw new MessageNotReadableException("Message body is write-only");
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkWriteOnlyBody();
        if (this.dataIn == null) {
            Buffer buffer = this.getContent();
            if (buffer == null) {
                buffer = new Buffer(new byte[0], 0, 0);
            }
            this.dataIn = new DataInputStream((InputStream)new ByteArrayInputStream(buffer));
        }
    }

    public String toString() {
        return super.toString() + " StompJmsStreamMessage{ dataOut = " + this.dataOut + ", dataIn = " + this.dataIn + " }";
    }
}

