/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.message;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.fusesource.stomp.jms.StompJmsConnection;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsQueue;
import org.fusesource.stomp.jms.StompJmsTempQueue;
import org.fusesource.stomp.jms.StompJmsTempTopic;
import org.fusesource.stomp.jms.StompJmsTopic;
import org.fusesource.stomp.jms.message.StompJmsBytesMessage;
import org.fusesource.stomp.jms.message.StompJmsMapMessage;
import org.fusesource.stomp.jms.message.StompJmsMessage;
import org.fusesource.stomp.jms.message.StompJmsObjectMessage;
import org.fusesource.stomp.jms.message.StompJmsStreamMessage;
import org.fusesource.stomp.jms.message.StompJmsTextMessage;

public final class StompJmsMessageTransformation {
    private StompJmsMessageTransformation() {
    }

    public static StompJmsDestination transformDestination(StompJmsConnection connection, Destination destination) throws JMSException {
        StompJmsDestination result = null;
        if (destination != null) {
            if (destination instanceof StompJmsDestination) {
                return (StompJmsDestination)destination;
            }
            if (destination instanceof TemporaryQueue) {
                result = new StompJmsTempQueue(connection.getQueuePrefix(), ((TemporaryQueue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                result = new StompJmsTempTopic(connection.getTopicPrefix(), ((TemporaryTopic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                result = new StompJmsQueue(connection, ((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                result = new StompJmsTopic(connection, ((Topic)destination).getTopicName());
            }
        }
        return result;
    }

    public static StompJmsMessage transformMessage(StompJmsConnection connection, Message message) throws JMSException {
        if (message instanceof StompJmsMessage) {
            return ((StompJmsMessage)message).copy();
        }
        StompJmsMessage activeMessage = null;
        if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            StompJmsBytesMessage msg = new StompJmsBytesMessage();
            try {
                while (true) {
                    msg.writeByte(bytesMsg.readByte());
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            StompJmsMapMessage msg = new StompJmsMapMessage();
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                msg.setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            StompJmsObjectMessage msg = new StompJmsObjectMessage();
            msg.setObject(objMsg.getObject());
            msg.storeContent();
            activeMessage = msg;
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            StompJmsStreamMessage msg = new StompJmsStreamMessage();
            Object obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    msg.writeObject(obj);
                }
            }
            catch (MessageEOFException messageEOFException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            StompJmsTextMessage msg = new StompJmsTextMessage();
            msg.setText(textMsg.getText());
            activeMessage = msg;
        } else {
            activeMessage = new StompJmsMessage();
        }
        StompJmsMessageTransformation.copyProperties(connection, message, activeMessage);
        return activeMessage;
    }

    public static void copyProperties(StompJmsConnection connection, Message fromMessage, Message toMessage) throws JMSException {
        toMessage.setJMSMessageID(fromMessage.getJMSMessageID());
        toMessage.setJMSCorrelationID(fromMessage.getJMSCorrelationID());
        toMessage.setJMSReplyTo((Destination)StompJmsMessageTransformation.transformDestination(connection, fromMessage.getJMSReplyTo()));
        toMessage.setJMSDestination((Destination)StompJmsMessageTransformation.transformDestination(connection, fromMessage.getJMSDestination()));
        toMessage.setJMSDeliveryMode(fromMessage.getJMSDeliveryMode());
        toMessage.setJMSRedelivered(fromMessage.getJMSRedelivered());
        toMessage.setJMSType(fromMessage.getJMSType());
        toMessage.setJMSExpiration(fromMessage.getJMSExpiration());
        toMessage.setJMSPriority(fromMessage.getJMSPriority());
        toMessage.setJMSTimestamp(fromMessage.getJMSTimestamp());
        Enumeration propertyNames = fromMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            Object obj = fromMessage.getObjectProperty(name);
            toMessage.setObjectProperty(name, obj);
        }
    }
}

