/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms;

import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.jms.StompJmsDestination;
import org.fusesource.stomp.jms.StompJmsMessageConsumer;
import org.fusesource.stomp.jms.StompJmsSession;
import org.fusesource.stomp.jms.message.StompJmsMessage;

public class StompJmsQueueBrowser
implements QueueBrowser,
Enumeration {
    private final StompJmsSession session;
    private final StompJmsDestination destination;
    private final String selector;
    private StompJmsMessageConsumer consumer;
    private boolean closed;
    private final AsciiBuffer id;
    private final AtomicBoolean browseDone = new AtomicBoolean(true);
    private Object semaphore = new Object();

    protected StompJmsQueueBrowser(StompJmsSession session, AsciiBuffer id, StompJmsDestination destination, String selector) throws JMSException {
        this.session = session;
        this.id = id;
        this.destination = destination;
        this.selector = selector;
    }

    private StompJmsMessageConsumer createConsumer() throws JMSException {
        this.browseDone.set(false);
        StompJmsMessageConsumer rc = new StompJmsMessageConsumer(this.id, this.session, this.destination, this.selector){

            @Override
            public boolean isBrowser() {
                return true;
            }

            @Override
            public void onMessage(StompJmsMessage message) {
                if (message == null) {
                    StompJmsQueueBrowser.this.browseDone.set(true);
                } else {
                    AsciiBuffer browser = message.getFrame().headerMap().get(Constants.BROWSER);
                    if (browser != null && Constants.END.equals((Buffer)browser)) {
                        StompJmsQueueBrowser.this.browseDone.set(true);
                    } else {
                        super.onMessage(message);
                    }
                }
                StompJmsQueueBrowser.this.notifyMessageAvailable();
            }
        };
        rc.init();
        return rc;
    }

    private void destroyConsumer() {
        if (this.consumer == null) {
            return;
        }
        try {
            if (this.session.getTransacted()) {
                this.session.commit();
            }
            this.consumer.close();
            this.consumer = null;
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkClosed();
        if (this.consumer == null) {
            this.consumer = this.createConsumer();
        }
        return this;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        while (true) {
            StompJmsQueueBrowser stompJmsQueueBrowser = this;
            synchronized (stompJmsQueueBrowser) {
                if (this.consumer == null) {
                    return false;
                }
            }
            if (this.consumer.getMessageQueueSize() > 0) {
                return true;
            }
            if (this.browseDone.get() || !this.session.isStarted()) {
                this.destroyConsumer();
                return false;
            }
            this.waitForMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object nextElement() {
        while (true) {
            StompJmsQueueBrowser stompJmsQueueBrowser = this;
            synchronized (stompJmsQueueBrowser) {
                if (this.consumer == null) {
                    return null;
                }
            }
            try {
                Message answer = this.consumer.receiveNoWait();
                if (answer != null) {
                    return answer;
                }
            }
            catch (JMSException e) {
                this.session.getConnection().onException(e);
                return null;
            }
            if (this.browseDone.get() || !this.session.isStarted()) {
                this.destroyConsumer();
                return null;
            }
            this.waitForMessage();
        }
    }

    public synchronized void close() throws JMSException {
        this.destroyConsumer();
        this.closed = true;
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.destination;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessage() {
        try {
            Object object = this.semaphore;
            synchronized (object) {
                this.semaphore.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMessageAvailable() {
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public String toString() {
        return "StompJmsQueueBrowser { value=" + this.id + " }";
    }
}

