/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.jndi;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.fusesource.stomp.jms.StompJmsConnectionFactory;
import org.fusesource.stomp.jms.StompJmsQueue;
import org.fusesource.stomp.jms.StompJmsTopic;
import org.fusesource.stomp.jms.jndi.LazyCreateContext;
import org.fusesource.stomp.jms.jndi.ReadOnlyContext;

public class StompJmsInitialContextFactory
implements InitialContextFactory {
    private static final String[] DEFAULT_CONNECTION_FACTORY_NAMES = new String[]{"ConnectionFactory", "QueueConnectionFactory", "TopicConnectionFactory"};
    private String connectionPrefix = "";
    String queuePrefix = "/queue/";
    String topicPrefix = "/topic/";

    public Context getInitialContext(Hashtable environment) throws NamingException {
        this.queuePrefix = StompJmsInitialContextFactory.getValue(environment, "queuePrefix", this.queuePrefix);
        this.topicPrefix = StompJmsInitialContextFactory.getValue(environment, "topicPrefix", this.topicPrefix);
        ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
        String[] names = this.getConnectionFactoryNames(environment);
        for (int i = 0; i < names.length; ++i) {
            StompJmsConnectionFactory factory = null;
            String name = names[i];
            try {
                factory = this.createConnectionFactory(name, environment);
            }
            catch (Exception e) {
                throw new NamingException("Invalid broker URL");
            }
            data.put(name, factory);
        }
        data.put("queue", new LazyCreateContext(){
            private static final long serialVersionUID = 6503881346214855588L;

            @Override
            protected Object createEntry(String name) {
                return new StompJmsQueue(StompJmsInitialContextFactory.this.queuePrefix, name);
            }
        });
        data.put("topic", new LazyCreateContext(){
            private static final long serialVersionUID = 2019166796234979615L;

            @Override
            protected Object createEntry(String name) {
                return new StompJmsTopic(StompJmsInitialContextFactory.this.topicPrefix, name);
            }
        });
        return this.createContext(environment, data);
    }

    private static String getValue(Hashtable environment, String key, String defaultValue) {
        Object o = environment.get(key);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    protected ReadOnlyContext createContext(Hashtable environment, Map<String, Object> data) {
        return new ReadOnlyContext(environment, data);
    }

    protected StompJmsConnectionFactory createConnectionFactory(String name, Hashtable environment) throws URISyntaxException {
        Hashtable temp = new Hashtable(environment);
        String prefix = this.connectionPrefix + name + ".";
        for (Map.Entry entry : environment.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            temp.remove(key);
            key = key.substring(prefix.length());
            temp.put(key, entry.getValue());
        }
        return this.createConnectionFactory(temp);
    }

    protected String[] getConnectionFactoryNames(Map environment) {
        String factoryNames = (String)environment.get("factories");
        if (factoryNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer enumeration = new StringTokenizer(factoryNames, ",");
            while (enumeration.hasMoreTokens()) {
                list.add(enumeration.nextToken().trim());
            }
            int size = list.size();
            if (size > 0) {
                String[] answer = new String[size];
                list.toArray(answer);
                return answer;
            }
        }
        return DEFAULT_CONNECTION_FACTORY_NAMES;
    }

    protected Queue createQueue(String name) {
        return new StompJmsQueue(this.queuePrefix, name);
    }

    protected Topic createTopic(String name) {
        return new StompJmsTopic(this.topicPrefix, name);
    }

    protected StompJmsConnectionFactory createConnectionFactory(Hashtable environment) throws URISyntaxException {
        StompJmsConnectionFactory answer = new StompJmsConnectionFactory();
        Properties properties = new Properties();
        environment.remove("java.naming.factory.initial");
        Object o = environment.remove("java.naming.provider.url");
        if (o != null) {
            answer.setBrokerURI(o.toString());
        }
        if ((o = environment.remove("java.naming.security.principal")) != null) {
            answer.setUsername(o.toString());
        }
        if ((o = environment.remove("java.naming.security.credentials")) != null) {
            answer.setPassword(o.toString());
        }
        properties.putAll((Map<?, ?>)environment);
        answer.setProperties(properties);
        return answer;
    }

    public String getConnectionPrefix() {
        return this.connectionPrefix;
    }

    public void setConnectionPrefix(String connectionPrefix) {
        this.connectionPrefix = connectionPrefix;
    }
}

