/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.DefaultTransportListener;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.stomp.client.BlockingConnection;
import org.fusesource.stomp.client.Callback;
import org.fusesource.stomp.client.CallbackConnection;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.client.Future;
import org.fusesource.stomp.client.FutureConnection;
import org.fusesource.stomp.client.Promise;
import org.fusesource.stomp.codec.StompFrame;
import org.fusesource.stomp.codec.StompProtocolCodec;

public class Stomp {
    private static final long KEEP_ALIVE = Long.parseLong(System.getProperty("stompjms.thread.keep_alive", "1000"));
    private static final long STACK_SIZE = Long.parseLong(System.getProperty("stompjms.thread.stack_size", "524288"));
    private static ThreadPoolExecutor blockingThreadPool;
    private URI remoteURI;
    private URI localURI;
    private SSLContext sslContext;
    private DispatchQueue dispatchQueue;
    private Executor blockingExecutor;
    private int maxReadRate;
    private int maxWriteRate;
    private int trafficClass = 8;
    private int receiveBufferSize = 65536;
    private int sendBufferSize = 65536;
    private boolean useLocalHost = true;
    private String login;
    private String passcode;
    private String host;
    private String clientId;
    private String version = "1.1";
    private Properties customHeaders;

    public static synchronized ThreadPoolExecutor getBlockingThreadPool() {
        if (blockingThreadPool == null) {
            blockingThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE, TimeUnit.MILLISECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread rc = new Thread(null, r, "Stomp JMS Task", STACK_SIZE);
                    rc.setDaemon(true);
                    return rc;
                }
            }){

                @Override
                public void shutdown() {
                }

                @Override
                public List<Runnable> shutdownNow() {
                    return Collections.emptyList();
                }
            };
        }
        return blockingThreadPool;
    }

    public static synchronized void setBlockingThreadPool(ThreadPoolExecutor pool) {
        blockingThreadPool = pool;
    }

    public void connectCallback(final Callback<CallbackConnection> cb) {
        assert (cb != null) : "Callback should not be null.";
        try {
            TcpTransport transport;
            String scheme = this.remoteURI.getScheme();
            if ("tcp".equals(scheme)) {
                transport = new TcpTransport();
            } else if (SslTransport.protocol(scheme) != null) {
                SslTransport ssl = new SslTransport();
                if (this.sslContext == null) {
                    this.sslContext = SSLContext.getDefault();
                }
                ssl.setSSLContext(this.sslContext);
                transport = ssl;
            } else {
                throw new Exception("Unsupported URI scheme '" + scheme + "'");
            }
            if (this.blockingExecutor == null) {
                this.blockingExecutor = Stomp.getBlockingThreadPool();
            }
            transport.setBlockingExecutor(this.blockingExecutor);
            if (this.dispatchQueue == null) {
                this.dispatchQueue = Dispatch.createQueue("stomp client");
            }
            transport.setDispatchQueue(this.dispatchQueue);
            transport.setProtocolCodec(new StompProtocolCodec());
            if (transport instanceof TcpTransport) {
                TcpTransport tcp = transport;
                tcp.setMaxReadRate(this.maxReadRate);
                tcp.setMaxWriteRate(this.maxWriteRate);
                tcp.setReceiveBufferSize(this.receiveBufferSize);
                tcp.setSendBufferSize(this.sendBufferSize);
                tcp.setTrafficClass(this.trafficClass);
                tcp.setUseLocalHost(this.useLocalHost);
                tcp.connecting(this.remoteURI, this.localURI);
            }
            DefaultTransportListener commandListener = new DefaultTransportListener(){

                @Override
                public void onTransportConnected() {
                    transport.resumeRead();
                    StompFrame frame = new StompFrame(Constants.CONNECT);
                    if (Stomp.this.version != null) {
                        frame.addHeader(Constants.ACCEPT_VERSION, StompFrame.encodeHeader(Stomp.this.version));
                    }
                    if (Stomp.this.host != null) {
                        frame.addHeader(Constants.HOST, StompFrame.encodeHeader(Stomp.this.host));
                    }
                    if (Stomp.this.login != null) {
                        frame.addHeader(Constants.LOGIN, StompFrame.encodeHeader(Stomp.this.login));
                    }
                    if (Stomp.this.passcode != null) {
                        frame.addHeader(Constants.PASSCODE, StompFrame.encodeHeader(Stomp.this.passcode));
                    }
                    if (Stomp.this.clientId != null) {
                        frame.addHeader(Constants.CLIENT_ID, StompFrame.encodeHeader(Stomp.this.clientId));
                    }
                    if (Stomp.this.customHeaders != null) {
                        for (Object key : Stomp.this.customHeaders.keySet()) {
                            frame.addHeader(StompFrame.encodeHeader(key.toString()), StompFrame.encodeHeader(Stomp.this.customHeaders.get(key).toString()));
                        }
                    }
                    boolean accepted = transport.offer(frame);
                    assert (accepted) : "First frame should always be accepted by the transport";
                }

                @Override
                public void onTransportCommand(Object command) {
                    StompFrame response = (StompFrame)command;
                    if (response.action().equals(Constants.ERROR)) {
                        cb.onFailure(new IOException("Could not connect: " + response.errorMessage()));
                    } else if (!response.action().equals(Constants.CONNECTED)) {
                        cb.onFailure(new IOException("Could not connect. Received unexpected frame: " + response.toString()));
                    } else {
                        transport.suspendRead();
                        cb.onSuccess(new CallbackConnection(transport, response));
                    }
                }

                @Override
                public void onTransportFailure(final IOException error) {
                    transport.stop(new Task(){

                        @Override
                        public void run() {
                            cb.onFailure(error);
                        }
                    });
                }
            };
            transport.setTransportListener(commandListener);
            transport.start(Dispatch.NOOP);
        }
        catch (Throwable e) {
            cb.onFailure(e);
        }
    }

    public Future<FutureConnection> connectFuture() {
        final Promise<FutureConnection> future = new Promise<FutureConnection>();
        this.connectCallback(new Callback<CallbackConnection>(){

            @Override
            public void onFailure(Throwable value) {
                future.onFailure(value);
            }

            @Override
            public void onSuccess(CallbackConnection value) {
                future.onSuccess(new FutureConnection(value));
            }
        });
        return future;
    }

    public BlockingConnection connectBlocking() throws IOException {
        try {
            return new BlockingConnection(this.connectFuture().await());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public Stomp() {
    }

    public Stomp(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public Stomp(String host, int port) throws URISyntaxException {
        this(new URI("tcp://" + host + ":" + port));
    }

    public Stomp(URI remoteURI) {
        assert (remoteURI != null) : "URI should not be null.";
        this.remoteURI = remoteURI;
        this.host = remoteURI.getHost();
    }

    public void setRemoteURI(URI remoteURI) {
        assert (remoteURI != null) : "URI should not be null.";
        this.remoteURI = remoteURI;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCustomHeaders(Properties customHeaders) {
        this.customHeaders = customHeaders;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    public void setLocalURI(URI localURI) {
        this.localURI = localURI;
    }

    public void setMaxReadRate(int maxReadRate) {
        this.maxReadRate = maxReadRate;
    }

    public void setMaxWriteRate(int maxWriteRate) {
        this.maxWriteRate = maxWriteRate;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Properties getCustomHeaders() {
        return this.customHeaders;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public String getHost() {
        return this.host;
    }

    public URI getLocalURI() {
        return this.localURI;
    }

    public String getLogin() {
        return this.login;
    }

    public int getMaxReadRate() {
        return this.maxReadRate;
    }

    public int getMaxWriteRate() {
        return this.maxWriteRate;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public URI getRemoteURI() {
        return this.remoteURI;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public String getVersion() {
        return this.version;
    }
}

