/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;

public class XATransactionId
extends TransactionId
implements Xid,
Comparable {
    public static final byte DATA_STRUCTURE_TYPE = 112;
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;
    private transient DataByteArrayOutputStream outputStream;
    private transient byte[] encodedXidBytes;
    private transient int hash;
    private transient String transactionKey;
    private transient ArrayList<MessageAck> preparedAcks;
    final int XID_PREFIX_SIZE = 16;

    public XATransactionId() {
    }

    public XATransactionId(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    public XATransactionId(byte[] encodedBytes) throws IOException {
        this.encodedXidBytes = encodedBytes;
        this.initFromEncodedBytes();
    }

    @Override
    public byte getDataStructureType() {
        return 112;
    }

    private void initFromEncodedBytes() throws IOException {
        DataByteArrayInputStream inputStream = new DataByteArrayInputStream(this.encodedXidBytes);
        inputStream.skipBytes(10);
        this.formatId = inputStream.readInt();
        short globalLength = inputStream.readShort();
        this.globalTransactionId = new byte[globalLength];
        try {
            inputStream.read(this.globalTransactionId);
            this.branchQualifier = new byte[inputStream.available()];
            inputStream.read(this.branchQualifier);
        }
        catch (IOException fatal) {
            throw new RuntimeException(this + ", failed to decode:", fatal);
        }
    }

    public synchronized byte[] getEncodedXidBytes() {
        if (this.encodedXidBytes == null) {
            this.outputStream = new DataByteArrayOutputStream(16 + this.globalTransactionId.length + this.branchQualifier.length);
            this.outputStream.position(10);
            this.outputStream.writeInt(this.formatId);
            this.outputStream.writeShort(this.globalTransactionId.length);
            try {
                this.outputStream.write(this.globalTransactionId);
                this.outputStream.write(this.branchQualifier);
            }
            catch (IOException fatal) {
                throw new RuntimeException(this + ", failed to encode:", fatal);
            }
            this.encodedXidBytes = this.outputStream.getData();
        }
        return this.encodedXidBytes;
    }

    public DataByteArrayOutputStream internalOutputStream() {
        return this.outputStream;
    }

    @Override
    public synchronized String getTransactionKey() {
        if (this.transactionKey == null) {
            StringBuffer s = new StringBuffer();
            s.append("XID:[" + this.formatId + ",globalId=");
            s.append(this.stringForm(this.formatId, this.globalTransactionId));
            s.append(",branchId=");
            s.append(this.stringForm(this.formatId, this.branchQualifier));
            s.append("]");
            this.transactionKey = s.toString();
        }
        return this.transactionKey;
    }

    private String stringForm(int format2, byte[] uid) {
        StringBuffer s = new StringBuffer();
        switch (format2) {
            case 131077: {
                this.stringFormArj(s, uid);
                break;
            }
            default: {
                this.stringFormDefault(s, uid);
            }
        }
        return s.toString();
    }

    private void stringFormDefault(StringBuffer s, byte[] uid) {
        for (int i = 0; i < uid.length; ++i) {
            s.append(Integer.toHexString(uid[i]));
        }
    }

    private void stringFormArj(StringBuffer s, byte[] uid) {
        try {
            DataByteArrayInputStream byteArrayInputStream = new DataByteArrayInputStream(uid);
            s.append(Long.toString(byteArrayInputStream.readLong(), 16));
            s.append(':');
            s.append(Long.toString(byteArrayInputStream.readLong(), 16));
            s.append(':');
            s.append(Integer.toString(byteArrayInputStream.readInt(), 16));
            s.append(':');
            s.append(Integer.toString(byteArrayInputStream.readInt(), 16));
            s.append(':');
            s.append(Integer.toString(byteArrayInputStream.readInt(), 16));
        }
        catch (Exception ignored) {
            this.stringFormDefault(s, uid);
        }
    }

    public String toString() {
        return this.getTransactionKey();
    }

    @Override
    public boolean isXATransaction() {
        return true;
    }

    @Override
    public boolean isLocalTransaction() {
        return false;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(byte[] branchQualifier) {
        this.branchQualifier = branchQualifier;
        this.hash = 0;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
        this.hash = 0;
    }

    public void setGlobalTransactionId(byte[] globalTransactionId) {
        this.globalTransactionId = globalTransactionId;
        this.hash = 0;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.formatId;
            this.hash = XATransactionId.hash(this.globalTransactionId, this.hash);
            this.hash = XATransactionId.hash(this.branchQualifier, this.hash);
            if (this.hash == 0) {
                this.hash = 0xACEACE;
            }
        }
        return this.hash;
    }

    private static int hash(byte[] bytes, int hash) {
        int size2 = bytes.length;
        for (int i = 0; i < size2; ++i) {
            hash ^= bytes[i] << i % 4 * 8;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != XATransactionId.class) {
            return false;
        }
        XATransactionId xid = (XATransactionId)o;
        return xid.formatId == this.formatId && Arrays.equals(xid.globalTransactionId, this.globalTransactionId) && Arrays.equals(xid.branchQualifier, this.branchQualifier);
    }

    public int compareTo(Object o) {
        if (o == null || o.getClass() != XATransactionId.class) {
            return -1;
        }
        XATransactionId xid = (XATransactionId)o;
        return this.getTransactionKey().compareTo(xid.getTransactionKey());
    }

    public void setPreparedAcks(ArrayList<MessageAck> preparedAcks) {
        this.preparedAcks = preparedAcks;
    }

    public ArrayList<MessageAck> getPreparedAcks() {
        return this.preparedAcks;
    }
}

