/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.client.ClientAuthenticationManager;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.channel.ChannelDirectTcpip;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.scp.ScpClientCreator;
import org.apache.sshd.client.session.ClientProxyConnectorHolder;
import org.apache.sshd.client.session.forward.DynamicPortForwardingTracker;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.subsystem.sftp.SftpClientCreator;
import org.apache.sshd.common.forward.PortForwardingManager;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public interface ClientSession
extends Session,
ScpClientCreator,
SftpClientCreator,
ClientProxyConnectorHolder,
ClientAuthenticationManager,
PortForwardingManager {
    public static final Set<ClientChannelEvent> REMOTE_COMMAND_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.CLOSED));

    public SocketAddress getConnectAddress();

    public AuthFuture auth() throws IOException;

    public ClientChannel createChannel(String var1) throws IOException;

    public ClientChannel createChannel(String var1, String var2) throws IOException;

    public ChannelShell createShellChannel() throws IOException;

    public ChannelExec createExecChannel(String var1) throws IOException;

    default public String executeRemoteCommand(String command) throws IOException {
        try (ByteArrayOutputStream stderr = new ByteArrayOutputStream();){
            String response = this.executeRemoteCommand(command, stderr, StandardCharsets.US_ASCII);
            if (stderr.size() > 0) {
                byte[] error = stderr.toByteArray();
                String errorMessage = new String(error, StandardCharsets.US_ASCII);
                throw new RemoteException("Error reported from remote command='" + command, new ServerException(errorMessage));
            }
            String string = response;
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    default public String executeRemoteCommand(String command, OutputStream stderr, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ChannelSubsystem createSubsystemChannel(String var1) throws IOException;

    public ChannelDirectTcpip createDirectTcpipChannel(SshdSocketAddress var1, SshdSocketAddress var2) throws IOException;

    default public ExplicitPortForwardingTracker createLocalPortForwardingTracker(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        return new ExplicitPortForwardingTracker(this, true, local, remote, this.startLocalPortForwarding(local, remote));
    }

    default public ExplicitPortForwardingTracker createRemotePortForwardingTracker(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        return new ExplicitPortForwardingTracker(this, false, local, remote, this.startRemotePortForwarding(remote, local));
    }

    default public DynamicPortForwardingTracker createDynamicPortForwardingTracker(SshdSocketAddress local) throws IOException {
        return new DynamicPortForwardingTracker(this, local, this.startDynamicPortForwarding(local));
    }

    public Set<ClientSessionEvent> waitFor(Collection<ClientSessionEvent> var1, long var2);

    public Map<Object, Object> getMetadataMap();

    @Override
    public ClientFactoryManager getFactoryManager();

    public KeyExchangeFuture switchToNoneCipher() throws IOException;

    public static enum ClientSessionEvent {
        TIMEOUT,
        CLOSED,
        WAIT_AUTH,
        AUTHED;

    }
}

