/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.Promise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private final UTF8Buffer topic;
    private final Buffer payload;
    private Callback<Callback<Void>> onComplete;
    private final DispatchQueue queue;
    boolean blocking = false;

    public Message(DispatchQueue queue2, UTF8Buffer topic, Buffer payload, Callback<Callback<Void>> onComplete2) {
        this.queue = queue2;
        this.payload = payload;
        this.topic = topic;
        this.onComplete = onComplete2;
    }

    public byte[] getPayload() {
        return this.payload.toByteArray();
    }

    public Buffer getPayloadBuffer() {
        return this.payload;
    }

    public String getTopic() {
        return this.topic.toString();
    }

    public UTF8Buffer getTopicBuffer() {
        return this.topic;
    }

    public void ack() {
        if (this.blocking) {
            Promise<Void> future2 = new Promise<Void>();
            this.ack(future2);
            try {
                future2.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.ack(null);
        }
    }

    public void ack(final Callback<Void> onAcked) {
        if (this.onComplete != null) {
            this.queue.execute(new Task(){
                Callback<Callback<Void>> onCompleteCopy;
                {
                    this.onCompleteCopy = Message.this.onComplete;
                }

                public void run() {
                    this.onCompleteCopy.onSuccess(onAcked);
                }
            });
            this.onComplete = null;
        } else if (onAcked != null) {
            onAcked.onSuccess(null);
        }
    }
}

